/*
 * Decompiled with CFR 0.152.
 */
package me.steinborn.krypton.mixin.shared.network.experimental;

import io.netty.buffer.ByteBuf;
import net.minecraft.network.VarLong;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={VarLong.class}, priority=900)
public class VarLongMixin {
    @Unique
    private static final long[] SIZE_MASKS = new long[]{0L, -128L, -16384L, -2097152L, -268435456L, -34359738368L, -4398046511104L, -562949953421312L, -72057594037927936L, Long.MIN_VALUE};
    @Unique
    private static final long MASK_7_BITS = -128L;
    @Unique
    private static final long MASK_14_BITS = -16384L;
    @Unique
    private static final long MASK_21_BITS = -2097152L;
    @Unique
    private static final long MASK_28_BITS = -268435456L;

    @Overwrite
    public static int getByteSize(long data) {
        for (int i = 1; i < 10; ++i) {
            if ((data & SIZE_MASKS[i]) != 0L) continue;
            return i;
        }
        return 10;
    }

    @Overwrite
    public static ByteBuf write(ByteBuf buffer, long value) {
        if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) {
            buffer.writeByte((int)value);
        } else if ((value & 0xFFFFFFFFFFFFC000L) == 0L) {
            VarLongMixin.krypton_Multi$writeTwoBytes(buffer, value);
        } else if ((value & 0xFFFFFFFFFFE00000L) == 0L) {
            VarLongMixin.krypton_Multi$writeThreeBytes(buffer, value);
        } else if ((value & 0xFFFFFFFFF0000000L) == 0L) {
            VarLongMixin.krypton_Multi$writeFourBytes(buffer, value);
        } else {
            VarLongMixin.krypton_Multi$writeVarLongFull(buffer, value);
        }
        return buffer;
    }

    @Unique
    private static void krypton_Multi$writeTwoBytes(ByteBuf buffer, long value) {
        int encoded = (int)(value & 0x7FL | 0x80L) << 8 | (int)(value >>> 7);
        buffer.writeShort(encoded);
    }

    @Unique
    private static void krypton_Multi$writeThreeBytes(ByteBuf buffer, long value) {
        int encoded = (int)(value & 0x7FL | 0x80L) << 16 | (int)(value >>> 7 & 0x7FL | 0x80L) << 8 | (int)(value >>> 14);
        buffer.writeMedium(encoded);
    }

    @Unique
    private static void krypton_Multi$writeFourBytes(ByteBuf buffer, long value) {
        int encoded = (int)(value & 0x7FL | 0x80L) << 24 | (int)(value >>> 7 & 0x7FL | 0x80L) << 16 | (int)(value >>> 14 & 0x7FL | 0x80L) << 8 | (int)(value >>> 21);
        buffer.writeInt(encoded);
    }

    @Unique
    private static void krypton_Multi$writeVarLongFull(ByteBuf buffer, long value) {
        while ((value & 0xFFFFFFFFFFFFFF80L) != 0L) {
            buffer.writeByte((int)(value & 0x7FL) | 0x80);
            value >>>= 7;
        }
        buffer.writeByte((int)value);
    }
}

