/*
 * Decompiled with CFR 0.152.
 */
package com.pokeskies.battleblocker.utils;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.pokeskies.battleblocker.BattleBlocker;
import com.pokeskies.battleblocker.config.ConfigManager;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_2378;
import net.minecraft.class_2596;
import net.minecraft.class_2767;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_6880;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u001b\u001cB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J!\u0010\t\u001a\u00020\b2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00042\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\u000b\u001a\u00020\b2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\r\u001a\u00020\b2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\r\u0010\fJ-\u0010\u0015\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0015\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0017\u00a2\u0006\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001d"}, d2={"Lcom/pokeskies/battleblocker/utils/Utils;", "", "<init>", "()V", "", "message", "", "bypassCheck", "", "printDebug", "(Ljava/lang/String;Z)V", "printError", "(Ljava/lang/String;)V", "printInfo", "Lnet/minecraft/class_3222;", "player", "Lnet/minecraft/class_3414;", "sound", "", "volume", "pitch", "sendPlayerSound", "(Lnet/minecraft/class_3222;Lnet/minecraft/class_3414;FF)V", "", "time", "getFormattedTime", "(J)Ljava/lang/String;", "RegistrySerializer", "CodecSerializer", "BattleBlocker"})
public final class Utils {
    @NotNull
    public static final Utils INSTANCE = new Utils();

    private Utils() {
    }

    public final void printDebug(@Nullable String message, boolean bypassCheck) {
        if (bypassCheck || ConfigManager.INSTANCE.getCONFIG().getDebug()) {
            BattleBlocker.Companion.getLOGGER().info("[" + BattleBlocker.Companion.getMOD_NAME() + "] DEBUG: " + message);
        }
    }

    public static /* synthetic */ void printDebug$default(Utils utils, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        utils.printDebug(string, bl);
    }

    public final void printError(@Nullable String message) {
        BattleBlocker.Companion.getLOGGER().error("[" + BattleBlocker.Companion.getMOD_NAME() + "] ERROR: " + message);
    }

    public final void printInfo(@Nullable String message) {
        BattleBlocker.Companion.getLOGGER().info("[" + BattleBlocker.Companion.getMOD_NAME() + "] " + message);
    }

    public final void sendPlayerSound(@NotNull class_3222 player, @NotNull class_3414 sound, float volume, float pitch) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)sound, (String)"sound");
        player.field_13987.method_14364((class_2596)new class_2767(class_6880.method_40223((Object)sound), class_3419.field_15250, player.method_23317(), player.method_23318(), player.method_23321(), volume, pitch, player.method_37908().method_8409().method_43055()));
    }

    @NotNull
    public final String getFormattedTime(long time) {
        if (time <= 0L) {
            return "0s";
        }
        List timeFormatted = new ArrayList();
        long days = time / (long)86400;
        long hours = time % (long)86400 / (long)3600;
        long minutes = time % (long)86400 % (long)3600 / (long)60;
        long seconds = time % (long)86400 % (long)3600 % (long)60;
        if (days > 0L) {
            timeFormatted.add(days + "d");
        }
        if (hours > 0L) {
            timeFormatted.add(hours + "h");
        }
        if (minutes > 0L) {
            timeFormatted.add(minutes + "m");
        }
        if (seconds > 0L) {
            timeFormatted.add(seconds + "s");
        }
        String string = String.join((CharSequence)" ", timeFormatted);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"join(...)");
        return string;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\b\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u00028\u00000\u00022\b\u0012\u0004\u0012\u00028\u00000\u0003B\u0015\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J/\u0010\u000e\u001a\u0004\u0018\u00018\u00002\b\u0010\t\u001a\u0004\u0018\u00010\b2\b\u0010\u000b\u001a\u0004\u0018\u00010\n2\b\u0010\r\u001a\u0004\u0018\u00010\fH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ-\u0010\u0013\u001a\u00020\b2\b\u0010\u0010\u001a\u0004\u0018\u00018\u00002\b\u0010\u0011\u001a\u0004\u0018\u00010\n2\b\u0010\r\u001a\u0004\u0018\u00010\u0012H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\u0015\u0010\u0016J&\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004H\u00c6\u0001\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u001a\u0010\u001c\u001a\u00020\u001b2\b\u0010\u001a\u001a\u0004\u0018\u00010\u0019H\u00d6\u0003\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0010\u0010\u001f\u001a\u00020\u001eH\u00d6\u0001\u00a2\u0006\u0004\b\u001f\u0010 J\u0010\u0010\"\u001a\u00020!H\u00d6\u0001\u00a2\u0006\u0004\b\"\u0010#R\u001d\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010$\u001a\u0004\b%\u0010\u0016\u00a8\u0006&"}, d2={"Lcom/pokeskies/battleblocker/utils/Utils$CodecSerializer;", "T", "Lcom/google/gson/JsonSerializer;", "Lcom/google/gson/JsonDeserializer;", "Lcom/mojang/serialization/Codec;", "codec", "<init>", "(Lcom/mojang/serialization/Codec;)V", "Lcom/google/gson/JsonElement;", "json", "Ljava/lang/reflect/Type;", "typeOfT", "Lcom/google/gson/JsonDeserializationContext;", "context", "deserialize", "(Lcom/google/gson/JsonElement;Ljava/lang/reflect/Type;Lcom/google/gson/JsonDeserializationContext;)Ljava/lang/Object;", "src", "typeOfSrc", "Lcom/google/gson/JsonSerializationContext;", "serialize", "(Ljava/lang/Object;Ljava/lang/reflect/Type;Lcom/google/gson/JsonSerializationContext;)Lcom/google/gson/JsonElement;", "component1", "()Lcom/mojang/serialization/Codec;", "copy", "(Lcom/mojang/serialization/Codec;)Lcom/pokeskies/battleblocker/utils/Utils$CodecSerializer;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Lcom/mojang/serialization/Codec;", "getCodec", "BattleBlocker"})
    public static final class CodecSerializer<T>
    implements JsonSerializer<T>,
    JsonDeserializer<T> {
        @NotNull
        private final Codec<T> codec;

        public CodecSerializer(@NotNull Codec<T> codec) {
            Intrinsics.checkNotNullParameter(codec, (String)"codec");
            this.codec = codec;
        }

        @NotNull
        public final Codec<T> getCodec() {
            return this.codec;
        }

        @Nullable
        public T deserialize(@Nullable JsonElement json, @Nullable Type typeOfT, @Nullable JsonDeserializationContext context) throws JsonParseException {
            Object object;
            try {
                object = ((Pair)this.codec.decode((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow()).getFirst();
            }
            catch (Throwable e) {
                INSTANCE.printError("There was an error while deserializing a Codec: " + this.codec);
                object = null;
            }
            return (T)object;
        }

        @NotNull
        public JsonElement serialize(@Nullable T src, @Nullable Type typeOfSrc, @Nullable JsonSerializationContext context) {
            JsonElement jsonElement;
            try {
                jsonElement = src != null ? (JsonElement)this.codec.encodeStart((DynamicOps)JsonOps.INSTANCE, src).getOrThrow() : (JsonElement)JsonNull.INSTANCE;
                Intrinsics.checkNotNull((Object)jsonElement);
            }
            catch (Throwable e) {
                INSTANCE.printError("There was an error while serializing a Codec: " + this.codec);
                JsonNull jsonNull = JsonNull.INSTANCE;
                Intrinsics.checkNotNull((Object)jsonNull);
                jsonElement = (JsonElement)jsonNull;
            }
            return jsonElement;
        }

        @NotNull
        public final Codec<T> component1() {
            return this.codec;
        }

        @NotNull
        public final CodecSerializer<T> copy(@NotNull Codec<T> codec) {
            Intrinsics.checkNotNullParameter(codec, (String)"codec");
            return new CodecSerializer<T>(codec);
        }

        public static /* synthetic */ CodecSerializer copy$default(CodecSerializer codecSerializer, Codec codec, int n, Object object) {
            if ((n & 1) != 0) {
                codec = codecSerializer.codec;
            }
            return codecSerializer.copy(codec);
        }

        @NotNull
        public String toString() {
            return "CodecSerializer(codec=" + this.codec + ")";
        }

        public int hashCode() {
            return this.codec.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CodecSerializer)) {
                return false;
            }
            CodecSerializer codecSerializer = (CodecSerializer)other;
            return Intrinsics.areEqual(this.codec, codecSerializer.codec);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\b\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u00028\u00000\u00022\b\u0012\u0004\u0012\u00028\u00000\u0003B\u0015\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J)\u0010\u000e\u001a\u0004\u0018\u00018\u00002\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ'\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00028\u00002\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\u0015\u0010\u0016J&\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004H\u00c6\u0001\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u001a\u0010\u001c\u001a\u00020\u001b2\b\u0010\u001a\u001a\u0004\u0018\u00010\u0019H\u00d6\u0003\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0010\u0010\u001f\u001a\u00020\u001eH\u00d6\u0001\u00a2\u0006\u0004\b\u001f\u0010 J\u0010\u0010\"\u001a\u00020!H\u00d6\u0001\u00a2\u0006\u0004\b\"\u0010#R\u001d\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010$\u001a\u0004\b%\u0010\u0016\u00a8\u0006&"}, d2={"Lcom/pokeskies/battleblocker/utils/Utils$RegistrySerializer;", "T", "Lcom/google/gson/JsonSerializer;", "Lcom/google/gson/JsonDeserializer;", "Lnet/minecraft/class_2378;", "registry", "<init>", "(Lnet/minecraft/class_2378;)V", "Lcom/google/gson/JsonElement;", "json", "Ljava/lang/reflect/Type;", "typeOfT", "Lcom/google/gson/JsonDeserializationContext;", "context", "deserialize", "(Lcom/google/gson/JsonElement;Ljava/lang/reflect/Type;Lcom/google/gson/JsonDeserializationContext;)Ljava/lang/Object;", "src", "typeOfSrc", "Lcom/google/gson/JsonSerializationContext;", "serialize", "(Ljava/lang/Object;Ljava/lang/reflect/Type;Lcom/google/gson/JsonSerializationContext;)Lcom/google/gson/JsonElement;", "component1", "()Lnet/minecraft/class_2378;", "copy", "(Lnet/minecraft/class_2378;)Lcom/pokeskies/battleblocker/utils/Utils$RegistrySerializer;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Lnet/minecraft/class_2378;", "getRegistry", "BattleBlocker"})
    public static final class RegistrySerializer<T>
    implements JsonSerializer<T>,
    JsonDeserializer<T> {
        @NotNull
        private final class_2378<T> registry;

        public RegistrySerializer(@NotNull class_2378<T> registry) {
            Intrinsics.checkNotNullParameter(registry, (String)"registry");
            this.registry = registry;
        }

        @NotNull
        public final class_2378<T> getRegistry() {
            return this.registry;
        }

        @Nullable
        public T deserialize(@NotNull JsonElement json, @NotNull Type typeOfT, @NotNull JsonDeserializationContext context) throws JsonParseException {
            Object parsed;
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            Intrinsics.checkNotNullParameter((Object)typeOfT, (String)"typeOfT");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Object object = parsed = json.isJsonPrimitive() ? this.registry.method_10223(class_2960.method_12829((String)json.getAsString())) : null;
            if (parsed == null) {
                INSTANCE.printError("There was an error while deserializing a Registry Type: " + this.registry);
            }
            return (T)parsed;
        }

        @NotNull
        public JsonElement serialize(T src, @NotNull Type typeOfSrc, @NotNull JsonSerializationContext context) {
            Intrinsics.checkNotNullParameter((Object)typeOfSrc, (String)"typeOfSrc");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            return (JsonElement)new JsonPrimitive(String.valueOf(this.registry.method_10206(src)));
        }

        @NotNull
        public final class_2378<T> component1() {
            return this.registry;
        }

        @NotNull
        public final RegistrySerializer<T> copy(@NotNull class_2378<T> registry) {
            Intrinsics.checkNotNullParameter(registry, (String)"registry");
            return new RegistrySerializer<T>(registry);
        }

        public static /* synthetic */ RegistrySerializer copy$default(RegistrySerializer registrySerializer, class_2378 class_23782, int n, Object object) {
            if ((n & 1) != 0) {
                class_23782 = registrySerializer.registry;
            }
            return registrySerializer.copy(class_23782);
        }

        @NotNull
        public String toString() {
            return "RegistrySerializer(registry=" + this.registry + ")";
        }

        public int hashCode() {
            return this.registry.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RegistrySerializer)) {
                return false;
            }
            RegistrySerializer registrySerializer = (RegistrySerializer)other;
            return Intrinsics.areEqual(this.registry, registrySerializer.registry);
        }
    }
}

