/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.fluid.block.CopperTap;

import com.adonis.fluid.CreateFluid;
import com.adonis.fluid.block.CopperTap.CopperTapBlock;
import com.adonis.fluid.packet.CopperTapParticlePacket;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.api.behaviour.spouting.CauldronSpoutingBehavior;
import com.simibubi.create.content.fluids.FluidFX;
import com.simibubi.create.content.fluids.spout.FillingBySpout;
import com.simibubi.create.content.kinetics.belt.transport.TransportedItemStack;
import com.simibubi.create.content.logistics.depot.DepotBehaviour;
import com.simibubi.create.content.logistics.depot.DepotBlockEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Containers;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.network.PacketDistributor;

public class CopperTapBlockEntity
extends SmartBlockEntity {
    private FluidStack renderingFluid = FluidStack.EMPTY;
    private int processingTicks = 0;
    private static final int FILLING_TIME = 20;
    private static final int TRANSFER_RATE = 250;
    private static final int TRANSFER_INTERVAL = 10;
    private int transferCooldown = 0;
    private ItemStack processingItem = ItemStack.EMPTY;
    private boolean isFillingItem = false;
    private FluidStack pendingFluid = FluidStack.EMPTY;
    private Direction sourceDirection = null;
    private BlockPos sourceBlockPos = null;
    private int continuousProcessingDelay = 0;
    private boolean shouldDrip = false;
    private int dripTickCounter = 0;
    private FluidStack dripFluid = FluidStack.EMPTY;
    private static final int DRIP_INTERVAL = 25;
    private static final TagKey<Block> TAP_FILLABLE = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)CreateFluid.asResource("tap_fillable"));

    public CopperTapBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    private boolean isCopperGrate(BlockState state) {
        Block block = state.getBlock();
        return block == Blocks.COPPER_GRATE || block == Blocks.EXPOSED_COPPER_GRATE || block == Blocks.WEATHERED_COPPER_GRATE || block == Blocks.OXIDIZED_COPPER_GRATE || block == Blocks.WAXED_COPPER_GRATE || block == Blocks.WAXED_EXPOSED_COPPER_GRATE || block == Blocks.WAXED_WEATHERED_COPPER_GRATE || block == Blocks.WAXED_OXIDIZED_COPPER_GRATE;
    }

    public void tick() {
        super.tick();
        if (this.level == null || this.level.isClientSide) {
            return;
        }
        BlockState state = this.getBlockState();
        boolean isOpen = (Boolean)state.getValue((Property)BlockStateProperties.OPEN);
        if (!isOpen) {
            boolean needsUpdate = !this.renderingFluid.isEmpty() || !this.pendingFluid.isEmpty() || this.shouldDrip;
            this.renderingFluid = FluidStack.EMPTY;
            this.pendingFluid = FluidStack.EMPTY;
            this.dripFluid = FluidStack.EMPTY;
            this.isFillingItem = false;
            this.processingTicks = 0;
            this.processingItem = ItemStack.EMPTY;
            this.sourceDirection = null;
            this.sourceBlockPos = null;
            this.continuousProcessingDelay = 0;
            this.shouldDrip = false;
            this.dripTickCounter = 0;
            this.transferCooldown = 0;
            if (needsUpdate) {
                this.notifyUpdate();
                this.setChanged();
                if (this.level != null && !this.level.isClientSide) {
                    this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
                }
            }
            return;
        }
        if (this.continuousProcessingDelay > 0) {
            --this.continuousProcessingDelay;
            if (this.continuousProcessingDelay == 0) {
                this.transferCooldown = 0;
            }
            return;
        }
        if (this.transferCooldown > 0) {
            --this.transferCooldown;
        }
        if (this.isFillingItem && this.processingTicks > 0) {
            --this.processingTicks;
            if (!this.validateItemStillPresent()) {
                this.cancelItemFilling();
                return;
            }
            if (this.processingTicks == 0) {
                this.finishItemFilling();
            }
            return;
        }
        if (this.transferCooldown == 0) {
            this.tryTransferFluid();
        }
        if (this.shouldDrip) {
            ++this.dripTickCounter;
            if (this.dripTickCounter >= 25) {
                this.dripTickCounter = 0;
                this.spawnDripParticle();
            }
        }
    }

    public void onTargetChanged() {
        if (this.isFillingItem) {
            this.cancelItemFilling();
        }
        this.transferCooldown = 0;
        this.continuousProcessingDelay = 0;
        this.shouldDrip = false;
        this.dripTickCounter = 0;
        this.dripFluid = FluidStack.EMPTY;
        this.notifyUpdate();
    }

    private boolean validateItemStillPresent() {
        if (this.processingItem.isEmpty()) {
            return false;
        }
        BlockPos targetPos = this.worldPosition.below();
        BlockEntity targetEntity = this.level.getBlockEntity(targetPos);
        if (targetEntity == null || !this.isDepot(targetEntity)) {
            return false;
        }
        ItemStack currentItem = this.getItemOnDepot(targetEntity);
        return ItemStack.isSameItemSameComponents((ItemStack)currentItem, (ItemStack)this.processingItem) && currentItem.getCount() >= 1;
    }

    private void cancelItemFilling() {
        this.isFillingItem = false;
        this.processingTicks = 0;
        this.processingItem = ItemStack.EMPTY;
        this.renderingFluid = FluidStack.EMPTY;
        this.pendingFluid = FluidStack.EMPTY;
        this.sourceDirection = null;
        this.sourceBlockPos = null;
        this.continuousProcessingDelay = 0;
        this.level.playSound(null, this.worldPosition, SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS, 0.25f, 2.0f);
        this.notifyUpdate();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void tryTransferFluid() {
        WaterloggedBlockFluidHandler sourceHandler;
        BlockPos sourcePos;
        Direction attached;
        block15: {
            attached = (Direction)this.getBlockState().getValue((Property)CopperTapBlock.FACING);
            sourcePos = this.worldPosition.relative(attached.getOpposite());
            BlockState sourceState = this.level.getBlockState(sourcePos);
            sourceHandler = null;
            if (sourceState.is(BlockTags.LEAVES) || this.isCopperGrate(sourceState)) {
                if (sourceState.hasProperty((Property)BlockStateProperties.WATERLOGGED) && ((Boolean)sourceState.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
                    sourceHandler = new WaterloggedBlockFluidHandler();
                    break block15;
                } else {
                    if (this.renderingFluid.isEmpty()) {
                        if (!this.shouldDrip) return;
                    }
                    this.renderingFluid = FluidStack.EMPTY;
                    this.shouldDrip = false;
                    this.dripTickCounter = 0;
                    this.notifyUpdate();
                    return;
                }
            }
            BlockEntity sourceEntity = this.level.getBlockEntity(sourcePos);
            if (sourceEntity == null) {
                if (this.renderingFluid.isEmpty()) {
                    if (!this.shouldDrip) return;
                }
                this.renderingFluid = FluidStack.EMPTY;
                this.shouldDrip = false;
                this.dripTickCounter = 0;
                this.notifyUpdate();
                return;
            }
            sourceHandler = (IFluidHandler)this.level.getCapability(Capabilities.FluidHandler.BLOCK, sourcePos, (Object)attached);
            if (sourceHandler == null) {
                sourceHandler = (IFluidHandler)this.level.getCapability(Capabilities.FluidHandler.BLOCK, sourcePos, null);
            }
        }
        if (sourceHandler == null) {
            if (this.renderingFluid.isEmpty()) {
                if (!this.shouldDrip) return;
            }
            this.renderingFluid = FluidStack.EMPTY;
            this.shouldDrip = false;
            this.dripTickCounter = 0;
            this.notifyUpdate();
            return;
        }
        FluidStack availableFluid = sourceHandler.drain(1, IFluidHandler.FluidAction.SIMULATE);
        if (availableFluid.isEmpty()) {
            if (this.renderingFluid.isEmpty()) {
                if (!this.shouldDrip) return;
            }
            this.renderingFluid = FluidStack.EMPTY;
            this.shouldDrip = false;
            this.dripTickCounter = 0;
            this.notifyUpdate();
            return;
        }
        BlockPos targetPos = this.worldPosition.below();
        boolean success = this.tryProcess(sourceHandler, targetPos, attached, sourcePos);
        if (success) {
            this.transferCooldown = 5;
            if (!this.shouldDrip) return;
            this.shouldDrip = false;
            this.dripTickCounter = 0;
            this.dripFluid = FluidStack.EMPTY;
            this.notifyUpdate();
            return;
        }
        this.transferCooldown = 10;
        boolean wasNotDripping = !this.shouldDrip;
        boolean fluidChanged = false;
        FluidStack newDripFluid = availableFluid.copy();
        newDripFluid.setAmount(Math.min(newDripFluid.getAmount(), 250));
        if (!this.dripFluid.isEmpty() && !FluidStack.isSameFluidSameComponents((FluidStack)this.dripFluid, (FluidStack)newDripFluid)) {
            fluidChanged = true;
        }
        this.dripFluid = newDripFluid;
        this.shouldDrip = true;
        if (fluidChanged) {
            this.dripTickCounter = 24;
        }
        if (this.renderingFluid.isEmpty() && !wasNotDripping) {
            if (!fluidChanged) return;
        }
        this.renderingFluid = FluidStack.EMPTY;
        this.notifyUpdate();
    }

    private void spawnDripParticle() {
        Level level;
        if (this.level == null || !((level = this.level) instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (this.dripFluid.isEmpty()) {
            return;
        }
        ParticleOptions fluidParticle = FluidFX.getFluidParticle((FluidStack)this.dripFluid);
        Vec3 spoutPos = Vec3.atCenterOf((Vec3i)this.worldPosition).add(0.0, -0.3, 0.0);
        for (int i = 0; i < 2; ++i) {
            double yOffset = -0.05 * (double)i;
            serverLevel.sendParticles(fluidParticle, spoutPos.x, spoutPos.y + yOffset, spoutPos.z, 1, 0.005, 0.0, 0.005, 0.005);
        }
        serverLevel.sendParticles(fluidParticle, spoutPos.x, spoutPos.y - 0.15, spoutPos.z, 1, 0.01, 0.0, 0.01, 0.15);
        serverLevel.sendParticles(fluidParticle, spoutPos.x, spoutPos.y - 0.3, spoutPos.z, 1, 0.015, 0.0, 0.015, 0.25);
        if (this.level.random.nextFloat() < 0.2f) {
            this.level.playSound(null, this.worldPosition, SoundEvents.POINTED_DRIPSTONE_DRIP_WATER, SoundSource.BLOCKS, 0.2f, 0.8f + this.level.random.nextFloat() * 0.4f);
        }
    }

    private boolean tryProcess(IFluidHandler sourceHandler, BlockPos targetPos, Direction sourceDir, BlockPos sourcePos) {
        BlockEntity targetEntity = this.level.getBlockEntity(targetPos);
        BlockState targetState = this.level.getBlockState(targetPos);
        if (targetEntity != null && this.isDepot(targetEntity)) {
            ItemStack itemOnDepot = this.getItemOnDepot(targetEntity);
            if (!itemOnDepot.isEmpty() && FillingBySpout.canItemBeFilled((Level)this.level, (ItemStack)itemOnDepot)) {
                return this.startItemFilling(sourceHandler, targetPos, itemOnDepot, sourceDir, sourcePos);
            }
            return false;
        }
        if (targetState.is(Blocks.CAULDRON) || targetState.is(Blocks.WATER_CAULDRON)) {
            return this.tryFillCauldron(sourceHandler, targetPos, targetState);
        }
        if (targetState.is(TAP_FILLABLE) && targetEntity != null) {
            return this.tryFillContainer(sourceHandler, targetEntity);
        }
        return false;
    }

    private boolean tryFillCauldron(IFluidHandler sourceHandler, BlockPos targetPos, BlockState targetState) {
        FluidStack availableFluid = sourceHandler.drain(1000, IFluidHandler.FluidAction.SIMULATE);
        if (availableFluid.isEmpty()) {
            return false;
        }
        if (availableFluid.getFluid() == Fluids.WATER) {
            int currentLevel;
            if (targetState.is(Blocks.CAULDRON)) {
                return this.fillWaterCauldronLevel(sourceHandler, targetPos, targetState, 1);
            }
            if (targetState.is(Blocks.WATER_CAULDRON) && targetState.hasProperty((Property)LayeredCauldronBlock.LEVEL) && (currentLevel = ((Integer)targetState.getValue((Property)LayeredCauldronBlock.LEVEL)).intValue()) < 3) {
                return this.fillWaterCauldronLevel(sourceHandler, targetPos, targetState, currentLevel + 1);
            }
            return false;
        }
        if (!targetState.is(Blocks.CAULDRON)) {
            return false;
        }
        CauldronSpoutingBehavior.CauldronInfo cauldronInfo = (CauldronSpoutingBehavior.CauldronInfo)CauldronSpoutingBehavior.CAULDRON_INFO.get((Object)availableFluid.getFluid());
        if (cauldronInfo == null) {
            return false;
        }
        if (availableFluid.getAmount() < cauldronInfo.amount()) {
            return false;
        }
        FluidStack drained = sourceHandler.drain(cauldronInfo.amount(), IFluidHandler.FluidAction.EXECUTE);
        if (drained.isEmpty() || drained.getAmount() < cauldronInfo.amount()) {
            return false;
        }
        this.level.setBlockAndUpdate(targetPos, cauldronInfo.cauldron());
        this.renderingFluid = drained.copy();
        this.level.playSound(null, targetPos, SoundEvents.BUCKET_EMPTY, SoundSource.BLOCKS, 0.5f, 1.0f);
        this.sendFillingParticles(targetPos, drained);
        this.notifyUpdate();
        return true;
    }

    private boolean fillWaterCauldronLevel(IFluidHandler sourceHandler, BlockPos targetPos, BlockState currentState, int targetLevel) {
        int requiredAmount = 250;
        FluidStack availableWater = sourceHandler.drain(requiredAmount, IFluidHandler.FluidAction.SIMULATE);
        if (availableWater.isEmpty() || availableWater.getAmount() < requiredAmount || availableWater.getFluid() != Fluids.WATER) {
            return false;
        }
        FluidStack drained = sourceHandler.drain(requiredAmount, IFluidHandler.FluidAction.EXECUTE);
        if (drained.isEmpty() || drained.getAmount() < requiredAmount) {
            return false;
        }
        BlockState newState = (BlockState)Blocks.WATER_CAULDRON.defaultBlockState().setValue((Property)LayeredCauldronBlock.LEVEL, (Comparable)Integer.valueOf(targetLevel));
        this.level.setBlockAndUpdate(targetPos, newState);
        this.renderingFluid = drained.copy();
        float pitch = 0.8f + (float)targetLevel * 0.1f;
        this.level.playSound(null, targetPos, SoundEvents.BUCKET_EMPTY, SoundSource.BLOCKS, 0.5f, pitch);
        this.sendFillingParticles(targetPos, drained);
        this.notifyUpdate();
        return true;
    }

    private boolean startItemFilling(IFluidHandler sourceHandler, BlockPos targetPos, ItemStack item, Direction sourceDir, BlockPos sourcePos) {
        FluidStack availableFluid = sourceHandler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE);
        if (availableFluid.isEmpty()) {
            return false;
        }
        int requiredAmount = FillingBySpout.getRequiredAmountForItem((Level)this.level, (ItemStack)item, (FluidStack)availableFluid);
        if (requiredAmount <= 0 || requiredAmount > availableFluid.getAmount()) {
            return false;
        }
        FluidStack simulatedDrain = sourceHandler.drain(requiredAmount, IFluidHandler.FluidAction.SIMULATE);
        if (simulatedDrain.isEmpty() || simulatedDrain.getAmount() < requiredAmount) {
            return false;
        }
        this.isFillingItem = true;
        this.processingTicks = 20;
        this.processingItem = item.copy();
        this.processingItem.setCount(1);
        this.pendingFluid = simulatedDrain.copy();
        this.renderingFluid = simulatedDrain.copy();
        this.sourceDirection = sourceDir;
        this.sourceBlockPos = sourcePos.immutable();
        AllSoundEvents.SPOUTING.playOnServer(this.level, (Vec3i)this.worldPosition, 0.75f, 0.9f + 0.2f * this.level.random.nextFloat());
        this.sendFillingParticles(targetPos, simulatedDrain);
        this.notifyUpdate();
        return true;
    }

    private void sendFillingParticles(BlockPos targetPos, FluidStack fluid) {
        if (this.level.isClientSide || fluid.isEmpty()) {
            return;
        }
        Vec3 startPos = Vec3.atCenterOf((Vec3i)this.worldPosition).add(0.0, -0.25, 0.0);
        Vec3 endPos = Vec3.atCenterOf((Vec3i)targetPos).add(0.0, 0.5, 0.0);
        PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)((ServerLevel)this.level), (ChunkPos)this.level.getChunkAt(targetPos).getPos(), (CustomPacketPayload)new CopperTapParticlePacket(startPos, endPos, fluid), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private void finishItemFilling() {
        if (!this.isFillingItem || this.processingItem.isEmpty() || this.pendingFluid.isEmpty()) {
            return;
        }
        BlockPos targetPos = this.worldPosition.below();
        BlockEntity targetEntity = this.level.getBlockEntity(targetPos);
        if (targetEntity != null && this.isDepot(targetEntity)) {
            ItemStack itemOnDepot;
            ItemStack currentItem = this.getItemOnDepot(targetEntity);
            if (!ItemStack.isSameItemSameComponents((ItemStack)currentItem, (ItemStack)this.processingItem) || currentItem.getCount() < 1) {
                this.cancelItemFilling();
                return;
            }
            boolean fluidConsumed = false;
            if (this.sourceBlockPos != null && this.sourceDirection != null) {
                BlockState sourceState = this.level.getBlockState(this.sourceBlockPos);
                if ((sourceState.is(BlockTags.LEAVES) || this.isCopperGrate(sourceState)) && sourceState.hasProperty((Property)BlockStateProperties.WATERLOGGED) && ((Boolean)sourceState.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue() && this.pendingFluid.getFluid() == Fluids.WATER) {
                    fluidConsumed = true;
                } else {
                    BlockEntity sourceEntity = this.level.getBlockEntity(this.sourceBlockPos);
                    if (sourceEntity != null) {
                        FluidStack drained;
                        IFluidHandler sourceHandler = (IFluidHandler)this.level.getCapability(Capabilities.FluidHandler.BLOCK, this.sourceBlockPos, (Object)this.sourceDirection);
                        if (sourceHandler == null) {
                            sourceHandler = (IFluidHandler)this.level.getCapability(Capabilities.FluidHandler.BLOCK, this.sourceBlockPos, null);
                        }
                        if (sourceHandler != null && !(drained = sourceHandler.drain(this.pendingFluid, IFluidHandler.FluidAction.EXECUTE)).isEmpty() && drained.getAmount() >= this.pendingFluid.getAmount()) {
                            fluidConsumed = true;
                        }
                    }
                }
            }
            if (!fluidConsumed) {
                this.cancelItemFilling();
                return;
            }
            DepotBehaviour behaviour = (DepotBehaviour)DepotBehaviour.get((BlockEntity)targetEntity, (BehaviourType)DepotBehaviour.TYPE);
            if (behaviour != null && !(itemOnDepot = behaviour.getHeldItemStack()).isEmpty()) {
                ItemStack singleItem = itemOnDepot.copy();
                singleItem.setCount(1);
                ItemStack result = FillingBySpout.fillItem((Level)this.level, (int)this.pendingFluid.getAmount(), (ItemStack)singleItem, (FluidStack)this.pendingFluid);
                if (!result.isEmpty()) {
                    itemOnDepot.shrink(1);
                    if (itemOnDepot.isEmpty()) {
                        TransportedItemStack resultTIS = new TransportedItemStack(result);
                        behaviour.setHeldItem(resultTIS);
                    } else {
                        TransportedItemStack updatedTIS = new TransportedItemStack(itemOnDepot);
                        behaviour.setHeldItem(updatedTIS);
                        try {
                            Field bufferField = DepotBehaviour.class.getDeclaredField("processingOutputBuffer");
                            bufferField.setAccessible(true);
                            ItemStackHandler outputBuffer = (ItemStackHandler)bufferField.get(behaviour);
                            ItemStack remainder = result.copy();
                            for (int slot = 0; slot < outputBuffer.getSlots() && !remainder.isEmpty(); ++slot) {
                                remainder = outputBuffer.insertItem(slot, remainder, false);
                            }
                            if (!remainder.isEmpty()) {
                                Vec3 dropPos = Vec3.atCenterOf((Vec3i)targetPos);
                                Containers.dropItemStack((Level)this.level, (double)dropPos.x, (double)(dropPos.y + 0.5), (double)dropPos.z, (ItemStack)remainder);
                            }
                        }
                        catch (Exception e) {
                            Vec3 dropPos = Vec3.atCenterOf((Vec3i)targetPos);
                            Containers.dropItemStack((Level)this.level, (double)dropPos.x, (double)(dropPos.y + 0.5), (double)dropPos.z, (ItemStack)result);
                        }
                    }
                    targetEntity.setChanged();
                    if (!this.level.isClientSide) {
                        this.level.sendBlockUpdated(targetPos, targetEntity.getBlockState(), targetEntity.getBlockState(), 3);
                        if (targetEntity instanceof SmartBlockEntity) {
                            SmartBlockEntity smartBE = (SmartBlockEntity)targetEntity;
                            smartBE.notifyUpdate();
                        }
                    }
                    this.level.playSound(null, targetPos, SoundEvents.BOTTLE_FILL, SoundSource.BLOCKS, 0.5f, 1.0f + this.level.random.nextFloat() * 0.2f);
                    this.sendFillingParticles(targetPos, this.renderingFluid);
                    if (itemOnDepot.isEmpty() && FillingBySpout.canItemBeFilled((Level)this.level, (ItemStack)result)) {
                        this.continuousProcessingDelay = 0;
                        this.isFillingItem = false;
                        this.processingTicks = 0;
                        this.processingItem = ItemStack.EMPTY;
                        this.renderingFluid = FluidStack.EMPTY;
                        this.pendingFluid = FluidStack.EMPTY;
                        this.notifyUpdate();
                        return;
                    }
                }
            }
        }
        this.isFillingItem = false;
        this.processingTicks = 0;
        this.processingItem = ItemStack.EMPTY;
        this.renderingFluid = FluidStack.EMPTY;
        this.pendingFluid = FluidStack.EMPTY;
        this.sourceDirection = null;
        this.sourceBlockPos = null;
        this.continuousProcessingDelay = 0;
        this.notifyUpdate();
    }

    private boolean tryFillContainer(IFluidHandler sourceHandler, BlockEntity targetEntity) {
        IFluidHandler targetHandler = (IFluidHandler)this.level.getCapability(Capabilities.FluidHandler.BLOCK, targetEntity.getBlockPos(), (Object)Direction.UP);
        if (targetHandler == null) {
            targetHandler = (IFluidHandler)this.level.getCapability(Capabilities.FluidHandler.BLOCK, targetEntity.getBlockPos(), null);
        }
        if (targetHandler == null) {
            return false;
        }
        FluidStack drain = sourceHandler.drain(250, IFluidHandler.FluidAction.SIMULATE);
        if (drain.isEmpty()) {
            return false;
        }
        int filled = targetHandler.fill(drain, IFluidHandler.FluidAction.SIMULATE);
        if (filled <= 0) {
            return false;
        }
        FluidStack actualDrain = sourceHandler.drain(filled, IFluidHandler.FluidAction.EXECUTE);
        if (actualDrain.isEmpty()) {
            return false;
        }
        targetHandler.fill(actualDrain, IFluidHandler.FluidAction.EXECUTE);
        this.renderingFluid = actualDrain.copy();
        if (this.level.random.nextFloat() < 0.1f) {
            AllSoundEvents.SPOUTING.playOnServer(this.level, (Vec3i)this.worldPosition, 0.3f, 0.9f + 0.2f * this.level.random.nextFloat());
        }
        this.sendFillingParticles(targetEntity.getBlockPos(), actualDrain);
        this.notifyUpdate();
        return true;
    }

    private boolean isDepot(BlockEntity entity) {
        return entity.getClass().getSimpleName().toLowerCase().contains("depot");
    }

    private ItemStack getItemOnDepot(BlockEntity depot) {
        if (depot instanceof DepotBlockEntity) {
            DepotBlockEntity depotEntity = (DepotBlockEntity)depot;
            return depotEntity.getHeldItem();
        }
        DepotBehaviour behaviour = (DepotBehaviour)DepotBehaviour.get((BlockEntity)depot, (BehaviourType)DepotBehaviour.TYPE);
        if (behaviour != null) {
            return behaviour.getHeldItemStack();
        }
        IItemHandler handler = (IItemHandler)this.level.getCapability(Capabilities.ItemHandler.BLOCK, depot.getBlockPos(), (Object)Direction.UP);
        if (handler != null && handler.getSlots() > 0) {
            return handler.getStackInSlot(0);
        }
        return ItemStack.EMPTY;
    }

    protected void write(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(tag, registries, clientPacket);
        if (!this.renderingFluid.isEmpty()) {
            tag.put("RenderingFluid", this.renderingFluid.save(registries));
        }
        if (!this.pendingFluid.isEmpty()) {
            tag.put("PendingFluid", this.pendingFluid.save(registries));
        }
        if (!this.dripFluid.isEmpty()) {
            tag.put("DripFluid", this.dripFluid.save(registries));
        }
        tag.putBoolean("IsFillingItem", this.isFillingItem);
        tag.putInt("ProcessingTicks", this.processingTicks);
        tag.putInt("TransferCooldown", this.transferCooldown);
        tag.putInt("ContinuousProcessingDelay", this.continuousProcessingDelay);
        tag.putBoolean("ShouldDrip", this.shouldDrip);
        tag.putInt("DripTickCounter", this.dripTickCounter);
        if (!this.processingItem.isEmpty()) {
            tag.put("ProcessingItem", this.processingItem.save(registries));
        }
        if (this.sourceDirection != null) {
            tag.putInt("SourceDirection", this.sourceDirection.get3DDataValue());
        }
        if (this.sourceBlockPos != null) {
            tag.putLong("SourcePos", this.sourceBlockPos.asLong());
        }
    }

    protected void read(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(tag, registries, clientPacket);
        this.renderingFluid = tag.contains("RenderingFluid") ? FluidStack.parse((HolderLookup.Provider)registries, (Tag)tag.getCompound("RenderingFluid")).orElse(FluidStack.EMPTY) : FluidStack.EMPTY;
        this.pendingFluid = tag.contains("PendingFluid") ? FluidStack.parse((HolderLookup.Provider)registries, (Tag)tag.getCompound("PendingFluid")).orElse(FluidStack.EMPTY) : FluidStack.EMPTY;
        this.dripFluid = tag.contains("DripFluid") ? FluidStack.parse((HolderLookup.Provider)registries, (Tag)tag.getCompound("DripFluid")).orElse(FluidStack.EMPTY) : FluidStack.EMPTY;
        this.isFillingItem = tag.getBoolean("IsFillingItem");
        this.processingTicks = tag.getInt("ProcessingTicks");
        this.transferCooldown = tag.getInt("TransferCooldown");
        this.continuousProcessingDelay = tag.getInt("ContinuousProcessingDelay");
        this.shouldDrip = tag.getBoolean("ShouldDrip");
        this.dripTickCounter = tag.getInt("DripTickCounter");
        this.processingItem = tag.contains("ProcessingItem") ? ItemStack.parse((HolderLookup.Provider)registries, (Tag)tag.getCompound("ProcessingItem")).orElse(ItemStack.EMPTY) : ItemStack.EMPTY;
        this.sourceDirection = tag.contains("SourceDirection") ? Direction.from3DDataValue((int)tag.getInt("SourceDirection")) : null;
        this.sourceBlockPos = tag.contains("SourcePos") ? BlockPos.of((long)tag.getLong("SourcePos")) : null;
    }

    public FluidStack getRenderingFluid() {
        return this.renderingFluid;
    }

    public int getProcessingTicks() {
        return this.processingTicks;
    }

    public boolean isProcessing() {
        return this.isFillingItem && this.processingTicks > 0;
    }

    public boolean hasFluidToRender() {
        return !this.renderingFluid.isEmpty();
    }

    public boolean shouldDrip() {
        return this.shouldDrip;
    }

    private static class WaterloggedBlockFluidHandler
    implements IFluidHandler {
        private static final FluidStack WATER = new FluidStack((Fluid)Fluids.WATER, 1000);

        private WaterloggedBlockFluidHandler() {
        }

        public int getTanks() {
            return 1;
        }

        public FluidStack getFluidInTank(int tank) {
            return WATER.copy();
        }

        public int getTankCapacity(int tank) {
            return Integer.MAX_VALUE;
        }

        public boolean isFluidValid(int tank, FluidStack stack) {
            return false;
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            return 0;
        }

        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            if (resource.getFluid() == Fluids.WATER) {
                return new FluidStack((Fluid)Fluids.WATER, Math.min(resource.getAmount(), 1000));
            }
            return FluidStack.EMPTY;
        }

        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            return new FluidStack((Fluid)Fluids.WATER, Math.min(maxDrain, 1000));
        }
    }
}

