/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.fluid.block.CopperTap;

import com.adonis.fluid.block.CopperTap.CopperTapBlock;
import com.adonis.fluid.block.CopperTap.CopperTapBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.simibubi.create.foundation.blockEntity.renderer.SafeBlockEntityRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;

public class CopperTapRenderer
extends SafeBlockEntityRenderer<CopperTapBlockEntity> {
    public CopperTapRenderer(BlockEntityRendererProvider.Context context) {
    }

    protected void renderSafe(CopperTapBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        if (!be.hasFluidToRender()) {
            return;
        }
        FluidStack fluidStack = be.getRenderingFluid();
        if (fluidStack.isEmpty()) {
            return;
        }
        BlockState state = be.getBlockState();
        boolean isOpen = (Boolean)state.getValue((Property)BlockStateProperties.OPEN);
        if (!isOpen) {
            return;
        }
        Direction facing = (Direction)state.getValue((Property)CopperTapBlock.FACING);
        ms.pushPose();
        switch (facing) {
            case SOUTH: {
                ms.translate(0.5, 0.0, 0.5);
                ms.mulPose(Axis.YP.rotationDegrees(180.0f));
                ms.translate(-0.5, 0.0, -0.5);
                break;
            }
            case WEST: {
                ms.translate(0.5, 0.0, 0.5);
                ms.mulPose(Axis.YP.rotationDegrees(270.0f));
                ms.translate(-0.5, 0.0, -0.5);
                break;
            }
            case EAST: {
                ms.translate(0.5, 0.0, 0.5);
                ms.mulPose(Axis.YP.rotationDegrees(90.0f));
                ms.translate(-0.5, 0.0, -0.5);
            }
        }
        this.renderFluidStream(be, fluidStack, ms, buffer, light, partialTicks);
        ms.popPose();
    }

    private void renderFluidStream(CopperTapBlockEntity be, FluidStack fluidStack, PoseStack ms, MultiBufferSource buffer, int light, float partialTicks) {
        float xMin = 0.375f;
        float xMax = 0.625f;
        float zMin = 0.375f;
        float zMax = 0.625f;
        float yTop = 0.25f;
        float yBottom = -0.5f;
        if (be.isProcessing()) {
            float progress = (float)be.getProcessingTicks() / 20.0f;
            float scale = 0.75f + 0.25f * Mth.sin((float)(progress * 3.14159f));
            float center = 0.5f;
            xMin = center - (center - xMin) * scale;
            xMax = center + (xMax - center) * scale;
            zMin = center - (center - zMin) * scale;
            zMax = center + (zMax - center) * scale;
        }
        this.renderFluidBox(fluidStack, xMin, yBottom, zMin, xMax, yTop, zMax, buffer, ms, light, false);
    }

    private void renderFluidBox(FluidStack fluidStack, float xMin, float yMin, float zMin, float xMax, float yMax, float zMax, MultiBufferSource buffer, PoseStack ms, int light, boolean renderBottom) {
        if (fluidStack.isEmpty()) {
            return;
        }
        Fluid fluid = fluidStack.getFluid();
        IClientFluidTypeExtensions fluidExtensions = IClientFluidTypeExtensions.of((Fluid)fluid);
        TextureAtlasSprite texture = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(fluidExtensions.getStillTexture(fluidStack));
        int color = fluidExtensions.getTintColor(fluidStack);
        int blockLightIn = light >> 4 & 0xF;
        int luminosity = Math.max(blockLightIn, fluid.getFluidType().getLightLevel(fluidStack));
        light = light & 0xF00000 | luminosity << 4;
        VertexConsumer builder = buffer.getBuffer(RenderType.translucent());
        CopperTapRenderer.renderStillTiledFace(Direction.UP, xMin, zMin, xMax, zMax, yMax, builder, ms, light, color, texture);
        if (renderBottom) {
            CopperTapRenderer.renderStillTiledFace(Direction.DOWN, xMin, zMin, xMax, zMax, yMin, builder, ms, light, color, texture);
        }
        CopperTapRenderer.renderStillTiledFace(Direction.NORTH, xMin, yMin, xMax, yMax, zMin, builder, ms, light, color, texture);
        CopperTapRenderer.renderStillTiledFace(Direction.SOUTH, xMin, yMin, xMax, yMax, zMax, builder, ms, light, color, texture);
        CopperTapRenderer.renderStillTiledFace(Direction.WEST, zMin, yMin, zMax, yMax, xMin, builder, ms, light, color, texture);
        CopperTapRenderer.renderStillTiledFace(Direction.EAST, zMin, yMin, zMax, yMax, xMax, builder, ms, light, color, texture);
    }

    private static void renderStillTiledFace(Direction dir, float left, float down, float right, float up, float depth, VertexConsumer builder, PoseStack ms, int light, int color, TextureAtlasSprite texture) {
        CopperTapRenderer.renderTiledFace(dir, left, down, right, up, depth, builder, ms, light, color, texture, 1.0f);
    }

    private static void renderTiledFace(Direction dir, float left, float down, float right, float up, float depth, VertexConsumer builder, PoseStack ms, int light, int color, TextureAtlasSprite texture, float textureScale) {
        boolean positive = dir.getAxisDirection() == Direction.AxisDirection.POSITIVE;
        boolean horizontal = dir.getAxis().isHorizontal();
        boolean x = dir.getAxis() == Direction.Axis.X;
        float shrink = texture.uvShrinkRatio() * 0.25f * textureScale;
        float centerU = texture.getU0() + (texture.getU1() - texture.getU0()) * 0.5f * textureScale;
        float centerV = texture.getV0() + (texture.getV1() - texture.getV0()) * 0.5f * textureScale;
        float x2 = 0.0f;
        float y2 = 0.0f;
        float x1 = left;
        while (x1 < right) {
            float u2;
            float u1;
            float f = Mth.floor((float)x1);
            x2 = Math.min(f + 1.0f, right);
            if (dir == Direction.NORTH || dir == Direction.EAST) {
                f = Mth.ceil((float)x2);
                u1 = texture.getU((f - x2) * textureScale);
                u2 = texture.getU((f - x1) * textureScale);
            } else {
                u1 = texture.getU((x1 - f) * textureScale);
                u2 = texture.getU((x2 - f) * textureScale);
            }
            u1 = Mth.lerp((float)shrink, (float)u1, (float)centerU);
            u2 = Mth.lerp((float)shrink, (float)u2, (float)centerU);
            float y1 = down;
            while (y1 < up) {
                float v2;
                float v1;
                f = Mth.floor((float)y1);
                y2 = Math.min(f + 1.0f, up);
                if (dir == Direction.UP) {
                    v1 = texture.getV((y1 - f) * textureScale);
                    v2 = texture.getV((y2 - f) * textureScale);
                } else {
                    f = Mth.ceil((float)y2);
                    v1 = texture.getV((f - y2) * textureScale);
                    v2 = texture.getV((f - y1) * textureScale);
                }
                v1 = Mth.lerp((float)shrink, (float)v1, (float)centerV);
                v2 = Mth.lerp((float)shrink, (float)v2, (float)centerV);
                if (horizontal) {
                    if (x) {
                        CopperTapRenderer.putVertex(builder, ms, depth, y2, positive ? x2 : x1, color, u1, v1, dir, light);
                        CopperTapRenderer.putVertex(builder, ms, depth, y1, positive ? x2 : x1, color, u1, v2, dir, light);
                        CopperTapRenderer.putVertex(builder, ms, depth, y1, positive ? x1 : x2, color, u2, v2, dir, light);
                        CopperTapRenderer.putVertex(builder, ms, depth, y2, positive ? x1 : x2, color, u2, v1, dir, light);
                    } else {
                        CopperTapRenderer.putVertex(builder, ms, positive ? x1 : x2, y2, depth, color, u1, v1, dir, light);
                        CopperTapRenderer.putVertex(builder, ms, positive ? x1 : x2, y1, depth, color, u1, v2, dir, light);
                        CopperTapRenderer.putVertex(builder, ms, positive ? x2 : x1, y1, depth, color, u2, v2, dir, light);
                        CopperTapRenderer.putVertex(builder, ms, positive ? x2 : x1, y2, depth, color, u2, v1, dir, light);
                    }
                } else {
                    CopperTapRenderer.putVertex(builder, ms, x1, depth, positive ? y1 : y2, color, u1, v1, dir, light);
                    CopperTapRenderer.putVertex(builder, ms, x1, depth, positive ? y2 : y1, color, u1, v2, dir, light);
                    CopperTapRenderer.putVertex(builder, ms, x2, depth, positive ? y2 : y1, color, u2, v2, dir, light);
                    CopperTapRenderer.putVertex(builder, ms, x2, depth, positive ? y1 : y2, color, u2, v1, dir, light);
                }
                y1 = y2;
            }
            x1 = x2;
        }
    }

    private static void putVertex(VertexConsumer builder, PoseStack ms, float x, float y, float z, int color, float u, float v, Direction face, int light) {
        Vec3i normal = face.getNormal();
        PoseStack.Pose peek = ms.last();
        int a = color >> 24 & 0xFF;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        builder.addVertex(peek.pose(), x, y, z).setColor(r, g, b, a).setUv(u, v).setLight(light).setNormal(peek, (float)normal.getX(), (float)normal.getY(), (float)normal.getZ());
    }
}

