/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.fluid.block.Pipette;

import com.adonis.fluid.block.Pipette.PipetteBlock;
import com.adonis.fluid.block.Pipette.PipetteBlockEntity;
import com.adonis.fluid.registry.CFPartialModels;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.SingleAxisRotatingVisual;
import com.simibubi.create.content.kinetics.mechanicalArm.ArmRenderer;
import dev.engine_room.flywheel.api.instance.Instance;
import dev.engine_room.flywheel.api.visual.DynamicVisual;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.FlatLit;
import dev.engine_room.flywheel.lib.instance.InstanceTypes;
import dev.engine_room.flywheel.lib.instance.TransformedInstance;
import dev.engine_room.flywheel.lib.model.Models;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.engine_room.flywheel.lib.transform.PoseTransformStack;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import dev.engine_room.flywheel.lib.util.RecyclingPoseStack;
import dev.engine_room.flywheel.lib.visual.SimpleDynamicVisual;
import java.util.ArrayList;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.state.properties.Property;

public class PipetteVisual
extends SingleAxisRotatingVisual<PipetteBlockEntity>
implements SimpleDynamicVisual {
    final TransformedInstance base;
    final TransformedInstance lowerBody;
    final TransformedInstance upperBody;
    final TransformedInstance head;
    private final ArrayList<TransformedInstance> models;
    private final boolean ceiling;
    private final RecyclingPoseStack poseStack = new RecyclingPoseStack();
    private float baseAngle = Float.NaN;
    private float lowerArmAngle = Float.NaN;
    private float upperArmAngle = Float.NaN;
    private float headAngle = Float.NaN;

    public PipetteVisual(VisualizationContext context, PipetteBlockEntity blockEntity, float partialTick) {
        super(context, (KineticBlockEntity)blockEntity, partialTick, Models.partial((PartialModel)PipetteVisual.getRotatingModel()));
        this.base = this.createSafeInstance(CFPartialModels.PIPETTE_BASE, AllPartialModels.ARM_BASE);
        this.lowerBody = this.createSafeInstance(CFPartialModels.PIPETTE_LOWER_ARM, AllPartialModels.ARM_LOWER_BODY);
        this.upperBody = this.createSafeInstance(CFPartialModels.PIPETTE_UPPER_ARM, AllPartialModels.ARM_UPPER_BODY);
        int fluidAmount = blockEntity.heldFluid.isEmpty() ? 0 : blockEntity.heldFluid.getAmount();
        PartialModel headModel = CFPartialModels.getPipetteHeadForFluidAmount(fluidAmount);
        this.head = this.createSafeInstance(headModel, AllPartialModels.ARM_CLAW_BASE);
        this.models = Lists.newArrayList((Object[])new TransformedInstance[]{this.base, this.lowerBody, this.upperBody, this.head});
        this.ceiling = (Boolean)this.blockState.getValue((Property)PipetteBlock.CEILING);
        PoseTransformStack msr = TransformStack.of((PoseStack)this.poseStack);
        msr.translate((Vec3i)this.getVisualPosition());
        msr.center();
        if (this.ceiling) {
            msr.rotateXDegrees(180.0f);
        }
        this.animate(partialTick);
    }

    private static PartialModel getRotatingModel() {
        try {
            if (CFPartialModels.PIPETTE_COG != null) {
                return CFPartialModels.PIPETTE_COG;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return AllPartialModels.ARM_COG;
    }

    private TransformedInstance createSafeInstance(PartialModel model, PartialModel fallback) {
        PartialModel modelToUse = model != null ? model : fallback;
        try {
            return (TransformedInstance)this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)modelToUse)).createInstance();
        }
        catch (Exception e) {
            if (fallback != null && fallback != modelToUse) {
                try {
                    return (TransformedInstance)this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)fallback)).createInstance();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    public void beginFrame(DynamicVisual.Context ctx) {
        try {
            this.animate(ctx.partialTick());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void animate(float pt) {
        try {
            float baseAngleNow = ((PipetteBlockEntity)this.blockEntity).baseAngle.getValue(pt);
            float lowerArmAngleNow = ((PipetteBlockEntity)this.blockEntity).lowerArmAngle.getValue(pt);
            float upperArmAngleNow = ((PipetteBlockEntity)this.blockEntity).upperArmAngle.getValue(pt);
            float headAngleNow = ((PipetteBlockEntity)this.blockEntity).headAngle.getValue(pt);
            boolean settled = Mth.equal((float)this.baseAngle, (float)baseAngleNow) && Mth.equal((float)this.lowerArmAngle, (float)lowerArmAngleNow) && Mth.equal((float)this.upperArmAngle, (float)upperArmAngleNow) && Mth.equal((float)this.headAngle, (float)headAngleNow);
            this.baseAngle = baseAngleNow;
            this.lowerArmAngle = lowerArmAngleNow;
            this.upperArmAngle = upperArmAngleNow;
            this.headAngle = headAngleNow;
            if (!settled) {
                this.animateArm();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void animateArm() {
        this.updateAngles(this.baseAngle, this.lowerArmAngle - 135.0f, this.upperArmAngle - 90.0f, this.headAngle, 0xFFFFFF);
    }

    private void updateAngles(float baseAngle, float lowerArmAngle, float upperArmAngle, float headAngle, int color) {
        try {
            this.poseStack.pushPose();
            PoseTransformStack msr = TransformStack.of((PoseStack)this.poseStack);
            if (this.base != null) {
                ArmRenderer.transformBase((TransformStack)msr, (float)baseAngle);
                this.base.setTransform((PoseStack)this.poseStack).setChanged();
            }
            if (this.lowerBody != null) {
                ArmRenderer.transformLowerArm((TransformStack)msr, (float)lowerArmAngle);
                this.lowerBody.setTransform((PoseStack)this.poseStack).colorRgb(color).setChanged();
            }
            if (this.upperBody != null) {
                ArmRenderer.transformUpperArm((TransformStack)msr, (float)upperArmAngle);
                this.upperBody.setTransform((PoseStack)this.poseStack).colorRgb(color).setChanged();
            }
            if (this.head != null) {
                ArmRenderer.transformHead((TransformStack)msr, (float)headAngle);
                if (this.ceiling && ((PipetteBlockEntity)this.blockEntity).goggles) {
                    msr.rotateZDegrees(180.0f);
                }
                this.head.setTransform((PoseStack)this.poseStack).setChanged();
            }
            this.poseStack.popPose();
        }
        catch (Exception e) {
            try {
                this.poseStack.popPose();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void update(float pt) {
        try {
            super.update(pt);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void updateLight(float partialTick) {
        try {
            super.updateLight(partialTick);
            FlatLit[] litModels = (FlatLit[])this.models.stream().filter(Objects::nonNull).toArray(FlatLit[]::new);
            this.relight(litModels);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void _delete() {
        try {
            super._delete();
            this.models.forEach(model -> {
                if (model != null) {
                    model.delete();
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void collectCrumblingInstances(Consumer<Instance> consumer) {
        try {
            super.collectCrumblingInstances(consumer);
            this.models.stream().filter(Objects::nonNull).forEach(consumer);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

