/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.fluid.block.SmartFluidInterface;

import com.adonis.fluid.block.SmartFluidInterface.SmartFluidInterfaceBlock;
import com.adonis.fluid.block.SmartFluidInterface.SmartFluidInterfaceFilterSlot;
import com.adonis.fluid.registry.CFBlockEntities;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class SmartFluidInterfaceBlockEntity
extends SmartBlockEntity {
    public FilteringBehaviour filtering;

    public SmartFluidInterfaceBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.filtering = new FilteringBehaviour((SmartBlockEntity)this, (ValueBoxTransform)new SmartFluidInterfaceFilterSlot()).forFluids();
        behaviours.add((BlockEntityBehaviour)this.filtering);
    }

    private boolean isCopperGrate(BlockState state) {
        Block block = state.getBlock();
        return block == Blocks.COPPER_GRATE || block == Blocks.EXPOSED_COPPER_GRATE || block == Blocks.WEATHERED_COPPER_GRATE || block == Blocks.OXIDIZED_COPPER_GRATE || block == Blocks.WAXED_COPPER_GRATE || block == Blocks.WAXED_EXPOSED_COPPER_GRATE || block == Blocks.WAXED_WEATHERED_COPPER_GRATE || block == Blocks.WAXED_OXIDIZED_COPPER_GRATE;
    }

    @Nullable
    public IFluidHandler getTargetFluidHandler() {
        if (this.level == null) {
            return null;
        }
        BlockState state = this.getBlockState();
        if (!(state.getBlock() instanceof SmartFluidInterfaceBlock)) {
            return null;
        }
        Direction attachedDirection = ((Direction)state.getValue((Property)SmartFluidInterfaceBlock.FACING)).getOpposite();
        BlockPos targetPos = this.worldPosition.relative(attachedDirection);
        IFluidHandler handler = (IFluidHandler)this.level.getCapability(Capabilities.FluidHandler.BLOCK, targetPos, (Object)((Direction)state.getValue((Property)SmartFluidInterfaceBlock.FACING)));
        if (handler == null) {
            handler = (IFluidHandler)this.level.getCapability(Capabilities.FluidHandler.BLOCK, targetPos, null);
        }
        return handler;
    }

    @Nullable
    public BlockEntity getTargetBlockEntity() {
        if (this.level == null) {
            return null;
        }
        BlockState state = this.getBlockState();
        if (!(state.getBlock() instanceof SmartFluidInterfaceBlock)) {
            return null;
        }
        Direction attachedDirection = ((Direction)state.getValue((Property)SmartFluidInterfaceBlock.FACING)).getOpposite();
        BlockPos targetPos = this.worldPosition.relative(attachedDirection);
        return this.level.getBlockEntity(targetPos);
    }

    protected void write(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(tag, registries, clientPacket);
    }

    protected void read(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(tag, registries, clientPacket);
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)CFBlockEntities.SMART_FLUID_INTERFACE.get(), (be, side) -> {
            BlockState state;
            Direction attachedDirection;
            BlockPos targetPos;
            BlockState targetState;
            IFluidHandler targetHandler = be.getTargetFluidHandler();
            if (targetHandler == null && ((targetState = be.level.getBlockState(targetPos = be.worldPosition.relative(attachedDirection = ((Direction)(state = be.getBlockState()).getValue((Property)SmartFluidInterfaceBlock.FACING)).getOpposite()))).is(BlockTags.LEAVES) || be.isCopperGrate(targetState)) && targetState.hasProperty((Property)BlockStateProperties.WATERLOGGED) && ((Boolean)targetState.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
                targetHandler = new WaterloggedBlockFluidHandler();
            }
            if (targetHandler != null && be.filtering != null) {
                return new FilteredFluidHandler(targetHandler, be.filtering);
            }
            return targetHandler;
        });
    }

    private static class WaterloggedBlockFluidHandler
    implements IFluidHandler {
        private static final FluidStack WATER = new FluidStack((Fluid)Fluids.WATER, 1000);

        private WaterloggedBlockFluidHandler() {
        }

        public int getTanks() {
            return 1;
        }

        public FluidStack getFluidInTank(int tank) {
            return WATER.copy();
        }

        public int getTankCapacity(int tank) {
            return Integer.MAX_VALUE;
        }

        public boolean isFluidValid(int tank, FluidStack stack) {
            return false;
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            return 0;
        }

        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            if (resource.getFluid() == Fluids.WATER) {
                return new FluidStack((Fluid)Fluids.WATER, Math.min(resource.getAmount(), 1000));
            }
            return FluidStack.EMPTY;
        }

        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            return new FluidStack((Fluid)Fluids.WATER, Math.min(maxDrain, 1000));
        }
    }

    private static class FilteredFluidHandler
    implements IFluidHandler {
        private final IFluidHandler wrapped;
        private final FilteringBehaviour filter;

        public FilteredFluidHandler(IFluidHandler wrapped, FilteringBehaviour filter) {
            this.wrapped = wrapped;
            this.filter = filter;
        }

        public int getTanks() {
            return this.wrapped.getTanks();
        }

        public FluidStack getFluidInTank(int tank) {
            FluidStack stack = this.wrapped.getFluidInTank(tank);
            return this.filter.test(stack) ? stack : FluidStack.EMPTY;
        }

        public int getTankCapacity(int tank) {
            return this.wrapped.getTankCapacity(tank);
        }

        public boolean isFluidValid(int tank, FluidStack stack) {
            return this.filter.test(stack) && this.wrapped.isFluidValid(tank, stack);
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            if (!this.filter.test(resource)) {
                return 0;
            }
            return this.wrapped.fill(resource, action);
        }

        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            if (!this.filter.test(resource)) {
                return FluidStack.EMPTY;
            }
            return this.wrapped.drain(resource, action);
        }

        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            FluidStack result = this.wrapped.drain(maxDrain, IFluidHandler.FluidAction.SIMULATE);
            if (!this.filter.test(result)) {
                return FluidStack.EMPTY;
            }
            return action.execute() ? this.wrapped.drain(maxDrain, action) : result;
        }
    }
}

