/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.fluid.content.pipette;

import com.adonis.fluid.content.pipette.FluidInteractionPoint;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.fluids.spout.FillingBySpout;
import com.simibubi.create.content.logistics.depot.DepotBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.fluids.FluidStack;

public class DepotFluidInteractionPoint
extends FluidInteractionPoint {
    public DepotFluidInteractionPoint(Level level, BlockPos pos, BlockState state) {
        super(level, pos, state);
        this.mode = FluidInteractionPoint.Mode.DEPOSIT;
    }

    @Override
    public boolean isValid() {
        if (this.level == null || !this.level.isLoaded(this.pos)) {
            return false;
        }
        BlockState currentState = this.level.getBlockState(this.pos);
        if (!AllBlocks.DEPOT.has(currentState) && !AllBlocks.WEIGHTED_EJECTOR.has(currentState)) {
            return false;
        }
        DepotBehaviour behaviour = (DepotBehaviour)BlockEntityBehaviour.get((BlockGetter)this.level, (BlockPos)this.pos, (BehaviourType)DepotBehaviour.TYPE);
        return behaviour != null;
    }

    @Override
    public void cycleMode() {
    }

    @Nullable
    private DepotBehaviour getDepotBehaviour() {
        return (DepotBehaviour)BlockEntityBehaviour.get((BlockGetter)this.level, (BlockPos)this.pos, (BehaviourType)DepotBehaviour.TYPE);
    }

    public boolean hasItemForFilling() {
        DepotBehaviour behaviour = this.getDepotBehaviour();
        if (behaviour == null) {
            return false;
        }
        ItemStack heldItem = behaviour.getHeldItemStack();
        if (heldItem.isEmpty()) {
            return false;
        }
        return FillingBySpout.canItemBeFilled((Level)this.level, (ItemStack)heldItem);
    }

    @Nullable
    public ItemStack getHeldItem() {
        DepotBehaviour behaviour = this.getDepotBehaviour();
        if (behaviour == null) {
            return null;
        }
        return behaviour.getHeldItemStack().copy();
    }

    @Override
    public FluidStack extract(int maxAmount, boolean simulate) {
        return FluidStack.EMPTY;
    }

    @Override
    public FluidStack insert(FluidStack stack, boolean simulate) {
        return stack;
    }

    @Override
    public boolean canExtract() {
        return false;
    }

    @Override
    public boolean canInsert(FluidStack stack) {
        if (!this.hasItemForFilling()) {
            return false;
        }
        ItemStack heldItem = this.getHeldItem();
        if (heldItem == null || heldItem.isEmpty()) {
            return false;
        }
        int required = FillingBySpout.getRequiredAmountForItem((Level)this.level, (ItemStack)heldItem, (FluidStack)stack);
        return required > 0 && required <= stack.getAmount();
    }
}

