/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.fluid.handler;

import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class CauldronFluidHandler
implements IFluidHandler {
    private final Level level;
    private final BlockPos pos;
    private BlockState state;
    private static final int FULL_AMOUNT = 1000;
    private static final int WATER_LEVEL_CAPACITY = 250;

    public CauldronFluidHandler(Level level, BlockPos pos, BlockState state) {
        this.level = level;
        this.pos = pos;
        this.state = state;
    }

    public int getTanks() {
        return 1;
    }

    @Nonnull
    public FluidStack getFluidInTank(int tank) {
        if (tank != 0) {
            return FluidStack.EMPTY;
        }
        this.state = this.level.getBlockState(this.pos);
        if (this.state.is(Blocks.WATER_CAULDRON)) {
            int level = (Integer)this.state.getValue((Property)LayeredCauldronBlock.LEVEL);
            if (level == 3) {
                return new FluidStack((Fluid)Fluids.WATER, 1000);
            }
            return FluidStack.EMPTY;
        }
        if (this.state.is(Blocks.LAVA_CAULDRON)) {
            return new FluidStack((Fluid)Fluids.LAVA, 1000);
        }
        return FluidStack.EMPTY;
    }

    public int getTankCapacity(int tank) {
        return 1000;
    }

    public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
        if (tank != 0 || stack.isEmpty()) {
            return false;
        }
        return stack.getFluid() == Fluids.WATER || stack.getFluid() == Fluids.LAVA;
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        int maxLevelsCanAdd;
        int levelsToAdd;
        int currentLevel;
        if (resource.isEmpty() || !this.isFluidValid(0, resource)) {
            return 0;
        }
        this.state = this.level.getBlockState(this.pos);
        if (this.state.is(Blocks.CAULDRON)) {
            BlockState newState = null;
            int fillAmount = 0;
            if (resource.getFluid() == Fluids.WATER) {
                if (resource.getAmount() >= 250) {
                    int levels = Math.min(3, resource.getAmount() / 250);
                    fillAmount = levels * 250;
                    newState = (BlockState)Blocks.WATER_CAULDRON.defaultBlockState().setValue((Property)LayeredCauldronBlock.LEVEL, (Comparable)Integer.valueOf(levels));
                }
            } else if (resource.getFluid() == Fluids.LAVA && resource.getAmount() >= 1000) {
                newState = Blocks.LAVA_CAULDRON.defaultBlockState();
                fillAmount = 1000;
            }
            if (newState != null && fillAmount > 0) {
                if (action.execute()) {
                    this.level.setBlockAndUpdate(this.pos, newState);
                    this.level.gameEvent(null, (Holder)GameEvent.BLOCK_CHANGE, this.pos);
                    if (resource.getFluid() == Fluids.WATER) {
                        this.level.levelEvent(1047, this.pos, 0);
                    } else if (resource.getFluid() == Fluids.LAVA) {
                        this.level.levelEvent(1046, this.pos, 0);
                    }
                }
                return fillAmount;
            }
            return 0;
        }
        if (this.state.is(Blocks.WATER_CAULDRON) && resource.getFluid() == Fluids.WATER && (currentLevel = ((Integer)this.state.getValue((Property)LayeredCauldronBlock.LEVEL)).intValue()) < 3 && (levelsToAdd = Math.min(maxLevelsCanAdd = 3 - currentLevel, resource.getAmount() / 250)) > 0) {
            int fillAmount = levelsToAdd * 250;
            if (action.execute()) {
                int newLevel = currentLevel + levelsToAdd;
                this.level.setBlockAndUpdate(this.pos, (BlockState)this.state.setValue((Property)LayeredCauldronBlock.LEVEL, (Comparable)Integer.valueOf(newLevel)));
                this.level.gameEvent(null, (Holder)GameEvent.BLOCK_CHANGE, this.pos);
                this.level.levelEvent(1047, this.pos, 0);
            }
            return fillAmount;
        }
        return 0;
    }

    @Nonnull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.isEmpty()) {
            return FluidStack.EMPTY;
        }
        FluidStack contained = this.getFluidInTank(0);
        if (contained.isEmpty() || !FluidStack.isSameFluidSameComponents((FluidStack)contained, (FluidStack)resource)) {
            return FluidStack.EMPTY;
        }
        return this.drain(resource.getAmount(), action);
    }

    @Nonnull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        if (maxDrain <= 0) {
            return FluidStack.EMPTY;
        }
        this.state = this.level.getBlockState(this.pos);
        FluidStack result = FluidStack.EMPTY;
        if (this.state.is(Blocks.WATER_CAULDRON)) {
            int currentLevel = (Integer)this.state.getValue((Property)LayeredCauldronBlock.LEVEL);
            if (currentLevel == 3 && maxDrain >= 1000) {
                result = new FluidStack((Fluid)Fluids.WATER, 1000);
                if (action.execute()) {
                    this.level.setBlockAndUpdate(this.pos, Blocks.CAULDRON.defaultBlockState());
                    this.level.gameEvent(null, (Holder)GameEvent.BLOCK_CHANGE, this.pos);
                }
            }
        } else if (this.state.is(Blocks.LAVA_CAULDRON) && maxDrain >= 1000) {
            result = new FluidStack((Fluid)Fluids.LAVA, 1000);
            if (action.execute()) {
                this.level.setBlockAndUpdate(this.pos, Blocks.CAULDRON.defaultBlockState());
                this.level.gameEvent(null, (Holder)GameEvent.BLOCK_CHANGE, this.pos);
            }
        }
        return result;
    }
}

