/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.fluid.mixin;

import com.adonis.fluid.mixin.accessor.ArmBlockEntityAccessor;
import com.adonis.fluid.packet.ArmInteractionPointSyncPacket;
import com.simibubi.create.content.kinetics.mechanicalArm.ArmBlockEntity;
import com.simibubi.create.content.kinetics.mechanicalArm.ArmPlacementPacket;
import java.lang.reflect.Method;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.PacketDistributor;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ArmPlacementPacket.class}, remap=false)
public class ArmPlacementPacketMixin {
    @Shadow
    @Final
    private ListTag tag;
    @Shadow
    @Final
    private BlockPos pos;

    @Inject(method={"handle"}, at={@At(value="TAIL")})
    private void afterHandle(ServerPlayer player, CallbackInfo ci) {
        Level world = player.level();
        if (!world.isLoaded(this.pos)) {
            return;
        }
        BlockEntity be = world.getBlockEntity(this.pos);
        if (!(be instanceof ArmBlockEntity)) {
            return;
        }
        ArmBlockEntity arm = (ArmBlockEntity)be;
        ArmBlockEntityAccessor accessor = (ArmBlockEntityAccessor)arm;
        accessor.setUpdateInteractionPoints(true);
        try {
            Method initMethod = ArmBlockEntity.class.getDeclaredMethod("initInteractionPoints", new Class[0]);
            initMethod.setAccessible(true);
            initMethod.invoke((Object)arm, new Object[0]);
        }
        catch (Exception initMethod) {
            // empty catch block
        }
        accessor.setPhase(ArmBlockEntity.Phase.SEARCH_INPUTS);
        accessor.setChasedPointProgress(0.0f);
        accessor.setChasedPointIndex(-1);
        arm.setChanged();
        if (world instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)world;
            ArmInteractionPointSyncPacket syncPacket = new ArmInteractionPointSyncPacket(this.pos, this.tag);
            try {
                PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)serverLevel, (ChunkPos)new ChunkPos(this.pos), (CustomPacketPayload)syncPacket, (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

