/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.fluid.packet;

import com.adonis.fluid.block.Pipette.PipetteBlockEntity;
import com.adonis.fluid.handler.PipetteFluidInteractionPointHandler;
import com.adonis.fluid.mixin.accessor.ArmBlockEntityAccessor;
import com.simibubi.create.content.fluids.FluidFX;
import com.simibubi.create.content.kinetics.mechanicalArm.ArmBlockEntity;
import java.lang.reflect.Method;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.ListTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.fluids.FluidStack;

@OnlyIn(value=Dist.CLIENT)
public class ClientPacketHandler {
    public static void handlePipetteParticle(Vec3 pos, FluidStack fluid) {
        ClientLevel level = Minecraft.getInstance().level;
        if (level == null || fluid.isEmpty()) {
            return;
        }
        ParticleOptions particle = FluidFX.getFluidParticle((FluidStack)fluid);
        for (int i = 0; i < 20; ++i) {
            Vec3 motion = VecHelper.offsetRandomly((Vec3)Vec3.ZERO, (RandomSource)level.random, (float)0.125f);
            motion = new Vec3(motion.x, -Math.abs(motion.y) * 0.5 - 0.1, motion.z);
            level.addParticle(particle, pos.x, pos.y, pos.z, motion.x, motion.y, motion.z);
        }
    }

    public static void handleArmSync(BlockPos pos, ListTag pointsTag) {
        ClientLevel world = Minecraft.getInstance().level;
        if (world == null) {
            return;
        }
        BlockEntity be = world.getBlockEntity(pos);
        if (!(be instanceof ArmBlockEntity)) {
            return;
        }
        ArmBlockEntity arm = (ArmBlockEntity)be;
        ArmBlockEntityAccessor accessor = (ArmBlockEntityAccessor)arm;
        accessor.getInputs().clear();
        accessor.getOutputs().clear();
        accessor.setInteractionPointTag(pointsTag);
        accessor.setUpdateInteractionPoints(true);
        accessor.setPhase(ArmBlockEntity.Phase.SEARCH_INPUTS);
        accessor.setChasedPointProgress(0.0f);
        accessor.setChasedPointIndex(-1);
        try {
            Method initMethod = ArmBlockEntity.class.getDeclaredMethod("initInteractionPoints", new Class[0]);
            initMethod.setAccessible(true);
            initMethod.invoke((Object)arm, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        arm.setChanged();
    }

    public static void handlePipetteSync(BlockPos pos, ListTag pointsTag) {
        ClientLevel world = Minecraft.getInstance().level;
        if (world == null) {
            return;
        }
        BlockEntity be = world.getBlockEntity(pos);
        if (!(be instanceof PipetteBlockEntity)) {
            return;
        }
        PipetteBlockEntity pipette = (PipetteBlockEntity)be;
        pipette.inputs.clear();
        pipette.outputs.clear();
        pipette.setInteractionPointTag(pointsTag);
        pipette.setUpdateInteractionPoints(true);
        pipette.forceInitInteractionPoints();
        pipette.resetMovementState();
        pipette.setChanged();
    }

    public static void handlePipetteRequest(BlockPos pos) {
        PipetteFluidInteractionPointHandler.flushSettings(pos);
    }
}

