/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.fluid.block.Aqueduct;

import com.adonis.fluid.block.Aqueduct.AbstractAqueductBlock;
import com.adonis.fluid.block.Aqueduct.AbstractAqueductBlockEntity;
import com.adonis.fluid.block.Aqueduct.AqueductBlockEntity;
import com.adonis.fluid.registry.CFBlockEntity;
import com.simibubi.create.foundation.block.IBE;
import java.util.function.Predicate;
import net.createmod.catnip.placement.IPlacementHelper;
import net.createmod.catnip.placement.PlacementHelpers;
import net.createmod.catnip.placement.PlacementOffset;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class AqueductBlock
extends AbstractAqueductBlock {
    private static final int placementHelperId = PlacementHelpers.register((IPlacementHelper)new AqueductPlacementHelper());

    public AqueductBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public Class<AbstractAqueductBlockEntity> getBlockEntityClass() {
        return AqueductBlockEntity.class;
    }

    public BlockEntityType<? extends AbstractAqueductBlockEntity> getBlockEntityType() {
        return (BlockEntityType)CFBlockEntity.AQUEDUCT.get();
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult ray) {
        ItemStack heldItem = player.m_21120_(hand);
        IPlacementHelper placementHelper = PlacementHelpers.get((int)placementHelperId);
        if (placementHelper.matchesItem(heldItem)) {
            return placementHelper.getOffset(player, world, state, pos, ray).placeInWorld(world, (BlockItem)heldItem.m_41720_(), player, hand, ray);
        }
        return super.m_6227_(state, world, pos, player, hand, ray);
    }

    @Override
    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.m_6807_(state, level, pos, oldState, isMoving);
        if (!level.f_46443_ && !oldState.m_60713_(state.m_60734_())) {
            this.withBlockEntityDo((BlockGetter)level, pos, be -> {
                if (be instanceof AqueductBlockEntity) {
                    AqueductBlockEntity aqueduct = (AqueductBlockEntity)((Object)be);
                    aqueduct.onBlockPlaced();
                }
            });
            this.notifyNeighborAqueducts(level, pos);
        }
    }

    @Override
    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            if (!level.f_46443_) {
                this.withBlockEntityDo((BlockGetter)level, pos, be -> {
                    if (be instanceof AqueductBlockEntity) {
                        AqueductBlockEntity aqueduct = (AqueductBlockEntity)((Object)be);
                        aqueduct.onBlockRemoved();
                    }
                });
                this.notifyNeighborAqueducts(level, pos);
            }
            IBE.onRemove((BlockState)state, (Level)level, (BlockPos)pos, (BlockState)newState);
        }
    }

    private void notifyNeighborAqueducts(Level level, BlockPos pos) {
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            BlockPos neighborPos = pos.m_121945_(dir);
            BlockState neighborState = level.m_8055_(neighborPos);
            if (!(neighborState.m_60734_() instanceof AbstractAqueductBlock)) continue;
            level.m_7260_(neighborPos, neighborState, neighborState, 3);
            this.withBlockEntityDo((BlockGetter)level, neighborPos, be -> {
                if (be instanceof AqueductBlockEntity) {
                    AqueductBlockEntity neighbor = (AqueductBlockEntity)((Object)be);
                    neighbor.checkFluidSource();
                }
            });
        }
        AqueductBlockEntity.triggerSystemRecheck();
    }

    @MethodsReturnNonnullByDefault
    private static class AqueductPlacementHelper
    implements IPlacementHelper {
        private AqueductPlacementHelper() {
        }

        public Predicate<ItemStack> getItemPredicate() {
            return stack -> stack.m_41720_() instanceof BlockItem && ((BlockItem)stack.m_41720_()).m_40614_() instanceof AbstractAqueductBlock;
        }

        public Predicate<BlockState> getStatePredicate() {
            return state -> state.m_60734_() instanceof AbstractAqueductBlock;
        }

        public PlacementOffset getOffset(Player player, Level world, BlockState state, BlockPos pos, BlockHitResult ray) {
            Direction[] validDirections;
            Direction facing = (Direction)state.m_61143_((Property)AbstractAqueductBlock.FACING);
            for (Direction dir : validDirections = new Direction[]{facing, facing.m_122424_()}) {
                BlockPos targetPos = pos.m_121945_(dir);
                BlockState targetState = world.m_8055_(targetPos);
                if (!targetState.m_247087_()) continue;
                return PlacementOffset.success((Vec3i)targetPos, s -> (BlockState)s.m_61124_((Property)AbstractAqueductBlock.FACING, (Comparable)facing));
            }
            return PlacementOffset.fail();
        }
    }
}

