/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.fluid.block.Aqueduct;

import com.adonis.fluid.block.Aqueduct.AbstractAqueductBlockEntity;
import com.adonis.fluid.config.CFCommonConfig;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AqueductBlockEntity
extends AbstractAqueductBlockEntity {
    private static final Logger LOGGER = LoggerFactory.getLogger(AqueductBlockEntity.class);
    private BlockPos fluidSourcePos = null;
    private boolean hasFluidSource = false;
    private int sourceFillCooldown = 0;
    private static final Map<BlockPos, AqueductBlockEntity> allAqueducts = new HashMap<BlockPos, AqueductBlockEntity>();
    private static BlockPos checkingPos = null;
    private int checkDelay = 0;

    public AqueductBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void onLoad() {
        super.onLoad();
        if (!this.f_58857_.f_46443_) {
            allAqueducts.put(this.f_58858_, this);
            AqueductBlockEntity.triggerSystemRecheck();
        }
    }

    public void onChunkUnloaded() {
        if (!this.f_58857_.f_46443_) {
            allAqueducts.remove(this.f_58858_);
        }
        super.onChunkUnloaded();
    }

    public void invalidate() {
        if (!this.f_58857_.f_46443_) {
            BlockEntity partnerBE;
            allAqueducts.remove(this.f_58858_);
            this.clearWorkingState();
            if (this.workingPartner != null && (partnerBE = this.f_58857_.m_7702_(this.workingPartner)) instanceof AqueductBlockEntity) {
                AqueductBlockEntity partner = (AqueductBlockEntity)partnerBE;
                partner.clearWorkingState();
            }
        }
        super.invalidate();
    }

    @Override
    public void tick() {
        super.tick();
        if (this.f_58857_.f_46443_) {
            return;
        }
        if (this.f_58857_.m_46467_() % 20L == 0L) {
            this.checkFluidSource();
        }
        if (this.checkDelay > 0) {
            --this.checkDelay;
            if (this.checkDelay == 0) {
                this.performCheck();
            }
        }
        if (this.hasFluidSource && this.workingState == AbstractAqueductBlockEntity.WorkingState.IDLE) {
            this.fillFromSource();
        }
    }

    public void onBlockPlaced() {
        if (!this.f_58857_.f_46443_) {
            this.checkFluidSource();
            AqueductBlockEntity.triggerSystemRecheck();
        }
    }

    public void onBlockRemoved() {
        if (!this.f_58857_.f_46443_) {
            BlockEntity partnerBE;
            this.clearWorkingState();
            if (this.workingPartner != null && (partnerBE = this.f_58857_.m_7702_(this.workingPartner)) instanceof AqueductBlockEntity) {
                AqueductBlockEntity partner = (AqueductBlockEntity)partnerBE;
                partner.clearWorkingState();
            }
            AqueductBlockEntity.triggerSystemRecheck();
        }
    }

    public static void triggerSystemRecheck() {
        checkingPos = null;
        AqueductBlockEntity upstreamMost = AqueductBlockEntity.findUpstreamMost();
        if (upstreamMost != null) {
            upstreamMost.checkDelay = 1;
        }
    }

    private static AqueductBlockEntity findUpstreamMost() {
        AqueductBlockEntity result = null;
        int minUpstreamDistance = Integer.MAX_VALUE;
        for (AqueductBlockEntity aqueduct : allAqueducts.values()) {
            int distance = AqueductBlockEntity.calculateUpstreamDistance(aqueduct);
            if (distance >= minUpstreamDistance) continue;
            minUpstreamDistance = distance;
            result = aqueduct;
        }
        return result;
    }

    private static int calculateUpstreamDistance(AqueductBlockEntity aqueduct) {
        AqueductBlockEntity upstream;
        BlockEntity be;
        int distance = 0;
        Direction upstreamDir = aqueduct.getFlowDirection().m_122424_();
        BlockPos checkPos = aqueduct.f_58858_.m_121945_(upstreamDir);
        for (int i = 0; i < 100 && (be = aqueduct.f_58857_.m_7702_(checkPos)) instanceof AqueductBlockEntity && (upstream = (AqueductBlockEntity)be).getFlowDirection() == aqueduct.getFlowDirection(); ++i) {
            ++distance;
            checkPos = checkPos.m_121945_(upstreamDir);
        }
        return distance;
    }

    private int getUpstreamDistance() {
        return AqueductBlockEntity.calculateUpstreamDistance(this);
    }

    private void performCheck() {
        AqueductBlockEntity target;
        BlockEntity be;
        checkingPos = this.f_58858_;
        if (this.tank.isEmpty()) {
            this.scheduleNextCheck();
            return;
        }
        if (this.workingState != AbstractAqueductBlockEntity.WorkingState.IDLE) {
            this.scheduleNextCheck();
            return;
        }
        Direction flowDir = this.getFlowDirection();
        BlockPos currentCheckPos = this.f_58858_;
        for (int i = 0; i < (Integer)CFCommonConfig.MAX_AQUEDUCT_LENGTH.get() && (be = this.f_58857_.m_7702_(currentCheckPos = currentCheckPos.m_121945_(flowDir))) instanceof AqueductBlockEntity && (target = (AqueductBlockEntity)be).getFlowDirection() == flowDir && (target.tank.isEmpty() || target.tank.getFluid().isFluidEqual(this.tank.getFluid())) && target.workingState == AbstractAqueductBlockEntity.WorkingState.IDLE; ++i) {
            if (target.canBeTarget(this.tank.getFluid())) {
                this.setAsSource(currentCheckPos);
                target.setAsTarget(this.f_58858_);
                break;
            }
            if (!target.canSkip(this.tank.getFluid())) break;
        }
        this.scheduleNextCheck();
    }

    private void scheduleNextCheck() {
        checkingPos = null;
        AqueductBlockEntity next = this.findNextToCheck();
        if (next != null) {
            next.checkDelay = 1;
        }
    }

    private AqueductBlockEntity findNextToCheck() {
        ArrayList<AqueductBlockEntity> sorted = new ArrayList<AqueductBlockEntity>(allAqueducts.values());
        sorted.sort(Comparator.comparingInt(this::calculateUpstreamDistanceForSort));
        boolean foundCurrent = false;
        for (AqueductBlockEntity aqueduct : sorted) {
            if (foundCurrent) {
                return aqueduct;
            }
            if (!aqueduct.f_58858_.equals((Object)this.f_58858_)) continue;
            foundCurrent = true;
        }
        return sorted.isEmpty() ? null : (AqueductBlockEntity)((Object)sorted.get(0));
    }

    private int calculateUpstreamDistanceForSort(AqueductBlockEntity aqueduct) {
        return AqueductBlockEntity.calculateUpstreamDistance(aqueduct);
    }

    public void checkFluidSource() {
        Direction upstreamDir = this.getFlowDirection().m_122424_();
        BlockPos sourcePos = this.f_58858_.m_121945_(upstreamDir);
        if (this.f_58857_.m_8055_(sourcePos).m_60734_() == Fluids.f_76193_.m_76145_().m_76188_().m_60734_()) {
            this.hasFluidSource = true;
            this.fluidSourcePos = sourcePos;
            return;
        }
        BlockEntity be = this.f_58857_.m_7702_(sourcePos);
        if (be != null) {
            LazyOptional cap = be.getCapability(ForgeCapabilities.FLUID_HANDLER, this.getFlowDirection());
            if (!cap.isPresent()) {
                cap = be.getCapability(ForgeCapabilities.FLUID_HANDLER, null);
            }
            cap.ifPresent(handler -> {
                for (int i = 0; i < handler.getTanks(); ++i) {
                    if (handler.getFluidInTank(i).isEmpty()) continue;
                    this.hasFluidSource = true;
                    this.fluidSourcePos = sourcePos;
                    return;
                }
            });
        }
        if (this.hasFluidSource && (this.fluidSourcePos == null || !this.fluidSourcePos.equals((Object)sourcePos))) {
            this.hasFluidSource = false;
            this.fluidSourcePos = null;
        }
    }

    private void fillFromSource() {
        if (this.sourceFillCooldown > 0) {
            --this.sourceFillCooldown;
            return;
        }
        if (this.fluidSourcePos == null) {
            this.checkFluidSource();
            if (!this.hasFluidSource) {
                return;
            }
        }
        Direction upstreamDir = this.getFlowDirection().m_122424_();
        if (this.f_58857_.m_8055_(this.fluidSourcePos).m_60734_() == Fluids.f_76193_.m_76145_().m_76188_().m_60734_()) {
            if (this.isFull()) {
                this.performVirtualSourceCheck();
                return;
            }
            if (!this.tank.getFluid().isEmpty() && this.tank.getFluid().getFluid() != Fluids.f_76193_) {
                return;
            }
            int fillAmount = Math.min((Integer)CFCommonConfig.WATER_SOURCE_FILL_RATE.get(), this.getSpace());
            FluidStack water = new FluidStack((Fluid)Fluids.f_76193_, fillAmount);
            this.tank.fill(water, IFluidHandler.FluidAction.EXECUTE);
            this.sourceFillCooldown = 2;
            return;
        }
        BlockEntity be = this.f_58857_.m_7702_(this.fluidSourcePos);
        if (be != null) {
            LazyOptional cap = be.getCapability(ForgeCapabilities.FLUID_HANDLER, this.getFlowDirection());
            if (!cap.isPresent()) {
                cap = be.getCapability(ForgeCapabilities.FLUID_HANDLER, null);
            }
            cap.ifPresent(handler -> {
                if (this.isFull()) {
                    this.performVirtualSourceCheck();
                    return;
                }
                FluidStack drain = handler.drain(this.getTransferRate(), IFluidHandler.FluidAction.SIMULATE);
                if (!drain.isEmpty()) {
                    if (!this.tank.isEmpty() && !this.tank.getFluid().isFluidEqual(drain)) {
                        return;
                    }
                    int toDrain = Math.min(drain.getAmount(), this.getSpace());
                    FluidStack actualDrain = handler.drain(toDrain, IFluidHandler.FluidAction.EXECUTE);
                    if (!actualDrain.isEmpty()) {
                        this.tank.fill(actualDrain, IFluidHandler.FluidAction.EXECUTE);
                        this.sourceFillCooldown = 2;
                    }
                }
            });
        }
    }

    private void performVirtualSourceCheck() {
        AqueductBlockEntity target;
        BlockEntity be;
        if (this.workingState != AbstractAqueductBlockEntity.WorkingState.IDLE) {
            return;
        }
        Direction flowDir = this.getFlowDirection();
        BlockPos currentCheckPos = this.f_58858_;
        for (int i = 0; i < (Integer)CFCommonConfig.MAX_AQUEDUCT_LENGTH.get() && (be = this.f_58857_.m_7702_(currentCheckPos = currentCheckPos.m_121945_(flowDir))) instanceof AqueductBlockEntity && (target = (AqueductBlockEntity)be).getFlowDirection() == flowDir && (target.tank.isEmpty() || target.tank.getFluid().isFluidEqual(this.tank.getFluid())) && target.workingState == AbstractAqueductBlockEntity.WorkingState.IDLE; ++i) {
            if (target.canBeTarget(this.tank.getFluid())) {
                this.setAsSource(currentCheckPos);
                target.setAsTarget(this.f_58858_);
                break;
            }
            if (!target.canSkip(this.tank.getFluid())) break;
        }
    }

    @Override
    protected void write(CompoundTag tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        tag.m_128379_("HasFluidSource", this.hasFluidSource);
        if (this.fluidSourcePos != null) {
            tag.m_128356_("FluidSourcePos", this.fluidSourcePos.m_121878_());
        }
        tag.m_128405_("SourceFillCooldown", this.sourceFillCooldown);
    }

    @Override
    protected void read(CompoundTag tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        this.hasFluidSource = tag.m_128471_("HasFluidSource");
        if (tag.m_128441_("FluidSourcePos")) {
            this.fluidSourcePos = BlockPos.m_122022_((long)tag.m_128454_("FluidSourcePos"));
        }
        this.sourceFillCooldown = tag.m_128451_("SourceFillCooldown");
    }
}

