/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.fluid.block.CentrifugalPump;

import com.adonis.fluid.block.CentrifugalPump.CentrifugalPumpBlockEntity;
import com.adonis.fluid.registry.CFBlockEntity;
import com.adonis.fluid.registry.CFShapes;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.fluids.FluidPropagator;
import com.simibubi.create.content.fluids.pipes.FluidPipeBlock;
import com.simibubi.create.content.kinetics.base.AbstractEncasedShaftBlock;
import com.simibubi.create.content.kinetics.base.DirectionalKineticBlock;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.RotatedPillarKineticBlock;
import com.simibubi.create.content.kinetics.simpleRelays.AbstractShaftBlock;
import com.simibubi.create.content.kinetics.simpleRelays.ICogWheel;
import com.simibubi.create.foundation.block.IBE;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.ticks.TickPriority;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;

public class CentrifugalPumpBlock
extends DirectionalKineticBlock
implements IBE<CentrifugalPumpBlockEntity>,
SimpleWaterloggedBlock,
IWrenchable {
    public static final EnumProperty<AttachFace> FACE = BlockStateProperties.f_61376_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final BooleanProperty ENCASED = BooleanProperty.m_61465_((String)"encased");
    private static final VoxelShape PUMP_SHAPE = Block.m_49796_((double)2.0, (double)2.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0);
    private static final VoxelShape FULL_SHAPE = Shapes.m_83144_();

    public CentrifugalPumpBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_(FACE, (Comparable)AttachFace.FLOOR)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)ENCASED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FACE, WATERLOGGED, ENCASED});
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack heldItem = player.m_21120_(hand);
        if (!((Boolean)state.m_61143_((Property)ENCASED)).booleanValue() && heldItem.m_150930_(AllBlocks.COPPER_CASING.m_5456_())) {
            if (!world.f_46443_) {
                BlockState newState = (BlockState)state.m_61124_((Property)ENCASED, (Comparable)Boolean.valueOf(true));
                world.m_7731_(pos, newState, 3);
                world.m_5594_(null, pos, SoundEvents.f_144119_, SoundSource.BLOCKS, 1.0f, 1.0f);
                BlockEntity blockEntity = world.m_7702_(pos);
                if (blockEntity instanceof CentrifugalPumpBlockEntity) {
                    CentrifugalPumpBlockEntity pump = (CentrifugalPumpBlockEntity)blockEntity;
                    pump.onEncasedStateChanged(true);
                }
            }
            return InteractionResult.m_19078_((boolean)world.f_46443_);
        }
        return InteractionResult.PASS;
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Player player = context.m_43723_();
        if (!world.f_46443_ && player != null && player.m_6144_() && ((Boolean)state.m_61143_((Property)ENCASED)).booleanValue()) {
            BlockState newState = (BlockState)state.m_61124_((Property)ENCASED, (Comparable)Boolean.valueOf(false));
            world.m_7731_(pos, newState, 3);
            if (!player.m_7500_()) {
                Block.m_49840_((Level)world, (BlockPos)pos, (ItemStack)AllBlocks.COPPER_CASING.asStack());
            }
            world.m_5594_(null, pos, SoundEvents.f_144117_, SoundSource.BLOCKS, 1.0f, 1.0f);
            BlockEntity blockEntity = world.m_7702_(pos);
            if (blockEntity instanceof CentrifugalPumpBlockEntity) {
                CentrifugalPumpBlockEntity pump = (CentrifugalPumpBlockEntity)blockEntity;
                pump.onEncasedStateChanged(false);
            }
            return InteractionResult.SUCCESS;
        }
        if (((Boolean)state.m_61143_((Property)ENCASED)).booleanValue()) {
            return InteractionResult.PASS;
        }
        if (!world.f_46443_) {
            Direction facing;
            AttachFace face = (AttachFace)state.m_61143_(FACE);
            Direction newFacing = facing = (Direction)state.m_61143_((Property)FACING);
            if (face == AttachFace.WALL) {
                newFacing = facing.m_122427_();
                if (newFacing.m_122434_() == Direction.Axis.Y) {
                    newFacing = Direction.NORTH;
                }
            } else {
                newFacing = facing.m_122427_();
                if (newFacing.m_122434_() == Direction.Axis.Y) {
                    newFacing = Direction.NORTH;
                }
            }
            BlockState newState = (BlockState)state.m_61124_((Property)FACING, (Comparable)newFacing);
            world.m_7731_(pos, newState, 3);
            BlockEntity blockEntity = world.m_7702_(pos);
            if (blockEntity instanceof CentrifugalPumpBlockEntity) {
                CentrifugalPumpBlockEntity pump = (CentrifugalPumpBlockEntity)blockEntity;
                pump.onPipeNetworkChanged();
            }
        }
        return InteractionResult.SUCCESS;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        if (((Boolean)state.m_61143_((Property)ENCASED)).booleanValue()) {
            return FULL_SHAPE;
        }
        AttachFace face = (AttachFace)state.m_61143_(FACE);
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        try {
            if (CFShapes.CENTRIFUGAL_PUMP_FLOOR != null && CFShapes.CENTRIFUGAL_PUMP_CEILING != null && CFShapes.CENTRIFUGAL_PUMP_WALL != null) {
                VoxelShape shape = null;
                shape = face == AttachFace.FLOOR ? CFShapes.CENTRIFUGAL_PUMP_FLOOR.get(facing) : (face == AttachFace.CEILING ? CFShapes.CENTRIFUGAL_PUMP_CEILING.get(facing) : CFShapes.CENTRIFUGAL_PUMP_WALL.get(facing));
                if (shape != null) {
                    return shape;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return PUMP_SHAPE;
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        Direction facing;
        AttachFace face;
        Level world = ctx.m_43725_();
        BlockPos pos = ctx.m_8083_();
        if (ctx.m_43723_() != null && ctx.m_43723_().m_6144_()) {
            AttachFace face2;
            Direction clickedFace = ctx.m_43719_();
            return (BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_(FACE, (Comparable)face2)).m_61124_((Property)FACING, (Comparable)(switch (clickedFace) {
                case Direction.UP -> {
                    face2 = AttachFace.FLOOR;
                    yield ctx.m_8125_().m_122424_();
                }
                case Direction.DOWN -> {
                    face2 = AttachFace.WALL;
                    yield ctx.m_8125_();
                }
                default -> {
                    face2 = AttachFace.FLOOR;
                    yield clickedFace.m_122424_();
                }
            }))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(ctx.m_43725_().m_6425_(pos).m_76152_() == Fluids.f_76193_))).m_61124_((Property)ENCASED, (Comparable)Boolean.valueOf(false));
        }
        boolean hasPipeUp = this.hasFluidConnection(world, pos.m_7494_(), pos);
        boolean hasPipeDown = this.hasFluidConnection(world, pos.m_7495_(), pos);
        boolean hasKineticUp = this.hasKineticConnection(world, pos.m_7494_(), world.m_8055_(pos.m_7494_()), Direction.DOWN);
        boolean hasKineticDown = this.hasKineticConnection(world, pos.m_7495_(), world.m_8055_(pos.m_7495_()), Direction.UP);
        Direction firstHorizontalPipe = null;
        Direction firstHorizontalKinetic = null;
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            BlockPos neighborPos = pos.m_121945_(dir);
            BlockState neighborState = world.m_8055_(neighborPos);
            if (firstHorizontalPipe == null && this.hasFluidConnection(world, neighborPos, pos)) {
                firstHorizontalPipe = dir;
            }
            if (firstHorizontalKinetic != null || !this.hasKineticConnection(world, neighborPos, neighborState, dir.m_122424_())) continue;
            firstHorizontalKinetic = dir;
        }
        if (hasPipeUp) {
            face = AttachFace.FLOOR;
            facing = firstHorizontalPipe != null ? firstHorizontalPipe : ctx.m_8125_().m_122424_();
        } else if (hasPipeDown) {
            if (hasKineticUp) {
                face = AttachFace.WALL;
                facing = firstHorizontalPipe != null ? firstHorizontalPipe : ctx.m_8125_();
            } else {
                face = AttachFace.CEILING;
                facing = firstHorizontalPipe != null ? firstHorizontalPipe : ctx.m_8125_().m_122424_();
            }
        } else if (firstHorizontalPipe != null) {
            if (hasKineticUp) {
                face = AttachFace.WALL;
                facing = firstHorizontalPipe;
            } else {
                face = AttachFace.FLOOR;
                facing = firstHorizontalPipe;
            }
        } else if (firstHorizontalKinetic != null) {
            face = AttachFace.FLOOR;
            facing = firstHorizontalKinetic.m_122424_();
        } else if (hasKineticUp) {
            face = AttachFace.WALL;
            facing = ctx.m_8125_();
        } else {
            Direction clickedFace;
            face = this.clickedFaceToAttachFace(ctx.m_43719_());
            facing = face == AttachFace.WALL ? ((clickedFace = ctx.m_43719_()).m_122434_() != Direction.Axis.Y ? clickedFace : ctx.m_8125_()) : ctx.m_8125_().m_122424_();
        }
        return (BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_(FACE, (Comparable)face)).m_61124_((Property)FACING, (Comparable)facing)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(ctx.m_43725_().m_6425_(pos).m_76152_() == Fluids.f_76193_))).m_61124_((Property)ENCASED, (Comparable)Boolean.valueOf(false));
    }

    private boolean hasFluidConnection(Level world, BlockPos neighborPos, BlockPos fromPos) {
        BlockState state = world.m_8055_(neighborPos);
        if (state.m_60734_() instanceof CentrifugalPumpBlock) {
            return false;
        }
        Direction directionToNeighbor = Direction.m_122378_((int)(neighborPos.m_123341_() - fromPos.m_123341_()), (int)(neighborPos.m_123342_() - fromPos.m_123342_()), (int)(neighborPos.m_123343_() - fromPos.m_123343_()));
        if (directionToNeighbor != null) {
            return FluidPipeBlock.canConnectTo((BlockAndTintGetter)world, (BlockPos)neighborPos, (BlockState)state, (Direction)directionToNeighbor.m_122424_());
        }
        return false;
    }

    private boolean hasKineticConnection(Level world, BlockPos pos, BlockState state, Direction from) {
        Block block = state.m_60734_();
        if (block instanceof CentrifugalPumpBlock) {
            return false;
        }
        if ((block instanceof AbstractShaftBlock || block instanceof AbstractEncasedShaftBlock) && state.m_61138_((Property)RotatedPillarKineticBlock.AXIS)) {
            return state.m_61143_((Property)RotatedPillarKineticBlock.AXIS) == from.m_122434_();
        }
        if (block instanceof ICogWheel) {
            return true;
        }
        BlockEntity be = world.m_7702_(pos);
        return be instanceof KineticBlockEntity;
    }

    private AttachFace clickedFaceToAttachFace(Direction clicked) {
        switch (clicked) {
            case UP: {
                return AttachFace.FLOOR;
            }
            case DOWN: {
                return AttachFace.CEILING;
            }
        }
        return AttachFace.WALL;
    }

    public Direction.Axis getRotationAxis(BlockState state) {
        return CentrifugalPumpBlock.getPumpAxis(state);
    }

    protected static Direction.Axis getPumpAxis(BlockState state) {
        if (!(state.m_60734_() instanceof CentrifugalPumpBlock)) {
            return Direction.Axis.Y;
        }
        if (!state.m_61138_(FACE) || !state.m_61138_((Property)FACING)) {
            return Direction.Axis.Y;
        }
        AttachFace face = (AttachFace)state.m_61143_(FACE);
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        if (face == AttachFace.WALL) {
            return Direction.Axis.Y;
        }
        return facing.m_122434_();
    }

    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        return face == CentrifugalPumpBlock.getShaftDirection(state);
    }

    public static Direction getShaftDirection(BlockState state) {
        if (!(state.m_60734_() instanceof CentrifugalPumpBlock)) {
            return Direction.UP;
        }
        if (!state.m_61138_(FACE) || !state.m_61138_((Property)FACING)) {
            return Direction.UP;
        }
        AttachFace face = (AttachFace)state.m_61143_(FACE);
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        if (face == AttachFace.WALL) {
            return Direction.UP;
        }
        return facing.m_122424_();
    }

    public static Direction getPrimaryFluidDirection(BlockState state) {
        if (!(state.m_60734_() instanceof CentrifugalPumpBlock)) {
            return Direction.UP;
        }
        if (!state.m_61138_(FACE) || !state.m_61138_((Property)FACING)) {
            return Direction.UP;
        }
        AttachFace face = (AttachFace)state.m_61143_(FACE);
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        if (face == AttachFace.WALL) {
            return Direction.DOWN;
        }
        return facing;
    }

    public static Direction getSecondaryFluidDirection(BlockState state) {
        if (!(state.m_60734_() instanceof CentrifugalPumpBlock)) {
            return Direction.NORTH;
        }
        if (!state.m_61138_(FACE) || !state.m_61138_((Property)FACING)) {
            return Direction.NORTH;
        }
        AttachFace face = (AttachFace)state.m_61143_(FACE);
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        if (face == AttachFace.WALL) {
            return facing;
        }
        if (face == AttachFace.FLOOR) {
            return Direction.UP;
        }
        return Direction.DOWN;
    }

    public static boolean isOpenAt(BlockState state, Direction d) {
        if (!(state.m_60734_() instanceof CentrifugalPumpBlock)) {
            return false;
        }
        if (!state.m_61138_(FACE) || !state.m_61138_((Property)FACING)) {
            return false;
        }
        return d == CentrifugalPumpBlock.getPrimaryFluidDirection(state) || d == CentrifugalPumpBlock.getSecondaryFluidDirection(state);
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        boolean blockTypeChanged;
        boolean bl = blockTypeChanged = !state.m_60713_(newState.m_60734_());
        if (blockTypeChanged && !world.f_46443_) {
            FluidPropagator.propagateChangedPipe((LevelAccessor)world, (BlockPos)pos, (BlockState)state);
        }
        IBE.onRemove((BlockState)state, (Level)world, (BlockPos)pos, (BlockState)newState);
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        return true;
    }

    public void m_6807_(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.m_6807_(state, world, pos, oldState, isMoving);
        if (!world.f_46443_ && state != oldState) {
            world.m_186464_(pos, (Block)this, 1, TickPriority.HIGH);
            BlockEntity blockEntity = world.m_7702_(pos);
            if (blockEntity instanceof CentrifugalPumpBlockEntity) {
                CentrifugalPumpBlockEntity pump = (CentrifugalPumpBlockEntity)blockEntity;
                pump.onPipeNetworkChanged();
            }
        }
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block otherBlock, BlockPos neighborPos, boolean isMoving) {
        CentrifugalPumpBlockEntity pump;
        BlockEntity blockEntity;
        super.m_6861_(state, world, pos, otherBlock, neighborPos, isMoving);
        DebugPackets.m_133708_((Level)world, (BlockPos)pos);
        Direction d = FluidPropagator.validateNeighbourChange((BlockState)state, (Level)world, (BlockPos)pos, (Block)otherBlock, (BlockPos)neighborPos, (boolean)isMoving);
        if (d != null && CentrifugalPumpBlock.isOpenAt(state, d)) {
            world.m_186464_(pos, (Block)this, 1, TickPriority.HIGH);
            blockEntity = world.m_7702_(pos);
            if (blockEntity instanceof CentrifugalPumpBlockEntity) {
                pump = (CentrifugalPumpBlockEntity)blockEntity;
                pump.pressureUpdate = true;
            }
        }
        if (!world.f_46443_ && (blockEntity = world.m_7702_(pos)) instanceof CentrifugalPumpBlockEntity) {
            BlockEntity neighborBE;
            pump = (CentrifugalPumpBlockEntity)blockEntity;
            Direction neighborDir = null;
            for (Direction dir : Direction.values()) {
                if (!pos.m_121945_(dir).equals((Object)neighborPos)) continue;
                neighborDir = dir;
                break;
            }
            if (neighborDir != null && CentrifugalPumpBlock.isOpenAt(state, neighborDir) && (neighborBE = world.m_7702_(neighborPos)) != null) {
                LazyOptional capability = neighborBE.getCapability(ForgeCapabilities.FLUID_HANDLER, neighborDir.m_122424_());
                if (!capability.isPresent()) {
                    capability = neighborBE.getCapability(ForgeCapabilities.FLUID_HANDLER, null);
                }
                if (capability.isPresent()) {
                    pump.onFluidContainerDetected(neighborDir);
                }
            }
        }
    }

    public void m_213897_(BlockState state, ServerLevel world, BlockPos pos, RandomSource r) {
        FluidPropagator.propagateChangedPipe((LevelAccessor)world, (BlockPos)pos, (BlockState)state);
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof CentrifugalPumpBlockEntity) {
            CentrifugalPumpBlockEntity pump = (CentrifugalPumpBlockEntity)blockEntity;
            pump.pressureUpdate = true;
        }
    }

    public BlockState m_7417_(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        if (((Boolean)pState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            pLevel.m_186469_(pCurrentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)pLevel));
        }
        return pState;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : Fluids.f_76191_.m_76145_();
    }

    public boolean m_7357_(BlockState state, BlockGetter reader, BlockPos pos, PathComputationType type) {
        return false;
    }

    public Class<CentrifugalPumpBlockEntity> getBlockEntityClass() {
        return CentrifugalPumpBlockEntity.class;
    }

    public BlockEntityType<? extends CentrifugalPumpBlockEntity> getBlockEntityType() {
        return (BlockEntityType)CFBlockEntity.CENTRIFUGAL_PUMP.get();
    }
}

