/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.fluid.block.CopperTap;

import com.adonis.fluid.block.CopperTap.CopperTapBlockEntity;
import com.adonis.fluid.registry.CFBlockEntity;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.fluids.transfer.GenericItemFilling;
import com.simibubi.create.foundation.block.IBE;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class CopperTapBlock
extends HorizontalDirectionalBlock
implements IBE<CopperTapBlockEntity>,
IWrenchable {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty OPEN = BlockStateProperties.f_61446_;
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    private static final VoxelShape NORTH_OUTLET = Block.m_49796_((double)3.0, (double)3.0, (double)15.0, (double)13.0, (double)12.9, (double)16.0);
    private static final VoxelShape NORTH_PIPE = Block.m_49796_((double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)15.0);
    private static final VoxelShape NORTH_DROP = Block.m_49796_((double)6.0, (double)4.0, (double)6.0, (double)10.0, (double)6.0, (double)10.0);
    private static final VoxelShape NORTH_BASE = Block.m_49796_((double)5.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0, (double)13.0);
    private static final VoxelShape NORTH_VALVE_TOP = Block.m_49796_((double)5.0, (double)13.0, (double)9.0, (double)11.0, (double)14.0, (double)15.0);
    private static final VoxelShape NORTH_VALVE_HANDLE = Block.m_49796_((double)7.0, (double)11.0, (double)11.0, (double)9.0, (double)13.0, (double)13.0);
    private static final VoxelShape NORTH_SHAPE = Shapes.m_83124_((VoxelShape)NORTH_OUTLET, (VoxelShape[])new VoxelShape[]{NORTH_PIPE, NORTH_DROP, NORTH_BASE, NORTH_VALVE_TOP, NORTH_VALVE_HANDLE});
    private static final VoxelShape SOUTH_OUTLET = Block.m_49796_((double)3.0, (double)3.0, (double)0.0, (double)13.0, (double)12.9, (double)1.0);
    private static final VoxelShape SOUTH_PIPE = Block.m_49796_((double)6.0, (double)6.0, (double)1.0, (double)10.0, (double)10.0, (double)10.0);
    private static final VoxelShape SOUTH_DROP = Block.m_49796_((double)6.0, (double)4.0, (double)6.0, (double)10.0, (double)6.0, (double)10.0);
    private static final VoxelShape SOUTH_BASE = Block.m_49796_((double)5.0, (double)5.0, (double)3.0, (double)11.0, (double)11.0, (double)5.0);
    private static final VoxelShape SOUTH_VALVE_TOP = Block.m_49796_((double)5.0, (double)13.0, (double)1.0, (double)11.0, (double)14.0, (double)7.0);
    private static final VoxelShape SOUTH_VALVE_HANDLE = Block.m_49796_((double)7.0, (double)11.0, (double)3.0, (double)9.0, (double)13.0, (double)5.0);
    private static final VoxelShape SOUTH_SHAPE = Shapes.m_83124_((VoxelShape)SOUTH_OUTLET, (VoxelShape[])new VoxelShape[]{SOUTH_PIPE, SOUTH_DROP, SOUTH_BASE, SOUTH_VALVE_TOP, SOUTH_VALVE_HANDLE});
    private static final VoxelShape EAST_OUTLET = Block.m_49796_((double)0.0, (double)3.0, (double)3.0, (double)1.0, (double)12.9, (double)13.0);
    private static final VoxelShape EAST_PIPE = Block.m_49796_((double)1.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0);
    private static final VoxelShape EAST_DROP = Block.m_49796_((double)6.0, (double)4.0, (double)6.0, (double)10.0, (double)6.0, (double)10.0);
    private static final VoxelShape EAST_BASE = Block.m_49796_((double)3.0, (double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)11.0);
    private static final VoxelShape EAST_VALVE_TOP = Block.m_49796_((double)1.0, (double)13.0, (double)5.0, (double)7.0, (double)14.0, (double)11.0);
    private static final VoxelShape EAST_VALVE_HANDLE = Block.m_49796_((double)3.0, (double)11.0, (double)7.0, (double)5.0, (double)13.0, (double)9.0);
    private static final VoxelShape EAST_SHAPE = Shapes.m_83124_((VoxelShape)EAST_OUTLET, (VoxelShape[])new VoxelShape[]{EAST_PIPE, EAST_DROP, EAST_BASE, EAST_VALVE_TOP, EAST_VALVE_HANDLE});
    private static final VoxelShape WEST_OUTLET = Block.m_49796_((double)15.0, (double)3.0, (double)3.0, (double)16.0, (double)12.9, (double)13.0);
    private static final VoxelShape WEST_PIPE = Block.m_49796_((double)6.0, (double)6.0, (double)6.0, (double)15.0, (double)10.0, (double)10.0);
    private static final VoxelShape WEST_DROP = Block.m_49796_((double)6.0, (double)4.0, (double)6.0, (double)10.0, (double)6.0, (double)10.0);
    private static final VoxelShape WEST_BASE = Block.m_49796_((double)11.0, (double)5.0, (double)5.0, (double)13.0, (double)11.0, (double)11.0);
    private static final VoxelShape WEST_VALVE_TOP = Block.m_49796_((double)9.0, (double)13.0, (double)5.0, (double)15.0, (double)14.0, (double)11.0);
    private static final VoxelShape WEST_VALVE_HANDLE = Block.m_49796_((double)11.0, (double)11.0, (double)7.0, (double)13.0, (double)13.0, (double)9.0);
    private static final VoxelShape WEST_SHAPE = Shapes.m_83124_((VoxelShape)WEST_OUTLET, (VoxelShape[])new VoxelShape[]{WEST_PIPE, WEST_DROP, WEST_BASE, WEST_VALVE_TOP, WEST_VALVE_HANDLE});

    public CopperTapBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, OPEN, POWERED});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            case Direction.NORTH -> NORTH_SHAPE;
            case Direction.SOUTH -> SOUTH_SHAPE;
            case Direction.EAST -> EAST_SHAPE;
            case Direction.WEST -> WEST_SHAPE;
            default -> NORTH_SHAPE;
        };
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.m_5940_(state, level, pos, context);
    }

    private boolean hasFluidCapability(LevelReader level, BlockPos pos, Direction fromDirection) {
        BlockState blockState = level.m_8055_(pos);
        if (blockState.m_204336_(BlockTags.f_13035_)) {
            return true;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity == null) {
            return false;
        }
        IFluidHandler capability = (IFluidHandler)blockEntity.getCapability(ForgeCapabilities.FLUID_HANDLER, fromDirection).orElse(null);
        if (capability != null && capability.getTanks() > 0) {
            return true;
        }
        capability = (IFluidHandler)blockEntity.getCapability(ForgeCapabilities.FLUID_HANDLER, null).orElse(null);
        return capability != null && capability.getTanks() > 0;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction direction = context.m_8125_().m_122424_();
        BlockPos blockpos = context.m_8083_();
        BlockPos attachedPos = blockpos.m_121945_(direction.m_122424_());
        Level level = context.m_43725_();
        if (this.hasFluidCapability((LevelReader)context.m_43725_(), attachedPos, direction)) {
            boolean powered = level.m_276867_(blockpos);
            return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)direction)).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(powered))).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(powered));
        }
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            BlockPos testPos = blockpos.m_121945_(dir.m_122424_());
            if (!this.hasFluidCapability((LevelReader)context.m_43725_(), testPos, dir)) continue;
            boolean powered = level.m_276867_(blockpos);
            return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)dir)).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(powered))).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(powered));
        }
        return null;
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        BlockPos attachedPos = pos.m_121945_(direction.m_122424_());
        BlockState attachedState = level.m_8055_(attachedPos);
        if (attachedState.m_204336_(BlockTags.f_13035_)) {
            return true;
        }
        return this.hasFluidCapability(level, attachedPos, direction);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        if (direction.m_122424_() == state.m_61143_((Property)FACING) && !state.m_60710_((LevelReader)level, currentPos)) {
            return Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(state, direction, neighborState, level, currentPos, neighborPos);
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (!level.f_46443_) {
            BlockEntity be;
            Direction facing = (Direction)state.m_61143_((Property)FACING);
            BlockPos attachedPos = pos.m_121945_(facing.m_122424_());
            if (fromPos.equals((Object)attachedPos) && !this.m_7898_(state, (LevelReader)level, pos)) {
                level.m_46961_(pos, true);
                return;
            }
            if (!level.m_183326_().m_183588_(pos, (Object)this)) {
                level.m_186460_(pos, (Block)this, 1);
            }
            if (fromPos.equals((Object)pos.m_7495_()) && ((Boolean)state.m_61143_((Property)OPEN)).booleanValue() && (be = level.m_7702_(pos)) instanceof CopperTapBlockEntity) {
                CopperTapBlockEntity tapBE = (CopperTapBlockEntity)be;
                tapBE.onTargetChanged();
            }
        }
    }

    public void m_213897_(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource random) {
        boolean currentlyPowered;
        boolean previouslyPowered = (Boolean)state.m_61143_((Property)POWERED);
        if (previouslyPowered != (currentlyPowered = worldIn.m_276867_(pos))) {
            BlockState newState = (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(currentlyPowered));
            if (currentlyPowered) {
                if (!((Boolean)state.m_61143_((Property)OPEN)).booleanValue()) {
                    newState = (BlockState)newState.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(true));
                    worldIn.m_5594_(null, pos, SoundEvents.f_12012_, SoundSource.BLOCKS, 0.5f, 1.0f);
                }
            } else if (((Boolean)state.m_61143_((Property)OPEN)).booleanValue() && previouslyPowered) {
                newState = (BlockState)newState.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false));
                worldIn.m_5594_(null, pos, SoundEvents.f_12011_, SoundSource.BLOCKS, 0.5f, 1.0f);
            }
            worldIn.m_7731_(pos, newState, 2);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockPos belowPos;
        BlockEntity belowEntity;
        if (level.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        if (((Boolean)state.m_61143_((Property)POWERED)).booleanValue()) {
            level.m_5594_(null, pos, SoundEvents.f_12011_, SoundSource.BLOCKS, 0.3f, 2.0f);
            return InteractionResult.SUCCESS;
        }
        ItemStack heldItem = player.m_21120_(hand);
        boolean shouldPreventToggle = false;
        if (!heldItem.m_41619_() && GenericItemFilling.canItemBeFilled((Level)level, (ItemStack)heldItem) && !(heldItem.m_41720_() instanceof BucketItem) && (belowEntity = level.m_7702_(belowPos = pos.m_7495_())) != null && this.isDepot(belowEntity)) {
            shouldPreventToggle = true;
        }
        if (shouldPreventToggle) {
            return InteractionResult.PASS;
        }
        this.toggleTap(state, level, pos);
        return InteractionResult.SUCCESS;
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        if (!context.m_43725_().m_5776_()) {
            if (((Boolean)state.m_61143_((Property)POWERED)).booleanValue()) {
                context.m_43725_().m_5594_(null, context.m_8083_(), SoundEvents.f_12011_, SoundSource.BLOCKS, 0.3f, 2.0f);
                return InteractionResult.SUCCESS;
            }
            this.toggleTap(state, context.m_43725_(), context.m_8083_());
        }
        return InteractionResult.SUCCESS;
    }

    private void toggleTap(BlockState state, Level level, BlockPos pos) {
        boolean isOpen = (Boolean)state.m_61143_((Property)OPEN);
        level.m_46597_(pos, (BlockState)state.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(!isOpen)));
        level.m_5594_(null, pos, isOpen ? SoundEvents.f_12011_ : SoundEvents.f_12012_, SoundSource.BLOCKS, 0.5f, 1.0f);
    }

    private boolean isDepot(BlockEntity entity) {
        return entity.getClass().getSimpleName().toLowerCase().contains("depot");
    }

    public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    public float m_7749_(BlockState state, BlockGetter level, BlockPos pos) {
        return 1.0f;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        IBE.onRemove((BlockState)state, (Level)level, (BlockPos)pos, (BlockState)newState);
    }

    public Class<CopperTapBlockEntity> getBlockEntityClass() {
        return CopperTapBlockEntity.class;
    }

    public BlockEntityType<? extends CopperTapBlockEntity> getBlockEntityType() {
        return (BlockEntityType)CFBlockEntity.COPPER_TAP.get();
    }
}

