/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.fluid.block.Pipette;

import com.adonis.fluid.block.Pipette.PipetteAngleTarget;
import com.adonis.fluid.block.Pipette.PipetteBlock;
import com.adonis.fluid.content.pipette.DepotFluidInteractionPoint;
import com.adonis.fluid.content.pipette.FluidInteractionPoint;
import com.adonis.fluid.content.pipette.IRemoteFluidProcessor;
import com.adonis.fluid.content.pipette.VirtualRelayManager;
import com.adonis.fluid.packet.PipetteParticlePacket;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllPackets;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.api.contraption.transformable.TransformableBlockEntity;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.contraptions.StructureTransform;
import com.simibubi.create.content.fluids.spout.FillingBySpout;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.belt.transport.TransportedItemStack;
import com.simibubi.create.content.logistics.depot.DepotBehaviour;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.CenteredSideValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.INamedIconOptions;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollOptionBehaviour;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.utility.CreateLang;
import com.simibubi.create.infrastructure.config.AllConfigs;
import dev.engine_room.flywheel.lib.visualization.VisualizationHelper;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.createmod.catnip.animation.LerpedFloat;
import net.createmod.catnip.lang.Lang;
import net.createmod.catnip.math.AngleHelper;
import net.createmod.catnip.math.VecHelper;
import net.createmod.catnip.nbt.NBTHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Containers;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.PacketDistributor;

public class PipetteBlockEntity
extends KineticBlockEntity
implements TransformableBlockEntity,
IRemoteFluidProcessor,
IHaveGoggleInformation {
    public List<FluidInteractionPoint> inputs = new ArrayList<FluidInteractionPoint>();
    public List<FluidInteractionPoint> outputs = new ArrayList<FluidInteractionPoint>();
    public ListTag interactionPointTag = null;
    float chasedPointProgress;
    int chasedPointIndex;
    public FluidStack heldFluid;
    Phase phase;
    public boolean goggles;
    PipetteAngleTarget previousTarget;
    public LerpedFloat lowerArmAngle;
    public LerpedFloat upperArmAngle;
    public LerpedFloat baseAngle;
    public LerpedFloat headAngle;
    public LerpedFloat clawAngle;
    float previousBaseAngle;
    boolean updateInteractionPoints;
    int tooltipWarmup;
    protected ScrollOptionBehaviour<SelectionMode> selectionMode;
    protected int lastInputIndex = -1;
    protected int lastOutputIndex = -1;
    protected boolean redstoneLocked;
    private ItemStack processingItem = ItemStack.f_41583_;
    private ItemStack processingResult = ItemStack.f_41583_;
    private int processingTicks = 0;
    private static final int PROCESSING_TIME = 20;
    private VirtualRelayManager.VirtualRelay activeRelay = null;
    private static final float HIGH_SPEED_THRESHOLD = 64.0f;
    private static final float LOW_SPEED_THRESHOLD = 32.0f;
    private float previousProgressForInjection = 0.0f;
    private boolean continuousProcessing = false;
    private int continuousProcessingCount = 0;
    private boolean processingBelt = false;
    private BlockPos processingBeltPos = null;
    private int beltProcessingTicks = 0;
    private boolean isPerformingInjection = false;
    private float injectionStartProgress = 0.8f;
    private static final int TRANSFER_AMOUNT = 1000;
    private static final int FLUID_CAPACITY = 1000;
    private BlockPos pendingBeltRequest = null;
    private ItemStack pendingBeltItem = ItemStack.f_41583_;
    private LazyOptional<IFluidHandler> fluidCapability = LazyOptional.of(() -> new IFluidHandler(){

        public int getTanks() {
            return 1;
        }

        public FluidStack getFluidInTank(int tank) {
            return PipetteBlockEntity.this.heldFluid.copy();
        }

        public int getTankCapacity(int tank) {
            return 1000;
        }

        public boolean isFluidValid(int tank, FluidStack stack) {
            return true;
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            if (resource.isEmpty()) {
                return 0;
            }
            int canFill = Math.min(resource.getAmount(), 1000 - PipetteBlockEntity.this.heldFluid.getAmount());
            if (canFill <= 0) {
                return 0;
            }
            if (action.execute()) {
                if (PipetteBlockEntity.this.heldFluid.isEmpty()) {
                    PipetteBlockEntity.this.heldFluid = resource.copy();
                    PipetteBlockEntity.this.heldFluid.setAmount(canFill);
                } else if (PipetteBlockEntity.this.heldFluid.isFluidEqual(resource)) {
                    PipetteBlockEntity.this.heldFluid.grow(canFill);
                } else {
                    return 0;
                }
                PipetteBlockEntity.this.m_6596_();
                PipetteBlockEntity.this.sendData();
            }
            return canFill;
        }

        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            if (!resource.isFluidEqual(PipetteBlockEntity.this.heldFluid)) {
                return FluidStack.EMPTY;
            }
            return this.drain(resource.getAmount(), action);
        }

        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            if (PipetteBlockEntity.this.heldFluid.isEmpty()) {
                return FluidStack.EMPTY;
            }
            int drained = Math.min(maxDrain, PipetteBlockEntity.this.heldFluid.getAmount());
            FluidStack result = PipetteBlockEntity.this.heldFluid.copy();
            result.setAmount(drained);
            if (action.execute()) {
                PipetteBlockEntity.this.heldFluid.shrink(drained);
                PipetteBlockEntity.this.m_6596_();
                PipetteBlockEntity.this.sendData();
            }
            return result;
        }
    });

    public PipetteBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
        this.heldFluid = FluidStack.EMPTY;
        this.phase = Phase.SEARCH_INPUTS;
        this.previousTarget = PipetteAngleTarget.NO_TARGET;
        this.baseAngle = LerpedFloat.angular();
        this.baseAngle.startWithValue((double)this.previousTarget.baseAngle);
        this.lowerArmAngle = LerpedFloat.angular();
        this.lowerArmAngle.startWithValue((double)this.previousTarget.lowerArmAngle);
        this.upperArmAngle = LerpedFloat.angular();
        this.upperArmAngle.startWithValue((double)this.previousTarget.upperArmAngle);
        this.headAngle = LerpedFloat.angular();
        this.headAngle.startWithValue((double)this.previousTarget.headAngle);
        this.clawAngle = LerpedFloat.angular();
        this.previousBaseAngle = this.previousTarget.baseAngle;
        this.updateInteractionPoints = true;
        this.redstoneLocked = false;
        this.tooltipWarmup = 15;
        this.goggles = false;
    }

    public int getFluidCapacity() {
        return 1000;
    }

    public boolean isInjectMode() {
        return this.phase == Phase.SEARCH_OUTPUTS || this.phase == Phase.MOVE_TO_OUTPUT;
    }

    public boolean isWorking() {
        return this.phase == Phase.MOVE_TO_INPUT || this.phase == Phase.MOVE_TO_OUTPUT;
    }

    public float getWorkProgress() {
        return this.chasedPointProgress;
    }

    public boolean isReadyToInject() {
        return this.phase == Phase.MOVE_TO_OUTPUT && this.chasedPointProgress >= this.injectionStartProgress;
    }

    public SpeedMode getSpeedMode() {
        float speed = Math.abs(this.getSpeed());
        if (speed < 32.0f) {
            return SpeedMode.ULTRA_LOW;
        }
        if (speed < 64.0f) {
            return SpeedMode.LOW;
        }
        return SpeedMode.HIGH;
    }

    public boolean isHighSpeed() {
        return this.getSpeedMode() == SpeedMode.HIGH;
    }

    public boolean isLowSpeed() {
        return this.getSpeedMode() == SpeedMode.LOW;
    }

    public boolean isUltraLowSpeed() {
        return this.getSpeedMode() == SpeedMode.ULTRA_LOW;
    }

    public boolean isContinuousProcessing() {
        return this.continuousProcessing;
    }

    public void startContinuousProcessing() {
        this.continuousProcessing = true;
        this.continuousProcessingCount = 0;
    }

    public void incrementContinuousProcessing() {
        ++this.continuousProcessingCount;
    }

    public void endContinuousProcessing() {
        this.continuousProcessing = false;
        this.continuousProcessingCount = 0;
    }

    private void handleHighSpeedInjection() {
        this.injectionStartProgress = 0.8f;
        if (this.phase == Phase.MOVE_TO_OUTPUT && this.processingBelt) {
            if (this.continuousProcessing && this.chasedPointProgress >= 0.9f) {
                this.chasedPointProgress = Math.min(this.chasedPointProgress, 0.95f);
            }
            if (!this.isPerformingInjection && this.previousProgressForInjection < this.injectionStartProgress && this.chasedPointProgress >= this.injectionStartProgress) {
                this.isPerformingInjection = true;
                this.notifyRelayInjectionReady(this.processingBeltPos);
            }
            if (this.chasedPointProgress >= 1.0f && !this.continuousProcessing) {
                this.isPerformingInjection = false;
            }
        }
    }

    private void handleLowSpeedInjection() {
        this.injectionStartProgress = 0.6f;
        if (this.phase == Phase.MOVE_TO_OUTPUT && this.processingBelt) {
            if (this.chasedPointProgress >= 0.9f && this.continuousProcessing) {
                this.chasedPointProgress = 1.0f;
            }
            if (!this.isPerformingInjection && this.chasedPointProgress >= this.injectionStartProgress) {
                this.isPerformingInjection = true;
                this.notifyRelayInjectionReady(this.processingBeltPos);
                if (!this.f_58857_.f_46443_) {
                    this.beltProcessingTicks = 30;
                }
            }
            if (this.chasedPointProgress >= 1.0f && !this.continuousProcessing) {
                this.isPerformingInjection = false;
            }
        }
    }

    private void handleUltraLowSpeedInjection() {
        this.injectionStartProgress = 0.3f;
        if (this.phase == Phase.MOVE_TO_OUTPUT && this.processingBelt) {
            if (!this.isPerformingInjection && this.chasedPointProgress > 0.1f) {
                this.isPerformingInjection = true;
                this.notifyRelayInjectionReady(this.processingBeltPos);
                if (!this.f_58857_.f_46443_) {
                    float speed = Math.abs(this.getSpeed());
                    int ticksToComplete = (int)((1.0f - this.chasedPointProgress) * 1024.0f / Math.max(speed, 1.0f));
                    this.beltProcessingTicks = Math.max(ticksToComplete + 10, 40);
                }
            }
            if (this.chasedPointProgress >= 1.0f) {
                this.isPerformingInjection = false;
            }
        }
    }

    public boolean willReachInjectionPoint() {
        if (this.phase != Phase.MOVE_TO_OUTPUT) {
            return false;
        }
        if (!this.isHighSpeed()) {
            return false;
        }
        float speed = Math.abs(this.getSpeed());
        float increment = Math.min(256.0f, speed) / 1024.0f;
        if (speed >= 256.0f && increment > 0.2f) {
            increment = 0.2f;
        }
        float nextProgress = this.chasedPointProgress + increment;
        return this.chasedPointProgress < this.injectionStartProgress && nextProgress >= this.injectionStartProgress;
    }

    public void notifyRelayInjectionReady(BlockPos beltPos) {
        VirtualRelayManager.notifyInjectionReady(beltPos);
    }

    public void resetMovementState() {
        this.phase = Phase.SEARCH_INPUTS;
        this.chasedPointProgress = 0.0f;
        this.chasedPointIndex = -1;
    }

    public void forceInitInteractionPoints() {
        this.initInteractionPoints();
    }

    public void forceReloadInteractionPoints() {
        if (this.interactionPointTag != null && this.f_58857_ != null) {
            this.inputs.clear();
            this.outputs.clear();
            for (Tag tag : this.interactionPointTag) {
                FluidInteractionPoint point = FluidInteractionPoint.deserialize((CompoundTag)tag, this.f_58857_, this.f_58858_);
                if (point == null) continue;
                if (point.getMode() == FluidInteractionPoint.Mode.TAKE) {
                    this.inputs.add(point);
                    continue;
                }
                this.outputs.add(point);
            }
            if (!this.f_58857_.f_46443_) {
                VirtualRelayManager.updateWorkstationRelays(this.f_58858_, this.f_58857_);
            }
            this.updateInteractionPoints = false;
            this.sendData();
            this.m_6596_();
        }
    }

    @Override
    public FluidStack getHeldFluid() {
        return this.heldFluid.copy();
    }

    public boolean hasFluid() {
        return !this.heldFluid.isEmpty();
    }

    @Override
    public void startFluidProcessing(ItemStack stack, VirtualRelayManager.VirtualRelay relay) {
        ItemStack singleItem = stack.m_41777_();
        singleItem.m_41764_(1);
        this.processingItem = singleItem;
        this.activeRelay = relay;
        this.processingTicks = 0;
        int required = FillingBySpout.getRequiredAmountForItem((Level)this.f_58857_, (ItemStack)singleItem, (FluidStack)this.heldFluid);
        if (required > 0 && required <= this.heldFluid.getAmount()) {
            FluidStack fluidForFilling = this.heldFluid.copy();
            fluidForFilling.setAmount(required);
            this.processingResult = FillingBySpout.fillItem((Level)this.f_58857_, (int)required, (ItemStack)singleItem, (FluidStack)fluidForFilling);
            if (!this.processingResult.m_41619_()) {
                this.heldFluid.shrink(required);
            }
        } else {
            this.processingResult = singleItem;
        }
        this.sendData();
    }

    @Override
    public boolean isFluidProcessingComplete() {
        return this.processingTicks >= 20;
    }

    @Override
    public ItemStack getFluidProcessingResult() {
        return this.processingResult.m_41777_();
    }

    @Override
    public void notifyProcessingStarted(BlockPos beltPos) {
        this.startBeltProcessing(beltPos);
    }

    @Override
    public void notifyProcessingCompleted(BlockPos beltPos) {
        this.processingItem = ItemStack.f_41583_;
        this.processingResult = ItemStack.f_41583_;
        this.processingTicks = 0;
        this.activeRelay = null;
    }

    public float getFluidFillRatio() {
        if (this.heldFluid.isEmpty()) {
            return 0.0f;
        }
        return (float)this.heldFluid.getAmount() / 1000.0f;
    }

    public void onLoad() {
        super.onLoad();
        if (!this.f_58857_.f_46443_) {
            VirtualRelayManager.registerWorkstation(this.f_58858_, this.f_58857_, PipetteBlockEntity.getRange());
        }
    }

    public void invalidate() {
        super.invalidate();
        if (!this.f_58857_.f_46443_) {
            VirtualRelayManager.unregisterWorkstation(this.f_58858_);
        }
    }

    public void destroy() {
        super.destroy();
        if (!this.f_58857_.f_46443_) {
            VirtualRelayManager.unregisterWorkstation(this.f_58858_);
        }
    }

    @Override
    public boolean canProcessFluidItem(ItemStack stack) {
        if (this.heldFluid.isEmpty()) {
            return false;
        }
        if (!FillingBySpout.canItemBeFilled((Level)this.f_58857_, (ItemStack)stack)) {
            return false;
        }
        int required = FillingBySpout.getRequiredAmountForItem((Level)this.f_58857_, (ItemStack)stack, (FluidStack)this.heldFluid);
        return required > 0 && required <= this.heldFluid.getAmount();
    }

    @Override
    public void syncFluid(FluidStack fluid) {
        this.heldFluid = fluid.copy();
        this.sendData();
        this.m_6596_();
    }

    @Override
    public boolean requestFluidForItem(ItemStack stack, BlockPos sourcePos) {
        int required;
        if (!this.heldFluid.isEmpty() && (required = FillingBySpout.getRequiredAmountForItem((Level)this.f_58857_, (ItemStack)stack, (FluidStack)this.heldFluid)) > 0 && required <= this.heldFluid.getAmount()) {
            return true;
        }
        for (FluidInteractionPoint input : this.inputs) {
            int required2;
            FluidStack simulatedFluid;
            if (!input.isValid() || !input.canExtract() || (simulatedFluid = input.extract(1000, true)).isEmpty() || (required2 = FillingBySpout.getRequiredAmountForItem((Level)this.f_58857_, (ItemStack)stack, (FluidStack)simulatedFluid)) <= 0 || required2 > simulatedFluid.getAmount()) continue;
            this.pendingBeltRequest = sourcePos;
            this.pendingBeltItem = stack.m_41777_();
            this.phase = Phase.MOVE_TO_INPUT;
            this.chasedPointIndex = this.inputs.indexOf(input);
            this.chasedPointProgress = 0.0f;
            this.lastInputIndex = this.chasedPointIndex;
            this.sendData();
            this.m_6596_();
            return true;
        }
        return false;
    }

    @Override
    public void onFluidProcessingComplete() {
    }

    @Override
    public int getProcessingRange() {
        return PipetteBlockEntity.getRange();
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.selectionMode = new ScrollOptionBehaviour(SelectionMode.class, (Component)CreateLang.translateDirect((String)"logistics.when_multiple_outputs_available", (Object[])new Object[0]), (SmartBlockEntity)this, (ValueBoxTransform)new SelectionModeValueBox());
        behaviours.add((BlockEntityBehaviour)this.selectionMode);
    }

    public void tick() {
        super.tick();
        if (!this.f_58857_.f_46443_ && this.processingItem != ItemStack.f_41583_) {
            ++this.processingTicks;
        }
        SpeedMode mode = this.getSpeedMode();
        switch (mode) {
            case HIGH: {
                this.handleHighSpeedInjection();
                break;
            }
            case LOW: {
                this.handleLowSpeedInjection();
                break;
            }
            case ULTRA_LOW: {
                this.handleUltraLowSpeedInjection();
            }
        }
        if (this.processingBelt && this.beltProcessingTicks > 0) {
            --this.beltProcessingTicks;
            if (this.beltProcessingTicks == 15) {
                this.f_58857_.m_5594_(null, this.processingBeltPos, AllSoundEvents.SPOUTING.getMainEvent(), SoundSource.BLOCKS, 0.75f, 0.9f + 0.2f * this.f_58857_.f_46441_.m_188501_());
            }
        }
        this.previousProgressForInjection = this.chasedPointProgress;
        this.initInteractionPoints();
        boolean targetReached = this.tickMovementProgress();
        if (this.tooltipWarmup > 0) {
            --this.tooltipWarmup;
        }
        if (this.chasedPointProgress < 1.0f) {
            FluidInteractionPoint point;
            if (this.phase == Phase.MOVE_TO_INPUT && (point = this.getTargetedInteractionPoint()) != null) {
                point.keepAlive();
            }
        } else if (!this.f_58857_.f_46443_) {
            if (this.phase == Phase.MOVE_TO_INPUT) {
                this.collectFluid();
            } else if (this.phase == Phase.MOVE_TO_OUTPUT) {
                this.depositFluid();
            } else if (this.phase == Phase.SEARCH_INPUTS) {
                this.searchForFluid();
            }
            if (targetReached) {
                this.lazyTick();
            }
        }
    }

    public void lazyTick() {
        super.lazyTick();
        if (!this.f_58857_.f_46443_ && this.chasedPointProgress >= 0.5f && this.phase == Phase.SEARCH_OUTPUTS) {
            this.searchForDestination();
        }
    }

    protected AABB createRenderBoundingBox() {
        return super.createRenderBoundingBox().m_82400_(3.0);
    }

    private boolean tickMovementProgress() {
        boolean targetReachedPreviously = this.chasedPointProgress >= 1.0f;
        float speed = Math.abs(this.getSpeed());
        float increment = Math.min(256.0f, speed) / 1024.0f;
        if (this.isHighSpeed()) {
            if (speed >= 256.0f && increment > 0.2f) {
                increment = 0.2f;
            }
        } else {
            increment *= 1.2f;
        }
        this.chasedPointProgress += increment;
        if (this.chasedPointProgress > 1.0f) {
            this.chasedPointProgress = 1.0f;
        }
        if (this.f_58857_.f_46443_) {
            FluidInteractionPoint targetedInteractionPoint = this.getTargetedInteractionPoint();
            PipetteAngleTarget previousTarget = this.previousTarget;
            PipetteAngleTarget target = targetedInteractionPoint == null ? PipetteAngleTarget.NO_TARGET : this.createAngleTarget(targetedInteractionPoint);
            double currentBaseAngle = AngleHelper.angleLerp((double)this.chasedPointProgress, (double)this.previousBaseAngle, (double)(target == PipetteAngleTarget.NO_TARGET ? (double)this.previousBaseAngle : (double)target.baseAngle));
            this.baseAngle.setValue(currentBaseAngle);
            if (this.chasedPointProgress < 0.5f) {
                target = PipetteAngleTarget.NO_TARGET;
            } else {
                previousTarget = PipetteAngleTarget.NO_TARGET;
            }
            float progress = this.chasedPointProgress == 1.0f ? 1.0f : this.chasedPointProgress % 0.5f * 2.0f;
            double lowerAngle = Mth.m_14179_((float)progress, (float)previousTarget.lowerArmAngle, (float)target.lowerArmAngle);
            double upperAngle = Mth.m_14179_((float)progress, (float)previousTarget.upperArmAngle, (float)target.upperArmAngle);
            double headAngleValue = AngleHelper.angleLerp((double)progress, (double)(previousTarget.headAngle % 360.0f), (double)(target.headAngle % 360.0f));
            this.lowerArmAngle.setValue(lowerAngle);
            this.upperArmAngle.setValue(upperAngle);
            this.headAngle.setValue(headAngleValue);
            return false;
        }
        return !targetReachedPreviously && this.chasedPointProgress >= 1.0f;
    }

    protected boolean isOnCeiling() {
        BlockState state = this.m_58900_();
        return this.m_58898_() && state.m_61145_((Property)PipetteBlock.CEILING).orElse(false) != false;
    }

    public void setInteractionPointTag(ListTag tag) {
        this.interactionPointTag = tag;
        this.updateInteractionPoints = true;
    }

    public void setUpdateInteractionPoints(boolean update) {
        this.updateInteractionPoints = update;
    }

    public boolean shouldUpdateInteractionPoints() {
        return this.updateInteractionPoints;
    }

    @Nullable
    private FluidInteractionPoint getTargetedInteractionPoint() {
        if (this.chasedPointIndex == -1) {
            return null;
        }
        if (this.phase == Phase.MOVE_TO_INPUT && this.chasedPointIndex < this.inputs.size()) {
            return this.inputs.get(this.chasedPointIndex);
        }
        return this.phase == Phase.MOVE_TO_OUTPUT && this.chasedPointIndex < this.outputs.size() ? this.outputs.get(this.chasedPointIndex) : null;
    }

    private PipetteAngleTarget createAngleTarget(FluidInteractionPoint point) {
        return new PipetteAngleTarget(this.f_58858_, VecHelper.getCenterOf((Vec3i)point.getPos()), Direction.DOWN, this.isOnCeiling());
    }

    private boolean canFluidBeOutputted(FluidStack fluid) {
        if (fluid.isEmpty()) {
            return false;
        }
        for (FluidInteractionPoint output : this.outputs) {
            BlockState outputState;
            if (!output.isValid() || this.isBlazeBurner(outputState = this.f_58857_.m_8055_(output.getPos())) && fluid.getFluid() != Fluids.f_76195_ || !output.canInsert(fluid)) continue;
            return true;
        }
        return false;
    }

    private boolean isBlazeBurner(BlockState state) {
        return AllBlocks.BLAZE_BURNER.has(state) || AllBlocks.LIT_BLAZE_BURNER.has(state);
    }

    protected void searchForFluid() {
        if (!this.redstoneLocked) {
            int scanRange;
            DepotFluidInteractionPoint depotPoint;
            boolean hasValidNonBeltOutput = false;
            for (FluidInteractionPoint output : this.outputs) {
                if (AllBlocks.BELT.has(this.f_58857_.m_8055_(output.getPos()))) continue;
                if (output instanceof DepotFluidInteractionPoint) {
                    depotPoint = (DepotFluidInteractionPoint)output;
                    if (!depotPoint.hasItemForFilling()) continue;
                    hasValidNonBeltOutput = true;
                    break;
                }
                if (!output.isValid()) continue;
                hasValidNonBeltOutput = true;
                break;
            }
            if (!hasValidNonBeltOutput) {
                return;
            }
            if (!this.heldFluid.isEmpty()) {
                for (FluidInteractionPoint output : this.outputs) {
                    if (AllBlocks.BELT.has(this.f_58857_.m_8055_(output.getPos()))) continue;
                    if (output instanceof DepotFluidInteractionPoint) {
                        depotPoint = (DepotFluidInteractionPoint)output;
                        if (!depotPoint.hasItemForFilling() || !depotPoint.canInsert(this.heldFluid)) continue;
                        this.phase = Phase.SEARCH_OUTPUTS;
                        this.chasedPointProgress = 0.0f;
                        this.chasedPointIndex = -1;
                        this.searchForDestination();
                        return;
                    }
                    if (!output.isValid() || !output.canInsert(this.heldFluid)) continue;
                    this.phase = Phase.SEARCH_OUTPUTS;
                    this.chasedPointProgress = 0.0f;
                    this.chasedPointIndex = -1;
                    this.searchForDestination();
                    return;
                }
            }
            boolean foundInput = false;
            int startIndex = this.selectionMode.get() == SelectionMode.PREFER_FIRST ? 0 : this.lastInputIndex + 1;
            int n = scanRange = this.selectionMode.get() == SelectionMode.FORCED_ROUND_ROBIN ? this.lastInputIndex + 2 : this.inputs.size();
            if (scanRange > this.inputs.size()) {
                scanRange = this.inputs.size();
            }
            for (int i = startIndex; i < scanRange; ++i) {
                FluidStack simulatedFluid;
                FluidInteractionPoint point = this.inputs.get(i);
                if (!point.isValid() || !point.canExtract() || (simulatedFluid = point.extract(1000, true)).isEmpty() || !this.canFluidBeOutputted(simulatedFluid)) continue;
                this.selectIndex(true, i);
                foundInput = true;
                break;
            }
            if (!foundInput && this.selectionMode.get() == SelectionMode.ROUND_ROBIN) {
                this.lastInputIndex = -1;
            }
            if (this.lastInputIndex == this.inputs.size() - 1) {
                this.lastInputIndex = -1;
            }
        }
    }

    protected void searchForDestination() {
        FluidStack held = this.heldFluid.copy();
        boolean foundOutput = false;
        for (int i = 0; i < this.outputs.size(); ++i) {
            FluidInteractionPoint point = this.outputs.get(i);
            if (AllBlocks.BELT.has(this.f_58857_.m_8055_(point.getPos())) || !point.isValid() || !point.canInsert(held)) continue;
            this.selectIndex(false, i);
            foundOutput = true;
            break;
        }
    }

    public void onBeltProcessingFinished(BlockPos beltPos) {
        this.processingBelt = false;
        this.processingBeltPos = null;
        this.beltProcessingTicks = 0;
        SpeedMode mode = this.getSpeedMode();
        if ((mode == SpeedMode.LOW || mode == SpeedMode.ULTRA_LOW) && this.continuousProcessing) {
            this.phase = Phase.MOVE_TO_OUTPUT;
            this.chasedPointProgress = 1.0f;
            this.isPerformingInjection = false;
        } else if (mode == SpeedMode.HIGH && this.continuousProcessing) {
            this.phase = Phase.MOVE_TO_OUTPUT;
            this.chasedPointProgress = 0.95f;
            this.isPerformingInjection = false;
        } else {
            this.isPerformingInjection = false;
            this.continuousProcessing = false;
            this.continuousProcessingCount = 0;
            if (!this.heldFluid.isEmpty()) {
                this.phase = Phase.SEARCH_OUTPUTS;
                this.chasedPointProgress = 0.0f;
                this.chasedPointIndex = -1;
                this.searchForDestination();
            } else {
                this.phase = Phase.SEARCH_INPUTS;
                this.chasedPointProgress = 0.0f;
                this.chasedPointIndex = -1;
            }
        }
        this.sendData();
        this.m_6596_();
    }

    private void selectIndex(boolean input, int index) {
        this.phase = input ? Phase.MOVE_TO_INPUT : Phase.MOVE_TO_OUTPUT;
        this.chasedPointIndex = index;
        this.chasedPointProgress = 0.0f;
        if (input) {
            this.lastInputIndex = index;
        } else {
            this.lastOutputIndex = index;
        }
        this.sendData();
        this.m_6596_();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.fluidCapability.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.fluidCapability.invalidate();
    }

    protected void depositFluid() {
        FluidInteractionPoint point = this.getTargetedInteractionPoint();
        if (point == null || !point.isValid()) {
            this.phase = this.heldFluid.isEmpty() ? Phase.SEARCH_INPUTS : Phase.SEARCH_OUTPUTS;
            this.chasedPointProgress = 0.0f;
            this.chasedPointIndex = -1;
            this.sendData();
            this.m_6596_();
            return;
        }
        if (point instanceof DepotFluidInteractionPoint) {
            DepotFluidInteractionPoint depotPoint = (DepotFluidInteractionPoint)point;
            DepotBehaviour behaviour = (DepotBehaviour)BlockEntityBehaviour.get((BlockGetter)this.f_58857_, (BlockPos)point.getPos(), (BehaviourType)DepotBehaviour.TYPE);
            if (behaviour == null) {
                return;
            }
            ItemStack itemOnDepot = behaviour.getHeldItemStack();
            if (itemOnDepot != null && !itemOnDepot.m_41619_()) {
                ItemStack singleItem = itemOnDepot.m_41777_();
                singleItem.m_41764_(1);
                int requiredAmount = FillingBySpout.getRequiredAmountForItem((Level)this.f_58857_, (ItemStack)singleItem, (FluidStack)this.heldFluid);
                if (requiredAmount > 0 && requiredAmount <= this.heldFluid.getAmount()) {
                    ItemStack toProcess = itemOnDepot.m_41777_();
                    toProcess.m_41764_(1);
                    FluidStack fluidForFilling = this.heldFluid.copy();
                    fluidForFilling.setAmount(requiredAmount);
                    ItemStack result = FillingBySpout.fillItem((Level)this.f_58857_, (int)requiredAmount, (ItemStack)toProcess, (FluidStack)fluidForFilling);
                    if (!result.m_41619_()) {
                        FluidStack fluidForParticles = this.heldFluid.copy();
                        itemOnDepot.m_41774_(1);
                        if (itemOnDepot.m_41619_()) {
                            behaviour.setHeldItem(null);
                        } else {
                            TransportedItemStack updatedStack = new TransportedItemStack(itemOnDepot);
                            updatedStack.beltPosition = 0.5f;
                            updatedStack.prevBeltPosition = 0.5f;
                            behaviour.setHeldItem(updatedStack);
                        }
                        try {
                            Field bufferField = DepotBehaviour.class.getDeclaredField("processingOutputBuffer");
                            bufferField.setAccessible(true);
                            ItemStackHandler outputBuffer = (ItemStackHandler)bufferField.get(behaviour);
                            ItemStack remainder = result.m_41777_();
                            for (int slot = 0; slot < outputBuffer.getSlots() && !remainder.m_41619_(); ++slot) {
                                remainder = outputBuffer.insertItem(slot, remainder, false);
                            }
                            if (!remainder.m_41619_()) {
                                Vec3 dropPos = VecHelper.getCenterOf((Vec3i)point.getPos());
                                Containers.m_18992_((Level)this.f_58857_, (double)dropPos.f_82479_, (double)(dropPos.f_82480_ + 0.5), (double)dropPos.f_82481_, (ItemStack)remainder);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            TransportedItemStack newTIS = new TransportedItemStack(result);
                            newTIS.beltPosition = 0.5f;
                            newTIS.prevBeltPosition = 0.5f;
                            behaviour.setHeldItem(newTIS);
                        }
                        behaviour.blockEntity.notifyUpdate();
                        this.heldFluid.shrink(requiredAmount);
                        this.f_58857_.m_5594_(null, point.getPos(), AllSoundEvents.SPOUTING.getMainEvent(), SoundSource.BLOCKS, 0.75f, 0.9f + 0.2f * this.f_58857_.f_46441_.m_188501_());
                        if (!this.f_58857_.f_46443_) {
                            this.sendFillingParticles(point.getPos(), fluidForParticles);
                        }
                    }
                }
            }
        } else {
            FluidStack remainder;
            FluidStack toInsert = this.heldFluid.copy();
            this.heldFluid = remainder = point.insert(toInsert, false);
        }
        this.phase = this.heldFluid.isEmpty() ? Phase.SEARCH_INPUTS : Phase.SEARCH_OUTPUTS;
        this.chasedPointProgress = 0.0f;
        this.chasedPointIndex = -1;
        this.sendData();
        this.m_6596_();
    }

    private void sendFillingParticles(BlockPos targetPos, FluidStack fluid) {
        if (this.f_58857_.f_46443_) {
            return;
        }
        Vec3 particlePos = VecHelper.getCenterOf((Vec3i)targetPos).m_82520_(0.0, 0.8125, 0.0);
        AllPackets.getChannel().send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(targetPos)), (Object)new PipetteParticlePacket(particlePos, fluid));
    }

    protected void collectFluid() {
        FluidInteractionPoint point = this.getTargetedInteractionPoint();
        if (point != null && point.isValid()) {
            FluidStack extracted;
            int maxCanExtract = 1000;
            if (!this.heldFluid.isEmpty() && (maxCanExtract = 1000 - this.heldFluid.getAmount()) <= 0) {
                this.phase = Phase.SEARCH_OUTPUTS;
                this.chasedPointProgress = 0.0f;
                this.chasedPointIndex = -1;
                this.sendData();
                this.m_6596_();
                return;
            }
            int extractAmount = Math.min(1000, maxCanExtract);
            if (this.pendingBeltRequest != null && !this.pendingBeltItem.m_41619_() && !(extracted = point.extract(extractAmount, false)).isEmpty()) {
                if (!this.heldFluid.isEmpty() && this.heldFluid.isFluidEqual(extracted)) {
                    this.heldFluid.grow(extracted.getAmount());
                } else if (this.heldFluid.isEmpty()) {
                    this.heldFluid = extracted;
                } else {
                    this.phase = Phase.SEARCH_INPUTS;
                    this.chasedPointProgress = 0.0f;
                    this.chasedPointIndex = -1;
                    this.pendingBeltRequest = null;
                    this.pendingBeltItem = ItemStack.f_41583_;
                    this.sendData();
                    this.m_6596_();
                    return;
                }
                this.phase = Phase.SEARCH_INPUTS;
                this.chasedPointProgress = 0.0f;
                this.chasedPointIndex = -1;
                this.pendingBeltRequest = null;
                this.pendingBeltItem = ItemStack.f_41583_;
                this.sendData();
                this.m_6596_();
                return;
            }
            extracted = point.extract(extractAmount, false);
            if (!extracted.isEmpty()) {
                if (!this.heldFluid.isEmpty() && this.heldFluid.isFluidEqual(extracted)) {
                    this.heldFluid.grow(extracted.getAmount());
                } else if (this.heldFluid.isEmpty()) {
                    this.heldFluid = extracted;
                }
                this.phase = Phase.SEARCH_OUTPUTS;
                this.chasedPointProgress = 0.0f;
                this.chasedPointIndex = -1;
                this.sendData();
                this.m_6596_();
                this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_11781_, SoundSource.BLOCKS, 0.125f, 0.5f + this.f_58857_.f_46441_.m_188501_() * 0.25f);
                return;
            }
        }
        this.phase = Phase.SEARCH_INPUTS;
        this.chasedPointProgress = 0.0f;
        this.chasedPointIndex = -1;
        this.sendData();
        this.m_6596_();
    }

    public void redstoneUpdate() {
        boolean blockPowered;
        if (!this.f_58857_.f_46443_ && (blockPowered = this.f_58857_.m_276867_(this.f_58858_)) != this.redstoneLocked) {
            this.redstoneLocked = blockPowered;
            this.sendData();
            if (!this.redstoneLocked) {
                this.searchForFluid();
            }
        }
    }

    public void transform(BlockEntity be, StructureTransform transform) {
        if (this.interactionPointTag != null) {
            for (Tag tag : this.interactionPointTag) {
                FluidInteractionPoint.transformPos((CompoundTag)tag, transform);
            }
            this.notifyUpdate();
        }
    }

    protected boolean isAreaActuallyLoaded(BlockPos center, int range) {
        if (!this.f_58857_.isAreaLoaded(center, range)) {
            return false;
        }
        if (this.f_58857_.f_46443_) {
            int minY = center.m_123342_() - range;
            int maxY = center.m_123342_() + range;
            if (maxY < this.f_58857_.m_141937_() || minY >= this.f_58857_.m_151558_()) {
                return false;
            }
            int minX = center.m_123341_() - range;
            int minZ = center.m_123343_() - range;
            int maxX = center.m_123341_() + range;
            int maxZ = center.m_123343_() + range;
            int minChunkX = SectionPos.m_123171_((int)minX);
            int maxChunkX = SectionPos.m_123171_((int)maxX);
            int minChunkZ = SectionPos.m_123171_((int)minZ);
            int maxChunkZ = SectionPos.m_123171_((int)maxZ);
            ChunkSource chunkSource = this.f_58857_.m_7726_();
            for (int chunkX = minChunkX; chunkX <= maxChunkX; ++chunkX) {
                for (int chunkZ = minChunkZ; chunkZ <= maxChunkZ; ++chunkZ) {
                    if (chunkSource.m_5563_(chunkX, chunkZ)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    protected void initInteractionPoints() {
        if (this.updateInteractionPoints && this.interactionPointTag != null && this.isAreaActuallyLoaded(this.f_58858_, PipetteBlockEntity.getRange() + 1)) {
            this.inputs.clear();
            this.outputs.clear();
            for (Tag tag : this.interactionPointTag) {
                FluidInteractionPoint point = FluidInteractionPoint.deserialize((CompoundTag)tag, this.f_58857_, this.f_58858_);
                if (point == null) continue;
                if (point.getMode() == FluidInteractionPoint.Mode.DEPOSIT) {
                    this.outputs.add(point);
                    continue;
                }
                if (point.getMode() != FluidInteractionPoint.Mode.TAKE) continue;
                this.inputs.add(point);
            }
            this.updateInteractionPoints = false;
            if (!this.f_58857_.f_46443_) {
                VirtualRelayManager.updateWorkstationRelays(this.f_58858_, this.f_58857_);
            }
            this.sendData();
            this.m_6596_();
        }
    }

    public void writeInteractionPoints(CompoundTag compound) {
        if (this.updateInteractionPoints && this.interactionPointTag != null) {
            compound.m_128365_("InteractionPoints", (Tag)this.interactionPointTag);
        } else {
            ListTag pointsNBT = new ListTag();
            this.inputs.stream().map(fip -> fip.serialize(this.f_58858_)).forEach(arg_0 -> pointsNBT.add(arg_0));
            this.outputs.stream().map(fip -> fip.serialize(this.f_58858_)).forEach(arg_0 -> pointsNBT.add(arg_0));
            compound.m_128365_("InteractionPoints", (Tag)pointsNBT);
        }
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        if (clientPacket) {
            ListTag currentPoints = new ListTag();
            this.inputs.stream().map(fip -> fip.serialize(this.f_58858_)).forEach(arg_0 -> currentPoints.add(arg_0));
            this.outputs.stream().map(fip -> fip.serialize(this.f_58858_)).forEach(arg_0 -> currentPoints.add(arg_0));
            compound.m_128365_("InteractionPoints", (Tag)currentPoints);
            compound.m_128379_("ForceUpdate", true);
        } else {
            this.writeInteractionPoints(compound);
        }
        NBTHelper.writeEnum((CompoundTag)compound, (String)"Phase", (Enum)this.phase);
        compound.m_128379_("Powered", this.redstoneLocked);
        compound.m_128379_("Goggles", this.goggles);
        compound.m_128365_("HeldFluid", (Tag)this.heldFluid.writeToNBT(new CompoundTag()));
        compound.m_128405_("TargetPointIndex", this.chasedPointIndex);
        compound.m_128350_("MovementProgress", this.chasedPointProgress);
        if (clientPacket && this.processingBelt) {
            compound.m_128379_("ProcessingBelt", true);
            compound.m_128356_("ProcessingBeltPos", this.processingBeltPos.m_121878_());
            compound.m_128405_("BeltProcessingTicks", this.beltProcessingTicks);
        }
    }

    public void writeSafe(CompoundTag compound) {
        super.writeSafe(compound);
        this.writeInteractionPoints(compound);
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        int previousIndex = this.chasedPointIndex;
        Phase previousPhase = this.phase;
        ListTag interactionPointTagBefore = this.interactionPointTag;
        super.read(compound, clientPacket);
        this.heldFluid = FluidStack.loadFluidStackFromNBT((CompoundTag)compound.m_128469_("HeldFluid"));
        this.phase = (Phase)NBTHelper.readEnum((CompoundTag)compound, (String)"Phase", Phase.class);
        this.chasedPointIndex = compound.m_128451_("TargetPointIndex");
        this.chasedPointProgress = compound.m_128457_("MovementProgress");
        this.interactionPointTag = compound.m_128437_("InteractionPoints", 10);
        this.redstoneLocked = compound.m_128471_("Powered");
        boolean hadGoggles = this.goggles;
        this.goggles = compound.m_128471_("Goggles");
        if (clientPacket) {
            boolean tagChanged;
            this.processingBelt = compound.m_128471_("ProcessingBelt");
            if (this.processingBelt) {
                this.processingBeltPos = BlockPos.m_122022_((long)compound.m_128454_("ProcessingBeltPos"));
                this.beltProcessingTicks = compound.m_128451_("BeltProcessingTicks");
            }
            if (hadGoggles != this.goggles) {
                DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> VisualizationHelper.queueUpdate((BlockEntity)this));
            }
            boolean forceUpdate = compound.m_128471_("ForceUpdate");
            boolean bl = tagChanged = interactionPointTagBefore == null || interactionPointTagBefore.size() != this.interactionPointTag.size();
            if (forceUpdate || tagChanged) {
                this.inputs.clear();
                this.outputs.clear();
                if (this.interactionPointTag != null && this.f_58857_ != null) {
                    for (Tag tag : this.interactionPointTag) {
                        FluidInteractionPoint point = FluidInteractionPoint.deserialize((CompoundTag)tag, this.f_58857_, this.f_58858_);
                        if (point == null) continue;
                        if (point.getMode() == FluidInteractionPoint.Mode.TAKE) {
                            this.inputs.add(point);
                            continue;
                        }
                        this.outputs.add(point);
                    }
                }
                this.updateInteractionPoints = false;
            }
            if (previousIndex != this.chasedPointIndex || previousPhase != this.phase) {
                FluidInteractionPoint targetedPoint;
                FluidInteractionPoint previousPoint = null;
                if (previousPhase == Phase.MOVE_TO_INPUT && previousIndex < this.inputs.size()) {
                    previousPoint = this.inputs.get(previousIndex);
                }
                if (previousPhase == Phase.MOVE_TO_OUTPUT && previousIndex < this.outputs.size()) {
                    previousPoint = this.outputs.get(previousIndex);
                }
                PipetteAngleTarget pipetteAngleTarget = this.previousTarget = previousPoint == null ? PipetteAngleTarget.NO_TARGET : this.createAngleTarget(previousPoint);
                if (previousPoint != null) {
                    this.previousBaseAngle = this.previousTarget.baseAngle;
                }
                if ((targetedPoint = this.getTargetedInteractionPoint()) != null) {
                    targetedPoint.updateCachedState();
                }
            }
        }
    }

    public static int getRange() {
        return (Integer)AllConfigs.server().logistics.mechanicalArmRange.get();
    }

    public boolean addToTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        if (super.addToTooltip(tooltip, isPlayerSneaking)) {
            return true;
        }
        if (isPlayerSneaking) {
            return false;
        }
        if (this.tooltipWarmup > 0) {
            return false;
        }
        if (!this.inputs.isEmpty()) {
            return false;
        }
        if (!this.outputs.isEmpty()) {
            return false;
        }
        TooltipHelper.addHint(tooltip, (String)"fluid.mechanical_pipette.no_targets", (Object[])new Object[0]);
        return true;
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        boolean added = super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        LazyOptional handler = this.getCapability(ForgeCapabilities.FLUID_HANDLER);
        if (handler.isPresent()) {
            return this.containedFluidTooltip(tooltip, isPlayerSneaking, handler) || added;
        }
        return added;
    }

    public void m_142339_(Level level) {
        super.m_142339_(level);
        for (FluidInteractionPoint input : this.inputs) {
            input.setLevel(level);
        }
        for (FluidInteractionPoint output : this.outputs) {
            output.setLevel(level);
        }
    }

    public void startBeltProcessing(BlockPos beltPos) {
        this.processingBelt = true;
        this.processingBeltPos = beltPos;
        this.isPerformingInjection = false;
        this.beltProcessingTicks = this.phase == Phase.SEARCH_OUTPUTS || this.phase == Phase.MOVE_TO_OUTPUT && this.chasedPointProgress < 0.5f ? 20 : 10;
        for (int i = 0; i < this.outputs.size(); ++i) {
            if (!this.outputs.get(i).getPos().equals((Object)beltPos)) continue;
            this.phase = Phase.MOVE_TO_OUTPUT;
            this.chasedPointIndex = i;
            if (!(this.chasedPointProgress >= 1.0f)) break;
            this.chasedPointProgress = 0.0f;
            break;
        }
        this.sendData();
    }

    public void finishBeltProcessing(BlockPos beltPos) {
        this.processingBelt = false;
        this.processingBeltPos = null;
        this.beltProcessingTicks = 0;
        if (this.heldFluid.isEmpty()) {
            this.phase = Phase.SEARCH_INPUTS;
            this.chasedPointProgress = 0.0f;
            this.chasedPointIndex = -1;
        }
        this.sendData();
    }

    public void sendBeltProcessingEffects(BlockPos beltPos, FluidStack fluid) {
        if (!this.f_58857_.f_46443_) {
            Vec3 particlePos = VecHelper.getCenterOf((Vec3i)beltPos).m_82520_(0.0, 0.5, 0.0);
            AllPackets.getChannel().send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(beltPos)), (Object)new PipetteParticlePacket(particlePos, fluid));
        }
    }

    public static enum Phase {
        SEARCH_INPUTS,
        MOVE_TO_INPUT,
        SEARCH_OUTPUTS,
        MOVE_TO_OUTPUT;

    }

    public static enum SpeedMode {
        ULTRA_LOW,
        LOW,
        HIGH;

    }

    public static enum SelectionMode implements INamedIconOptions
    {
        ROUND_ROBIN(AllIcons.I_ARM_ROUND_ROBIN),
        FORCED_ROUND_ROBIN(AllIcons.I_ARM_FORCED_ROUND_ROBIN),
        PREFER_FIRST(AllIcons.I_ARM_PREFER_FIRST);

        private final String translationKey;
        private final AllIcons icon;

        private SelectionMode(AllIcons icon) {
            this.icon = icon;
            this.translationKey = "create.mechanical_arm.selection_mode." + Lang.asId((String)this.name());
        }

        public AllIcons getIcon() {
            return this.icon;
        }

        public String getTranslationKey() {
            return this.translationKey;
        }
    }

    private class SelectionModeValueBox
    extends CenteredSideValueBoxTransform {
        public SelectionModeValueBox() {
            super((blockState, direction) -> !direction.m_122434_().m_122478_());
        }

        public Vec3 getLocalOffset(LevelAccessor level, BlockPos pos, BlockState state) {
            int yPos = (Boolean)state.m_61143_((Property)PipetteBlock.CEILING) != false ? 13 : 3;
            Vec3 location = VecHelper.voxelSpace((double)8.0, (double)yPos, (double)15.5);
            location = VecHelper.rotateCentered((Vec3)location, (double)AngleHelper.horizontalAngle((Direction)this.getSide()), (Direction.Axis)Direction.Axis.Y);
            return location;
        }

        public float getScale() {
            return super.getScale();
        }
    }
}

