/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.fluid.block.SmartFluidInterface;

import com.adonis.fluid.block.SmartFluidInterface.SmartFluidInterfaceBlock;
import com.adonis.fluid.block.SmartFluidInterface.SmartFluidInterfaceFilterSlot;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class SmartFluidInterfaceBlockEntity
extends SmartBlockEntity {
    private LazyOptional<IFluidHandler> fluidCapability = LazyOptional.of(() -> new SmartFluidInterfaceHandler());
    protected FilteringBehaviour filtering;

    public SmartFluidInterfaceBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.filtering = new FilteringBehaviour((SmartBlockEntity)this, (ValueBoxTransform)new SmartFluidInterfaceFilterSlot()).forFluids();
        behaviours.add((BlockEntityBehaviour)this.filtering);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.fluidCapability.invalidate();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.fluidCapability.cast();
        }
        return super.getCapability(cap, side);
    }

    @Nullable
    private IFluidHandler getTargetFluidHandler() {
        if (this.f_58857_ == null) {
            return null;
        }
        BlockState state = this.m_58900_();
        if (!(state.m_60734_() instanceof SmartFluidInterfaceBlock)) {
            return null;
        }
        Direction attachedDirection = ((Direction)state.m_61143_((Property)SmartFluidInterfaceBlock.FACING)).m_122424_();
        BlockPos targetPos = this.f_58858_.m_121945_(attachedDirection);
        BlockState targetState = this.f_58857_.m_8055_(targetPos);
        if (targetState.m_204336_(BlockTags.f_13035_) && targetState.m_61138_((Property)BlockStateProperties.f_61362_) && ((Boolean)targetState.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
            return new WaterloggedBlockFluidHandler();
        }
        BlockEntity targetBlockEntity = this.f_58857_.m_7702_(targetPos);
        if (targetBlockEntity == null) {
            return null;
        }
        IFluidHandler handler = (IFluidHandler)targetBlockEntity.getCapability(ForgeCapabilities.FLUID_HANDLER, (Direction)state.m_61143_((Property)SmartFluidInterfaceBlock.FACING)).orElse(null);
        if (handler == null) {
            handler = (IFluidHandler)targetBlockEntity.getCapability(ForgeCapabilities.FLUID_HANDLER, null).orElse(null);
        }
        return handler;
    }

    @Nullable
    private BlockEntity getTargetBlockEntity() {
        if (this.f_58857_ == null) {
            return null;
        }
        BlockState state = this.m_58900_();
        if (!(state.m_60734_() instanceof SmartFluidInterfaceBlock)) {
            return null;
        }
        Direction attachedDirection = ((Direction)state.m_61143_((Property)SmartFluidInterfaceBlock.FACING)).m_122424_();
        BlockPos targetPos = this.f_58858_.m_121945_(attachedDirection);
        return this.f_58857_.m_7702_(targetPos);
    }

    protected void write(CompoundTag tag, boolean clientPacket) {
        super.write(tag, clientPacket);
    }

    protected void read(CompoundTag tag, boolean clientPacket) {
        super.read(tag, clientPacket);
    }

    private static class WaterloggedBlockFluidHandler
    implements IFluidHandler {
        private static final FluidStack WATER = new FluidStack((Fluid)Fluids.f_76193_, 1000);

        private WaterloggedBlockFluidHandler() {
        }

        public int getTanks() {
            return 1;
        }

        public FluidStack getFluidInTank(int tank) {
            return WATER.copy();
        }

        public int getTankCapacity(int tank) {
            return Integer.MAX_VALUE;
        }

        public boolean isFluidValid(int tank, FluidStack stack) {
            return false;
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            return 0;
        }

        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            if (resource.getFluid() == Fluids.f_76193_) {
                return new FluidStack((Fluid)Fluids.f_76193_, Math.min(resource.getAmount(), 1000));
            }
            return FluidStack.EMPTY;
        }

        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            return new FluidStack((Fluid)Fluids.f_76193_, Math.min(maxDrain, 1000));
        }
    }

    private class SmartFluidInterfaceHandler
    implements IFluidHandler {
        private SmartFluidInterfaceHandler() {
        }

        public int getTanks() {
            IFluidHandler target = SmartFluidInterfaceBlockEntity.this.getTargetFluidHandler();
            return target != null ? target.getTanks() : 0;
        }

        @Nonnull
        public FluidStack getFluidInTank(int tank) {
            IFluidHandler target = SmartFluidInterfaceBlockEntity.this.getTargetFluidHandler();
            if (target == null) {
                return FluidStack.EMPTY;
            }
            FluidStack fluid = target.getFluidInTank(tank);
            return fluid;
        }

        public int getTankCapacity(int tank) {
            IFluidHandler target = SmartFluidInterfaceBlockEntity.this.getTargetFluidHandler();
            return target != null ? target.getTankCapacity(tank) : 0;
        }

        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            IFluidHandler target = SmartFluidInterfaceBlockEntity.this.getTargetFluidHandler();
            if (target == null) {
                return false;
            }
            if (SmartFluidInterfaceBlockEntity.this.filtering != null && !SmartFluidInterfaceBlockEntity.this.filtering.test(stack)) {
                return false;
            }
            return target.isFluidValid(tank, stack);
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            IFluidHandler target = SmartFluidInterfaceBlockEntity.this.getTargetFluidHandler();
            if (target == null) {
                return 0;
            }
            if (SmartFluidInterfaceBlockEntity.this.filtering != null && !SmartFluidInterfaceBlockEntity.this.filtering.test(resource)) {
                return 0;
            }
            int filled = target.fill(resource, action);
            if (filled > 0 && action.execute()) {
                BlockEntity targetBE = SmartFluidInterfaceBlockEntity.this.getTargetBlockEntity();
                if (targetBE != null) {
                    targetBE.m_6596_();
                }
                SmartFluidInterfaceBlockEntity.this.m_6596_();
            }
            return filled;
        }

        @Nonnull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            IFluidHandler target = SmartFluidInterfaceBlockEntity.this.getTargetFluidHandler();
            if (target == null) {
                return FluidStack.EMPTY;
            }
            if (SmartFluidInterfaceBlockEntity.this.filtering != null && !SmartFluidInterfaceBlockEntity.this.filtering.test(resource)) {
                return FluidStack.EMPTY;
            }
            FluidStack drained = target.drain(resource, action);
            if (!drained.isEmpty() && action.execute()) {
                BlockEntity targetBE = SmartFluidInterfaceBlockEntity.this.getTargetBlockEntity();
                if (targetBE != null) {
                    targetBE.m_6596_();
                }
                SmartFluidInterfaceBlockEntity.this.m_6596_();
            }
            return drained;
        }

        @Nonnull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            IFluidHandler target = SmartFluidInterfaceBlockEntity.this.getTargetFluidHandler();
            if (target == null) {
                return FluidStack.EMPTY;
            }
            for (int i = 0; i < target.getTanks(); ++i) {
                FluidStack fluid = target.getFluidInTank(i);
                if (fluid.isEmpty() || SmartFluidInterfaceBlockEntity.this.filtering != null && !SmartFluidInterfaceBlockEntity.this.filtering.test(fluid)) continue;
                FluidStack toDrain = fluid.copy();
                toDrain.setAmount(Math.min(maxDrain, fluid.getAmount()));
                FluidStack drained = target.drain(toDrain, action);
                if (!drained.isEmpty() && action.execute()) {
                    BlockEntity targetBE = SmartFluidInterfaceBlockEntity.this.getTargetBlockEntity();
                    if (targetBE != null) {
                        targetBE.m_6596_();
                    }
                    SmartFluidInterfaceBlockEntity.this.m_6596_();
                }
                return drained;
            }
            return FluidStack.EMPTY;
        }
    }
}

