/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.fluid.content.pipette;

import com.adonis.fluid.registry.CFFluid;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class CauldronFluidHandler
implements IFluidHandler {
    private final Level level;
    private final BlockPos pos;
    private BlockState state;
    private static final int FULL_AMOUNT = 1000;
    private static final int WATER_LEVEL_CAPACITY = 250;

    public CauldronFluidHandler(Level level, BlockPos pos, BlockState state) {
        this.level = level;
        this.pos = pos;
        this.state = state;
    }

    public int getTanks() {
        return 1;
    }

    @Nonnull
    public FluidStack getFluidInTank(int tank) {
        if (tank != 0) {
            return FluidStack.EMPTY;
        }
        this.state = this.level.m_8055_(this.pos);
        if (this.state.m_60713_(Blocks.f_152476_)) {
            int level = (Integer)this.state.m_61143_((Property)LayeredCauldronBlock.f_153514_);
            if (level == 3) {
                return new FluidStack((Fluid)Fluids.f_76193_, 1000);
            }
            return FluidStack.EMPTY;
        }
        if (this.state.m_60713_(Blocks.f_152477_)) {
            return new FluidStack((Fluid)Fluids.f_76195_, 1000);
        }
        if (this.state.m_60713_(Blocks.f_152478_)) {
            int level = (Integer)this.state.m_61143_((Property)LayeredCauldronBlock.f_153514_);
            if (level == 3) {
                return CFFluid.getPowderSnowFluidStack(1000);
            }
            return FluidStack.EMPTY;
        }
        return FluidStack.EMPTY;
    }

    public int getTankCapacity(int tank) {
        return 1000;
    }

    public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
        if (tank != 0 || stack.isEmpty()) {
            return false;
        }
        return stack.getFluid() == Fluids.f_76193_ || stack.getFluid() == Fluids.f_76195_ || CFFluid.isPowderSnowFluid(stack.getFluid());
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        int maxLevelsCanAdd;
        int levelsToAdd;
        int currentLevel;
        if (resource.isEmpty() || !this.isFluidValid(0, resource)) {
            return 0;
        }
        this.state = this.level.m_8055_(this.pos);
        if (this.state.m_60713_(Blocks.f_50256_)) {
            BlockState newState = null;
            int fillAmount = 0;
            if (resource.getFluid() == Fluids.f_76193_) {
                if (resource.getAmount() >= 250) {
                    int levels = Math.min(3, resource.getAmount() / 250);
                    fillAmount = levels * 250;
                    newState = (BlockState)Blocks.f_152476_.m_49966_().m_61124_((Property)LayeredCauldronBlock.f_153514_, (Comparable)Integer.valueOf(levels));
                }
            } else if (resource.getFluid() == Fluids.f_76195_) {
                if (resource.getAmount() >= 1000) {
                    newState = Blocks.f_152477_.m_49966_();
                    fillAmount = 1000;
                }
            } else if (CFFluid.isPowderSnowFluid(resource.getFluid()) && resource.getAmount() >= 1000) {
                newState = (BlockState)Blocks.f_152478_.m_49966_().m_61124_((Property)LayeredCauldronBlock.f_153514_, (Comparable)Integer.valueOf(3));
                fillAmount = 1000;
            }
            if (newState != null && fillAmount > 0) {
                if (action.execute()) {
                    this.level.m_46597_(this.pos, newState);
                    this.level.m_142346_(null, GameEvent.f_157792_, this.pos);
                    if (resource.getFluid() == Fluids.f_76193_) {
                        this.level.m_46796_(1047, this.pos, 0);
                    } else if (resource.getFluid() == Fluids.f_76195_) {
                        this.level.m_46796_(1046, this.pos, 0);
                    }
                }
                return fillAmount;
            }
            return 0;
        }
        if (this.state.m_60713_(Blocks.f_152476_) && resource.getFluid() == Fluids.f_76193_ && (currentLevel = ((Integer)this.state.m_61143_((Property)LayeredCauldronBlock.f_153514_)).intValue()) < 3 && (levelsToAdd = Math.min(maxLevelsCanAdd = 3 - currentLevel, resource.getAmount() / 250)) > 0) {
            int fillAmount = levelsToAdd * 250;
            if (action.execute()) {
                int newLevel = currentLevel + levelsToAdd;
                this.level.m_46597_(this.pos, (BlockState)this.state.m_61124_((Property)LayeredCauldronBlock.f_153514_, (Comparable)Integer.valueOf(newLevel)));
                this.level.m_142346_(null, GameEvent.f_157792_, this.pos);
                this.level.m_46796_(1047, this.pos, 0);
            }
            return fillAmount;
        }
        return 0;
    }

    @Nonnull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.isEmpty()) {
            return FluidStack.EMPTY;
        }
        FluidStack contained = this.getFluidInTank(0);
        if (!contained.isFluidEqual(resource)) {
            return FluidStack.EMPTY;
        }
        return this.drain(resource.getAmount(), action);
    }

    @Nonnull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        int currentLevel;
        if (maxDrain <= 0) {
            return FluidStack.EMPTY;
        }
        this.state = this.level.m_8055_(this.pos);
        FluidStack result = FluidStack.EMPTY;
        if (this.state.m_60713_(Blocks.f_152476_)) {
            int currentLevel2 = (Integer)this.state.m_61143_((Property)LayeredCauldronBlock.f_153514_);
            if (currentLevel2 == 3 && maxDrain >= 1000) {
                result = new FluidStack((Fluid)Fluids.f_76193_, 1000);
                if (action.execute()) {
                    this.level.m_46597_(this.pos, Blocks.f_50256_.m_49966_());
                    this.level.m_142346_(null, GameEvent.f_157792_, this.pos);
                }
            }
        } else if (this.state.m_60713_(Blocks.f_152477_)) {
            if (maxDrain >= 1000) {
                result = new FluidStack((Fluid)Fluids.f_76195_, 1000);
                if (action.execute()) {
                    this.level.m_46597_(this.pos, Blocks.f_50256_.m_49966_());
                    this.level.m_142346_(null, GameEvent.f_157792_, this.pos);
                }
            }
        } else if (this.state.m_60713_(Blocks.f_152478_) && (currentLevel = ((Integer)this.state.m_61143_((Property)LayeredCauldronBlock.f_153514_)).intValue()) == 3 && maxDrain >= 1000) {
            result = CFFluid.getPowderSnowFluidStack(1000);
            if (action.execute()) {
                this.level.m_46597_(this.pos, Blocks.f_50256_.m_49966_());
                this.level.m_142346_(null, GameEvent.f_157792_, this.pos);
            }
        }
        return result;
    }
}

