/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.fluid.content.pipette;

import com.adonis.fluid.block.Pipette.PipetteBlockEntity;
import com.adonis.fluid.content.pipette.FluidInteractionPoint;
import com.adonis.fluid.content.pipette.IRemoteFluidProcessor;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.fluids.spout.FillingBySpout;
import com.simibubi.create.content.kinetics.belt.behaviour.BeltProcessingBehaviour;
import com.simibubi.create.content.kinetics.belt.behaviour.TransportedItemStackHandlerBehaviour;
import com.simibubi.create.content.kinetics.belt.transport.TransportedItemStack;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.ItemHandlerHelper;

public class VirtualRelayManager {
    private static final Map<BlockPos, VirtualRelay> activeRelays = new ConcurrentHashMap<BlockPos, VirtualRelay>();
    private static final Map<BlockPos, Set<BlockPos>> workstationToRelays = new ConcurrentHashMap<BlockPos, Set<BlockPos>>();

    public static void registerWorkstation(BlockPos workstationPos, Level level, int range) {
        BlockEntity blockEntity = level.m_7702_(workstationPos);
        if (!(blockEntity instanceof IRemoteFluidProcessor)) {
            return;
        }
        IRemoteFluidProcessor processor = (IRemoteFluidProcessor)blockEntity;
        if (processor instanceof PipetteBlockEntity) {
            PipetteBlockEntity pipette = (PipetteBlockEntity)processor;
            HashSet<BlockPos> relayPositions = new HashSet<BlockPos>();
            for (FluidInteractionPoint output : pipette.outputs) {
                BlockPos outputPos = output.getPos();
                BlockState state = level.m_8055_(outputPos);
                if (!AllBlocks.BELT.has(state)) continue;
                BlockPos relayPos = outputPos.m_6630_(2);
                VirtualRelay relay = new VirtualRelay(outputPos, workstationPos, level);
                activeRelays.put(relayPos, relay);
                relayPositions.add(relayPos);
            }
            workstationToRelays.put(workstationPos, relayPositions);
        }
    }

    public static void unregisterWorkstation(BlockPos workstationPos) {
        Set<BlockPos> relayPositions = workstationToRelays.remove(workstationPos);
        if (relayPositions != null) {
            relayPositions.forEach(activeRelays::remove);
        }
    }

    public static VirtualRelay getRelayAt(BlockPos pos) {
        return activeRelays.get(pos);
    }

    public static void updateWorkstationRelays(BlockPos workstationPos, Level level) {
        VirtualRelayManager.unregisterWorkstation(workstationPos);
        VirtualRelayManager.registerWorkstation(workstationPos, level, 5);
    }

    public static void notifyInjectionReady(BlockPos beltPos) {
        BlockPos relayPos = beltPos.m_6630_(2);
        VirtualRelay relay = activeRelays.get(relayPos);
        if (relay != null) {
            relay.notifyInjectionReady();
        }
    }

    public static class VirtualRelay {
        private final BlockPos beltSegmentPos;
        private final BlockPos relayPos;
        private final BlockPos workstationPos;
        private WeakReference<BlockEntity> workstationRef;
        private final BeltProcessingBehaviour processingBehaviour;
        private TransportedItemStack currentlyProcessing;
        private int localProcessingTicks = -1;
        private boolean waitingForFluid = false;
        private boolean waitingForPipetteAnimation = false;
        private static final int FILLING_TIME = 20;
        private boolean pipetteReady = false;
        private boolean particlesSent = false;
        private boolean injectionReadySignalReceived = false;

        public VirtualRelay(BlockPos beltPos, BlockPos workstationPos, Level level) {
            this.beltSegmentPos = beltPos;
            this.relayPos = beltPos.m_6630_(2);
            this.workstationPos = workstationPos;
            BlockEntity workstation = level.m_7702_(workstationPos);
            this.workstationRef = new WeakReference<BlockEntity>(workstation);
            this.processingBehaviour = new BeltProcessingBehaviour(null){

                public BeltProcessingBehaviour.ProcessingResult handleReceivedItem(TransportedItemStack transported, TransportedItemStackHandlerBehaviour handler) {
                    return this.onItemReceived(transported, handler);
                }

                public BeltProcessingBehaviour.ProcessingResult handleHeldItem(TransportedItemStack transported, TransportedItemStackHandlerBehaviour handler) {
                    return this.whenItemHeld(transported, handler);
                }
            };
        }

        public BeltProcessingBehaviour getProcessingBehaviour() {
            return this.processingBehaviour;
        }

        public void notifyInjectionReady() {
            this.injectionReadySignalReceived = true;
        }

        private BeltProcessingBehaviour.ProcessingResult onItemReceived(TransportedItemStack transported, TransportedItemStackHandlerBehaviour handler) {
            BlockEntity workstation = (BlockEntity)this.workstationRef.get();
            if (!(workstation instanceof IRemoteFluidProcessor)) {
                return BeltProcessingBehaviour.ProcessingResult.PASS;
            }
            IRemoteFluidProcessor processor = (IRemoteFluidProcessor)workstation;
            if (!FillingBySpout.canItemBeFilled((Level)workstation.m_58904_(), (ItemStack)transported.stack)) {
                return BeltProcessingBehaviour.ProcessingResult.PASS;
            }
            FluidStack fluid = processor.getHeldFluid();
            ItemStack singleItem = ItemHandlerHelper.copyStackWithSize((ItemStack)transported.stack, (int)1);
            int required = FillingBySpout.getRequiredAmountForItem((Level)workstation.m_58904_(), (ItemStack)singleItem, (FluidStack)fluid);
            if (fluid.isEmpty() || required > 0 && required > fluid.getAmount()) {
                if (processor.requestFluidForItem(transported.stack, this.beltSegmentPos)) {
                    this.currentlyProcessing = transported;
                    this.waitingForFluid = true;
                    this.waitingForPipetteAnimation = false;
                    this.injectionReadySignalReceived = false;
                    this.particlesSent = false;
                    return BeltProcessingBehaviour.ProcessingResult.HOLD;
                }
                return BeltProcessingBehaviour.ProcessingResult.PASS;
            }
            if (required > 0 && required <= fluid.getAmount()) {
                this.currentlyProcessing = transported;
                this.waitingForFluid = false;
                this.waitingForPipetteAnimation = true;
                this.injectionReadySignalReceived = false;
                this.particlesSent = false;
                this.localProcessingTicks = -1;
                processor.notifyProcessingStarted(this.beltSegmentPos);
                return BeltProcessingBehaviour.ProcessingResult.HOLD;
            }
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }

        private BeltProcessingBehaviour.ProcessingResult whenItemHeld(TransportedItemStack transported, TransportedItemStackHandlerBehaviour handler) {
            PipetteBlockEntity pipette;
            if (this.currentlyProcessing != transported) {
                return BeltProcessingBehaviour.ProcessingResult.PASS;
            }
            if (handler == null) {
                this.resetState();
                return BeltProcessingBehaviour.ProcessingResult.PASS;
            }
            BlockEntity workstation = (BlockEntity)this.workstationRef.get();
            if (!(workstation instanceof IRemoteFluidProcessor)) {
                this.resetState();
                return BeltProcessingBehaviour.ProcessingResult.PASS;
            }
            IRemoteFluidProcessor processor = (IRemoteFluidProcessor)workstation;
            if (this.waitingForFluid) {
                FluidStack fluid = processor.getHeldFluid();
                ItemStack singleItem = ItemHandlerHelper.copyStackWithSize((ItemStack)transported.stack, (int)1);
                int required = FillingBySpout.getRequiredAmountForItem((Level)workstation.m_58904_(), (ItemStack)singleItem, (FluidStack)fluid);
                if (!fluid.isEmpty() && required > 0 && required <= fluid.getAmount()) {
                    this.waitingForFluid = false;
                    this.waitingForPipetteAnimation = true;
                    this.injectionReadySignalReceived = false;
                    processor.notifyProcessingStarted(this.beltSegmentPos);
                }
                return BeltProcessingBehaviour.ProcessingResult.HOLD;
            }
            if (this.waitingForPipetteAnimation) {
                if (processor instanceof PipetteBlockEntity) {
                    PipetteBlockEntity pipette2 = (PipetteBlockEntity)processor;
                    PipetteBlockEntity.SpeedMode mode = pipette2.getSpeedMode();
                    switch (mode) {
                        case HIGH: {
                            boolean willReachSoon = pipette2.willReachInjectionPoint();
                            if (!this.injectionReadySignalReceived && !pipette2.isReadyToInject() && !willReachSoon) break;
                            this.waitingForPipetteAnimation = false;
                            this.localProcessingTicks = willReachSoon ? 6 : 5;
                            break;
                        }
                        case LOW: {
                            if (pipette2.isContinuousProcessing() && pipette2.getWorkProgress() >= 0.95f) {
                                this.waitingForPipetteAnimation = false;
                                this.localProcessingTicks = 8;
                                break;
                            }
                            if (!this.injectionReadySignalReceived && !(pipette2.getWorkProgress() >= 0.6f)) break;
                            this.waitingForPipetteAnimation = false;
                            this.localProcessingTicks = 10;
                            break;
                        }
                        case ULTRA_LOW: {
                            float progress;
                            if (!this.injectionReadySignalReceived || !((progress = pipette2.getWorkProgress()) >= 0.8f)) break;
                            this.waitingForPipetteAnimation = false;
                            float speed = Math.abs(pipette2.getSpeed());
                            int remainingTicks = (int)((1.0f - progress) * 1024.0f / Math.max(speed, 1.0f));
                            this.localProcessingTicks = Math.min(remainingTicks + 5, 15);
                        }
                    }
                }
                return BeltProcessingBehaviour.ProcessingResult.HOLD;
            }
            if (this.localProcessingTicks > 0) {
                BlockEntity ws;
                --this.localProcessingTicks;
                if (this.localProcessingTicks == 4 && !this.particlesSent && (ws = (BlockEntity)this.workstationRef.get()) instanceof PipetteBlockEntity) {
                    pipette = (PipetteBlockEntity)ws;
                    FluidStack fluidForParticles = pipette.getHeldFluid().copy();
                    pipette.sendBeltProcessingEffects(this.beltSegmentPos, fluidForParticles);
                    this.particlesSent = true;
                }
                if (this.localProcessingTicks == 2) {
                    this.performActualFilling(transported, handler, processor);
                }
                if (this.localProcessingTicks > 0) {
                    return BeltProcessingBehaviour.ProcessingResult.HOLD;
                }
            }
            boolean wasContinuous = false;
            if (processor instanceof PipetteBlockEntity) {
                pipette = (PipetteBlockEntity)processor;
                wasContinuous = pipette.isContinuousProcessing();
            }
            this.resetState();
            if (processor instanceof PipetteBlockEntity) {
                pipette = (PipetteBlockEntity)processor;
                if (!wasContinuous) {
                    pipette.onBeltProcessingFinished(this.beltSegmentPos);
                }
            }
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }

        private void performActualFilling(TransportedItemStack transported, TransportedItemStackHandlerBehaviour handler, IRemoteFluidProcessor processor) {
            boolean bulk;
            ItemStack toProcess;
            FluidStack fluid = processor.getHeldFluid();
            Level level = ((BlockEntity)this.workstationRef.get()).m_58904_();
            int required = FillingBySpout.getRequiredAmountForItem((Level)level, (ItemStack)(toProcess = (bulk = this.canProcessInBulk() || transported.stack.m_41613_() == 1) ? transported.stack.m_41777_() : ItemHandlerHelper.copyStackWithSize((ItemStack)transported.stack, (int)1)), (FluidStack)fluid);
            if (required > 0 && required <= fluid.getAmount()) {
                FluidStack fluidForFilling = fluid.copy();
                fluidForFilling.setAmount(required);
                ItemStack filledResult = FillingBySpout.fillItem((Level)level, (int)required, (ItemStack)toProcess, (FluidStack)fluidForFilling);
                if (!filledResult.m_41619_()) {
                    PipetteBlockEntity pipette;
                    ItemStack nextSingle;
                    int nextRequired;
                    transported.clearFanProcessingData();
                    ArrayList<TransportedItemStack> outList = new ArrayList<TransportedItemStack>();
                    TransportedItemStack resultTransported = transported.copy();
                    resultTransported.stack = filledResult;
                    outList.add(resultTransported);
                    fluid.shrink(required);
                    processor.syncFluid(fluid);
                    if (bulk) {
                        TransportedItemStackHandlerBehaviour.TransportedResult result = TransportedItemStackHandlerBehaviour.TransportedResult.convertTo(outList);
                        handler.handleProcessingOnItem(transported, result);
                    } else {
                        TransportedItemStack leftover = null;
                        if (transported.stack.m_41613_() > 1) {
                            leftover = transported.copy();
                            leftover.stack = transported.stack.m_41777_();
                            leftover.stack.m_41774_(1);
                        }
                        TransportedItemStackHandlerBehaviour.TransportedResult result = TransportedItemStackHandlerBehaviour.TransportedResult.convertToAndLeaveHeld(outList, (TransportedItemStack)leftover);
                        handler.handleProcessingOnItem(transported, result);
                    }
                    if (!bulk && transported.stack.m_41613_() > 1 && (nextRequired = FillingBySpout.getRequiredAmountForItem((Level)level, (ItemStack)(nextSingle = ItemHandlerHelper.copyStackWithSize((ItemStack)transported.stack, (int)1)), (FluidStack)fluid)) > 0 && nextRequired <= fluid.getAmount() && processor instanceof PipetteBlockEntity) {
                        PipetteBlockEntity pipette2 = (PipetteBlockEntity)processor;
                        PipetteBlockEntity.SpeedMode mode = pipette2.getSpeedMode();
                        switch (mode) {
                            case HIGH: {
                                if (!pipette2.isContinuousProcessing()) {
                                    pipette2.startContinuousProcessing();
                                }
                                pipette2.incrementContinuousProcessing();
                                this.waitingForPipetteAnimation = false;
                                this.injectionReadySignalReceived = true;
                                this.particlesSent = false;
                                this.localProcessingTicks = 3;
                                return;
                            }
                            case LOW: {
                                if (!pipette2.isContinuousProcessing()) {
                                    pipette2.startContinuousProcessing();
                                }
                                pipette2.incrementContinuousProcessing();
                                this.waitingForPipetteAnimation = false;
                                this.injectionReadySignalReceived = false;
                                this.particlesSent = false;
                                this.localProcessingTicks = 8;
                                return;
                            }
                            case ULTRA_LOW: {
                                if (!pipette2.isContinuousProcessing()) {
                                    pipette2.startContinuousProcessing();
                                }
                                pipette2.incrementContinuousProcessing();
                                this.waitingForPipetteAnimation = true;
                                this.injectionReadySignalReceived = false;
                                this.particlesSent = false;
                                this.localProcessingTicks = -1;
                                return;
                            }
                        }
                    }
                    if (processor instanceof PipetteBlockEntity && (pipette = (PipetteBlockEntity)processor).isContinuousProcessing()) {
                        pipette.endContinuousProcessing();
                    }
                }
            }
        }

        private void resetState() {
            this.currentlyProcessing = null;
            this.localProcessingTicks = -1;
            this.waitingForFluid = false;
            this.waitingForPipetteAnimation = false;
            this.pipetteReady = false;
            this.particlesSent = false;
            this.injectionReadySignalReceived = false;
        }

        private boolean canProcessInBulk() {
            return false;
        }

        public boolean isValid() {
            return this.workstationRef.get() != null;
        }
    }
}

