/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.fluid.fluid.powdersnow;

import com.adonis.fluid.registry.CFFluid;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(modid="fluid")
public class PowderSnowBucketHandler {
    @SubscribeEvent
    public static void onAttachCapabilities(AttachCapabilitiesEvent<ItemStack> event) {
        ItemStack stack = (ItemStack)event.getObject();
        if (stack.m_41720_() == Items.f_151055_ || stack.m_41720_() == Items.f_42446_) {
            event.addCapability(new ResourceLocation("fluid", "powder_snow_handler"), (ICapabilityProvider)new Provider(stack));
        }
    }

    static class Provider
    implements ICapabilityProvider {
        private final LazyOptional<IFluidHandlerItem> holder = LazyOptional.of(() -> new Handler(stack));

        Provider(ItemStack stack) {
        }

        @NotNull
        public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, Direction side) {
            if (cap == ForgeCapabilities.FLUID_HANDLER_ITEM) {
                return this.holder.cast();
            }
            return LazyOptional.empty();
        }
    }

    static class Handler
    implements IFluidHandlerItem {
        private ItemStack container;

        Handler(ItemStack container) {
            this.container = container;
        }

        @NotNull
        public ItemStack getContainer() {
            return this.container;
        }

        public int getTanks() {
            return 1;
        }

        @NotNull
        public FluidStack getFluidInTank(int tank) {
            if (this.container.m_41720_() == Items.f_151055_) {
                return new FluidStack((Fluid)CFFluid.POWDER_SNOW.get(), 1000);
            }
            return FluidStack.EMPTY;
        }

        public int getTankCapacity(int tank) {
            return 1000;
        }

        public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
            return stack.getFluid() == CFFluid.POWDER_SNOW.get();
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            if (this.container.m_41720_() != Items.f_42446_ || this.container.m_41613_() != 1) {
                return 0;
            }
            if (resource.getFluid() != CFFluid.POWDER_SNOW.get() || resource.getAmount() < 1000) {
                return 0;
            }
            if (action.execute()) {
                this.container = new ItemStack((ItemLike)Items.f_151055_);
            }
            return 1000;
        }

        @NotNull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            return this.drain(resource.getAmount(), action);
        }

        @NotNull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            if (this.container.m_41720_() != Items.f_151055_ || maxDrain < 1000) {
                return FluidStack.EMPTY;
            }
            FluidStack result = new FluidStack((Fluid)CFFluid.POWDER_SNOW.get(), 1000);
            if (action.execute()) {
                this.container = new ItemStack((ItemLike)Items.f_42446_);
            }
            return result;
        }
    }
}

