/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.fluid.packet;

import com.adonis.fluid.mixin.accessor.ArmBlockEntityAccessor;
import com.simibubi.create.content.kinetics.mechanicalArm.ArmBlockEntity;
import com.simibubi.create.foundation.networking.SimplePacketBase;
import java.lang.reflect.Method;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class ArmInteractionPointSyncPacket
extends SimplePacketBase {
    private BlockPos pos;
    private ListTag pointsTag;

    public ArmInteractionPointSyncPacket(BlockPos pos, ListTag pointsTag) {
        this.pos = pos;
        this.pointsTag = pointsTag;
    }

    public ArmInteractionPointSyncPacket(FriendlyByteBuf buffer) {
        this.pos = buffer.m_130135_();
        CompoundTag nbt = buffer.m_130260_();
        this.pointsTag = nbt != null ? nbt.m_128437_("Points", 10) : new ListTag();
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.pos);
        CompoundTag nbt = new CompoundTag();
        nbt.m_128365_("Points", (Tag)this.pointsTag);
        buffer.m_130079_(nbt);
    }

    public boolean handle(NetworkEvent.Context context) {
        context.enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> this.handleClient()));
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void handleClient() {
        BlockEntity be;
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        if (world != null && (be = world.m_7702_(this.pos)) instanceof ArmBlockEntity) {
            ArmBlockEntity arm = (ArmBlockEntity)be;
            ArmBlockEntityAccessor accessor = (ArmBlockEntityAccessor)arm;
            accessor.getInputs().clear();
            accessor.getOutputs().clear();
            accessor.setInteractionPointTag(this.pointsTag);
            accessor.setUpdateInteractionPoints(true);
            accessor.setPhase(ArmBlockEntity.Phase.SEARCH_INPUTS);
            accessor.setChasedPointProgress(0.0f);
            accessor.setChasedPointIndex(-1);
            arm.m_6596_();
            try {
                Method initMethod = ArmBlockEntity.class.getDeclaredMethod("initInteractionPoints", new Class[0]);
                initMethod.setAccessible(true);
                initMethod.invoke((Object)arm, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

