/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.fluid.packet;

import com.simibubi.create.content.fluids.FluidFX;
import com.simibubi.create.foundation.networking.SimplePacketBase;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.RandomSource;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class CopperTapParticlePacket
extends SimplePacketBase {
    private final Vec3 startPos;
    private final Vec3 endPos;
    private final FluidStack fluid;

    public CopperTapParticlePacket(Vec3 startPos, Vec3 endPos, FluidStack fluid) {
        this.startPos = startPos;
        this.endPos = endPos;
        this.fluid = fluid;
    }

    public CopperTapParticlePacket(FriendlyByteBuf buffer) {
        this.startPos = new Vec3(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
        this.endPos = new Vec3(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
        this.fluid = FluidStack.readFromPacket((FriendlyByteBuf)buffer);
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeDouble(this.startPos.f_82479_);
        buffer.writeDouble(this.startPos.f_82480_);
        buffer.writeDouble(this.startPos.f_82481_);
        buffer.writeDouble(this.endPos.f_82479_);
        buffer.writeDouble(this.endPos.f_82480_);
        buffer.writeDouble(this.endPos.f_82481_);
        this.fluid.writeToPacket(buffer);
    }

    public boolean handle(NetworkEvent.Context context) {
        context.enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ClientHandler.spawnParticles(this.startPos, this.endPos, this.fluid)));
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    private static class ClientHandler {
        private ClientHandler() {
        }

        private static void spawnParticles(Vec3 startPos, Vec3 endPos, FluidStack fluid) {
            int i;
            Minecraft mc = Minecraft.m_91087_();
            ClientLevel level = mc.f_91073_;
            if (level == null || fluid.isEmpty()) {
                return;
            }
            ParticleOptions particle = FluidFX.getFluidParticle((FluidStack)fluid);
            Vec3 flowDirection = endPos.m_82546_(startPos);
            double distance = flowDirection.m_82553_();
            Vec3 normalizedFlow = flowDirection.m_82541_();
            int particleCount = (int)(distance * 8.0);
            for (i = 0; i < particleCount; ++i) {
                float progress = (float)i / (float)particleCount;
                Vec3 particlePos = startPos.m_82549_(normalizedFlow.m_82490_(distance * (double)progress));
                Vec3 offset = VecHelper.offsetRandomly((Vec3)Vec3.f_82478_, (RandomSource)level.f_46441_, (float)0.02f);
                particlePos = particlePos.m_82520_(offset.f_82479_, 0.0, offset.f_82481_);
                level.m_7106_(particle, particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, offset.f_82479_ * 0.1, -0.05, offset.f_82481_ * 0.1);
            }
            for (i = 0; i < 10; ++i) {
                Vec3 splash = VecHelper.offsetRandomly((Vec3)Vec3.f_82478_, (RandomSource)level.f_46441_, (float)0.15f);
                splash = new Vec3(splash.f_82479_, Math.abs(splash.f_82480_) * 0.3, splash.f_82481_);
                level.m_7106_(particle, endPos.f_82479_, endPos.f_82480_, endPos.f_82481_, splash.f_82479_, splash.f_82480_, splash.f_82481_);
            }
        }
    }
}

