/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.fluid.ponder;

import com.adonis.fluid.block.CopperTap.CopperTapBlock;
import com.adonis.fluid.registry.CFFluid;
import com.simibubi.create.content.fluids.FluidFX;
import com.simibubi.create.content.fluids.tank.FluidTankBlockEntity;
import com.simibubi.create.content.processing.basin.BasinBlockEntity;
import com.simibubi.create.foundation.ponder.CreateSceneBuilder;
import net.createmod.catnip.math.Pointing;
import net.createmod.catnip.math.VecHelper;
import net.createmod.ponder.api.PonderPalette;
import net.createmod.ponder.api.scene.SceneBuilder;
import net.createmod.ponder.api.scene.SceneBuildingUtil;
import net.createmod.ponder.api.scene.Selection;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeverBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class CopperTapScenes {
    public static void tap(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("copper_tap", "Using Copper Taps");
        scene.configureBasePlate(0, 0, 5);
        scene.showBasePlate();
        BlockPos tap1Pos = util.grid().at(4, 2, 2);
        BlockPos tank1BottomPos = util.grid().at(4, 1, 3);
        BlockPos tank1TopPos = util.grid().at(4, 2, 3);
        BlockPos cauldronPos = util.grid().at(4, 1, 2);
        BlockPos tap2Pos = util.grid().at(2, 2, 2);
        BlockPos tank2BottomPos = util.grid().at(2, 1, 3);
        BlockPos tank2TopPos = util.grid().at(2, 2, 3);
        BlockPos depotPos = util.grid().at(2, 1, 2);
        BlockPos copperCasing1Pos = util.grid().at(2, 3, 3);
        BlockPos leverPos = util.grid().at(2, 3, 2);
        BlockPos tap3Pos = util.grid().at(0, 2, 2);
        BlockPos basinPos = util.grid().at(0, 1, 2);
        BlockPos leavesPos = util.grid().at(0, 2, 3);
        BlockPos copperCasing2Pos = util.grid().at(0, 1, 3);
        Selection tap1Sel = util.select().position(tap1Pos);
        Selection tank1Sel = util.select().fromTo(4, 1, 3, 4, 2, 3);
        Selection cauldronSel = util.select().position(cauldronPos);
        Selection tap2Sel = util.select().position(tap2Pos);
        Selection tank2Sel = util.select().fromTo(2, 1, 3, 2, 2, 3);
        Selection depotSel = util.select().position(depotPos);
        Selection copperCasing1Sel = util.select().position(copperCasing1Pos);
        Selection leverSel = util.select().position(leverPos);
        Selection tap3Sel = util.select().position(tap3Pos);
        Selection basinSel = util.select().position(basinPos);
        Selection leavesSel = util.select().position(leavesPos);
        Selection copperCasing2Sel = util.select().position(copperCasing2Pos);
        scene.idle(20);
        scene.world().modifyBlockEntity(tank1BottomPos, FluidTankBlockEntity.class, be -> be.getTankInventory().fill(new FluidStack((Fluid)Fluids.f_76195_, 4000), IFluidHandler.FluidAction.EXECUTE));
        scene.world().modifyBlockEntity(tank2BottomPos, FluidTankBlockEntity.class, be -> be.getTankInventory().fill(CFFluid.getPowderSnowFluidStack(4000), IFluidHandler.FluidAction.EXECUTE));
        scene.world().showSection(tank1Sel, Direction.DOWN);
        scene.idle(5);
        scene.world().showSection(tap1Sel, Direction.DOWN);
        scene.idle(5);
        scene.world().showSection(cauldronSel, Direction.DOWN);
        scene.idle(10);
        scene.overlay().showText(100).attachKeyFrame().colored(PonderPalette.GREEN).text("Copper Taps draw fluid from containers behind them and can fill Cauldrons or Basins below").pointAt(util.vector().blockSurface(tap1Pos, Direction.WEST)).placeNearTarget();
        scene.idle(110);
        scene.world().modifyBlock(tap1Pos, s -> {
            if (s.m_60734_() instanceof CopperTapBlock) {
                return (BlockState)s.m_61124_((Property)BlockStateProperties.f_61446_, (Comparable)Boolean.valueOf(true));
            }
            return s;
        }, false);
        scene.idle(10);
        CopperTapScenes.simulateLavaCauldronFilling(scene, tap1Pos, cauldronPos, tank1BottomPos, util);
        scene.world().modifyBlock(tap1Pos, s -> {
            if (s.m_60734_() instanceof CopperTapBlock) {
                return (BlockState)s.m_61124_((Property)BlockStateProperties.f_61446_, (Comparable)Boolean.valueOf(false));
            }
            return s;
        }, false);
        scene.idle(20);
        scene.world().showSection(leavesSel, Direction.DOWN);
        scene.idle(5);
        scene.world().showSection(copperCasing2Sel, Direction.DOWN);
        scene.idle(5);
        scene.world().showSection(tap3Sel, Direction.DOWN);
        scene.idle(5);
        scene.world().showSection(basinSel, Direction.DOWN);
        scene.idle(10);
        scene.overlay().showText(100).attachKeyFrame().colored(PonderPalette.GREEN).text("Copper Taps can be attached to leaves and infinitely output water from waterlogged leaves").pointAt(util.vector().blockSurface(tap3Pos, Direction.WEST)).placeNearTarget();
        scene.idle(110);
        scene.world().modifyBlock(tap3Pos, s -> {
            if (s.m_60734_() instanceof CopperTapBlock) {
                return (BlockState)s.m_61124_((Property)BlockStateProperties.f_61446_, (Comparable)Boolean.valueOf(true));
            }
            return s;
        }, false);
        scene.idle(10);
        CopperTapScenes.simulateBasinFilling(scene, tap3Pos, basinPos, util);
        scene.world().modifyBlock(tap3Pos, s -> {
            if (s.m_60734_() instanceof CopperTapBlock) {
                return (BlockState)s.m_61124_((Property)BlockStateProperties.f_61446_, (Comparable)Boolean.valueOf(false));
            }
            return s;
        }, false);
        scene.idle(20);
        scene.world().showSection(tank2Sel, Direction.DOWN);
        scene.idle(5);
        scene.world().showSection(tap2Sel, Direction.DOWN);
        scene.idle(5);
        scene.world().showSection(depotSel, Direction.DOWN);
        scene.idle(10);
        scene.overlay().showText(100).attachKeyFrame().colored(PonderPalette.GREEN).text("Copper Taps can perform spout processing on Depots below").pointAt(util.vector().blockSurface(tap2Pos, Direction.WEST)).placeNearTarget();
        scene.idle(110);
        ItemStack emptyBucket = new ItemStack((ItemLike)Items.f_42446_);
        scene.overlay().showControls(util.vector().topOf(depotPos), Pointing.RIGHT, 30).rightClick().withItem(emptyBucket);
        scene.world().createItemOnBeltLike(depotPos, Direction.DOWN, emptyBucket);
        scene.idle(20);
        scene.world().modifyBlock(tap2Pos, s -> {
            if (s.m_60734_() instanceof CopperTapBlock) {
                return (BlockState)s.m_61124_((Property)BlockStateProperties.f_61446_, (Comparable)Boolean.valueOf(true));
            }
            return s;
        }, false);
        scene.idle(10);
        CopperTapScenes.simulateItemFilling(scene, tap2Pos, depotPos, tank2BottomPos, util);
        scene.world().modifyBlock(tap2Pos, s -> {
            if (s.m_60734_() instanceof CopperTapBlock) {
                return (BlockState)s.m_61124_((Property)BlockStateProperties.f_61446_, (Comparable)Boolean.valueOf(false));
            }
            return s;
        }, false);
        scene.idle(10);
        scene.world().showSection(copperCasing1Sel, Direction.DOWN);
        scene.idle(5);
        scene.world().showSection(leverSel, Direction.DOWN);
        scene.idle(10);
        scene.overlay().showText(80).attachKeyFrame().colored(PonderPalette.WHITE).text("Redstone signals can be used to control the tap's on/off state").pointAt(util.vector().blockSurface(leverPos, Direction.WEST)).placeNearTarget();
        scene.idle(90);
        scene.world().toggleRedstonePower(util.select().fromTo(2, 3, 2, 2, 2, 2));
        scene.effects().indicateRedstone(leverPos);
        scene.world().modifyBlock(leverPos, s -> (BlockState)s.m_61124_((Property)LeverBlock.f_54622_, (Comparable)Boolean.valueOf(true)), false);
        scene.world().modifyBlock(tap2Pos, s -> {
            if (s.m_60734_() instanceof CopperTapBlock) {
                return (BlockState)((BlockState)s.m_61124_((Property)BlockStateProperties.f_61448_, (Comparable)Boolean.valueOf(true))).m_61124_((Property)BlockStateProperties.f_61446_, (Comparable)Boolean.valueOf(true));
            }
            return s;
        }, false);
        for (int i = 0; i < 30; ++i) {
            Vec3 tapBottom = util.vector().centerOf(tap2Pos).m_82520_(0.0, -0.25, 0.0);
            Vec3 depotTop = util.vector().topOf(depotPos);
            CopperTapScenes.createFluidStream(scene, tapBottom, depotTop, CFFluid.getPowderSnowFluidStack(100));
            scene.idle(1);
        }
        scene.world().toggleRedstonePower(util.select().fromTo(2, 3, 2, 2, 2, 2));
        scene.effects().indicateRedstone(leverPos);
        scene.world().modifyBlock(leverPos, s -> (BlockState)s.m_61124_((Property)LeverBlock.f_54622_, (Comparable)Boolean.valueOf(false)), false);
        scene.world().modifyBlock(tap2Pos, s -> {
            if (s.m_60734_() instanceof CopperTapBlock) {
                return (BlockState)((BlockState)s.m_61124_((Property)BlockStateProperties.f_61448_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BlockStateProperties.f_61446_, (Comparable)Boolean.valueOf(false));
            }
            return s;
        }, false);
        scene.idle(20);
        scene.markAsFinished();
    }

    private static void simulateLavaCauldronFilling(CreateSceneBuilder scene, BlockPos tapPos, BlockPos cauldronPos, BlockPos tankPos, SceneBuildingUtil util) {
        FluidStack lava = new FluidStack((Fluid)Fluids.f_76195_, 1000);
        Vec3 tapBottom = util.vector().centerOf(tapPos).m_82520_(0.0, -0.25, 0.0);
        Vec3 cauldronTop = util.vector().topOf(cauldronPos);
        for (int i = 0; i < 60; ++i) {
            CopperTapScenes.createFluidStream(scene, tapBottom, cauldronTop, lava);
            scene.idle(1);
        }
        scene.world().setBlock(cauldronPos, Blocks.f_152477_.m_49966_(), false);
        scene.world().modifyBlockEntity(tankPos, FluidTankBlockEntity.class, be -> be.getTankInventory().drain(1000, IFluidHandler.FluidAction.EXECUTE));
        scene.idle(10);
    }

    private static void simulateBasinFilling(CreateSceneBuilder scene, BlockPos tapPos, BlockPos basinPos, SceneBuildingUtil util) {
        FluidStack water = new FluidStack((Fluid)Fluids.f_76193_, 1000);
        Vec3 tapBottom = util.vector().centerOf(tapPos).m_82520_(0.0, -0.25, 0.0);
        Vec3 basinTop = util.vector().topOf(basinPos);
        for (int i = 0; i < 60; ++i) {
            CopperTapScenes.createFluidStream(scene, tapBottom, basinTop, water);
            scene.idle(1);
        }
        scene.world().modifyBlockEntity(basinPos, BasinBlockEntity.class, be -> be.getCapability(ForgeCapabilities.FLUID_HANDLER).ifPresent(fh -> fh.fill(new FluidStack((Fluid)Fluids.f_76193_, 1000), IFluidHandler.FluidAction.EXECUTE)));
    }

    private static void simulateItemFilling(CreateSceneBuilder scene, BlockPos tapPos, BlockPos depotPos, BlockPos tankPos, SceneBuildingUtil util) {
        FluidStack powderSnow = CFFluid.getPowderSnowFluidStack(1000);
        Vec3 tapBottom = util.vector().centerOf(tapPos).m_82520_(0.0, -0.25, 0.0);
        Vec3 depotTop = util.vector().topOf(depotPos);
        for (int i = 0; i < 20; ++i) {
            CopperTapScenes.createFluidStream(scene, tapBottom, depotTop, powderSnow);
            scene.idle(1);
        }
        scene.world().removeItemsFromBelt(depotPos);
        ItemStack powderSnowBucket = new ItemStack((ItemLike)Items.f_151055_);
        scene.world().createItemOnBeltLike(depotPos, Direction.DOWN, powderSnowBucket);
        scene.world().modifyBlockEntity(tankPos, FluidTankBlockEntity.class, be -> be.getTankInventory().drain(1000, IFluidHandler.FluidAction.EXECUTE));
        scene.idle(10);
    }

    private static void createFluidStream(CreateSceneBuilder scene, Vec3 start, Vec3 end, FluidStack fluid) {
        ParticleOptions particle = FluidFX.getFluidParticle((FluidStack)fluid);
        Vec3 flow = end.m_82546_(start);
        for (float t = 0.0f; t <= 1.0f; t += 0.1f) {
            Vec3 pos = start.m_82549_(flow.m_82490_((double)t));
            Vec3 motion = flow.m_82541_().m_82490_(0.01);
            RandomSource random = RandomSource.m_216327_();
            pos = pos.m_82549_(VecHelper.offsetRandomly((Vec3)Vec3.f_82478_, (RandomSource)random, (float)0.005f));
            scene.effects().emitParticles(pos, scene.effects().simpleParticleEmitter(particle, motion), 0.5f, 1);
        }
        if (RandomSource.m_216327_().m_188501_() < 0.3f) {
            Vec3 splashMotion = Vec3.f_82478_.m_82549_(VecHelper.offsetRandomly((Vec3)Vec3.f_82478_, (RandomSource)RandomSource.m_216327_(), (float)0.02f));
            scene.effects().emitParticles(end, scene.effects().simpleParticleEmitter(particle, splashMotion), 0.2f, 1);
        }
    }
}

