/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.fluid.ponder;

import com.adonis.fluid.block.Pipette.PipetteBlockEntity;
import com.adonis.fluid.block.SmartFluidInterface.SmartFluidInterfaceBlockEntity;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllFluids;
import com.simibubi.create.AllItems;
import com.simibubi.create.content.fluids.FluidFX;
import com.simibubi.create.content.fluids.drain.ItemDrainBlockEntity;
import com.simibubi.create.content.fluids.tank.FluidTankBlockEntity;
import com.simibubi.create.content.kinetics.mixer.MechanicalMixerBlockEntity;
import com.simibubi.create.content.processing.basin.BasinBlockEntity;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.ponder.CreateSceneBuilder;
import net.createmod.catnip.math.Pointing;
import net.createmod.catnip.math.VecHelper;
import net.createmod.catnip.nbt.NBTHelper;
import net.createmod.ponder.api.PonderPalette;
import net.createmod.ponder.api.scene.SceneBuilder;
import net.createmod.ponder.api.scene.SceneBuildingUtil;
import net.createmod.ponder.api.scene.Selection;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.registries.ForgeRegistries;

public class PipetteScenes {
    public static void setup(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("mechanical_pipette", "Setting up Mechanical Pipette");
        scene.configureBasePlate(0, 0, 5);
        scene.showBasePlate();
        BlockPos pipettePos = util.grid().at(2, 1, 2);
        BlockPos basinPos = util.grid().at(0, 1, 1);
        BlockPos splashingPos = util.grid().at(4, 1, 1);
        BlockPos tankPos = util.grid().at(4, 1, 3);
        BlockPos fluidInterfacePos = util.grid().at(4, 2, 2);
        BlockPos blazeBurnerPos = util.grid().at(2, 1, 0);
        BlockPos beehivePos = util.grid().at(3, 3, 4);
        BlockPos beenestPos = util.grid().at(1, 2, 4);
        Selection pipetteSel = util.select().position(pipettePos);
        Selection basinSel = util.select().position(basinPos);
        Selection splashingSel = util.select().position(splashingPos);
        Selection tankSel = util.select().fromTo(4, 1, 3, 4, 3, 3);
        Selection fluidInterfaceSel = util.select().position(fluidInterfacePos);
        Selection blazeBurnerSel = util.select().position(blazeBurnerPos);
        Selection beehiveSel = util.select().position(beehivePos);
        Selection beenestSel = util.select().position(beenestPos);
        Selection beehivePillarSel = util.select().fromTo(3, 1, 4, 3, 3, 4);
        Selection beenestPillarSel = util.select().fromTo(1, 1, 4, 1, 2, 4);
        Selection gearsSel = util.select().fromTo(2, 1, 5, 2, 1, 3).add(util.select().position(2, 0, 5));
        scene.world().setKineticSpeed(pipetteSel, 0.0f);
        scene.world().setKineticSpeed(gearsSel, 0.0f);
        scene.idle(20);
        scene.world().showSection(pipetteSel, Direction.DOWN);
        scene.idle(10);
        scene.world().showSection(basinSel, Direction.DOWN);
        scene.idle(5);
        scene.world().showSection(splashingSel, Direction.DOWN);
        scene.idle(15);
        scene.overlay().showOutlineWithText(splashingSel, 40).colored(PonderPalette.INPUT).text("\u8f93\u5165").pointAt(util.vector().blockSurface(splashingPos, Direction.WEST)).placeNearTarget();
        scene.idle(5);
        scene.overlay().showOutlineWithText(basinSel, 40).colored(PonderPalette.OUTPUT).text("\u8f93\u51fa").pointAt(util.vector().blockSurface(basinPos, Direction.WEST)).placeNearTarget();
        scene.idle(40);
        scene.overlay().showText(80).attachKeyFrame().colored(PonderPalette.GREEN).text("\u52a8\u529b\u79fb\u6db2\u5668\u4e0e\u52a8\u529b\u81c2\u7684\u5de5\u4f5c\u65b9\u5f0f\u522b\u65e0\u4e8c\u81f4\uff0c\u4f46\u662f\u6b63\u5982\u5176\u540d\uff0c\u5b83\u4e13\u6ce8\u4e8e\u4e0e\u6d41\u4f53\u5bb9\u5668\u4ea4\u4e92").pointAt(util.vector().blockSurface(pipettePos, Direction.WEST)).placeNearTarget();
        scene.idle(90);
        scene.world().showSection(gearsSel, Direction.DOWN);
        scene.idle(10);
        scene.world().modifyBlockEntity(splashingPos, ItemDrainBlockEntity.class, be -> {
            SmartFluidTankBehaviour tankBehaviour = (SmartFluidTankBehaviour)be.getBehaviour(SmartFluidTankBehaviour.TYPE);
            if (tankBehaviour != null) {
                tankBehaviour.allowInsertion();
                be.getCapability(ForgeCapabilities.FLUID_HANDLER).ifPresent(fh -> fh.fill(new FluidStack((Fluid)Fluids.f_76193_, 1000), IFluidHandler.FluidAction.EXECUTE));
                tankBehaviour.forbidInsertion();
            }
        });
        scene.idle(5);
        scene.world().setKineticSpeed(pipetteSel, -48.0f);
        scene.world().setKineticSpeed(gearsSel, -48.0f);
        scene.world().multiplyKineticSpeed(util.select().position(2, 1, 5), -1.0f);
        scene.idle(20);
        PipetteScenes.instructPipette(scene, pipettePos, PipetteBlockEntity.Phase.MOVE_TO_INPUT, FluidStack.EMPTY, 0);
        scene.idle(24);
        scene.world().modifyBlockEntity(splashingPos, ItemDrainBlockEntity.class, be -> be.getCapability(ForgeCapabilities.FLUID_HANDLER).ifPresent(fh -> fh.drain(1000, IFluidHandler.FluidAction.EXECUTE)));
        scene.idle(10);
        PipetteScenes.instructPipette(scene, pipettePos, PipetteBlockEntity.Phase.SEARCH_OUTPUTS, new FluidStack((Fluid)Fluids.f_76193_, 1000), -1);
        scene.idle(20);
        PipetteScenes.instructPipette(scene, pipettePos, PipetteBlockEntity.Phase.MOVE_TO_OUTPUT, new FluidStack((Fluid)Fluids.f_76193_, 1000), 0);
        scene.idle(24);
        scene.world().modifyBlockEntity(basinPos, BasinBlockEntity.class, be -> be.getCapability(ForgeCapabilities.FLUID_HANDLER).ifPresent(fh -> fh.fill(new FluidStack((Fluid)Fluids.f_76193_, 1000), IFluidHandler.FluidAction.EXECUTE)));
        scene.idle(10);
        PipetteScenes.instructPipette(scene, pipettePos, PipetteBlockEntity.Phase.SEARCH_INPUTS, FluidStack.EMPTY, -1);
        scene.idle(20);
        scene.world().showSection(tankSel, Direction.DOWN);
        scene.idle(5);
        scene.world().showSection(fluidInterfaceSel, Direction.DOWN);
        scene.idle(10);
        scene.overlay().showOutlineWithText(fluidInterfaceSel, 80).attachKeyFrame().colored(PonderPalette.OUTPUT).text("\u5bf9\u4e8e\u67d0\u4e9b\u65e0\u6cd5\u76f4\u63a5\u4ea4\u4e92\u7684\u6d41\u4f53\u5bb9\u5668\uff0c\u6d41\u4f53\u63a5\u53e3\u53ef\u4ee5\u89e3\u51b3\u6b64\u95ee\u9898").pointAt(util.vector().blockSurface(fluidInterfacePos, Direction.NORTH)).placeNearTarget();
        scene.idle(90);
        scene.world().showSection(blazeBurnerSel, Direction.DOWN);
        scene.idle(5);
        scene.world().showSection(beehivePillarSel, Direction.DOWN);
        scene.idle(5);
        scene.world().showSection(beenestPillarSel, Direction.DOWN);
        scene.idle(10);
        scene.overlay().showOutlineWithText(blazeBurnerSel.add(beehiveSel).add(beenestSel), 100).attachKeyFrame().colored(PonderPalette.GREEN).text("\u9664\u4e86\u5e38\u89c4\u7684\u6d41\u4f53\u5bb9\u5668\uff0c\u52a8\u529b\u79fb\u6db2\u5668\u8fd8\u652f\u6301\u4e0e\u66f4\u591a\u6709\u8da3\u7684\u65b9\u5757\u4ea4\u4e92\uff0c\u4e5f\u8bb8\u5b83\u80fd\u66f4\u597d\u5730\u5e2e\u52a9\u4f60\u65bd\u5c55\u521b\u610f").pointAt(util.vector().blockSurface(beehivePos, Direction.WEST)).placeNearTarget();
        scene.idle(110);
        PipetteScenes.instructPipette(scene, pipettePos, PipetteBlockEntity.Phase.MOVE_TO_INPUT, FluidStack.EMPTY, 1);
        scene.idle(24);
        scene.world().modifyBlockEntity(tankPos, FluidTankBlockEntity.class, be -> be.getTankInventory().drain(1000, IFluidHandler.FluidAction.EXECUTE));
        scene.idle(10);
        PipetteScenes.instructPipette(scene, pipettePos, PipetteBlockEntity.Phase.SEARCH_OUTPUTS, new FluidStack((Fluid)Fluids.f_76195_, 1000), -1);
        scene.idle(20);
        PipetteScenes.instructPipette(scene, pipettePos, PipetteBlockEntity.Phase.MOVE_TO_OUTPUT, new FluidStack((Fluid)Fluids.f_76195_, 1000), 1);
        scene.idle(24);
        scene.world().modifyBlock(blazeBurnerPos, s -> {
            if (AllBlocks.BLAZE_BURNER.has(s)) {
                return (BlockState)s.m_61124_((Property)BlazeBurnerBlock.HEAT_LEVEL, (Comparable)BlazeBurnerBlock.HeatLevel.KINDLED);
            }
            return s;
        }, false);
        scene.idle(10);
        PipetteScenes.instructPipette(scene, pipettePos, PipetteBlockEntity.Phase.SEARCH_INPUTS, FluidStack.EMPTY, -1);
        scene.idle(30);
        Vec3 pipetteTop = util.vector().blockSurface(pipettePos, Direction.UP).m_82520_(0.0, 0.5, 0.0);
        scene.overlay().showText(100).attachKeyFrame().colored(PonderPalette.GREEN).text("\u8fd9\u662f\u52a8\u529b\u79fb\u6db2\u5668\u7684\u5b58\u91cf\u6307\u793a\u5668\uff0c\u901a\u8fc7\u5b83\u6765\u4e86\u89e3\u5f53\u524d\u52a8\u529b\u79fb\u6db2\u5668\u6240\u6301\u6709\u7684\u6d41\u4f53\u91cf\u3002\u52a8\u529b\u79fb\u6db2\u5668\u7684\u6700\u5927\u6d41\u4f53\u5bb9\u91cf\u4e3a1000mb").pointAt(pipetteTop).placeNearTarget();
        scene.idle(110);
        scene.markAsFinished();
    }

    public static void filtering(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("mechanical_pipette_filter", "Filtering Fluids with Smart Fluid Interface");
        scene.configureBasePlate(0, 0, 5);
        scene.showBasePlate();
        BlockPos pipettePos = util.grid().at(2, 1, 2);
        BlockPos basinPos = util.grid().at(4, 2, 1);
        BlockPos blazeBurnerPos = util.grid().at(4, 1, 1);
        BlockPos smartInterfacePos = util.grid().at(3, 2, 1);
        BlockPos tankPos = util.grid().at(0, 1, 3);
        BlockPos fluidInterfacePos = util.grid().at(0, 2, 2);
        BlockPos mixerPos = util.grid().at(4, 4, 1);
        BlockPos mixerShaftPos = util.grid().at(5, 3, 1);
        BlockPos mixerGearPos = util.grid().at(5, 4, 1);
        BlockPos lowerGearPos = util.grid().at(5, 0, 1);
        Selection pipetteSel = util.select().position(pipettePos);
        Selection basinSel = util.select().position(basinPos);
        Selection blazeBurnerSel = util.select().position(blazeBurnerPos);
        Selection smartInterfaceSel = util.select().position(smartInterfacePos);
        Selection tankSel = util.select().fromTo(0, 1, 3, 0, 3, 3);
        Selection fluidInterfaceSel = util.select().position(fluidInterfacePos);
        Selection mixerSel = util.select().position(mixerPos);
        Selection mixerShaftSel = util.select().fromTo(5, 1, 1, 5, 3, 1);
        Selection mixerGearSel = util.select().position(mixerGearPos);
        Selection lowerGearSel = util.select().position(lowerGearPos);
        Selection gearsSel = util.select().fromTo(2, 1, 5, 2, 1, 3).add(util.select().position(2, 0, 5));
        scene.world().setKineticSpeed(pipetteSel, 0.0f);
        scene.world().setKineticSpeed(gearsSel, 0.0f);
        scene.world().setKineticSpeed(mixerSel, 0.0f);
        scene.world().setKineticSpeed(mixerGearSel, 0.0f);
        scene.idle(20);
        scene.world().showSection(pipetteSel, Direction.DOWN);
        scene.idle(10);
        scene.world().showSection(blazeBurnerSel, Direction.DOWN);
        scene.idle(5);
        scene.world().modifyBlock(blazeBurnerPos, s -> {
            if (AllBlocks.BLAZE_BURNER.has(s)) {
                return (BlockState)s.m_61124_((Property)BlazeBurnerBlock.HEAT_LEVEL, (Comparable)BlazeBurnerBlock.HeatLevel.KINDLED);
            }
            return s;
        }, false);
        scene.idle(5);
        scene.world().showSection(basinSel, Direction.DOWN);
        scene.idle(10);
        scene.world().modifyBlockEntity(basinPos, BasinBlockEntity.class, be -> be.getCapability(ForgeCapabilities.FLUID_HANDLER).ifPresent(fh -> {
            FluidStack milk = new FluidStack((Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation("minecraft", "milk")), 1000);
            if (milk.getFluid() == Fluids.f_76191_) {
                milk = new FluidStack((Fluid)Fluids.f_76193_, 1000);
            }
            fh.fill(milk, IFluidHandler.FluidAction.EXECUTE);
        }));
        scene.overlay().showText(80).attachKeyFrame().text("\u6709\u65f6\uff0c\u4f60\u4f1a\u60f3\u7740\u5229\u7528\u67d0\u79cd\u8fc7\u6ee4\u9650\u5236\u52a8\u529b\u79fb\u6db2\u5668\u7684\u76ee\u6807").pointAt(util.vector().blockSurface(basinPos, Direction.WEST)).placeNearTarget();
        scene.idle(90);
        ItemStack sugar = new ItemStack((ItemLike)Items.f_42501_);
        ItemStack cocoaBeans = new ItemStack((ItemLike)Items.f_42533_);
        scene.overlay().showControls(util.vector().topOf(basinPos), Pointing.LEFT, 30).withItem(sugar);
        scene.world().modifyBlockEntity(basinPos, BasinBlockEntity.class, be -> be.getInputInventory().insertItem(0, sugar.m_41777_(), false));
        scene.overlay().showControls(util.vector().topOf(basinPos), Pointing.RIGHT, 30).withItem(cocoaBeans);
        scene.world().modifyBlockEntity(basinPos, BasinBlockEntity.class, be -> be.getInputInventory().insertItem(1, cocoaBeans.m_41777_(), false));
        scene.idle(30);
        scene.world().showSection(lowerGearSel, Direction.UP);
        scene.idle(5);
        scene.world().showSection(mixerShaftSel, Direction.DOWN);
        scene.idle(5);
        scene.world().showSection(mixerSel, Direction.DOWN);
        scene.idle(5);
        scene.world().showSection(mixerGearSel, Direction.DOWN);
        scene.idle(10);
        scene.world().setKineticSpeed(lowerGearSel, 32.0f);
        scene.world().setKineticSpeed(mixerShaftSel, 32.0f);
        scene.world().setKineticSpeed(mixerSel, 32.0f);
        scene.world().setKineticSpeed(mixerGearSel, 32.0f);
        scene.world().modifyBlockEntity(mixerPos, MechanicalMixerBlockEntity.class, mixer -> mixer.startProcessingBasin());
        scene.idle(40);
        Fluid chocolateFluid = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation("create", "chocolate"));
        if (chocolateFluid == null || chocolateFluid == Fluids.f_76191_) {
            chocolateFluid = Fluids.f_76193_;
        }
        Fluid finalChocolateFluid = chocolateFluid;
        scene.world().modifyBlockEntity(basinPos, BasinBlockEntity.class, be -> {
            be.getInputInventory().extractItem(0, 64, false);
            be.getInputInventory().extractItem(1, 64, false);
            be.getCapability(ForgeCapabilities.FLUID_HANDLER).ifPresent(fh -> {
                fh.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.EXECUTE);
                fh.fill(new FluidStack(finalChocolateFluid, 1000), IFluidHandler.FluidAction.EXECUTE);
            });
        });
        scene.idle(20);
        scene.world().showSection(smartInterfaceSel, Direction.DOWN);
        scene.idle(20);
        scene.overlay().showOutlineWithText(smartInterfaceSel, 80).attachKeyFrame().colored(PonderPalette.GREEN).text("\u667a\u80fd\u6d41\u4f53\u63a5\u53e3\u56e0\u4e3a\u8fd9\u79cd\u9700\u6c42\u800c\u5b58\u5728").pointAt(util.vector().blockSurface(smartInterfacePos, Direction.WEST)).placeNearTarget();
        scene.idle(90);
        Vec3 filterSlot = util.vector().of(3.6, 2.5, 1.5);
        scene.overlay().showFilterSlotInput(filterSlot, Direction.WEST, 80);
        scene.idle(10);
        scene.overlay().showText(80).attachKeyFrame().colored(PonderPalette.WHITE).text("\u667a\u80fd\u6d41\u4f53\u63a5\u53e3\u7684\u8fc7\u6ee4\u69fd\u53ef\u4ee5\u5e94\u7528\u81f3\u52a8\u529b\u79fb\u6db2\u5668\u4e0a").pointAt(filterSlot).placeNearTarget();
        scene.idle(90);
        ItemStack chocolateBucket = ((ForgeFlowingFluid.Flowing)AllFluids.CHOCOLATE.get()).getFluidType().getBucket(new FluidStack(finalChocolateFluid, 1000));
        scene.overlay().showControls(filterSlot, Pointing.LEFT, 30).rightClick().withItem(chocolateBucket);
        scene.idle(7);
        scene.world().setFilterData(util.select().position(smartInterfacePos), SmartFluidInterfaceBlockEntity.class, chocolateBucket);
        scene.idle(20);
        scene.world().showSection(tankSel, Direction.DOWN);
        scene.idle(5);
        scene.world().showSection(fluidInterfaceSel, Direction.DOWN);
        scene.idle(10);
        scene.world().showSection(gearsSel, Direction.DOWN);
        scene.idle(10);
        scene.world().setKineticSpeed(pipetteSel, -48.0f);
        scene.world().setKineticSpeed(gearsSel, -48.0f);
        scene.world().multiplyKineticSpeed(util.select().position(2, 1, 5), -1.0f);
        scene.idle(20);
        PipetteScenes.instructPipette(scene, pipettePos, PipetteBlockEntity.Phase.MOVE_TO_INPUT, FluidStack.EMPTY, 0);
        scene.idle(24);
        scene.world().modifyBlockEntity(basinPos, BasinBlockEntity.class, be -> be.getCapability(ForgeCapabilities.FLUID_HANDLER).ifPresent(fh -> fh.drain(1000, IFluidHandler.FluidAction.EXECUTE)));
        scene.idle(10);
        FluidStack chocolateStack = new FluidStack(finalChocolateFluid, 1000);
        PipetteScenes.instructPipette(scene, pipettePos, PipetteBlockEntity.Phase.SEARCH_OUTPUTS, chocolateStack, -1);
        scene.idle(20);
        PipetteScenes.instructPipette(scene, pipettePos, PipetteBlockEntity.Phase.MOVE_TO_OUTPUT, chocolateStack, 0);
        scene.idle(24);
        scene.world().modifyBlockEntity(tankPos, FluidTankBlockEntity.class, be -> be.getTankInventory().fill(chocolateStack, IFluidHandler.FluidAction.EXECUTE));
        scene.idle(10);
        PipetteScenes.instructPipette(scene, pipettePos, PipetteBlockEntity.Phase.SEARCH_INPUTS, FluidStack.EMPTY, -1);
        scene.idle(20);
        scene.markAsFinished();
    }

    public static void filling(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("mechanical_pipette_fill", "Spout Processing with Mechanical Pipette");
        scene.configureBasePlate(0, 0, 5);
        scene.showBasePlate();
        BlockPos pipettePos = util.grid().at(3, 1, 2);
        BlockPos milkTankPos = util.grid().at(2, 1, 4);
        BlockPos honeyTankPos = util.grid().at(0, 1, 3);
        BlockPos milkInterfacePos = util.grid().at(2, 2, 3);
        BlockPos honeyInterfacePos = util.grid().at(0, 2, 2);
        BlockPos depotPos = util.grid().at(1, 1, 1);
        BlockPos beltStartPos = util.grid().at(2, 1, 0);
        BlockPos beltEndPos = util.grid().at(4, 1, 0);
        BlockPos funnelPos = util.grid().at(4, 2, 0);
        BlockPos casingPos = util.grid().at(5, 1, 0);
        BlockPos chestPos = util.grid().at(5, 2, 0);
        BlockPos plusPos = util.grid().at(4, 1, 1);
        BlockPos bigplusPos = util.grid().at(5, 2, 1);
        Selection pipetteSel = util.select().position(pipettePos);
        Selection milkTankSel = util.select().fromTo(2, 1, 4, 2, 3, 4);
        Selection honeyTankSel = util.select().fromTo(0, 1, 3, 0, 3, 3);
        Selection milkInterfaceSel = util.select().position(milkInterfacePos);
        Selection honeyInterfaceSel = util.select().position(honeyInterfacePos);
        Selection depotSel = util.select().position(depotPos);
        Selection beltSel = util.select().fromTo(2, 1, 0, 4, 1, 0);
        Selection funnelSel = util.select().position(funnelPos);
        Selection casingSel = util.select().position(casingPos);
        Selection plusSel = util.select().position(plusPos);
        Selection bigplusSel = util.select().position(bigplusPos);
        Selection chestSel = util.select().position(chestPos);
        Selection gearsSel = util.select().fromTo(3, 1, 3, 3, 1, 5).add(util.select().position(3, 0, 5));
        scene.world().modifyBlockEntity(milkTankPos, FluidTankBlockEntity.class, be -> {
            ResourceLocation milkId = new ResourceLocation("minecraft", "milk");
            Fluid milk = (Fluid)ForgeRegistries.FLUIDS.getValue(milkId);
            if (milk != null && milk != Fluids.f_76191_) {
                be.getTankInventory().fill(new FluidStack(milk, 4000), IFluidHandler.FluidAction.EXECUTE);
            }
        });
        scene.world().modifyBlockEntity(honeyTankPos, FluidTankBlockEntity.class, be -> {
            Fluid honey = (Fluid)AllFluids.HONEY.get();
            be.getTankInventory().fill(new FluidStack(honey, 4000), IFluidHandler.FluidAction.EXECUTE);
        });
        scene.idle(20);
        scene.world().showSection(pipetteSel, Direction.DOWN);
        scene.idle(5);
        scene.world().showSection(milkTankSel, Direction.DOWN);
        scene.idle(5);
        scene.world().showSection(honeyTankSel, Direction.DOWN);
        scene.idle(5);
        scene.world().showSection(milkInterfaceSel, Direction.DOWN);
        scene.idle(5);
        scene.world().showSection(honeyInterfaceSel, Direction.DOWN);
        scene.idle(5);
        scene.world().showSection(depotSel, Direction.DOWN);
        scene.idle(5);
        scene.world().showSection(beltSel, Direction.DOWN);
        scene.idle(5);
        scene.world().showSection(plusSel, Direction.DOWN);
        scene.idle(5);
        scene.world().showSection(bigplusSel, Direction.DOWN);
        scene.idle(5);
        scene.world().showSection(funnelSel, Direction.DOWN);
        scene.idle(5);
        scene.world().showSection(casingSel, Direction.DOWN);
        scene.idle(5);
        scene.world().showSection(chestSel, Direction.DOWN);
        scene.idle(10);
        scene.overlay().showOutlineWithText(milkInterfaceSel.add(honeyInterfaceSel), 40).colored(PonderPalette.INPUT).text("\u8f93\u5165").pointAt(util.vector().blockSurface(milkInterfacePos, Direction.WEST)).placeNearTarget();
        scene.idle(5);
        scene.overlay().showOutlineWithText(depotSel.add(beltSel), 40).colored(PonderPalette.OUTPUT).text("\u8f93\u51fa").pointAt(util.vector().blockSurface(depotPos, Direction.WEST)).placeNearTarget();
        scene.idle(40);
        scene.overlay().showText(80).attachKeyFrame().colored(PonderPalette.GREEN).text("\u9664\u4e86\u5904\u7406\u7269\u6d41\uff0c\u52a8\u529b\u79fb\u6db2\u5668\u4e5f\u53ef\u4ee5\u5e94\u7528\u4e8e\u52a0\u5de5\u573a\u666f").pointAt(util.vector().blockSurface(pipettePos, Direction.WEST)).placeNearTarget();
        scene.idle(90);
        scene.overlay().showOutlineWithText(depotSel.add(beltSel), 100).attachKeyFrame().colored(PonderPalette.WHITE).text("\u5f53\u9009\u5b9a\u7f6e\u7269\u53f0\u6216\u4f20\u9001\u5e26\u4f5c\u4e3a\u8f93\u51fa\u7aef\u65f6\uff0c\u52a8\u529b\u79fb\u6db2\u5668\u4f1a\u65f6\u523b\u7559\u610f\u4e0a\u65b9\u662f\u5426\u6709\u53ef\u4ee5\u6267\u884c\u6ce8\u6db2\u52a0\u5de5\u7684\u539f\u6599").pointAt(util.vector().blockSurface(depotPos, Direction.UP)).placeNearTarget();
        scene.idle(110);
        ItemStack bread = new ItemStack((ItemLike)Items.f_42406_);
        scene.world().createItemOnBeltLike(depotPos, Direction.DOWN, bread);
        scene.overlay().showControls(util.vector().topOf(depotPos), Pointing.DOWN, 30).withItem(bread);
        scene.world().modifyBlockEntity(depotPos, BasinBlockEntity.class, be -> be.getInputInventory().insertItem(0, bread.m_41777_(), false));
        scene.idle(20);
        scene.overlay().showText(100).attachKeyFrame().colored(PonderPalette.GREEN).text("\u52a8\u529b\u79fb\u6db2\u5668\u4f1a\u4ece\u6240\u6709\u7684\u8f93\u5165\u7aef\u4e2d\u5bfb\u627e\u6240\u9700\u7684\u6d41\u4f53\u539f\u6599\uff0c\u7136\u540e\u6267\u884c\u6ce8\u6db2\u52a0\u5de5").pointAt(util.vector().blockSurface(honeyTankPos.m_7494_(), Direction.WEST)).placeNearTarget();
        scene.idle(110);
        scene.world().setKineticSpeed(pipetteSel, -48.0f);
        scene.world().setKineticSpeed(gearsSel, -48.0f);
        scene.world().showSection(gearsSel, Direction.DOWN);
        scene.world().multiplyKineticSpeed(util.select().position(3, 1, 5), -1.0f);
        scene.world().setKineticSpeed(beltSel, 16.0f);
        scene.world().setKineticSpeed(plusSel, 16.0f);
        scene.world().setKineticSpeed(bigplusSel, -16.0f);
        scene.world().setKineticSpeed(funnelSel, 16.0f);
        scene.idle(10);
        PipetteScenes.instructPipette(scene, pipettePos, PipetteBlockEntity.Phase.MOVE_TO_INPUT, FluidStack.EMPTY, 0);
        scene.idle(24);
        ResourceLocation milkId = new ResourceLocation("minecraft", "milk");
        Fluid milk = (Fluid)ForgeRegistries.FLUIDS.getValue(milkId);
        FluidStack milkStack = milk != null && milk != Fluids.f_76191_ ? new FluidStack(milk, 250) : new FluidStack((Fluid)Fluids.f_76193_, 250);
        scene.world().modifyBlockEntity(milkTankPos, FluidTankBlockEntity.class, be -> be.getTankInventory().drain(250, IFluidHandler.FluidAction.EXECUTE));
        scene.idle(10);
        PipetteScenes.instructPipette(scene, pipettePos, PipetteBlockEntity.Phase.SEARCH_OUTPUTS, milkStack, -1);
        scene.idle(20);
        PipetteScenes.instructPipette(scene, pipettePos, PipetteBlockEntity.Phase.MOVE_TO_OUTPUT, milkStack, 0);
        scene.idle(24);
        Vec3 depotTop = util.vector().topOf(depotPos);
        ParticleOptions fluidParticle = FluidFX.getFluidParticle((FluidStack)milkStack);
        RandomSource random = RandomSource.m_216327_();
        for (int i = 0; i < 10; ++i) {
            scene.effects().emitParticles(depotTop.m_82520_(0.0, 0.0625, 0.0), scene.effects().simpleParticleEmitter(fluidParticle, VecHelper.offsetRandomly((Vec3)Vec3.f_82478_, (RandomSource)random, (float)0.1f)), 1.0f, 1);
        }
        ItemStack sweetRoll = AllItems.SWEET_ROLL.asStack();
        scene.world().removeItemsFromBelt(depotPos);
        scene.world().createItemOnBeltLike(depotPos, Direction.DOWN, sweetRoll);
        scene.idle(10);
        PipetteScenes.instructPipette(scene, pipettePos, PipetteBlockEntity.Phase.SEARCH_INPUTS, FluidStack.EMPTY, -1);
        scene.idle(30);
        scene.markAsFinished();
    }

    private static void instructPipette(CreateSceneBuilder scene, BlockPos pipettePos, PipetteBlockEntity.Phase phase, FluidStack heldFluid, int targetedPoint) {
        scene.world().modifyBlockEntityNBT(scene.getScene().getSceneBuildingUtil().select().position(pipettePos), PipetteBlockEntity.class, compound -> {
            NBTHelper.writeEnum((CompoundTag)compound, (String)"Phase", (Enum)phase);
            compound.m_128365_("HeldFluid", (Tag)heldFluid.writeToNBT(new CompoundTag()));
            compound.m_128405_("TargetPointIndex", targetedPoint);
            compound.m_128350_("MovementProgress", 0.0f);
        });
    }
}

