/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.fluid.block.CopperTap;

import com.adonis.fluid.block.CopperTap.CopperTapBlock;
import com.adonis.fluid.block.CopperTap.CopperTapBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.simibubi.create.content.fluids.FluidFX;
import com.simibubi.create.foundation.blockEntity.renderer.SafeBlockEntityRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;

public class CopperTapRenderer
extends SafeBlockEntityRenderer<CopperTapBlockEntity> {
    public CopperTapRenderer(BlockEntityRendererProvider.Context context) {
    }

    protected void renderSafe(CopperTapBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        if (!be.hasFluidToRender()) {
            return;
        }
        FluidStack fluid = be.getRenderingFluid();
        if (fluid.isEmpty()) {
            return;
        }
        BlockState state = be.m_58900_();
        boolean isOpen = (Boolean)state.m_61143_((Property)BlockStateProperties.f_61446_);
        if (!isOpen) {
            return;
        }
        Direction facing = (Direction)state.m_61143_((Property)CopperTapBlock.FACING);
        ms.m_85836_();
        switch (facing) {
            case SOUTH: {
                ms.m_85837_(0.5, 0.0, 0.5);
                ms.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                ms.m_85837_(-0.5, 0.0, -0.5);
                break;
            }
            case WEST: {
                ms.m_85837_(0.5, 0.0, 0.5);
                ms.m_252781_(Axis.f_252436_.m_252977_(270.0f));
                ms.m_85837_(-0.5, 0.0, -0.5);
                break;
            }
            case EAST: {
                ms.m_85837_(0.5, 0.0, 0.5);
                ms.m_252781_(Axis.f_252436_.m_252977_(90.0f));
                ms.m_85837_(-0.5, 0.0, -0.5);
            }
        }
        this.renderFluidStream(be, fluid, ms, buffer, light, partialTicks);
        if (be.isProcessing()) {
            this.renderSplashEffect(be, fluid, ms, buffer, light, partialTicks);
        }
        ms.m_85849_();
    }

    private void renderSplashEffect(CopperTapBlockEntity be, FluidStack fluid, PoseStack ms, MultiBufferSource buffer, int light, float partialTicks) {
        int processingTicks = be.getProcessingTicks();
        if (processingTicks <= 0) {
            return;
        }
        float processingProgress = ((float)processingTicks - partialTicks) / 20.0f;
        float splash = 1.0f - processingProgress;
        if (splash < 0.3f) {
            float splashRadius = splash * 0.5f;
            this.renderFluidBox(fluid, 0.5f - splashRadius, -0.96875f, 0.5f - splashRadius, 0.5f + splashRadius, -0.9375f, 0.5f + splashRadius, buffer, ms, light, false, true);
        }
    }

    private void renderFluidStream(CopperTapBlockEntity be, FluidStack fluid, PoseStack ms, MultiBufferSource buffer, int light, float partialTicks) {
        float startX = 0.375f;
        float endX = 0.625f;
        float startZ = 0.375f;
        float endZ = 0.625f;
        float startY = 0.25f;
        float endY = -0.5f;
        if (be.isProcessing()) {
            float progress = (float)be.getProcessingTicks() / 20.0f;
            float scale = 0.75f + 0.25f * Mth.m_14031_((float)(progress * 3.14159f));
            float center = 0.5f;
            startX = center - (center - startX) * scale;
            endX = center + (endX - center) * scale;
            startZ = center - (center - startZ) * scale;
            endZ = center + (endZ - center) * scale;
        }
        this.renderFluidBox(fluid, startX, endY, startZ, endX, startY, endZ, buffer, ms, light, false, true);
    }

    private void renderFillingEffect(CopperTapBlockEntity be, FluidStack fluid, PoseStack ms, MultiBufferSource buffer, int light, float partialTicks) {
        int processingTicks = be.getProcessingTicks();
        if (processingTicks <= 0) {
            return;
        }
        float processingProgress = ((float)processingTicks - partialTicks) / 20.0f;
        if (processingProgress > 0.0f) {
            float flowScale = 0.5f + 0.5f * Mth.m_14031_((float)(processingProgress * 3.14159f));
            float startX = 0.5f - 0.0625f * flowScale;
            float endX = 0.5f + 0.0625f * flowScale;
            float startZ = 0.5f - 0.0625f * flowScale;
            float endZ = 0.5f + 0.0625f * flowScale;
            float startY = 0.1875f;
            float endY = -0.75f;
            this.renderFluidBox(fluid, startX, endY, startZ, endX, startY, endZ, buffer, ms, light, false, true);
            float splash = 1.0f - processingProgress;
            if (splash < 0.3f) {
                float splashRadius = splash * 0.5f;
                this.renderFluidBox(fluid, 0.5f - splashRadius, -0.96875f, 0.5f - splashRadius, 0.5f + splashRadius, -0.9375f, 0.5f + splashRadius, buffer, ms, light, false, true);
            }
        }
    }

    private void renderFluidBox(FluidStack fluidStack, float xMin, float yMin, float zMin, float xMax, float yMax, float zMax, MultiBufferSource buffer, PoseStack ms, int light, boolean renderBottom, boolean invertGasses) {
        VertexConsumer builder = buffer.m_6299_(RenderType.m_110466_());
        this.renderFluidBox(fluidStack, xMin, yMin, zMin, xMax, yMax, zMax, builder, ms, light, renderBottom, invertGasses);
    }

    private void renderFluidBox(FluidStack fluidStack, float xMin, float yMin, float zMin, float xMax, float yMax, float zMax, VertexConsumer builder, PoseStack ms, int light, boolean renderBottom, boolean invertGasses) {
        Direction[] directions;
        if (fluidStack.isEmpty()) {
            return;
        }
        Fluid fluid = fluidStack.getFluid();
        IClientFluidTypeExtensions fluidAttributes = IClientFluidTypeExtensions.of((Fluid)fluid);
        ResourceLocation textureLocation = fluidAttributes.getStillTexture(fluidStack);
        TextureAtlasSprite fluidTexture = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(textureLocation);
        int color = fluidAttributes.getTintColor(fluidStack);
        int blockLightIn = light >> 4 & 0xF;
        int luminosity = Math.max(blockLightIn, fluid.getFluidType().getLightLevel());
        light = light & 0xF00000 | luminosity << 4;
        Vec3 center = new Vec3((double)xMin + (double)(xMax - xMin) / 2.0, (double)yMin + (double)(yMax - yMin) / 2.0, (double)zMin + (double)(zMax - zMin) / 2.0);
        ms.m_85836_();
        if (invertGasses && fluid.getFluidType().isLighterThanAir()) {
            ms.m_85837_(center.f_82479_, center.f_82480_, center.f_82481_);
            ms.m_252781_(Axis.f_252529_.m_252977_(180.0f));
            ms.m_85837_(-center.f_82479_, -center.f_82480_, -center.f_82481_);
        }
        for (Direction side : directions = Direction.values()) {
            boolean positive;
            if (side == Direction.DOWN && !renderBottom) continue;
            boolean bl = positive = side.m_122421_() == Direction.AxisDirection.POSITIVE;
            if (side.m_122434_().m_122479_()) {
                if (side.m_122434_() == Direction.Axis.X) {
                    CopperTapRenderer.renderStillTiledFace(side, zMin, yMin, zMax, yMax, positive ? xMax : xMin, builder, ms, light, color, fluidTexture);
                    continue;
                }
                CopperTapRenderer.renderStillTiledFace(side, xMin, yMin, xMax, yMax, positive ? zMax : zMin, builder, ms, light, color, fluidTexture);
                continue;
            }
            CopperTapRenderer.renderStillTiledFace(side, xMin, zMin, xMax, zMax, positive ? yMax : yMin, builder, ms, light, color, fluidTexture);
        }
        ms.m_85849_();
    }

    private static void renderStillTiledFace(Direction dir, float left, float down, float right, float up, float depth, VertexConsumer builder, PoseStack ms, int light, int color, TextureAtlasSprite texture) {
        CopperTapRenderer.renderTiledFace(dir, left, down, right, up, depth, builder, ms, light, color, texture, 1.0f);
    }

    private static void renderTiledFace(Direction dir, float left, float down, float right, float up, float depth, VertexConsumer builder, PoseStack ms, int light, int color, TextureAtlasSprite texture, float textureScale) {
        boolean positive = dir.m_122421_() == Direction.AxisDirection.POSITIVE;
        boolean horizontal = dir.m_122434_().m_122479_();
        boolean x = dir.m_122434_() == Direction.Axis.X;
        float shrink = texture.m_118417_() * 0.25f * textureScale;
        float centerU = texture.m_118409_() + (texture.m_118410_() - texture.m_118409_()) * 0.5f * textureScale;
        float centerV = texture.m_118411_() + (texture.m_118412_() - texture.m_118411_()) * 0.5f * textureScale;
        float x2 = 0.0f;
        float y2 = 0.0f;
        float x1 = left;
        while (x1 < right) {
            float u2;
            float u1;
            float f = Mth.m_14143_((float)x1);
            x2 = Math.min(f + 1.0f, right);
            if (dir == Direction.NORTH || dir == Direction.EAST) {
                f = Mth.m_14167_((float)x2);
                u1 = texture.m_118367_((double)((f - x2) * 16.0f * textureScale));
                u2 = texture.m_118367_((double)((f - x1) * 16.0f * textureScale));
            } else {
                u1 = texture.m_118367_((double)((x1 - f) * 16.0f * textureScale));
                u2 = texture.m_118367_((double)((x2 - f) * 16.0f * textureScale));
            }
            u1 = Mth.m_14179_((float)shrink, (float)u1, (float)centerU);
            u2 = Mth.m_14179_((float)shrink, (float)u2, (float)centerU);
            float y1 = down;
            while (y1 < up) {
                float v2;
                float v1;
                f = Mth.m_14143_((float)y1);
                y2 = Math.min(f + 1.0f, up);
                if (dir == Direction.UP) {
                    v1 = texture.m_118393_((double)((y1 - f) * 16.0f * textureScale));
                    v2 = texture.m_118393_((double)((y2 - f) * 16.0f * textureScale));
                } else {
                    f = Mth.m_14167_((float)y2);
                    v1 = texture.m_118393_((double)((f - y2) * 16.0f * textureScale));
                    v2 = texture.m_118393_((double)((f - y1) * 16.0f * textureScale));
                }
                v1 = Mth.m_14179_((float)shrink, (float)v1, (float)centerV);
                v2 = Mth.m_14179_((float)shrink, (float)v2, (float)centerV);
                if (horizontal) {
                    if (x) {
                        CopperTapRenderer.putVertex(builder, ms, depth, y2, positive ? x2 : x1, color, u1, v1, dir, light);
                        CopperTapRenderer.putVertex(builder, ms, depth, y1, positive ? x2 : x1, color, u1, v2, dir, light);
                        CopperTapRenderer.putVertex(builder, ms, depth, y1, positive ? x1 : x2, color, u2, v2, dir, light);
                        CopperTapRenderer.putVertex(builder, ms, depth, y2, positive ? x1 : x2, color, u2, v1, dir, light);
                    } else {
                        CopperTapRenderer.putVertex(builder, ms, positive ? x1 : x2, y2, depth, color, u1, v1, dir, light);
                        CopperTapRenderer.putVertex(builder, ms, positive ? x1 : x2, y1, depth, color, u1, v2, dir, light);
                        CopperTapRenderer.putVertex(builder, ms, positive ? x2 : x1, y1, depth, color, u2, v2, dir, light);
                        CopperTapRenderer.putVertex(builder, ms, positive ? x2 : x1, y2, depth, color, u2, v1, dir, light);
                    }
                } else {
                    CopperTapRenderer.putVertex(builder, ms, x1, depth, positive ? y1 : y2, color, u1, v1, dir, light);
                    CopperTapRenderer.putVertex(builder, ms, x1, depth, positive ? y2 : y1, color, u1, v2, dir, light);
                    CopperTapRenderer.putVertex(builder, ms, x2, depth, positive ? y2 : y1, color, u2, v2, dir, light);
                    CopperTapRenderer.putVertex(builder, ms, x2, depth, positive ? y1 : y2, color, u2, v1, dir, light);
                }
                y1 = y2;
            }
            x1 = x2;
        }
    }

    private static void putVertex(VertexConsumer builder, PoseStack ms, float x, float y, float z, int color, float u, float v, Direction face, int light) {
        Vec3i normal = face.m_122436_();
        PoseStack.Pose peek = ms.m_85850_();
        int a = color >> 24 & 0xFF;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        builder.m_252986_(peek.m_252922_(), x, y, z).m_6122_(r, g, b, a).m_7421_(u, v).m_85969_(light).m_252939_(peek.m_252943_(), (float)normal.m_123341_(), (float)normal.m_123342_(), (float)normal.m_123343_()).m_5752_();
    }

    public static void spawnFluidParticles(CopperTapBlockEntity be) {
        if (be.m_58904_() == null || !be.m_58904_().f_46443_) {
            return;
        }
        FluidStack fluid = be.getRenderingFluid();
        if (fluid.isEmpty() || !((Boolean)be.m_58900_().m_61143_((Property)BlockStateProperties.f_61446_)).booleanValue()) {
            return;
        }
        Vec3 pos = Vec3.m_82512_((Vec3i)be.m_58899_()).m_82520_(0.0, -0.25, 0.0);
        ParticleOptions particle = FluidFX.getFluidParticle((FluidStack)fluid);
        if (be.m_58904_().f_46441_.m_188501_() < 0.1f) {
            be.m_58904_().m_7106_(particle, pos.f_82479_, pos.f_82480_, pos.f_82481_, 0.0, -0.05, 0.0);
        }
    }
}

