/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.fluid.content.pipette;

import com.adonis.fluid.content.pipette.FluidInteractionPoint;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.fluids.spout.FillingBySpout;
import com.simibubi.create.content.kinetics.belt.BeltBlock;
import com.simibubi.create.content.kinetics.belt.BeltBlockEntity;
import com.simibubi.create.content.kinetics.belt.BeltHelper;
import com.simibubi.create.content.kinetics.belt.transport.BeltInventory;
import com.simibubi.create.content.kinetics.belt.transport.TransportedItemStack;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fluids.FluidStack;

public class BeltFluidInteractionPoint
extends FluidInteractionPoint {
    private TransportedItemStack lockedItem = null;

    public BeltFluidInteractionPoint(Level level, BlockPos pos, BlockState state) {
        super(level, pos, state);
        this.mode = FluidInteractionPoint.Mode.DEPOSIT;
    }

    @Override
    public boolean isValid() {
        if (this.level == null || !this.level.m_46749_(this.pos)) {
            return false;
        }
        BlockState currentState = this.level.m_8055_(this.pos);
        if (!AllBlocks.BELT.has(currentState)) {
            return false;
        }
        if (!BeltBlock.canTransportObjects((BlockState)currentState)) {
            return false;
        }
        BeltBlockEntity belt = BeltHelper.getControllerBE((LevelAccessor)this.level, (BlockPos)this.pos);
        return belt != null;
    }

    @Nullable
    private TransportedItemStack findItemForFilling(FluidStack fluid) {
        BeltBlockEntity controller = BeltHelper.getControllerBE((LevelAccessor)this.level, (BlockPos)this.pos);
        if (controller == null) {
            return null;
        }
        BeltInventory inventory = controller.getInventory();
        if (inventory == null) {
            return null;
        }
        BeltBlockEntity segment = BeltHelper.getSegmentBE((LevelAccessor)this.level, (BlockPos)this.pos);
        if (segment == null) {
            return null;
        }
        int segmentIndex = segment.index;
        List items = inventory.getTransportedItems();
        for (TransportedItemStack transported : items) {
            int required;
            float itemPos = transported.beltPosition;
            if (!(Math.abs(itemPos - (float)segmentIndex - 0.5f) < 0.75f) || transported.locked || transported.lockedExternally || !FillingBySpout.canItemBeFilled((Level)this.level, (ItemStack)transported.stack) || (required = FillingBySpout.getRequiredAmountForItem((Level)this.level, (ItemStack)transported.stack, (FluidStack)fluid)) <= 0 || required > fluid.getAmount()) continue;
            return transported;
        }
        return null;
    }

    public boolean hasItemForFilling(FluidStack fluid) {
        return this.findItemForFilling(fluid) != null;
    }

    public boolean lockItemForProcessing(FluidStack fluid) {
        if (this.lockedItem != null) {
            return false;
        }
        TransportedItemStack item = this.findItemForFilling(fluid);
        if (item == null) {
            return false;
        }
        item.locked = true;
        this.lockedItem = item;
        BeltBlockEntity controller = BeltHelper.getControllerBE((LevelAccessor)this.level, (BlockPos)this.pos);
        if (controller != null) {
            controller.m_6596_();
            controller.sendData();
        }
        return true;
    }

    public ItemStack processLockedItem(FluidStack fluid) {
        if (this.lockedItem == null) {
            return ItemStack.f_41583_;
        }
        ItemStack original = this.lockedItem.stack.m_41777_();
        int required = FillingBySpout.getRequiredAmountForItem((Level)this.level, (ItemStack)original, (FluidStack)fluid);
        if (required <= 0 || required > fluid.getAmount()) {
            this.unlockItem();
            return ItemStack.f_41583_;
        }
        FluidStack fluidForFilling = fluid.copy();
        fluidForFilling.setAmount(required);
        ItemStack result = FillingBySpout.fillItem((Level)this.level, (int)required, (ItemStack)original, (FluidStack)fluidForFilling);
        if (!result.m_41619_()) {
            this.lockedItem.stack = result;
            this.lockedItem.clearFanProcessingData();
            BeltBlockEntity controller = BeltHelper.getControllerBE((LevelAccessor)this.level, (BlockPos)this.pos);
            if (controller != null) {
                controller.m_6596_();
                controller.sendData();
            }
        }
        this.unlockItem();
        return result;
    }

    public int getRequiredAmount(FluidStack fluid) {
        if (this.lockedItem == null) {
            return 0;
        }
        return FillingBySpout.getRequiredAmountForItem((Level)this.level, (ItemStack)this.lockedItem.stack, (FluidStack)fluid);
    }

    public ItemStack getLockedItem() {
        return this.lockedItem != null ? this.lockedItem.stack.m_41777_() : ItemStack.f_41583_;
    }

    public void unlockItem() {
        if (this.lockedItem != null) {
            this.lockedItem.locked = false;
            BeltBlockEntity controller = BeltHelper.getControllerBE((LevelAccessor)this.level, (BlockPos)this.pos);
            if (controller != null) {
                controller.m_6596_();
                controller.sendData();
            }
            this.lockedItem = null;
        }
    }

    @Override
    public FluidStack extract(int maxAmount, boolean simulate) {
        return FluidStack.EMPTY;
    }

    @Override
    public FluidStack insert(FluidStack stack, boolean simulate) {
        return stack;
    }

    @Override
    public boolean canExtract() {
        return false;
    }

    @Override
    public boolean canInsert(FluidStack stack) {
        return this.hasItemForFilling(stack);
    }

    @Override
    public void cycleMode() {
    }
}

