/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.fluid.content.pipette;

import com.adonis.fluid.content.pipette.CauldronFluidHandler;
import com.adonis.fluid.content.pipette.DepotFluidInteractionPoint;
import com.adonis.fluid.content.pipette.ItemDrainFluidInteractionPoint;
import com.adonis.fluid.registry.CFBlock;
import com.adonis.fluid.registry.CFFluid;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.StructureTransform;
import com.simibubi.create.content.fluids.drain.ItemDrainBlockEntity;
import com.simibubi.create.content.kinetics.belt.BeltBlock;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.registries.ForgeRegistries;

public class FluidInteractionPoint {
    protected BlockPos pos;
    protected Direction face;
    protected Mode mode;
    protected Level level;
    protected long lastKnownValid = -1L;

    public FluidInteractionPoint(Level level, BlockPos pos, BlockState state) {
        this.level = level;
        this.pos = pos;
        this.face = Direction.UP;
        this.mode = FluidInteractionPoint.isBlazeBurner(state) ? Mode.DEPOSIT : (FluidInteractionPoint.isBeehive(state) ? Mode.TAKE : (AllBlocks.BELT.has(state) ? Mode.DEPOSIT : (AllBlocks.ITEM_DRAIN.has(state) ? Mode.TAKE : (FluidInteractionPoint.isCauldron(state) ? Mode.DEPOSIT : Mode.DEPOSIT))));
    }

    @Nullable
    public static FluidInteractionPoint create(Level level, BlockPos pos, BlockState state) {
        if (AllBlocks.DEPOT.has(state) || AllBlocks.WEIGHTED_EJECTOR.has(state)) {
            return new DepotFluidInteractionPoint(level, pos, state);
        }
        if (AllBlocks.ITEM_DRAIN.has(state)) {
            return new ItemDrainFluidInteractionPoint(level, pos, state);
        }
        if (AllBlocks.BELT.has(state)) {
            if (BeltBlock.canTransportObjects((BlockState)state)) {
                return new FluidInteractionPoint(level, pos, state);
            }
            return null;
        }
        if (FluidInteractionPoint.isCauldron(state)) {
            return new FluidInteractionPoint(level, pos, state);
        }
        if (FluidInteractionPoint.isValidFluidBlock(state)) {
            return new FluidInteractionPoint(level, pos, state);
        }
        return null;
    }

    private static boolean isValidFluidBlock(BlockState state) {
        if (AllBlocks.BELT.has(state)) {
            return true;
        }
        if (AllBlocks.DEPOT.has(state) || AllBlocks.WEIGHTED_EJECTOR.has(state)) {
            return true;
        }
        if (AllBlocks.ITEM_DRAIN.has(state)) {
            return true;
        }
        if (AllBlocks.BASIN.has(state) || CFBlock.FLUID_INTERFACE.has(state) || CFBlock.SMART_FLUID_INTERFACE.has(state)) {
            return true;
        }
        if (FluidInteractionPoint.isBlazeBurner(state)) {
            return true;
        }
        if (FluidInteractionPoint.isBeehive(state)) {
            return true;
        }
        return FluidInteractionPoint.isCauldron(state);
    }

    private static boolean isBlazeBurner(BlockState state) {
        return AllBlocks.BLAZE_BURNER.has(state) || AllBlocks.LIT_BLAZE_BURNER.has(state);
    }

    private static boolean isBeehive(BlockState state) {
        return state.m_60734_() instanceof BeehiveBlock;
    }

    private static boolean isCauldron(BlockState state) {
        return state.m_60713_(Blocks.f_50256_) || state.m_60713_(Blocks.f_152476_) || state.m_60713_(Blocks.f_152477_) || state.m_60713_(Blocks.f_152478_);
    }

    public boolean isValid() {
        if (this.level == null) {
            return false;
        }
        long gameTime = this.level.m_46467_();
        if (gameTime == this.lastKnownValid) {
            return true;
        }
        BlockState state = this.level.m_8055_(this.pos);
        if (AllBlocks.BELT.has(state)) {
            if (BeltBlock.canTransportObjects((BlockState)state)) {
                this.lastKnownValid = gameTime;
                return true;
            }
            return false;
        }
        if (AllBlocks.ITEM_DRAIN.has(state)) {
            BlockEntity be = this.level.m_7702_(this.pos);
            if (be instanceof ItemDrainBlockEntity) {
                this.lastKnownValid = gameTime;
                return true;
            }
            return false;
        }
        if (FluidInteractionPoint.isCauldron(state)) {
            this.lastKnownValid = gameTime;
            return true;
        }
        BlockEntity be = this.level.m_7702_(this.pos);
        boolean valid = false;
        valid = be != null ? FluidInteractionPoint.isValidFluidBlock(state) && this.getFluidHandler() != null : FluidInteractionPoint.isValidFluidBlock(state);
        if (valid) {
            this.lastKnownValid = gameTime;
        }
        return valid;
    }

    @Nullable
    private IFluidHandler getFluidHandler() {
        BlockState state = this.level.m_8055_(this.pos);
        if (AllBlocks.BELT.has(state)) {
            return null;
        }
        if (FluidInteractionPoint.isCauldron(state)) {
            return new CauldronFluidHandler(this.level, this.pos, state);
        }
        BlockEntity be = this.level.m_7702_(this.pos);
        if (FluidInteractionPoint.isBlazeBurner(state)) {
            return new BlazeBurnerFluidHandler(this.level, this.pos, state);
        }
        if (FluidInteractionPoint.isBeehive(state)) {
            return new BeehiveFluidHandler(this.level, this.pos, state);
        }
        if (AllBlocks.ITEM_DRAIN.has(state)) {
            if (be == null) {
                return null;
            }
            return (IFluidHandler)be.getCapability(ForgeCapabilities.FLUID_HANDLER, Direction.DOWN).orElse(null);
        }
        if (be == null) {
            return null;
        }
        return (IFluidHandler)be.getCapability(ForgeCapabilities.FLUID_HANDLER, this.face).orElse(null);
    }

    public FluidStack extract(int maxAmount, boolean simulate) {
        if (AllBlocks.BELT.has(this.level.m_8055_(this.pos))) {
            return FluidStack.EMPTY;
        }
        IFluidHandler handler = this.getFluidHandler();
        if (handler == null) {
            return FluidStack.EMPTY;
        }
        return handler.drain(maxAmount, simulate ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE);
    }

    public FluidStack insert(FluidStack stack, boolean simulate) {
        if (AllBlocks.BELT.has(this.level.m_8055_(this.pos))) {
            return stack;
        }
        if (AllBlocks.ITEM_DRAIN.has(this.level.m_8055_(this.pos))) {
            return stack;
        }
        IFluidHandler handler = this.getFluidHandler();
        if (handler == null) {
            return stack;
        }
        int filled = handler.fill(stack, simulate ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE);
        FluidStack remainder = stack.copy();
        remainder.shrink(filled);
        return remainder;
    }

    public boolean canExtract() {
        if (AllBlocks.BELT.has(this.level.m_8055_(this.pos))) {
            return false;
        }
        BlockState state = this.level.m_8055_(this.pos);
        if (state.m_60713_(Blocks.f_50256_)) {
            return false;
        }
        if (state.m_60713_(Blocks.f_152476_)) {
            return (Integer)state.m_61143_((Property)LayeredCauldronBlock.f_153514_) == 3;
        }
        if (state.m_60713_(Blocks.f_152477_)) {
            return true;
        }
        if (state.m_60713_(Blocks.f_152478_)) {
            return (Integer)state.m_61143_((Property)LayeredCauldronBlock.f_153514_) == 3;
        }
        IFluidHandler handler = this.getFluidHandler();
        if (handler == null) {
            return false;
        }
        return !handler.drain(1, IFluidHandler.FluidAction.SIMULATE).isEmpty();
    }

    public boolean canInsert(FluidStack stack) {
        IFluidHandler handler;
        if (AllBlocks.BELT.has(this.level.m_8055_(this.pos))) {
            return this.mode == Mode.DEPOSIT;
        }
        if (AllBlocks.ITEM_DRAIN.has(this.level.m_8055_(this.pos))) {
            return false;
        }
        BlockState state = this.level.m_8055_(this.pos);
        if (FluidInteractionPoint.isCauldron(state)) {
            if (state.m_60713_(Blocks.f_50256_)) {
                return stack.getFluid() == Fluids.f_76193_ || stack.getFluid() == Fluids.f_76195_ || CFFluid.isPowderSnowFluid(stack.getFluid());
            }
            if (state.m_60713_(Blocks.f_152476_)) {
                int level = (Integer)state.m_61143_((Property)LayeredCauldronBlock.f_153514_);
                return level < 3 && stack.getFluid() == Fluids.f_76193_;
            }
            if (state.m_60713_(Blocks.f_152477_)) {
                return false;
            }
            if (state.m_60713_(Blocks.f_152478_)) {
                return false;
            }
        }
        if ((handler = this.getFluidHandler()) == null) {
            return false;
        }
        return handler.fill(stack, IFluidHandler.FluidAction.SIMULATE) > 0;
    }

    public void cycleMode() {
        BlockState state = this.level.m_8055_(this.pos);
        if (FluidInteractionPoint.isBlazeBurner(state)) {
            return;
        }
        if (FluidInteractionPoint.isBeehive(state)) {
            return;
        }
        if (AllBlocks.ITEM_DRAIN.has(state)) {
            return;
        }
        if (AllBlocks.BELT.has(state)) {
            if (this.mode != Mode.DEPOSIT) {
                this.mode = Mode.DEPOSIT;
            }
            return;
        }
        this.mode = this.mode == Mode.TAKE ? Mode.DEPOSIT : Mode.TAKE;
    }

    public Mode getMode() {
        return this.mode;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public Level getLevel() {
        return this.level;
    }

    public void setLevel(Level level) {
        this.level = level;
    }

    public void keepAlive() {
        this.lastKnownValid = this.level != null ? this.level.m_46467_() : -1L;
    }

    public void updateCachedState() {
        this.lastKnownValid = -1L;
    }

    public CompoundTag serialize(BlockPos armPos) {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128365_("Pos", (Tag)NbtUtils.m_129224_((BlockPos)this.pos.m_121996_((Vec3i)armPos)));
        nbt.m_128359_("Mode", this.mode.name());
        nbt.m_128359_("Face", this.face.name());
        return nbt;
    }

    @Nullable
    public static FluidInteractionPoint deserialize(CompoundTag nbt, Level level, BlockPos armPos) {
        BlockState state;
        BlockPos pos = NbtUtils.m_129239_((CompoundTag)nbt.m_128469_("Pos")).m_121955_((Vec3i)armPos);
        FluidInteractionPoint point = FluidInteractionPoint.create(level, pos, state = level.m_8055_(pos));
        if (point != null) {
            if (nbt.m_128441_("Mode")) {
                try {
                    Mode deserializedMode = Mode.valueOf(nbt.m_128461_("Mode"));
                    point.mode = AllBlocks.BELT.has(state) ? Mode.DEPOSIT : (AllBlocks.ITEM_DRAIN.has(state) ? Mode.TAKE : deserializedMode);
                }
                catch (IllegalArgumentException e) {
                    point.mode = Mode.DEPOSIT;
                }
            }
            if (nbt.m_128441_("Face")) {
                try {
                    point.face = Direction.valueOf((String)nbt.m_128461_("Face"));
                }
                catch (IllegalArgumentException e) {
                    point.face = Direction.UP;
                }
            }
        }
        return point;
    }

    public static void transformPos(CompoundTag nbt, StructureTransform transform) {
        BlockPos pos = NbtUtils.m_129239_((CompoundTag)nbt.m_128469_("Pos"));
        pos = transform.apply(pos);
        nbt.m_128365_("Pos", (Tag)NbtUtils.m_129224_((BlockPos)pos));
        if (nbt.m_128441_("Face")) {
            Direction face = Direction.valueOf((String)nbt.m_128461_("Face"));
            face = transform.mirrorFacing(face);
            face = transform.rotateFacing(face);
            nbt.m_128359_("Face", face.name());
        }
    }

    public static enum Mode {
        TAKE("fluid.mechanical_pipette.extract", 8375776),
        DEPOSIT("fluid.mechanical_pipette.deposit", 14532966);

        private final String translationKey;
        private final int color;

        private Mode(String translationKey, int color) {
            this.translationKey = translationKey;
            this.color = color;
        }

        public String getTranslationKey() {
            return this.translationKey;
        }

        public int getColor() {
            return this.color;
        }
    }

    private static class BlazeBurnerFluidHandler
    implements IFluidHandler {
        private final Level level;
        private final BlockPos pos;
        private final BlockState state;

        public BlazeBurnerFluidHandler(Level level, BlockPos pos, BlockState state) {
            this.level = level;
            this.pos = pos;
            this.state = state;
        }

        public int getTanks() {
            return 1;
        }

        @Nonnull
        public FluidStack getFluidInTank(int tank) {
            return FluidStack.EMPTY;
        }

        public int getTankCapacity(int tank) {
            return 1000;
        }

        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            return stack.getFluid() == Fluids.f_76195_;
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            if (!this.isFluidValid(0, resource)) {
                return 0;
            }
            ItemStack lavaBucket = new ItemStack((ItemLike)Items.f_42448_);
            try {
                InteractionResultHolder result = BlazeBurnerBlock.tryInsert((BlockState)this.state, (Level)this.level, (BlockPos)this.pos, (ItemStack)lavaBucket, (boolean)true, (boolean)false, (boolean)true);
                if (result.m_19089_() == InteractionResult.SUCCESS) {
                    if (action.execute()) {
                        BlazeBurnerBlock.tryInsert((BlockState)this.state, (Level)this.level, (BlockPos)this.pos, (ItemStack)lavaBucket, (boolean)true, (boolean)false, (boolean)false);
                    }
                    return Math.min(resource.getAmount(), 1000);
                }
            }
            catch (Exception e) {
                return 0;
            }
            return 0;
        }

        @Nonnull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            return FluidStack.EMPTY;
        }

        @Nonnull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            return FluidStack.EMPTY;
        }
    }

    private static class BeehiveFluidHandler
    implements IFluidHandler {
        private final Level level;
        private final BlockPos pos;
        private final BlockState state;

        public BeehiveFluidHandler(Level level, BlockPos pos, BlockState state) {
            this.level = level;
            this.pos = pos;
            this.state = state;
        }

        private Fluid getHoneyFluid() {
            try {
                ResourceLocation honeyLocation = new ResourceLocation("create", "honey");
                Fluid honeyFluid = (Fluid)ForgeRegistries.FLUIDS.getValue(honeyLocation);
                if (honeyFluid != null && honeyFluid != Fluids.f_76191_) {
                    return honeyFluid;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return Fluids.f_76193_;
        }

        public int getTanks() {
            return 1;
        }

        @Nonnull
        public FluidStack getFluidInTank(int tank) {
            if (this.isHoneyFull()) {
                return new FluidStack(this.getHoneyFluid(), 250);
            }
            return FluidStack.EMPTY;
        }

        public int getTankCapacity(int tank) {
            return 250;
        }

        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            return false;
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            return 0;
        }

        @Nonnull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            if (!resource.isEmpty() && resource.getFluid() == this.getHoneyFluid()) {
                return this.drain(resource.getAmount(), action);
            }
            return FluidStack.EMPTY;
        }

        @Nonnull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            if (!this.isHoneyFull()) {
                return FluidStack.EMPTY;
            }
            int drainAmount = Math.min(maxDrain, 250);
            FluidStack result = new FluidStack(this.getHoneyFluid(), drainAmount);
            if (action.execute()) {
                try {
                    BeehiveBlock beehiveBlock = (BeehiveBlock)this.state.m_60734_();
                    beehiveBlock.m_49590_(this.level, this.state, this.pos);
                }
                catch (Exception e) {
                    this.level.m_7731_(this.pos, (BlockState)this.state.m_61124_((Property)BlockStateProperties.f_61421_, (Comparable)Integer.valueOf(0)), 3);
                }
            }
            return result;
        }

        private boolean isHoneyFull() {
            try {
                BlockState currentState = this.level.m_8055_(this.pos);
                if (currentState.m_61138_((Property)BlockStateProperties.f_61421_)) {
                    return (Integer)currentState.m_61143_((Property)BlockStateProperties.f_61421_) >= 5;
                }
            }
            catch (Exception e) {
                return false;
            }
            return false;
        }
    }
}

