/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.fluid.content.pipette;

import com.adonis.fluid.content.pipette.FluidInteractionPoint;
import com.simibubi.create.content.fluids.drain.ItemDrainBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class ItemDrainFluidInteractionPoint
extends FluidInteractionPoint {
    public ItemDrainFluidInteractionPoint(Level level, BlockPos pos, BlockState state) {
        super(level, pos, state);
        this.mode = FluidInteractionPoint.Mode.TAKE;
        this.face = Direction.DOWN;
    }

    @Override
    public void cycleMode() {
    }

    @Override
    public boolean isValid() {
        if (this.level == null) {
            return false;
        }
        long gameTime = this.level.m_46467_();
        if (gameTime == this.lastKnownValid) {
            return true;
        }
        BlockEntity be = this.level.m_7702_(this.pos);
        if (!(be instanceof ItemDrainBlockEntity)) {
            return false;
        }
        this.lastKnownValid = gameTime;
        return true;
    }

    @Override
    public FluidStack extract(int maxAmount, boolean simulate) {
        BlockEntity be = this.level.m_7702_(this.pos);
        if (!(be instanceof ItemDrainBlockEntity)) {
            return FluidStack.EMPTY;
        }
        return be.getCapability(ForgeCapabilities.FLUID_HANDLER, Direction.DOWN).map(handler -> handler.drain(maxAmount, simulate ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE)).orElse(FluidStack.EMPTY);
    }

    @Override
    public FluidStack insert(FluidStack stack, boolean simulate) {
        return stack;
    }

    @Override
    public boolean canExtract() {
        BlockEntity be = this.level.m_7702_(this.pos);
        if (!(be instanceof ItemDrainBlockEntity)) {
            return false;
        }
        return be.getCapability(ForgeCapabilities.FLUID_HANDLER, Direction.DOWN).map(handler -> !handler.getFluidInTank(0).isEmpty()).orElse(false);
    }

    @Override
    public boolean canInsert(FluidStack stack) {
        return false;
    }
}

