/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.fluid.handler;

import com.adonis.fluid.block.Pipette.PipetteBlockEntity;
import com.adonis.fluid.content.pipette.FluidInteractionPoint;
import com.adonis.fluid.packet.PipetteFluidPlacementPacket;
import com.adonis.fluid.registry.CFBlock;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllPackets;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.createmod.catnip.outliner.Outliner;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public class PipetteFluidInteractionPointHandler {
    static List<FluidInteractionPoint> currentSelection = new ArrayList<FluidInteractionPoint>();
    static ItemStack currentItem;
    static long lastBlockPos;

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void rightClickingBlocksSelectsThem(PlayerInteractEvent.RightClickBlock event) {
        if (!CFBlock.PIPETTE.isIn(event.getItemStack())) {
            return;
        }
        if (currentItem == null || !ItemStack.m_41728_((ItemStack)currentItem, (ItemStack)event.getItemStack())) {
            currentItem = event.getItemStack();
        }
        BlockPos pos = event.getPos();
        Level world = event.getLevel();
        if (world.f_46443_) {
            Player player = event.getEntity();
            if (player != null && !player.m_5833_()) {
                BlockState state = world.m_8055_(pos);
                FluidInteractionPoint point = FluidInteractionPoint.create(world, pos, state);
                if (point == null) {
                    return;
                }
                FluidInteractionPoint selected = PipetteFluidInteractionPointHandler.getSelected(pos);
                if (selected == null) {
                    selected = point;
                    PipetteFluidInteractionPointHandler.put(point);
                }
                selected.cycleMode();
                FluidInteractionPoint.Mode mode = selected.getMode();
                CreateLang.builder().translate(mode.getTranslationKey(), new Object[]{CreateLang.blockName((BlockState)state).style(ChatFormatting.WHITE)}).color(mode.getColor()).sendStatus(player);
                event.setCanceled(true);
                event.setCancellationResult(InteractionResult.SUCCESS);
            }
        } else {
            BlockState state = world.m_8055_(pos);
            if (FluidInteractionPoint.create(world, pos, state) != null) {
                event.setCanceled(true);
                event.setCancellationResult(InteractionResult.SUCCESS);
            }
        }
    }

    @SubscribeEvent
    public static void leftClickingBlocksDeselectsThem(PlayerInteractEvent.LeftClickBlock event) {
        BlockPos pos;
        if (currentItem != null && CFBlock.PIPETTE.isIn(currentItem) && event.getLevel().f_46443_ && PipetteFluidInteractionPointHandler.remove(pos = event.getPos()) != null) {
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.SUCCESS);
        }
    }

    public static void flushSettings(BlockPos pos) {
        if (currentSelection != null) {
            int removed = 0;
            Iterator<FluidInteractionPoint> iterator = currentSelection.iterator();
            while (iterator.hasNext()) {
                FluidInteractionPoint point = iterator.next();
                if (point.getPos().m_123314_((Vec3i)pos, (double)PipetteBlockEntity.getRange())) continue;
                iterator.remove();
                ++removed;
            }
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (removed > 0) {
                CreateLang.builder().translate("fluid.mechanical_pipette.points_outside_range", new Object[]{removed}).style(ChatFormatting.RED).sendStatus((Player)player);
            } else {
                int inputs = 0;
                int outputs = 0;
                for (FluidInteractionPoint point : currentSelection) {
                    if (point.getMode() == FluidInteractionPoint.Mode.DEPOSIT) {
                        ++outputs;
                        continue;
                    }
                    ++inputs;
                }
                if (inputs + outputs > 0) {
                    CreateLang.builder().translate("fluid.mechanical_pipette.summary", new Object[]{inputs, outputs}).style(ChatFormatting.WHITE).sendStatus((Player)player);
                }
            }
            AllPackets.getChannel().sendToServer((Object)new PipetteFluidPlacementPacket(currentSelection, pos));
            currentSelection.clear();
            currentItem = null;
        }
    }

    public static void tick() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            ItemStack heldItemMainhand = player.m_21205_();
            if (CFBlock.PIPETTE.isIn(heldItemMainhand)) {
                if (heldItemMainhand != currentItem) {
                    currentSelection.clear();
                    currentItem = heldItemMainhand;
                }
                PipetteFluidInteractionPointHandler.drawOutlines(currentSelection);
            } else {
                currentItem = null;
            }
            if (AllItems.WRENCH.isIn(heldItemMainhand)) {
                HitResult objectMouseOver = Minecraft.m_91087_().f_91077_;
                if (objectMouseOver instanceof BlockHitResult) {
                    BlockHitResult result = (BlockHitResult)objectMouseOver;
                    BlockPos pos = result.m_82425_();
                    BlockEntity be = Minecraft.m_91087_().f_91073_.m_7702_(pos);
                    if (be instanceof PipetteBlockEntity) {
                        PipetteBlockEntity pipette = (PipetteBlockEntity)be;
                        if (lastBlockPos != pos.m_121878_()) {
                            currentSelection.clear();
                            pipette.inputs.forEach(PipetteFluidInteractionPointHandler::put);
                            pipette.outputs.forEach(PipetteFluidInteractionPointHandler::put);
                            lastBlockPos = pos.m_121878_();
                        }
                        PipetteFluidInteractionPointHandler.drawOutlines(currentSelection);
                    } else if (lastBlockPos != -1L) {
                        lastBlockPos = -1L;
                        currentSelection.clear();
                    }
                } else if (lastBlockPos != -1L) {
                    lastBlockPos = -1L;
                    currentSelection.clear();
                }
            } else if (currentItem == null && lastBlockPos != -1L) {
                lastBlockPos = -1L;
                currentSelection.clear();
            }
        }
    }

    private static void checkForWrench(ItemStack heldItem) {
        if (AllItems.WRENCH.isIn(heldItem)) {
            HitResult objectMouseOver = Minecraft.m_91087_().f_91077_;
            if (objectMouseOver instanceof BlockHitResult) {
                BlockHitResult result = (BlockHitResult)objectMouseOver;
                BlockPos pos = result.m_82425_();
                BlockEntity be = Minecraft.m_91087_().f_91073_.m_7702_(pos);
                if (be instanceof PipetteBlockEntity) {
                    if (lastBlockPos != pos.m_121878_()) {
                        currentSelection.clear();
                        PipetteBlockEntity pipette = (PipetteBlockEntity)be;
                        pipette.inputs.forEach(PipetteFluidInteractionPointHandler::put);
                        pipette.outputs.forEach(PipetteFluidInteractionPointHandler::put);
                        lastBlockPos = pos.m_121878_();
                    }
                    PipetteFluidInteractionPointHandler.drawOutlines(currentSelection);
                } else if (lastBlockPos != -1L) {
                    lastBlockPos = -1L;
                    currentSelection.clear();
                }
            } else if (lastBlockPos != -1L) {
                lastBlockPos = -1L;
                currentSelection.clear();
            }
        } else if (lastBlockPos != -1L) {
            lastBlockPos = -1L;
            currentSelection.clear();
        }
    }

    private static void drawOutlines(Collection<FluidInteractionPoint> selection) {
        Iterator<FluidInteractionPoint> iterator = selection.iterator();
        while (iterator.hasNext()) {
            BlockPos pos;
            FluidInteractionPoint point = iterator.next();
            if (!point.isValid()) {
                iterator.remove();
                continue;
            }
            Level level = point.getLevel();
            BlockState state = level.m_8055_(pos = point.getPos());
            VoxelShape shape = state.m_60808_((BlockGetter)level, pos);
            if (shape.m_83281_()) continue;
            int color = point.getMode().getColor();
            Outliner.getInstance().showAABB((Object)point, shape.m_83215_().m_82338_(pos)).colored(color).lineWidth(0.0625f);
        }
    }

    public static void put(FluidInteractionPoint point) {
        currentSelection.add(point);
    }

    private static FluidInteractionPoint remove(BlockPos pos) {
        FluidInteractionPoint result = PipetteFluidInteractionPointHandler.getSelected(pos);
        if (result != null) {
            currentSelection.remove(result);
        }
        return result;
    }

    public static FluidInteractionPoint getSelected(BlockPos pos) {
        for (FluidInteractionPoint point : currentSelection) {
            if (!point.getPos().equals((Object)pos)) continue;
            return point;
        }
        return null;
    }

    static {
        lastBlockPos = -1L;
    }
}

