/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.fluid.mixin;

import com.adonis.fluid.block.CentrifugalPump.CentrifugalPumpBlock;
import com.adonis.fluid.block.CentrifugalPump.CentrifugalPumpBlockEntity;
import com.simibubi.create.content.fluids.FluidPropagator;
import com.simibubi.create.content.fluids.FluidTransportBehaviour;
import com.simibubi.create.content.fluids.pump.PumpBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.createmod.catnip.data.Pair;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={FluidPropagator.class}, remap=false, priority=1145)
public class FluidPropagatorMixin {
    @Unique
    private static final ThreadLocal<Set<Pair<CentrifugalPumpBlockEntity, Direction>>> centrifugalPumpsToUpdate = ThreadLocal.withInitial(HashSet::new);

    @Inject(method={"propagateChangedPipe"}, at={@At(value="HEAD")})
    private static void clearCentrifugalPumps(LevelAccessor world, BlockPos pipePos, BlockState pipeState, CallbackInfo ci) {
        centrifugalPumpsToUpdate.get().clear();
    }

    @Inject(method={"propagateChangedPipe"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/LevelAccessor;m_7702_(Lnet/minecraft/core/BlockPos;)Lnet/minecraft/world/level/block/entity/BlockEntity;", shift=At.Shift.AFTER)}, locals=LocalCapture.CAPTURE_FAILHARD)
    private static void detectCentrifugalPump(LevelAccessor world, BlockPos pipePos, BlockState pipeState, CallbackInfo ci, List<Pair<Integer, BlockPos>> frontier, Set<BlockPos> visited, Set<Pair<PumpBlockEntity, Direction>> discoveredPumps, Pair<Integer, BlockPos> pair, BlockPos currentPos, BlockState currentState, FluidTransportBehaviour pipe, Iterator<Direction> iterator, Direction direction, BlockPos target) {
        BlockEntity blockEntity = world.m_7702_(target);
        BlockState targetState = world.m_8055_(target);
        if (blockEntity instanceof CentrifugalPumpBlockEntity) {
            CentrifugalPumpBlockEntity centrifugalPump = (CentrifugalPumpBlockEntity)blockEntity;
            if (targetState.m_60734_() instanceof CentrifugalPumpBlock && CentrifugalPumpBlock.isOpenAt(targetState, direction.m_122424_())) {
                centrifugalPumpsToUpdate.get().add((Pair<CentrifugalPumpBlockEntity, Direction>)Pair.of((Object)((Object)centrifugalPump), (Object)direction.m_122424_()));
            }
        }
    }

    @Inject(method={"propagateChangedPipe"}, at={@At(value="RETURN")})
    private static void notifyCentrifugalPumps(LevelAccessor world, BlockPos pipePos, BlockState pipeState, CallbackInfo ci) {
        centrifugalPumpsToUpdate.get().forEach(pair -> ((CentrifugalPumpBlockEntity)((Object)((Object)pair.getFirst()))).updatePipesOnSide((Direction)pair.getSecond()));
        centrifugalPumpsToUpdate.get().clear();
    }

    @Inject(method={"validateNeighbourChange"}, at={@At(value="HEAD")}, cancellable=true)
    private static void recognizeCentrifugalPump(BlockState state, Level world, BlockPos pos, Block otherBlock, BlockPos neighborPos, boolean isMoving, CallbackInfoReturnable<Direction> cir) {
        if (world.f_46443_) {
            return;
        }
        Block actualBlock = world.m_8055_(neighborPos).m_60734_();
        if (actualBlock instanceof CentrifugalPumpBlock) {
            cir.setReturnValue(null);
        }
    }

    @Inject(method={"isOpenEnd"}, at={@At(value="HEAD")}, cancellable=true)
    private static void checkCentrifugalPumpEnd(BlockGetter reader, BlockPos pos, Direction side, CallbackInfoReturnable<Boolean> cir) {
        BlockPos connectedPos = pos.m_121945_(side);
        BlockState connectedState = reader.m_8055_(connectedPos);
        if (connectedState.m_60734_() instanceof CentrifugalPumpBlock && CentrifugalPumpBlock.isOpenAt(connectedState, side.m_122424_())) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"getStraightPipeAxis"}, at={@At(value="HEAD")}, cancellable=true)
    private static void handleCentrifugalPumpAxis(BlockState state, CallbackInfoReturnable<Direction.Axis> cir) {
        if (state.m_60734_() instanceof CentrifugalPumpBlock) {
            cir.setReturnValue(null);
        }
    }

    @Inject(method={"getPipe"}, at={@At(value="RETURN")}, cancellable=true)
    private static void includeCentrifugalPump(BlockGetter reader, BlockPos pos, CallbackInfoReturnable<FluidTransportBehaviour> cir) {
        BlockEntity be;
        if (cir.getReturnValue() == null && (be = reader.m_7702_(pos)) instanceof CentrifugalPumpBlockEntity) {
            FluidTransportBehaviour behaviour = (FluidTransportBehaviour)BlockEntityBehaviour.get((BlockGetter)reader, (BlockPos)pos, (BehaviourType)FluidTransportBehaviour.TYPE);
            cir.setReturnValue((Object)behaviour);
        }
    }
}

