/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.fluid.block.Aqueduct;

import com.adonis.fluid.block.Aqueduct.AbstractAqueductBlockEntity;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.foundation.block.IBE;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAqueductBlock
extends HorizontalDirectionalBlock
implements IBE<AbstractAqueductBlockEntity>,
IWrenchable,
SimpleWaterloggedBlock {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractAqueductBlock.class);
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty LOCKED = BooleanProperty.m_61465_((String)"locked");
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    protected static final VoxelShape BASE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0);
    protected static final VoxelShape WALL_NORTH = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)2.0);
    protected static final VoxelShape WALL_SOUTH = Block.m_49796_((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)12.0, (double)16.0);
    protected static final VoxelShape WALL_WEST = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)12.0, (double)16.0);
    protected static final VoxelShape WALL_EAST = Block.m_49796_((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0);
    protected static final VoxelShape SHAPE_NORTH_SOUTH = Shapes.m_83124_((VoxelShape)BASE, (VoxelShape[])new VoxelShape[]{WALL_WEST, WALL_EAST});
    protected static final VoxelShape SHAPE_EAST_WEST = Shapes.m_83124_((VoxelShape)BASE, (VoxelShape[])new VoxelShape[]{WALL_NORTH, WALL_SOUTH});
    private static final VoxelShape[] SHAPE_CACHE = new VoxelShape[4];

    public AbstractAqueductBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)LOCKED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, LOCKED, WATERLOGGED});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        return SHAPE_CACHE[facing.m_122416_()];
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Direction facing = context.m_8125_();
        facing = this.getAlignedDirection(level, pos, facing);
        FluidState fluidState = level.m_6425_(pos);
        boolean waterlogged = fluidState.m_76152_() == Fluids.f_76193_;
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)facing)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged));
    }

    private Direction getAlignedDirection(Level level, BlockPos pos, Direction defaultFacing) {
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            Direction adjacentFacing;
            BlockPos adjacentPos = pos.m_121945_(dir);
            BlockState adjacentState = level.m_8055_(adjacentPos);
            if (!(adjacentState.m_60734_() instanceof AbstractAqueductBlock) || (adjacentFacing = (Direction)adjacentState.m_61143_((Property)FACING)).m_122434_() != dir.m_122434_()) continue;
            return adjacentFacing;
        }
        return defaultFacing;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack heldItem = player.m_21120_(hand);
        if (!heldItem.m_41619_() && FluidUtil.getFluidHandler((ItemStack)heldItem).isPresent()) {
            if (!level.f_46443_) {
                return this.handleFluidInteraction(level, pos, player, hand);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private InteractionResult handleFluidInteraction(Level level, BlockPos pos, Player player, InteractionHand hand) {
        return this.onBlockEntityUse((BlockGetter)level, pos, be -> {
            try {
                IFluidHandler tankHandler = (IFluidHandler)be.getCapability(ForgeCapabilities.FLUID_HANDLER, null).orElse(null);
                if (tankHandler == null) {
                    return InteractionResult.PASS;
                }
                boolean success = FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (IFluidHandler)tankHandler);
                if (success) {
                    level.m_5594_(null, pos, SoundEvents.f_11778_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    return InteractionResult.SUCCESS;
                }
                return InteractionResult.PASS;
            }
            catch (Exception e) {
                return InteractionResult.PASS;
            }
        });
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        if (!level.f_46443_) {
            Direction currentFacing = (Direction)state.m_61143_((Property)FACING);
            Direction newFacing = currentFacing.m_122424_();
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)FACING, (Comparable)newFacing), 3);
            level.m_5594_(null, pos, SoundEvents.f_12017_, SoundSource.BLOCKS, 0.5f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.SUCCESS;
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (!level.f_46443_) {
            this.updateRedstoneState(state, level, pos);
        }
    }

    private void updateRedstoneState(BlockState state, Level level, BlockPos pos) {
        boolean locked;
        boolean powered = level.m_276867_(pos);
        if (powered != (locked = ((Boolean)state.m_61143_((Property)LOCKED)).booleanValue())) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)LOCKED, (Comparable)Boolean.valueOf(powered)), 3);
            this.withBlockEntityDo((BlockGetter)level, pos, be -> be.setLocked(powered));
        }
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.m_6807_(state, level, pos, oldState, isMoving);
        if (!level.f_46443_) {
            this.notifyNeighborAqueducts(level, pos);
        }
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            if (!level.f_46443_) {
                this.notifyNeighborAqueducts(level, pos);
            }
            IBE.onRemove((BlockState)state, (Level)level, (BlockPos)pos, (BlockState)newState);
        }
    }

    private void notifyNeighborAqueducts(Level level, BlockPos pos) {
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            BlockPos neighborPos = pos.m_121945_(dir);
            BlockState neighborState = level.m_8055_(neighborPos);
            if (!(neighborState.m_60734_() instanceof AbstractAqueductBlock)) continue;
            level.m_7260_(neighborPos, neighborState, neighborState, 3);
        }
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return super.m_7417_(state, direction, neighborState, level, currentPos, neighborPos);
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        return this.getBlockEntityOptional((BlockGetter)level, pos).map(be -> (int)(15.0f * be.getFluidLevel())).orElse(0);
    }

    static {
        AbstractAqueductBlock.SHAPE_CACHE[Direction.NORTH.m_122416_()] = SHAPE_NORTH_SOUTH;
        AbstractAqueductBlock.SHAPE_CACHE[Direction.SOUTH.m_122416_()] = SHAPE_NORTH_SOUTH;
        AbstractAqueductBlock.SHAPE_CACHE[Direction.EAST.m_122416_()] = SHAPE_EAST_WEST;
        AbstractAqueductBlock.SHAPE_CACHE[Direction.WEST.m_122416_()] = SHAPE_EAST_WEST;
    }
}

