/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.fluid.block.Aqueduct;

import com.adonis.fluid.block.Aqueduct.AbstractAqueductBlock;
import com.adonis.fluid.block.Aqueduct.AbstractAqueductBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.renderer.SmartBlockEntityRenderer;
import net.createmod.catnip.render.FluidRenderHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class AqueductRenderer
extends SmartBlockEntityRenderer<AbstractAqueductBlockEntity> {
    public AqueductRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected void renderSafe(AbstractAqueductBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        super.renderSafe((SmartBlockEntity)be, partialTicks, ms, buffer, light, overlay);
        FluidStack fluidStack = be.getFluid();
        if (fluidStack.isEmpty()) {
            return;
        }
        float fluidLevel = be.getRenderedFluidLevel(partialTicks);
        if (fluidLevel <= 0.0f) {
            return;
        }
        BlockState state = be.m_58900_();
        Direction facing = (Direction)state.m_61143_((Property)AbstractAqueductBlock.FACING);
        this.renderTrapezoidalFluid(be, fluidStack, fluidLevel, facing, partialTicks, ms, buffer, light);
    }

    private void renderTrapezoidalFluid(AbstractAqueductBlockEntity be, FluidStack fluidStack, float level, Direction facing, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light) {
        Fluid fluid = fluidStack.getFluid();
        IClientFluidTypeExtensions clientFluid = IClientFluidTypeExtensions.of((Fluid)fluid);
        TextureAtlasSprite stillTexture = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(clientFluid.getStillTexture(fluidStack));
        int color = clientFluid.getTintColor(fluidStack);
        VertexConsumer builder = buffer.m_6299_(RenderType.m_110466_());
        float baseY = 0.25f;
        float maxHeight = 0.375f;
        float currentY = baseY + maxHeight * level;
        boolean isNorthSouth = facing == Direction.NORTH || facing == Direction.SOUTH;
        ms.m_85836_();
        if (isNorthSouth) {
            this.renderNorthSouthFluid(builder, ms, stillTexture, currentY, baseY, light, color);
        } else {
            this.renderEastWestFluid(builder, ms, stillTexture, currentY, baseY, light, color);
        }
        ms.m_85849_();
    }

    private void renderNorthSouthFluid(VertexConsumer builder, PoseStack ms, TextureAtlasSprite texture, float topY, float bottomY, int light, int color) {
        float wallThickness = 0.125f;
        float bottomMinX = 0.28125f;
        float bottomMaxX = 0.71875f;
        float topMinX = wallThickness + 0.03125f;
        float topMaxX = 1.0f - wallThickness - 0.03125f;
        float zMin = 0.0625f;
        float zMax = 0.9375f;
        FluidRenderHelper.renderStillTiledFace((Direction)Direction.UP, (float)topMinX, (float)zMin, (float)topMaxX, (float)zMax, (float)topY, (VertexConsumer)builder, (PoseStack)ms, (int)light, (int)color, (TextureAtlasSprite)texture);
        if (bottomY > 0.0f) {
            FluidRenderHelper.renderStillTiledFace((Direction)Direction.DOWN, (float)bottomMinX, (float)zMin, (float)bottomMaxX, (float)zMax, (float)bottomY, (VertexConsumer)builder, (PoseStack)ms, (int)light, (int)color, (TextureAtlasSprite)texture);
        }
        this.renderNorthSouthSides(builder, ms, texture, bottomMinX, bottomMaxX, topMinX, topMaxX, bottomY, topY, zMin, zMax, light, color);
    }

    private void renderEastWestFluid(VertexConsumer builder, PoseStack ms, TextureAtlasSprite texture, float topY, float bottomY, int light, int color) {
        float wallThickness = 0.125f;
        float bottomMinZ = 0.28125f;
        float bottomMaxZ = 0.71875f;
        float topMinZ = wallThickness + 0.03125f;
        float topMaxZ = 1.0f - wallThickness - 0.03125f;
        float xMin = 0.0625f;
        float xMax = 0.9375f;
        FluidRenderHelper.renderStillTiledFace((Direction)Direction.UP, (float)xMin, (float)topMinZ, (float)xMax, (float)topMaxZ, (float)topY, (VertexConsumer)builder, (PoseStack)ms, (int)light, (int)color, (TextureAtlasSprite)texture);
        if (bottomY > 0.0f) {
            FluidRenderHelper.renderStillTiledFace((Direction)Direction.DOWN, (float)xMin, (float)bottomMinZ, (float)xMax, (float)bottomMaxZ, (float)bottomY, (VertexConsumer)builder, (PoseStack)ms, (int)light, (int)color, (TextureAtlasSprite)texture);
        }
        this.renderEastWestSides(builder, ms, texture, bottomMinZ, bottomMaxZ, topMinZ, topMaxZ, bottomY, topY, xMin, xMax, light, color);
    }

    private void renderNorthSouthSides(VertexConsumer builder, PoseStack ms, TextureAtlasSprite texture, float bottomMinX, float bottomMaxX, float topMinX, float topMaxX, float bottomY, float topY, float zMin, float zMax, int light, int color) {
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float minU = texture.m_118409_();
        float maxU = texture.m_118410_();
        float minV = texture.m_118411_();
        float maxV = texture.m_118412_();
        this.renderQuad(builder, ms, topMinX, topY, zMax, topMinX, topY, zMin, bottomMinX, bottomY, zMin, bottomMinX, bottomY, zMax, minU, minV, maxU, maxV, r * 0.6f, g * 0.6f, b * 0.6f, a, light);
        this.renderQuad(builder, ms, topMaxX, topY, zMin, topMaxX, topY, zMax, bottomMaxX, bottomY, zMax, bottomMaxX, bottomY, zMin, minU, minV, maxU, maxV, r * 0.6f, g * 0.6f, b * 0.6f, a, light);
        if (zMin > 0.0f) {
            this.renderQuad(builder, ms, topMinX, topY, zMin, topMaxX, topY, zMin, bottomMaxX, bottomY, zMin, bottomMinX, bottomY, zMin, minU, minV, maxU, maxV, r * 0.8f, g * 0.8f, b * 0.8f, a, light);
        }
        if (zMax < 1.0f) {
            this.renderQuad(builder, ms, topMaxX, topY, zMax, topMinX, topY, zMax, bottomMinX, bottomY, zMax, bottomMaxX, bottomY, zMax, minU, minV, maxU, maxV, r * 0.8f, g * 0.8f, b * 0.8f, a, light);
        }
    }

    private void renderEastWestSides(VertexConsumer builder, PoseStack ms, TextureAtlasSprite texture, float bottomMinZ, float bottomMaxZ, float topMinZ, float topMaxZ, float bottomY, float topY, float xMin, float xMax, int light, int color) {
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float minU = texture.m_118409_();
        float maxU = texture.m_118410_();
        float minV = texture.m_118411_();
        float maxV = texture.m_118412_();
        this.renderQuad(builder, ms, xMin, topY, topMinZ, xMax, topY, topMinZ, xMax, bottomY, bottomMinZ, xMin, bottomY, bottomMinZ, minU, minV, maxU, maxV, r * 0.6f, g * 0.6f, b * 0.6f, a, light);
        this.renderQuad(builder, ms, xMin, bottomY, bottomMaxZ, xMax, bottomY, bottomMaxZ, xMax, topY, topMaxZ, xMin, topY, topMaxZ, minU, minV, maxU, maxV, r * 0.6f, g * 0.6f, b * 0.6f, a, light);
        if (xMin > 0.0f) {
            this.renderQuad(builder, ms, xMin, bottomY, bottomMinZ, xMin, bottomY, bottomMaxZ, xMin, topY, topMaxZ, xMin, topY, topMinZ, minU, minV, maxU, maxV, r * 0.8f, g * 0.8f, b * 0.8f, a, light);
        }
        if (xMax < 1.0f) {
            this.renderQuad(builder, ms, xMax, topY, topMinZ, xMax, topY, topMaxZ, xMax, bottomY, bottomMaxZ, xMax, bottomY, bottomMinZ, minU, minV, maxU, maxV, r * 0.8f, g * 0.8f, b * 0.8f, a, light);
        }
    }

    private void renderQuad(VertexConsumer builder, PoseStack ms, float x1, float y1, float z1, float x2, float y2, float z2, float x3, float y3, float z3, float x4, float y4, float z4, float minU, float minV, float maxU, float maxV, float r, float g, float b, float a, int light) {
        Matrix4f pose = ms.m_85850_().m_252922_();
        Matrix3f normal = ms.m_85850_().m_252943_();
        float e1y = y2 - y1;
        float e2z = z4 - z1;
        float e1z = z2 - z1;
        float e2y = y4 - y1;
        float nx = e1y * e2z - e1z * e2y;
        float e2x = x4 - x1;
        float e1x = x2 - x1;
        float ny = e1z * e2x - e1x * e2z;
        float nz = e1x * e2y - e1y * e2x;
        float length = (float)Math.sqrt(nx * nx + ny * ny + nz * nz);
        if (length > 1.0E-4f) {
            nx /= length;
            ny /= length;
            nz /= length;
        }
        builder.m_252986_(pose, x1, y1, z1).m_85950_(r, g, b, a).m_7421_(minU, minV).m_7122_(0, 10).m_85969_(light).m_252939_(normal, nx, ny, nz).m_5752_();
        builder.m_252986_(pose, x2, y2, z2).m_85950_(r, g, b, a).m_7421_(maxU, minV).m_7122_(0, 10).m_85969_(light).m_252939_(normal, nx, ny, nz).m_5752_();
        builder.m_252986_(pose, x3, y3, z3).m_85950_(r, g, b, a).m_7421_(maxU, maxV).m_7122_(0, 10).m_85969_(light).m_252939_(normal, nx, ny, nz).m_5752_();
        builder.m_252986_(pose, x4, y4, z4).m_85950_(r, g, b, a).m_7421_(minU, maxV).m_7122_(0, 10).m_85969_(light).m_252939_(normal, nx, ny, nz).m_5752_();
    }
}

