/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.fluid.block.SmartFluidInterface;

import com.adonis.fluid.block.SmartFluidInterface.SmartFluidInterfaceBlockEntity;
import com.adonis.fluid.registry.CFBlockEntity;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.fluids.tank.CreativeFluidTankBlockEntity;
import com.simibubi.create.content.fluids.transfer.GenericItemEmptying;
import com.simibubi.create.content.fluids.transfer.GenericItemFilling;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.fluid.FluidHelper;
import javax.annotation.Nullable;
import net.createmod.catnip.data.Pair;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class SmartFluidInterfaceBlock
extends HorizontalDirectionalBlock
implements IBE<SmartFluidInterfaceBlockEntity>,
IWrenchable {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    private static final VoxelShape NORTH_LAYER_1 = Block.m_49796_((double)3.0, (double)3.0, (double)14.0, (double)13.0, (double)12.9, (double)16.0);
    private static final VoxelShape NORTH_LAYER_2 = Block.m_49796_((double)4.0, (double)4.0, (double)13.0, (double)12.0, (double)12.0, (double)14.0);
    private static final VoxelShape NORTH_LAYER_3 = Block.m_49796_((double)5.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0, (double)13.0);
    private static final VoxelShape NORTH_SHAPE = Shapes.m_83124_((VoxelShape)NORTH_LAYER_1, (VoxelShape[])new VoxelShape[]{NORTH_LAYER_2, NORTH_LAYER_3});
    private static final VoxelShape SOUTH_LAYER_1 = Block.m_49796_((double)3.0, (double)3.0, (double)0.0, (double)13.0, (double)12.9, (double)2.0);
    private static final VoxelShape SOUTH_LAYER_2 = Block.m_49796_((double)4.0, (double)4.0, (double)2.0, (double)12.0, (double)12.0, (double)3.0);
    private static final VoxelShape SOUTH_LAYER_3 = Block.m_49796_((double)5.0, (double)5.0, (double)3.0, (double)11.0, (double)11.0, (double)5.0);
    private static final VoxelShape SOUTH_SHAPE = Shapes.m_83124_((VoxelShape)SOUTH_LAYER_1, (VoxelShape[])new VoxelShape[]{SOUTH_LAYER_2, SOUTH_LAYER_3});
    private static final VoxelShape EAST_LAYER_1 = Block.m_49796_((double)0.0, (double)3.0, (double)3.0, (double)2.0, (double)12.9, (double)13.0);
    private static final VoxelShape EAST_LAYER_2 = Block.m_49796_((double)2.0, (double)4.0, (double)4.0, (double)3.0, (double)12.0, (double)12.0);
    private static final VoxelShape EAST_LAYER_3 = Block.m_49796_((double)3.0, (double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)11.0);
    private static final VoxelShape EAST_SHAPE = Shapes.m_83124_((VoxelShape)EAST_LAYER_1, (VoxelShape[])new VoxelShape[]{EAST_LAYER_2, EAST_LAYER_3});
    private static final VoxelShape WEST_LAYER_1 = Block.m_49796_((double)14.0, (double)3.0, (double)3.0, (double)16.0, (double)12.9, (double)13.0);
    private static final VoxelShape WEST_LAYER_2 = Block.m_49796_((double)13.0, (double)4.0, (double)4.0, (double)14.0, (double)12.0, (double)12.0);
    private static final VoxelShape WEST_LAYER_3 = Block.m_49796_((double)11.0, (double)5.0, (double)5.0, (double)13.0, (double)11.0, (double)11.0);
    private static final VoxelShape WEST_SHAPE = Shapes.m_83124_((VoxelShape)WEST_LAYER_1, (VoxelShape[])new VoxelShape[]{WEST_LAYER_2, WEST_LAYER_3});

    public SmartFluidInterfaceBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            case Direction.NORTH -> NORTH_SHAPE;
            case Direction.SOUTH -> SOUTH_SHAPE;
            case Direction.EAST -> EAST_SHAPE;
            case Direction.WEST -> WEST_SHAPE;
            default -> NORTH_SHAPE;
        };
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.m_5940_(state, level, pos, context);
    }

    private boolean hasFluidCapability(LevelReader level, BlockPos pos, Direction fromDirection) {
        BlockState blockState = level.m_8055_(pos);
        if (blockState.m_204336_(BlockTags.f_13035_)) {
            return true;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity == null) {
            return false;
        }
        IFluidHandler capability = (IFluidHandler)blockEntity.getCapability(ForgeCapabilities.FLUID_HANDLER, fromDirection).orElse(null);
        if (capability != null && capability.getTanks() > 0) {
            return true;
        }
        capability = (IFluidHandler)blockEntity.getCapability(ForgeCapabilities.FLUID_HANDLER, null).orElse(null);
        return capability != null && capability.getTanks() > 0;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction direction = context.m_8125_().m_122424_();
        BlockPos blockpos = context.m_8083_();
        BlockPos attachedPos = blockpos.m_121945_(direction.m_122424_());
        if (this.hasFluidCapability((LevelReader)context.m_43725_(), attachedPos, direction)) {
            return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)direction);
        }
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            BlockPos testPos = blockpos.m_121945_(dir.m_122424_());
            if (!this.hasFluidCapability((LevelReader)context.m_43725_(), testPos, dir)) continue;
            return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)dir);
        }
        return null;
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        BlockPos attachedPos = pos.m_121945_(direction.m_122424_());
        BlockState attachedState = level.m_8055_(attachedPos);
        if (attachedState.m_204336_(BlockTags.f_13035_)) {
            return true;
        }
        return this.hasFluidCapability(level, attachedPos, direction);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        if (direction.m_122424_() == state.m_61143_((Property)FACING) && !state.m_60710_((LevelReader)level, currentPos)) {
            return Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(state, direction, neighborState, level, currentPos, neighborPos);
    }

    public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    public float m_7749_(BlockState state, BlockGetter level, BlockPos pos) {
        return 1.0f;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        SoundEvent soundevent;
        WaterloggedBlockFluidHandler tankCapability;
        if (level.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        if (player instanceof FakePlayer) {
            return InteractionResult.PASS;
        }
        ItemStack stack = player.m_21120_(hand);
        if (!GenericItemEmptying.canItemBeEmptied((Level)level, (ItemStack)stack) && !GenericItemFilling.canItemBeFilled((Level)level, (ItemStack)stack)) {
            return InteractionResult.PASS;
        }
        Direction attachedDirection = ((Direction)state.m_61143_((Property)FACING)).m_122424_();
        BlockPos targetPos = pos.m_121945_(attachedDirection);
        BlockState targetState = level.m_8055_(targetPos);
        if (targetState.m_204336_(BlockTags.f_13035_) && targetState.m_61138_((Property)BlockStateProperties.f_61362_) && ((Boolean)targetState.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
            tankCapability = new WaterloggedBlockFluidHandler();
        } else {
            BlockEntity targetBlockEntity = level.m_7702_(targetPos);
            if (targetBlockEntity == null) {
                return InteractionResult.FAIL;
            }
            tankCapability = (IFluidHandler)targetBlockEntity.getCapability(ForgeCapabilities.FLUID_HANDLER, (Direction)state.m_61143_((Property)FACING)).orElse(null);
            if (tankCapability == null) {
                tankCapability = (IFluidHandler)targetBlockEntity.getCapability(ForgeCapabilities.FLUID_HANDLER, null).orElse(null);
            }
        }
        if (tankCapability == null) {
            return InteractionResult.FAIL;
        }
        FilteringBehaviour filter = (FilteringBehaviour)BlockEntityBehaviour.get((BlockGetter)level, (BlockPos)pos, (BehaviourType)FilteringBehaviour.TYPE);
        if (filter == null) {
            return InteractionResult.FAIL;
        }
        FluidHelper.FluidExchange exchange = null;
        FluidStack fluidStack = FluidStack.EMPTY;
        if (GenericItemEmptying.canItemBeEmptied((Level)level, (ItemStack)stack) && !(fluidStack = this.tryEmptyItem(level, player, hand, stack, targetPos, tankCapability, filter)).isEmpty()) {
            exchange = FluidHelper.FluidExchange.ITEM_TO_TANK;
        }
        if (exchange == null && GenericItemFilling.canItemBeFilled((Level)level, (ItemStack)stack) && !(fluidStack = this.tryFillItem(level, player, hand, stack, targetPos, tankCapability, filter)).isEmpty()) {
            exchange = FluidHelper.FluidExchange.TANK_TO_ITEM;
        }
        if (exchange == null) {
            return InteractionResult.FAIL;
        }
        switch (exchange) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case ITEM_TO_TANK: {
                SoundEvent soundEvent = FluidHelper.getEmptySound((FluidStack)fluidStack);
                break;
            }
            case TANK_TO_ITEM: {
                SoundEvent soundEvent = soundevent = FluidHelper.getFillSound((FluidStack)fluidStack);
            }
        }
        if (soundevent != null) {
            float pitch = Mth.m_14036_((float)(1.0f - (float)fluidStack.getAmount() / 16000.0f), (float)0.0f, (float)1.0f);
            pitch /= 1.5f;
            pitch += 0.5f;
            level.m_5594_(null, pos, soundevent, SoundSource.BLOCKS, 0.5f, pitch += (level.f_46441_.m_188501_() - 0.5f) / 4.0f);
        }
        return InteractionResult.SUCCESS;
    }

    private FluidStack tryEmptyItem(Level level, Player player, InteractionHand hand, ItemStack stack, BlockPos targetPos, IFluidHandler capability, FilteringBehaviour filter) {
        if (!GenericItemEmptying.canItemBeEmptied((Level)level, (ItemStack)stack)) {
            return FluidStack.EMPTY;
        }
        ItemStack copy = stack.m_41777_();
        Pair result = GenericItemEmptying.emptyItem((Level)level, (ItemStack)copy, (boolean)true);
        FluidStack fluidStack = (FluidStack)result.getFirst();
        if (fluidStack.isEmpty()) {
            return FluidStack.EMPTY;
        }
        if (!filter.test(fluidStack)) {
            return FluidStack.EMPTY;
        }
        int filled = capability.fill(fluidStack, IFluidHandler.FluidAction.SIMULATE);
        if (filled != fluidStack.getAmount()) {
            return FluidStack.EMPTY;
        }
        if (level.f_46443_) {
            return fluidStack;
        }
        copy = stack.m_41777_();
        result = GenericItemEmptying.emptyItem((Level)level, (ItemStack)copy, (boolean)false);
        ItemStack resultItem = (ItemStack)result.getSecond();
        capability.fill(fluidStack.copy(), IFluidHandler.FluidAction.EXECUTE);
        BlockEntity targetBlockEntity = level.m_7702_(targetPos);
        if (targetBlockEntity != null) {
            targetBlockEntity.m_6596_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_7726_().m_8450_(targetPos);
            }
        }
        if (!player.m_7500_() && !(targetBlockEntity instanceof CreativeFluidTankBlockEntity)) {
            if (stack.m_41613_() == 1) {
                player.m_21008_(hand, resultItem);
            } else {
                stack.m_41774_(1);
                player.m_150109_().m_150079_(resultItem);
            }
        }
        return fluidStack;
    }

    private FluidStack tryFillItem(Level level, Player player, InteractionHand hand, ItemStack stack, BlockPos targetPos, IFluidHandler capability, FilteringBehaviour filter) {
        if (!GenericItemFilling.canItemBeFilled((Level)level, (ItemStack)stack)) {
            return FluidStack.EMPTY;
        }
        BlockEntity targetBlockEntity = level.m_7702_(targetPos);
        for (int i = 0; i < capability.getTanks(); ++i) {
            int requiredAmount;
            FluidStack fluidStack = capability.getFluidInTank(i);
            if (fluidStack.isEmpty() || !filter.test(fluidStack) || (requiredAmount = GenericItemFilling.getRequiredAmountForItem((Level)level, (ItemStack)stack, (FluidStack)fluidStack.copy())) == -1 || requiredAmount > fluidStack.getAmount()) continue;
            if (level.f_46443_) {
                return fluidStack;
            }
            ItemStack fillStack = stack;
            if (player.m_7500_() || targetBlockEntity instanceof CreativeFluidTankBlockEntity) {
                fillStack = stack.m_41777_();
            }
            ItemStack result = GenericItemFilling.fillItem((Level)level, (int)requiredAmount, (ItemStack)fillStack, (FluidStack)fluidStack.copy());
            FluidStack drainFluid = fluidStack.copy();
            drainFluid.setAmount(requiredAmount);
            capability.drain(drainFluid, IFluidHandler.FluidAction.EXECUTE);
            if (!player.m_7500_()) {
                if (stack.m_41613_() == 1 && result.m_41613_() == 1) {
                    player.m_21008_(hand, result);
                } else {
                    stack.m_41774_(1);
                    player.m_150109_().m_150079_(result);
                }
            }
            if (targetBlockEntity != null) {
                targetBlockEntity.m_6596_();
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    serverLevel.m_7726_().m_8450_(targetPos);
                }
            }
            return drainFluid;
        }
        return FluidStack.EMPTY;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        IBE.onRemove((BlockState)state, (Level)level, (BlockPos)pos, (BlockState)newState);
    }

    public Class<SmartFluidInterfaceBlockEntity> getBlockEntityClass() {
        return SmartFluidInterfaceBlockEntity.class;
    }

    public BlockEntityType<? extends SmartFluidInterfaceBlockEntity> getBlockEntityType() {
        return (BlockEntityType)CFBlockEntity.SMART_FLUID_INTERFACE.get();
    }

    private static class WaterloggedBlockFluidHandler
    implements IFluidHandler {
        private static final FluidStack WATER = new FluidStack((Fluid)Fluids.f_76193_, 1000);

        private WaterloggedBlockFluidHandler() {
        }

        public int getTanks() {
            return 1;
        }

        public FluidStack getFluidInTank(int tank) {
            return WATER.copy();
        }

        public int getTankCapacity(int tank) {
            return Integer.MAX_VALUE;
        }

        public boolean isFluidValid(int tank, FluidStack stack) {
            return false;
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            return 0;
        }

        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            if (resource.getFluid() == Fluids.f_76193_) {
                return new FluidStack((Fluid)Fluids.f_76193_, Math.min(resource.getAmount(), 1000));
            }
            return FluidStack.EMPTY;
        }

        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            return new FluidStack((Fluid)Fluids.f_76193_, Math.min(maxDrain, 1000));
        }
    }
}

