/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.fluid.config;

import com.simibubi.create.api.stress.BlockStressValues;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.util.nullness.NonNullUnaryOperator;
import java.util.HashMap;
import java.util.Map;
import java.util.function.DoubleSupplier;
import javax.annotation.Nullable;
import net.createmod.catnip.config.ConfigBase;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.registries.ForgeRegistries;

public class CFStress
extends ConfigBase {
    private final String modId;
    private final Map<ResourceLocation, Double> defaultImpacts = new HashMap<ResourceLocation, Double>();
    private final Map<ResourceLocation, Double> defaultCapacities = new HashMap<ResourceLocation, Double>();
    private final Map<ResourceLocation, ForgeConfigSpec.ConfigValue<Double>> impacts = new HashMap<ResourceLocation, ForgeConfigSpec.ConfigValue<Double>>();
    private final Map<ResourceLocation, ForgeConfigSpec.ConfigValue<Double>> capacities = new HashMap<ResourceLocation, ForgeConfigSpec.ConfigValue<Double>>();

    public CFStress(String modId) {
        this.modId = modId;
    }

    protected int getVersion() {
        return 1;
    }

    public void registerAll(ForgeConfigSpec.Builder builder) {
        builder.comment(new String[]{"Stress impact configurations for " + this.modId, "[in Stress Units]"}).push("impact");
        this.defaultImpacts.forEach((id, defaultValue) -> this.impacts.put((ResourceLocation)id, (ForgeConfigSpec.ConfigValue<Double>)builder.define(id.m_135815_(), defaultValue)));
        builder.pop();
        if (!this.defaultCapacities.isEmpty()) {
            builder.comment(new String[]{"Stress capacity configurations for " + this.modId, "[in Stress Units]"}).push("capacity");
            this.defaultCapacities.forEach((id, defaultValue) -> this.capacities.put((ResourceLocation)id, (ForgeConfigSpec.ConfigValue<Double>)builder.define(id.m_135815_(), defaultValue)));
            builder.pop();
        }
        BlockStressValues.IMPACTS.registerProvider(this::getImpact);
        BlockStressValues.CAPACITIES.registerProvider(this::getCapacity);
    }

    public String getName() {
        return this.modId + "-stressValues.v" + this.getVersion();
    }

    @Nullable
    public DoubleSupplier getImpact(Block block) {
        ResourceLocation id = ForgeRegistries.BLOCKS.getKey((Object)block);
        if (id == null || !id.m_135827_().equals(this.modId)) {
            return null;
        }
        ForgeConfigSpec.ConfigValue<Double> configValue = this.impacts.get(id);
        return configValue == null ? null : () -> configValue.get();
    }

    @Nullable
    public DoubleSupplier getCapacity(Block block) {
        ResourceLocation id = ForgeRegistries.BLOCKS.getKey((Object)block);
        if (id == null || !id.m_135827_().equals(this.modId)) {
            return null;
        }
        ForgeConfigSpec.ConfigValue<Double> configValue = this.capacities.get(id);
        return configValue == null ? null : () -> configValue.get();
    }

    public <B extends Block, P> NonNullUnaryOperator<BlockBuilder<B, P>> setImpact(double value) {
        return builder -> {
            if (!builder.getOwner().getModid().equals(this.modId)) {
                throw new IllegalStateException("Attempting to set stress impact for block '" + builder.getName() + "' from mod '" + builder.getOwner().getModid() + "' using config for mod '" + this.modId + "'.");
            }
            ResourceLocation id = new ResourceLocation(this.modId, builder.getName());
            this.defaultImpacts.put(id, value);
            return builder;
        };
    }

    public <B extends Block, P> NonNullUnaryOperator<BlockBuilder<B, P>> setCapacity(double value) {
        return builder -> {
            if (!builder.getOwner().getModid().equals(this.modId)) {
                throw new IllegalStateException("Attempting to set stress capacity for block '" + builder.getName() + "' from mod '" + builder.getOwner().getModid() + "' using config for mod '" + this.modId + "'.");
            }
            ResourceLocation id = new ResourceLocation(this.modId, builder.getName());
            this.defaultCapacities.put(id, value);
            return builder;
        };
    }

    public <B extends Block, P> NonNullUnaryOperator<BlockBuilder<B, P>> setNoImpact() {
        return this.setImpact(0.0);
    }
}

