/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.fluid.content.pipette;

import com.adonis.fluid.content.pipette.DepotFluidInteractionPoint;
import com.adonis.fluid.content.pipette.ItemDrainFluidInteractionPoint;
import com.adonis.fluid.registry.CFBlocks;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.StructureTransform;
import com.simibubi.create.content.kinetics.belt.BeltBlock;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class FluidInteractionPoint {
    protected BlockPos pos;
    protected Direction face;
    protected Mode mode;
    protected Level level;
    protected long lastKnownValid = -1L;

    public FluidInteractionPoint(Level level, BlockPos pos, BlockState state) {
        this.level = level;
        this.pos = pos;
        this.face = Direction.UP;
        this.mode = FluidInteractionPoint.isBlazeBurner(state) ? Mode.DEPOSIT : (FluidInteractionPoint.isBeehive(state) ? Mode.TAKE : (AllBlocks.BELT.has(state) ? Mode.DEPOSIT : (FluidInteractionPoint.isCauldron(state) ? Mode.DEPOSIT : Mode.DEPOSIT)));
    }

    @Nullable
    public static FluidInteractionPoint create(Level level, BlockPos pos, BlockState state) {
        if (AllBlocks.DEPOT.has(state) || AllBlocks.WEIGHTED_EJECTOR.has(state)) {
            return new DepotFluidInteractionPoint(level, pos, state);
        }
        if (AllBlocks.ITEM_DRAIN.has(state)) {
            return new ItemDrainFluidInteractionPoint(level, pos, state);
        }
        if (AllBlocks.BELT.has(state)) {
            if (BeltBlock.canTransportObjects((BlockState)state)) {
                return new FluidInteractionPoint(level, pos, state){

                    @Override
                    public boolean canExtract() {
                        return false;
                    }

                    @Override
                    public boolean canInsert(FluidStack stack) {
                        return this.mode == Mode.DEPOSIT;
                    }

                    @Override
                    public FluidStack extract(int maxAmount, boolean simulate) {
                        return FluidStack.EMPTY;
                    }

                    @Override
                    public FluidStack insert(FluidStack stack, boolean simulate) {
                        return stack;
                    }

                    @Override
                    public void cycleMode() {
                        this.mode = Mode.DEPOSIT;
                    }
                };
            }
            return null;
        }
        if (FluidInteractionPoint.isCauldron(state)) {
            return new FluidInteractionPoint(level, pos, state);
        }
        if (FluidInteractionPoint.isValidFluidBlock(state)) {
            return new FluidInteractionPoint(level, pos, state);
        }
        return null;
    }

    private static boolean isValidFluidBlock(BlockState state) {
        if (AllBlocks.BELT.has(state)) {
            return BeltBlock.canTransportObjects((BlockState)state);
        }
        if (AllBlocks.DEPOT.has(state) || AllBlocks.WEIGHTED_EJECTOR.has(state)) {
            return true;
        }
        if (AllBlocks.ITEM_DRAIN.has(state)) {
            return true;
        }
        if (AllBlocks.BASIN.has(state) || CFBlocks.FLUID_INTERFACE.has(state) || CFBlocks.SMART_FLUID_INTERFACE.has(state)) {
            return true;
        }
        return FluidInteractionPoint.isBlazeBurner(state) || FluidInteractionPoint.isBeehive(state) || FluidInteractionPoint.isCauldron(state);
    }

    private static boolean isBlazeBurner(BlockState state) {
        return AllBlocks.BLAZE_BURNER.has(state) || AllBlocks.LIT_BLAZE_BURNER.has(state);
    }

    private static boolean isBeehive(BlockState state) {
        return state.getBlock() instanceof BeehiveBlock;
    }

    public static boolean isCauldron(BlockState state) {
        return state.is(Blocks.CAULDRON) || state.is(Blocks.WATER_CAULDRON) || state.is(Blocks.LAVA_CAULDRON) || state.is(Blocks.POWDER_SNOW_CAULDRON);
    }

    public boolean isValid() {
        if (this.level == null) {
            return false;
        }
        long gameTime = this.level.getGameTime();
        if (gameTime == this.lastKnownValid) {
            return true;
        }
        BlockState state = this.level.getBlockState(this.pos);
        if (AllBlocks.BELT.has(state)) {
            if (BeltBlock.canTransportObjects((BlockState)state)) {
                this.lastKnownValid = gameTime;
                return true;
            }
            return false;
        }
        if (FluidInteractionPoint.isCauldron(state)) {
            this.lastKnownValid = gameTime;
            return true;
        }
        BlockEntity be = this.level.getBlockEntity(this.pos);
        boolean valid = false;
        valid = be != null ? FluidInteractionPoint.isValidFluidBlock(state) && this.getFluidHandler() != null : FluidInteractionPoint.isValidFluidBlock(state);
        if (valid) {
            this.lastKnownValid = gameTime;
        }
        return valid;
    }

    @Nullable
    private IFluidHandler getFluidHandler() {
        BlockState state = this.level.getBlockState(this.pos);
        if (FluidInteractionPoint.isCauldron(state)) {
            return new CauldronFluidHandler(this.level, this.pos, state);
        }
        BlockEntity be = this.level.getBlockEntity(this.pos);
        if (FluidInteractionPoint.isBlazeBurner(state)) {
            return new BlazeBurnerFluidHandler(this.level, this.pos, state);
        }
        if (FluidInteractionPoint.isBeehive(state)) {
            return new BeehiveFluidHandler(this.level, this.pos, state);
        }
        if (be == null) {
            return null;
        }
        return (IFluidHandler)this.level.getCapability(Capabilities.FluidHandler.BLOCK, this.pos, (Object)this.face);
    }

    public FluidStack extract(int maxAmount, boolean simulate) {
        IFluidHandler handler = this.getFluidHandler();
        if (handler == null) {
            return FluidStack.EMPTY;
        }
        return handler.drain(maxAmount, simulate ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE);
    }

    public FluidStack insert(FluidStack stack, boolean simulate) {
        IFluidHandler handler = this.getFluidHandler();
        if (handler == null) {
            return stack;
        }
        int filled = handler.fill(stack, simulate ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE);
        FluidStack remainder = stack.copy();
        remainder.shrink(filled);
        return remainder;
    }

    public boolean canExtract() {
        BlockState state = this.level.getBlockState(this.pos);
        if (state.is(Blocks.CAULDRON)) {
            return false;
        }
        if (state.is(Blocks.WATER_CAULDRON)) {
            return (Integer)state.getValue((Property)LayeredCauldronBlock.LEVEL) == 3;
        }
        if (state.is(Blocks.LAVA_CAULDRON)) {
            return true;
        }
        if (state.is(Blocks.POWDER_SNOW_CAULDRON)) {
            return (Integer)state.getValue((Property)LayeredCauldronBlock.LEVEL) == 3;
        }
        IFluidHandler handler = this.getFluidHandler();
        if (handler == null) {
            return false;
        }
        return !handler.drain(1, IFluidHandler.FluidAction.SIMULATE).isEmpty();
    }

    public boolean canInsert(FluidStack stack) {
        IFluidHandler handler;
        BlockState state = this.level.getBlockState(this.pos);
        if (FluidInteractionPoint.isCauldron(state)) {
            if (state.is(Blocks.CAULDRON)) {
                return stack.getFluid() == Fluids.WATER || stack.getFluid() == Fluids.LAVA;
            }
            if (state.is(Blocks.WATER_CAULDRON)) {
                int level = (Integer)state.getValue((Property)LayeredCauldronBlock.LEVEL);
                return level < 3 && stack.getFluid() == Fluids.WATER;
            }
            if (state.is(Blocks.LAVA_CAULDRON)) {
                return false;
            }
            if (state.is(Blocks.POWDER_SNOW_CAULDRON)) {
                return false;
            }
        }
        if ((handler = this.getFluidHandler()) == null) {
            return false;
        }
        return handler.fill(stack, IFluidHandler.FluidAction.SIMULATE) > 0;
    }

    public void cycleMode() {
        BlockState state = this.level.getBlockState(this.pos);
        if (FluidInteractionPoint.isBlazeBurner(state) || FluidInteractionPoint.isBeehive(state)) {
            return;
        }
        this.mode = this.mode == Mode.TAKE ? Mode.DEPOSIT : Mode.TAKE;
    }

    public Mode getMode() {
        return this.mode;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public Level getLevel() {
        return this.level;
    }

    public void setLevel(Level level) {
        this.level = level;
    }

    public void keepAlive() {
        this.lastKnownValid = this.level != null ? this.level.getGameTime() : -1L;
    }

    public void updateCachedState() {
        this.lastKnownValid = -1L;
    }

    public CompoundTag serialize(BlockPos armPos) {
        CompoundTag nbt = new CompoundTag();
        nbt.put("Pos", NbtUtils.writeBlockPos((BlockPos)this.pos.subtract((Vec3i)armPos)));
        nbt.putString("Mode", this.mode.name());
        nbt.putString("Face", this.face.name());
        return nbt;
    }

    @Nullable
    public static FluidInteractionPoint deserialize(CompoundTag nbt, Level level, BlockPos armPos) {
        BlockState state;
        BlockPos pos = NbtUtils.readBlockPos((CompoundTag)nbt, (String)"Pos").orElse(BlockPos.ZERO).offset((Vec3i)armPos);
        FluidInteractionPoint point = FluidInteractionPoint.create(level, pos, state = level.getBlockState(pos));
        if (point != null) {
            if (nbt.contains("Mode")) {
                try {
                    Mode deserializedMode;
                    point.mode = deserializedMode = Mode.valueOf(nbt.getString("Mode"));
                }
                catch (IllegalArgumentException e) {
                    point.mode = Mode.DEPOSIT;
                }
            }
            if (nbt.contains("Face")) {
                try {
                    point.face = Direction.valueOf((String)nbt.getString("Face"));
                }
                catch (IllegalArgumentException e) {
                    point.face = Direction.UP;
                }
            }
        }
        return point;
    }

    public static void transformPos(CompoundTag nbt, StructureTransform transform) {
        BlockPos pos = NbtUtils.readBlockPos((CompoundTag)nbt, (String)"Pos").orElse(BlockPos.ZERO);
        pos = transform.apply(pos);
        nbt.put("Pos", NbtUtils.writeBlockPos((BlockPos)pos));
        if (nbt.contains("Face")) {
            Direction face = Direction.valueOf((String)nbt.getString("Face"));
            face = transform.mirrorFacing(face);
            face = transform.rotateFacing(face);
            nbt.putString("Face", face.name());
        }
    }

    public static enum Mode {
        TAKE("fluid.mechanical_pipette.extract", 8375776),
        DEPOSIT("fluid.mechanical_pipette.deposit", 14532966);

        private final String translationKey;
        private final int color;

        private Mode(String translationKey, int color) {
            this.translationKey = translationKey;
            this.color = color;
        }

        public String getTranslationKey() {
            return this.translationKey;
        }

        public int getColor() {
            return this.color;
        }
    }

    private static class CauldronFluidHandler
    implements IFluidHandler {
        private final Level level;
        private final BlockPos pos;
        private final BlockState state;

        public CauldronFluidHandler(Level level, BlockPos pos, BlockState state) {
            this.level = level;
            this.pos = pos;
            this.state = state;
        }

        public int getTanks() {
            return 1;
        }

        @Nonnull
        public FluidStack getFluidInTank(int tank) {
            if (this.state.is(Blocks.WATER_CAULDRON)) {
                int level = (Integer)this.state.getValue((Property)LayeredCauldronBlock.LEVEL);
                return new FluidStack((Fluid)Fluids.WATER, level * 333);
            }
            if (this.state.is(Blocks.LAVA_CAULDRON)) {
                return new FluidStack((Fluid)Fluids.LAVA, 1000);
            }
            return FluidStack.EMPTY;
        }

        public int getTankCapacity(int tank) {
            return 1000;
        }

        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            return stack.getFluid() == Fluids.WATER || stack.getFluid() == Fluids.LAVA;
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            int currentLevel;
            if (this.state.is(Blocks.CAULDRON)) {
                if (resource.getFluid() == Fluids.WATER && resource.getAmount() >= 250) {
                    if (action.execute()) {
                        this.level.setBlock(this.pos, (BlockState)Blocks.WATER_CAULDRON.defaultBlockState().setValue((Property)LayeredCauldronBlock.LEVEL, (Comparable)Integer.valueOf(1)), 3);
                    }
                    return 250;
                }
                if (resource.getFluid() == Fluids.LAVA && resource.getAmount() >= 1000) {
                    if (action.execute()) {
                        this.level.setBlock(this.pos, Blocks.LAVA_CAULDRON.defaultBlockState(), 3);
                    }
                    return 1000;
                }
            } else if (this.state.is(Blocks.WATER_CAULDRON) && (currentLevel = ((Integer)this.state.getValue((Property)LayeredCauldronBlock.LEVEL)).intValue()) < 3 && resource.getFluid() == Fluids.WATER && resource.getAmount() >= 250) {
                if (action.execute()) {
                    this.level.setBlock(this.pos, (BlockState)this.state.setValue((Property)LayeredCauldronBlock.LEVEL, (Comparable)Integer.valueOf(currentLevel + 1)), 3);
                }
                return 250;
            }
            return 0;
        }

        @Nonnull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            FluidStack inTank = this.getFluidInTank(0);
            if (inTank.isEmpty() || !inTank.getFluid().equals(resource.getFluid())) {
                return FluidStack.EMPTY;
            }
            return this.drain(resource.getAmount(), action);
        }

        @Nonnull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            if (this.state.is(Blocks.WATER_CAULDRON)) {
                int level = (Integer)this.state.getValue((Property)LayeredCauldronBlock.LEVEL);
                if (level == 3 && maxDrain >= 1000) {
                    if (action.execute()) {
                        this.level.setBlock(this.pos, Blocks.CAULDRON.defaultBlockState(), 3);
                    }
                    return new FluidStack((Fluid)Fluids.WATER, 1000);
                }
            } else if (this.state.is(Blocks.LAVA_CAULDRON) && maxDrain >= 1000) {
                if (action.execute()) {
                    this.level.setBlock(this.pos, Blocks.CAULDRON.defaultBlockState(), 3);
                }
                return new FluidStack((Fluid)Fluids.LAVA, 1000);
            }
            return FluidStack.EMPTY;
        }
    }

    private static class BlazeBurnerFluidHandler
    implements IFluidHandler {
        private final Level level;
        private final BlockPos pos;
        private final BlockState state;

        public BlazeBurnerFluidHandler(Level level, BlockPos pos, BlockState state) {
            this.level = level;
            this.pos = pos;
            this.state = state;
        }

        public int getTanks() {
            return 1;
        }

        @Nonnull
        public FluidStack getFluidInTank(int tank) {
            return FluidStack.EMPTY;
        }

        public int getTankCapacity(int tank) {
            return 1000;
        }

        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            return stack.getFluid() == Fluids.LAVA;
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            if (!this.isFluidValid(0, resource)) {
                return 0;
            }
            ItemStack lavaBucket = new ItemStack((ItemLike)Items.LAVA_BUCKET);
            try {
                InteractionResultHolder result = BlazeBurnerBlock.tryInsert((BlockState)this.state, (Level)this.level, (BlockPos)this.pos, (ItemStack)lavaBucket, (boolean)true, (boolean)false, (boolean)true);
                if (result.getResult() == InteractionResult.SUCCESS) {
                    if (action.execute()) {
                        BlazeBurnerBlock.tryInsert((BlockState)this.state, (Level)this.level, (BlockPos)this.pos, (ItemStack)lavaBucket, (boolean)true, (boolean)false, (boolean)false);
                    }
                    return Math.min(resource.getAmount(), 1000);
                }
            }
            catch (Exception e) {
                return 0;
            }
            return 0;
        }

        @Nonnull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            return FluidStack.EMPTY;
        }

        @Nonnull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            return FluidStack.EMPTY;
        }
    }

    private static class BeehiveFluidHandler
    implements IFluidHandler {
        private final Level level;
        private final BlockPos pos;
        private final BlockState state;

        public BeehiveFluidHandler(Level level, BlockPos pos, BlockState state) {
            this.level = level;
            this.pos = pos;
            this.state = state;
        }

        private Fluid getHoneyFluid() {
            try {
                ResourceLocation honeyLocation = ResourceLocation.fromNamespaceAndPath((String)"create", (String)"honey");
                Registry registry = this.level.registryAccess().registryOrThrow(Registries.FLUID);
                Fluid honeyFluid = (Fluid)registry.get(honeyLocation);
                if (honeyFluid != null && honeyFluid != Fluids.EMPTY) {
                    return honeyFluid;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return Fluids.WATER;
        }

        public int getTanks() {
            return 1;
        }

        @Nonnull
        public FluidStack getFluidInTank(int tank) {
            if (this.isHoneyFull()) {
                return new FluidStack(this.getHoneyFluid(), 250);
            }
            return FluidStack.EMPTY;
        }

        public int getTankCapacity(int tank) {
            return 250;
        }

        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            return false;
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            return 0;
        }

        @Nonnull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            if (!resource.isEmpty() && resource.getFluid() == this.getHoneyFluid()) {
                return this.drain(resource.getAmount(), action);
            }
            return FluidStack.EMPTY;
        }

        @Nonnull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            if (!this.isHoneyFull()) {
                return FluidStack.EMPTY;
            }
            int drainAmount = Math.min(maxDrain, 250);
            FluidStack result = new FluidStack(this.getHoneyFluid(), drainAmount);
            if (action.execute()) {
                try {
                    BeehiveBlock beehiveBlock = (BeehiveBlock)this.state.getBlock();
                    beehiveBlock.resetHoneyLevel(this.level, this.state, this.pos);
                }
                catch (Exception e) {
                    this.level.setBlock(this.pos, (BlockState)this.state.setValue((Property)BlockStateProperties.LEVEL_HONEY, (Comparable)Integer.valueOf(0)), 3);
                }
            }
            return result;
        }

        private boolean isHoneyFull() {
            try {
                BlockState currentState = this.level.getBlockState(this.pos);
                if (currentState.hasProperty((Property)BlockStateProperties.LEVEL_HONEY)) {
                    return (Integer)currentState.getValue((Property)BlockStateProperties.LEVEL_HONEY) >= 5;
                }
            }
            catch (Exception e) {
                return false;
            }
            return false;
        }
    }
}

