/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.fluid.item;

import com.adonis.fluid.content.pipette.FluidInteractionPoint;
import com.adonis.fluid.packet.PipetteFluidPlacementPacket;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class PipetteItem
extends BlockItem {
    public PipetteItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    public InteractionResult useOn(UseOnContext ctx) {
        BlockState state;
        BlockPos pos;
        Level world = ctx.getLevel();
        if (FluidInteractionPoint.create(world, pos = ctx.getClickedPos(), state = world.getBlockState(pos)) != null) {
            return InteractionResult.SUCCESS;
        }
        return super.useOn(ctx);
    }

    protected boolean updateCustomBlockEntityTag(BlockPos pos, Level world, Player player, ItemStack stack, BlockState state) {
        if (!world.isClientSide && player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            CatnipServices.NETWORK.sendToClient(sp, (CustomPacketPayload)new PipetteFluidPlacementPacket.ClientBoundRequest(pos));
        }
        return super.updateCustomBlockEntityTag(pos, world, player, stack, state);
    }

    public boolean canAttackBlock(BlockState state, Level world, BlockPos pos, Player player) {
        return FluidInteractionPoint.create(world, pos, state) == null;
    }
}

