/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.fluid.packet;

import com.adonis.fluid.CreateFluid;
import com.simibubi.create.content.fluids.FluidFX;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.util.RandomSource;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record CopperTapParticlePacket(ParticleType particleType, Vec3 startPos, Vec3 endPos, FluidStack fluid) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<CopperTapParticlePacket> TYPE = new CustomPacketPayload.Type(CreateFluid.asResource("copper_tap_particle"));
    public static final StreamCodec<RegistryFriendlyByteBuf, CopperTapParticlePacket> STREAM_CODEC = StreamCodec.of((buf, packet) -> packet.encode((RegistryFriendlyByteBuf)buf), CopperTapParticlePacket::decode);

    public static CopperTapParticlePacket decode(RegistryFriendlyByteBuf buffer) {
        ParticleType particleType = (ParticleType)buffer.readEnum(ParticleType.class);
        Vec3 startPos = new Vec3(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
        Vec3 endPos = new Vec3(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
        FluidStack fluid = (FluidStack)FluidStack.OPTIONAL_STREAM_CODEC.decode((Object)buffer);
        return new CopperTapParticlePacket(particleType, startPos, endPos, fluid);
    }

    public void encode(RegistryFriendlyByteBuf buffer) {
        buffer.writeEnum((Enum)this.particleType);
        buffer.writeDouble(this.startPos.x);
        buffer.writeDouble(this.startPos.y);
        buffer.writeDouble(this.startPos.z);
        buffer.writeDouble(this.endPos.x);
        buffer.writeDouble(this.endPos.y);
        buffer.writeDouble(this.endPos.z);
        FluidStack.OPTIONAL_STREAM_CODEC.encode((Object)buffer, (Object)this.fluid);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void handle(IPayloadContext context) {
        context.enqueueWork(() -> {
            if (FMLEnvironment.dist == Dist.CLIENT) {
                switch (this.particleType.ordinal()) {
                    case 0: {
                        ClientHandler.spawnStreamParticles(this.startPos, this.endPos, this.fluid);
                        break;
                    }
                    case 1: {
                        ClientHandler.spawnDripEffect(this.startPos, this.fluid);
                    }
                }
            }
        });
    }

    public static enum ParticleType {
        STREAM,
        DRIP;

    }

    @OnlyIn(value=Dist.CLIENT)
    private static class ClientHandler {
        private ClientHandler() {
        }

        private static void spawnStreamParticles(Vec3 startPos, Vec3 endPos, FluidStack fluid) {
            int i;
            Minecraft mc = Minecraft.getInstance();
            ClientLevel level = mc.level;
            if (level == null || fluid.isEmpty()) {
                return;
            }
            ParticleOptions particle = FluidFX.getFluidParticle((FluidStack)fluid);
            Vec3 flowDirection = endPos.subtract(startPos);
            double distance = flowDirection.length();
            Vec3 normalizedFlow = flowDirection.normalize();
            int particleCount = (int)(distance * 8.0);
            for (i = 0; i < particleCount; ++i) {
                float progress = (float)i / (float)particleCount;
                Vec3 particlePos = startPos.add(normalizedFlow.scale(distance * (double)progress));
                Vec3 offset = ClientHandler.offsetRandomly(Vec3.ZERO, level.random, 0.02f);
                particlePos = particlePos.add(offset.x, 0.0, offset.z);
                level.addParticle(particle, particlePos.x, particlePos.y, particlePos.z, offset.x * 0.1, -0.05, offset.z * 0.1);
            }
            for (i = 0; i < 10; ++i) {
                Vec3 splash = ClientHandler.offsetRandomly(Vec3.ZERO, level.random, 0.15f);
                splash = new Vec3(splash.x, Math.abs(splash.y) * 0.3, splash.z);
                level.addParticle(particle, endPos.x, endPos.y, endPos.z, splash.x, splash.y, splash.z);
            }
        }

        private static void spawnDripEffect(Vec3 spoutPos, FluidStack fluid) {
            Minecraft mc = Minecraft.getInstance();
            ClientLevel level = mc.level;
            if (level == null || fluid.isEmpty()) {
                return;
            }
            ParticleOptions fluidParticle = FluidFX.getFluidParticle((FluidStack)fluid);
            level.addParticle(fluidParticle, spoutPos.x, spoutPos.y, spoutPos.z, 0.0, -0.05, 0.0);
            Vec3 fallMotion = ClientHandler.offsetRandomly(Vec3.ZERO, level.random, 0.02f);
            level.addParticle(fluidParticle, spoutPos.x, spoutPos.y, spoutPos.z, fallMotion.x, -0.2, fallMotion.z);
        }

        private static Vec3 offsetRandomly(Vec3 vec, RandomSource random, float maxOffset) {
            return new Vec3(vec.x + ((double)random.nextFloat() - 0.5) * 2.0 * (double)maxOffset, vec.y + ((double)random.nextFloat() - 0.5) * 2.0 * (double)maxOffset, vec.z + ((double)random.nextFloat() - 0.5) * 2.0 * (double)maxOffset);
        }
    }
}

