/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.fluid.packet;

import com.adonis.fluid.CreateFluid;
import com.simibubi.create.content.redstone.RoseQuartzLampBlock;
import io.netty.buffer.ByteBuf;
import net.minecraft.core.BlockPos;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record QuartzLampTogglePacket(BlockPos pos) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<QuartzLampTogglePacket> TYPE = new CustomPacketPayload.Type(CreateFluid.asResource("quartz_lamp_toggle"));
    public static final StreamCodec<ByteBuf, QuartzLampTogglePacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, QuartzLampTogglePacket::pos, QuartzLampTogglePacket::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void handle(IPayloadContext context) {
        context.enqueueWork(() -> {
            Player patt0$temp = context.player();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)patt0$temp;
                if (!player.mayBuild()) {
                    return;
                }
                Level world = player.level();
                if (!world.isLoaded(this.pos)) {
                    return;
                }
                BlockState state = world.getBlockState(this.pos);
                if (!(state.getBlock() instanceof RoseQuartzLampBlock)) {
                    return;
                }
                if (player.distanceToSqr((double)this.pos.getX() + 0.5, (double)this.pos.getY() + 0.5, (double)this.pos.getZ() + 0.5) > 64.0) {
                    return;
                }
                BlockState newState = (BlockState)state.cycle((Property)RoseQuartzLampBlock.POWERING);
                world.setBlock(this.pos, newState, 3);
                world.updateNeighborsAt(this.pos, state.getBlock());
            }
        });
    }
}

