/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.brickhopper.blockentity;

import de.cech12.brickhopper.Constants;
import de.cech12.brickhopper.inventory.BrickHopperContainer;
import de.cech12.brickhopper.platform.Services;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2377;
import net.minecraft.class_238;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2614;
import net.minecraft.class_2615;
import net.minecraft.class_2621;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3481;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public abstract class BrickHopperBlockEntity
extends class_2621
implements class_2615 {
    protected int transferCooldown = -1;
    protected long tickedGameTime;

    public BrickHopperBlockEntity(class_2338 pos, class_2680 state) {
        super(Constants.BRICK_HOPPER_BLOCK_ENTITY_TYPE.get(), pos, state);
    }

    protected void method_11014(@NotNull class_11368 valueInput) {
        super.method_11014(valueInput);
        this.transferCooldown = valueInput.method_71424("TransferCooldown", -1);
    }

    public void method_11007(@NotNull class_11372 valueOutput) {
        super.method_11007(valueOutput);
        valueOutput.method_71465("TransferCooldown", this.transferCooldown);
    }

    @NotNull
    protected class_2561 method_17823() {
        return class_2561.method_43471((String)"block.brickhopper.brick_hopper");
    }

    public double method_11266() {
        return (double)this.field_11867.method_10263() + 0.5;
    }

    public double method_11264() {
        return (double)this.field_11867.method_10264() + 0.5;
    }

    public double method_11265() {
        return (double)this.field_11867.method_10260() + 0.5;
    }

    public boolean method_57081() {
        return true;
    }

    @NotNull
    protected class_1703 method_5465(int id, @NotNull class_1661 player) {
        return new BrickHopperContainer(id, player, (class_1263)this);
    }

    public void setTransferCooldown(int ticks) {
        this.transferCooldown = ticks;
    }

    protected boolean isNotOnTransferCooldown() {
        return this.transferCooldown <= 0;
    }

    public boolean mayNotTransfer() {
        return this.transferCooldown <= Services.CONFIG.getCooldown();
    }

    protected long getLastUpdateTime() {
        return this.tickedGameTime;
    }

    public static List<class_1297> getAllAliveEntitiesAt(class_1937 level, double x, double y, double z, Predicate<? super class_1297> filter) {
        return level.method_8333((class_1297)null, new class_238(x - 0.5, y - 0.5, z - 0.5, x + 0.5, y + 0.5, z + 0.5), entity -> entity.method_5805() && filter.test((class_1297)entity));
    }

    public static void tick(class_1937 level, BrickHopperBlockEntity entity) {
        if (level != null && !level.method_8608()) {
            --entity.transferCooldown;
            entity.tickedGameTime = level.method_8510();
            if (entity.isNotOnTransferCooldown()) {
                entity.setTransferCooldown(0);
                if (entity instanceof BrickHopperBlockEntity) {
                    BrickHopperBlockEntity blockEntity = entity;
                    blockEntity.updateHopper(blockEntity::pullItems);
                }
            }
        }
    }

    public void onItemEntityIsCaptured(class_1542 itemEntity) {
        this.updateHopper(() -> this.captureItem(itemEntity));
    }

    protected abstract class_1799 putStackInInventoryAllSlots(class_2586 var1, Object var2, Object var3, class_1799 var4);

    protected abstract Optional<Pair<Object, Object>> getItemHandler(class_1937 var1, double var2, double var4, double var6, class_2350 var8);

    protected abstract boolean isNotFull(Object var1);

    protected abstract boolean pullItemsFromItemHandler(Object var1);

    protected abstract Object getOwnItemHandler();

    protected boolean pullItems() {
        return this.getItemHandler(this, class_2350.field_11036).map(itemHandlerResult -> {
            if (Services.CONFIG.isPullItemsFromInventoriesEnabled()) {
                return this.pullItemsFromItemHandler(itemHandlerResult.getKey());
            }
            return false;
        }).orElseGet(() -> {
            class_2338 pos;
            class_2680 aboveBlockState;
            if (Services.CONFIG.isPullItemsFromWorldEnabled() && ((aboveBlockState = this.field_11863.method_8320(pos = class_2338.method_49637((double)this.method_11266(), (double)(this.method_11264() + 1.0), (double)this.method_11265()))).method_26164(class_3481.field_49147) || !aboveBlockState.method_26234((class_1922)this.field_11863, pos))) {
                for (class_1542 itementity : class_2614.method_11237((class_1937)this.field_11863, (class_2615)this)) {
                    if (!this.captureItem(itementity)) continue;
                    return true;
                }
            }
            return false;
        });
    }

    protected void updateCooldown(boolean inventoryWasEmpty, class_2586 source, Object destination) {
        BrickHopperBlockEntity destinationHopper;
        if (inventoryWasEmpty && destination instanceof BrickHopperBlockEntity && (destinationHopper = (BrickHopperBlockEntity)((Object)destination)).mayNotTransfer()) {
            int k = 0;
            if (source instanceof BrickHopperBlockEntity && destinationHopper.getLastUpdateTime() >= ((BrickHopperBlockEntity)source).getLastUpdateTime()) {
                k = 1;
            }
            destinationHopper.setTransferCooldown(Services.CONFIG.getCooldown() - k);
        }
    }

    protected void updateHopper(Supplier<Boolean> p_200109_1_) {
        if (this.field_11863 != null && !this.field_11863.method_8608() && this.isNotOnTransferCooldown() && ((Boolean)this.method_11010().method_11654((class_2769)class_2377.field_11126)).booleanValue()) {
            boolean flag = false;
            if (!this.method_5442()) {
                flag = this.transferItemsOut();
            }
            if (this.isNotFull(this.getOwnItemHandler())) {
                flag |= p_200109_1_.get().booleanValue();
            }
            if (flag) {
                this.setTransferCooldown(Services.CONFIG.getCooldown());
                this.method_5431();
            }
        }
    }

    private Optional<Pair<Object, Object>> getItemHandler(BrickHopperBlockEntity hopper, class_2350 hopperFacing) {
        double x = hopper.method_11266() + (double)hopperFacing.method_10148();
        double y = hopper.method_11264() + (double)hopperFacing.method_10164();
        double z = hopper.method_11265() + (double)hopperFacing.method_10165();
        return this.getItemHandler(hopper.method_10997(), x, y, z, hopperFacing.method_10153());
    }

    private boolean transferItemsOut() {
        class_2350 hopperFacing = (class_2350)this.method_11010().method_11654((class_2769)class_2377.field_11129);
        return this.getItemHandler(this, hopperFacing).map(destinationResult -> {
            Object itemHandler = destinationResult.getKey();
            Object destination = destinationResult.getValue();
            if (this.isNotFull(itemHandler)) {
                for (int i = 0; i < this.method_5439(); ++i) {
                    if (this.method_5438(i).method_7960()) continue;
                    class_1799 originalSlotContents = this.method_5438(i).method_7972();
                    class_1799 insertStack = this.method_5434(i, 1);
                    class_1799 remainder = this.putStackInInventoryAllSlots((class_2586)this, destination, itemHandler, insertStack);
                    if (remainder.method_7960()) {
                        return true;
                    }
                    this.method_5447(i, originalSlotContents);
                }
            }
            return false;
        }).orElse(false);
    }

    private boolean captureItem(class_1542 itemEntity) {
        boolean flag = false;
        class_1799 itemstack = itemEntity.method_6983().method_7972();
        class_1799 itemstack1 = this.putStackInInventoryAllSlots(null, (Object)this, this.getOwnItemHandler(), itemstack);
        if (itemstack1.method_7960()) {
            flag = true;
            itemEntity.method_5650(class_1297.class_5529.field_26999);
        } else {
            itemEntity.method_6979(itemstack1);
        }
        return flag;
    }
}

