/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.brickhopper.platform;

import de.cech12.brickhopper.platform.services.IConfigHelper;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import me.shedaniel.autoconfig.serializer.Toml4jConfigSerializer;

@Config(name="brickhopper")
public class FabricConfigHelper
implements ConfigData,
IConfigHelper {
    @ConfigEntry.Gui.Tooltip(count=5)
    public int COOLDOWN = 12;
    @ConfigEntry.Gui.Tooltip(count=3)
    public boolean PULL_ITEMS_FROM_WORLD_ENABLED = true;
    @ConfigEntry.Gui.Tooltip(count=3)
    public boolean PULL_ITEMS_FROM_INVENTORIES_ENABLED = true;

    @Override
    public void init() {
        AutoConfig.register(FabricConfigHelper.class, Toml4jConfigSerializer::new);
    }

    private FabricConfigHelper getConfig() {
        return (FabricConfigHelper)AutoConfig.getConfigHolder(FabricConfigHelper.class).getConfig();
    }

    @Override
    public int getCooldown() {
        return Math.clamp((long)this.getConfig().COOLDOWN, 1, 1000);
    }

    @Override
    public boolean isPullItemsFromWorldEnabled() {
        return this.getConfig().PULL_ITEMS_FROM_WORLD_ENABLED;
    }

    @Override
    public boolean isPullItemsFromInventoriesEnabled() {
        return this.getConfig().PULL_ITEMS_FROM_INVENTORIES_ENABLED;
    }
}

