/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.brickhopper.blockentity;

import de.cech12.brickhopper.Constants;
import de.cech12.brickhopper.inventory.BrickHopperContainer;
import de.cech12.brickhopper.platform.Services;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.HopperBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.Hopper;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public abstract class BrickHopperBlockEntity
extends RandomizableContainerBlockEntity
implements Hopper {
    protected int transferCooldown = -1;
    protected long tickedGameTime;

    public BrickHopperBlockEntity(BlockPos pos, BlockState state) {
        super(Constants.BRICK_HOPPER_BLOCK_ENTITY_TYPE.get(), pos, state);
    }

    protected void loadAdditional(@NotNull ValueInput valueInput) {
        super.loadAdditional(valueInput);
        this.transferCooldown = valueInput.getIntOr("TransferCooldown", -1);
    }

    public void saveAdditional(@NotNull ValueOutput valueOutput) {
        super.saveAdditional(valueOutput);
        valueOutput.putInt("TransferCooldown", this.transferCooldown);
    }

    @NotNull
    protected Component getDefaultName() {
        return Component.translatable((String)"block.brickhopper.brick_hopper");
    }

    public double getLevelX() {
        return (double)this.worldPosition.getX() + 0.5;
    }

    public double getLevelY() {
        return (double)this.worldPosition.getY() + 0.5;
    }

    public double getLevelZ() {
        return (double)this.worldPosition.getZ() + 0.5;
    }

    public boolean isGridAligned() {
        return true;
    }

    @NotNull
    protected AbstractContainerMenu createMenu(int id, @NotNull Inventory player) {
        return new BrickHopperContainer(id, player, (Container)this);
    }

    public void setTransferCooldown(int ticks) {
        this.transferCooldown = ticks;
    }

    protected boolean isNotOnTransferCooldown() {
        return this.transferCooldown <= 0;
    }

    public boolean mayNotTransfer() {
        return this.transferCooldown <= Services.CONFIG.getCooldown();
    }

    protected long getLastUpdateTime() {
        return this.tickedGameTime;
    }

    public static List<Entity> getAllAliveEntitiesAt(Level level, double x, double y, double z, Predicate<? super Entity> filter) {
        return level.getEntities((Entity)null, new AABB(x - 0.5, y - 0.5, z - 0.5, x + 0.5, y + 0.5, z + 0.5), entity -> entity.isAlive() && filter.test((Entity)entity));
    }

    public static void tick(Level level, BrickHopperBlockEntity entity) {
        if (level != null && !level.isClientSide()) {
            --entity.transferCooldown;
            entity.tickedGameTime = level.getGameTime();
            if (entity.isNotOnTransferCooldown()) {
                entity.setTransferCooldown(0);
                if (entity instanceof BrickHopperBlockEntity) {
                    BrickHopperBlockEntity blockEntity = entity;
                    blockEntity.updateHopper(blockEntity::pullItems);
                }
            }
        }
    }

    public void onItemEntityIsCaptured(ItemEntity itemEntity) {
        this.updateHopper(() -> this.captureItem(itemEntity));
    }

    protected abstract ItemStack putStackInInventoryAllSlots(BlockEntity var1, Object var2, Object var3, ItemStack var4);

    protected abstract Optional<Pair<Object, Object>> getItemHandler(Level var1, double var2, double var4, double var6, Direction var8);

    protected abstract boolean isNotFull(Object var1);

    protected abstract boolean pullItemsFromItemHandler(Object var1);

    protected abstract Object getOwnItemHandler();

    protected boolean pullItems() {
        return this.getItemHandler(this, Direction.UP).map(itemHandlerResult -> {
            if (Services.CONFIG.isPullItemsFromInventoriesEnabled()) {
                return this.pullItemsFromItemHandler(itemHandlerResult.getKey());
            }
            return false;
        }).orElseGet(() -> {
            BlockPos pos;
            BlockState aboveBlockState;
            if (Services.CONFIG.isPullItemsFromWorldEnabled() && ((aboveBlockState = this.level.getBlockState(pos = BlockPos.containing((double)this.getLevelX(), (double)(this.getLevelY() + 1.0), (double)this.getLevelZ()))).is(BlockTags.DOES_NOT_BLOCK_HOPPERS) || !aboveBlockState.isCollisionShapeFullBlock((BlockGetter)this.level, pos))) {
                for (ItemEntity itementity : HopperBlockEntity.getItemsAtAndAbove((Level)this.level, (Hopper)this)) {
                    if (!this.captureItem(itementity)) continue;
                    return true;
                }
            }
            return false;
        });
    }

    protected void updateCooldown(boolean inventoryWasEmpty, BlockEntity source, Object destination) {
        BrickHopperBlockEntity destinationHopper;
        if (inventoryWasEmpty && destination instanceof BrickHopperBlockEntity && (destinationHopper = (BrickHopperBlockEntity)((Object)destination)).mayNotTransfer()) {
            int k = 0;
            if (source instanceof BrickHopperBlockEntity && destinationHopper.getLastUpdateTime() >= ((BrickHopperBlockEntity)source).getLastUpdateTime()) {
                k = 1;
            }
            destinationHopper.setTransferCooldown(Services.CONFIG.getCooldown() - k);
        }
    }

    protected void updateHopper(Supplier<Boolean> p_200109_1_) {
        if (this.level != null && !this.level.isClientSide() && this.isNotOnTransferCooldown() && ((Boolean)this.getBlockState().getValue((Property)HopperBlock.ENABLED)).booleanValue()) {
            boolean flag = false;
            if (!this.isEmpty()) {
                flag = this.transferItemsOut();
            }
            if (this.isNotFull(this.getOwnItemHandler())) {
                flag |= p_200109_1_.get().booleanValue();
            }
            if (flag) {
                this.setTransferCooldown(Services.CONFIG.getCooldown());
                this.setChanged();
            }
        }
    }

    private Optional<Pair<Object, Object>> getItemHandler(BrickHopperBlockEntity hopper, Direction hopperFacing) {
        double x = hopper.getLevelX() + (double)hopperFacing.getStepX();
        double y = hopper.getLevelY() + (double)hopperFacing.getStepY();
        double z = hopper.getLevelZ() + (double)hopperFacing.getStepZ();
        return this.getItemHandler(hopper.getLevel(), x, y, z, hopperFacing.getOpposite());
    }

    private boolean transferItemsOut() {
        Direction hopperFacing = (Direction)this.getBlockState().getValue((Property)HopperBlock.FACING);
        return this.getItemHandler(this, hopperFacing).map(destinationResult -> {
            Object itemHandler = destinationResult.getKey();
            Object destination = destinationResult.getValue();
            if (this.isNotFull(itemHandler)) {
                for (int i = 0; i < this.getContainerSize(); ++i) {
                    if (this.getItem(i).isEmpty()) continue;
                    ItemStack originalSlotContents = this.getItem(i).copy();
                    ItemStack insertStack = this.removeItem(i, 1);
                    ItemStack remainder = this.putStackInInventoryAllSlots((BlockEntity)this, destination, itemHandler, insertStack);
                    if (remainder.isEmpty()) {
                        return true;
                    }
                    this.setItem(i, originalSlotContents);
                }
            }
            return false;
        }).orElse(false);
    }

    private boolean captureItem(ItemEntity itemEntity) {
        boolean flag = false;
        ItemStack itemstack = itemEntity.getItem().copy();
        ItemStack itemstack1 = this.putStackInInventoryAllSlots(null, (Object)this, this.getOwnItemHandler(), itemstack);
        if (itemstack1.isEmpty()) {
            flag = true;
            itemEntity.remove(Entity.RemovalReason.DISCARDED);
        } else {
            itemEntity.setItem(itemstack1);
        }
        return flag;
    }
}

