/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.brickhopper.blockentity;

import de.cech12.brickhopper.blockentity.BrickHopperBlockEntity;
import de.cech12.brickhopper.platform.Services;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.WorldlyContainerHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.item.ItemStacksResourceHandler;
import net.neoforged.neoforge.transfer.item.VanillaContainerWrapper;
import net.neoforged.neoforge.transfer.item.WorldlyContainerWrapper;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.SnapshotJournal;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class NeoForgeBrickHopperBlockEntity
extends BrickHopperBlockEntity {
    private ItemStacksResourceHandler inventory = new ItemStacksResourceHandler(3);
    private final SnapshotJournal<Integer> cooldownTimeJournal = new SnapshotJournal<Integer>(){

        protected Integer createSnapshot() {
            return NeoForgeBrickHopperBlockEntity.this.transferCooldown;
        }

        protected void revertToSnapshot(Integer snapshot) {
            NeoForgeBrickHopperBlockEntity.this.transferCooldown = snapshot;
        }
    };

    public NeoForgeBrickHopperBlockEntity(BlockPos pos, BlockState state) {
        super(pos, state);
    }

    @Override
    protected void loadAdditional(@NotNull ValueInput valueInput) {
        super.loadAdditional(valueInput);
        this.inventory = new ItemStacksResourceHandler(3);
        if (!this.tryLoadLootTable(valueInput)) {
            this.inventory.deserialize(valueInput);
        }
    }

    @Override
    public void saveAdditional(@NotNull ValueOutput valueOutput) {
        super.saveAdditional(valueOutput);
        if (!this.trySaveLootTable(valueOutput)) {
            this.inventory.serialize(valueOutput);
        }
    }

    public int getContainerSize() {
        return this.inventory.size();
    }

    @NotNull
    protected NonNullList<ItemStack> getItems() {
        NonNullList list = NonNullList.withSize((int)3, (Object)ItemStack.EMPTY);
        for (int i = 0; i < 3; ++i) {
            list.set(i, (Object)((ItemResource)this.inventory.getResource(i)).toStack(this.inventory.getAmountAsInt(i)));
        }
        return list;
    }

    protected void setItems(@NotNull NonNullList<ItemStack> itemsIn) {
        if (itemsIn.size() == 3) {
            for (int i = 0; i < 3; ++i) {
                this.inventory.set(i, (Resource)ItemResource.of((ItemStack)((ItemStack)itemsIn.getFirst())), ((ItemStack)itemsIn.getFirst()).getCount());
            }
        }
    }

    @NotNull
    public ItemStack removeItem(int index, int count) {
        this.unpackLootTable(null);
        try (Transaction transaction = Transaction.open(null);){
            ItemResource resource = (ItemResource)this.inventory.getResource(index);
            if (!resource.isEmpty()) {
                int extractedAmount = this.inventory.extract(index, (Resource)resource, count, (TransactionContext)transaction);
                transaction.commit();
                this.setChanged();
                ItemStack itemStack = resource.toStack(extractedAmount);
                return itemStack;
            }
        }
        return ItemStack.EMPTY;
    }

    @NotNull
    public ItemStack removeItemNoUpdate(int index) {
        try (Transaction transaction = Transaction.open(null);){
            this.unpackLootTable(null);
            ItemResource resource = (ItemResource)this.inventory.getResource(index);
            int amount = this.inventory.getAmountAsInt(index);
            if (!resource.isEmpty() && amount > 0) {
                int extractedAmount = this.inventory.extract(index, (Resource)resource, amount, (TransactionContext)transaction);
                ItemStack stack = resource.toStack(extractedAmount);
                transaction.commit();
                this.setChanged();
                ItemStack itemStack = stack;
                return itemStack;
            }
        }
        return ItemStack.EMPTY;
    }

    public void setItem(int index, @NotNull ItemStack stack, boolean insideTransaction) {
        super.setItem(index, stack, insideTransaction);
        this.unpackLootTable(null);
        this.inventory.set(index, (Resource)ItemResource.of((ItemStack)stack), stack.getCount());
        if (!insideTransaction) {
            this.setChanged();
        }
    }

    @Override
    protected ItemStack putStackInInventoryAllSlots(BlockEntity source, Object destination, Object destInventoryObj, ItemStack stack) {
        ResourceHandler destInventory = (ResourceHandler)destInventoryObj;
        for (int slot = 0; slot < destInventory.size() && !stack.isEmpty(); ++slot) {
            stack = this.insertStack(source, destination, (ResourceHandler<ItemResource>)destInventory, stack, slot);
        }
        return stack;
    }

    private ItemStack insertStack(BlockEntity source, Object destination, ResourceHandler<ItemResource> destInventory, ItemStack stack, int slot) {
        ItemStack result = stack;
        boolean inventoryWasEmpty = this.isEmpty(destInventory);
        try (Transaction transaction = Transaction.open(null);){
            ItemResource resource = ItemResource.of((ItemStack)stack);
            int insertedAmount = destInventory.insert(slot, (Resource)resource, stack.getCount(), (TransactionContext)transaction);
            if (insertedAmount <= stack.getCount()) {
                result = resource.toStack(stack.getCount() - insertedAmount);
                transaction.commit();
                this.updateCooldown(inventoryWasEmpty, source, destination);
            }
        }
        return result;
    }

    @Override
    protected Optional<Pair<Object, Object>> getItemHandler(Level level, double x, double y, double z, Direction side) {
        Block block;
        BlockPos blockpos = BlockPos.containing((double)x, (double)y, (double)z);
        BlockState state = level.getBlockState(blockpos);
        if (state.hasBlockEntity()) {
            WorldlyContainer container;
            ResourceHandler handler;
            BlockEntity blockEntity = level.getBlockEntity(blockpos);
            if (blockEntity != null && (handler = (ResourceHandler)level.getCapability(Capabilities.Item.BLOCK, blockpos, state, blockEntity, (Object)side)) != null) {
                return Optional.of(ImmutablePair.of((Object)handler, (Object)blockEntity));
            }
            if (blockEntity instanceof WorldlyContainer) {
                container = (WorldlyContainer)blockEntity;
                return Optional.of(ImmutablePair.of((Object)new WorldlyContainerWrapper(container, side), (Object)state));
            }
            if (blockEntity instanceof Container) {
                container = (Container)blockEntity;
                return Optional.of(ImmutablePair.of((Object)VanillaContainerWrapper.of((Container)container), (Object)state));
            }
        }
        if ((block = state.getBlock()) instanceof WorldlyContainerHolder) {
            return Optional.of(ImmutablePair.of((Object)new WorldlyContainerWrapper(((WorldlyContainerHolder)block).getContainer(state, (LevelAccessor)level, blockpos), side), (Object)state));
        }
        List<Entity> list = NeoForgeBrickHopperBlockEntity.getAllAliveEntitiesAt(level, x, y, z, entity -> entity instanceof Container || !(entity instanceof LivingEntity) && entity.getCapability(Capabilities.Item.ENTITY_AUTOMATION, (Object)side) != null);
        if (!list.isEmpty()) {
            Entity entity2 = list.get(level.random.nextInt(list.size()));
            ResourceHandler cap = (ResourceHandler)entity2.getCapability(Capabilities.Item.ENTITY_AUTOMATION, (Object)side);
            if (cap != null) {
                return Optional.of(ImmutablePair.of((Object)cap, (Object)entity2));
            }
            if (entity2 instanceof WorldlyContainer) {
                WorldlyContainer container = (WorldlyContainer)entity2;
                return Optional.of(ImmutablePair.of((Object)new WorldlyContainerWrapper(container, side), (Object)entity2));
            }
            if (entity2 instanceof Container) {
                Container containerEntity = (Container)entity2;
                return Optional.of(ImmutablePair.of((Object)VanillaContainerWrapper.of((Container)containerEntity), (Object)entity2));
            }
        }
        return Optional.empty();
    }

    @Override
    protected boolean isNotFull(Object itemHandlerObj) {
        ResourceHandler itemHandler = (ResourceHandler)itemHandlerObj;
        for (int slot = 0; slot < itemHandler.size(); ++slot) {
            ItemResource resource = (ItemResource)itemHandler.getResource(slot);
            int amount = itemHandler.getAmountAsInt(slot);
            if (!resource.isEmpty() && amount > 0 && amount >= itemHandler.getCapacityAsInt(slot, (Resource)resource)) continue;
            return true;
        }
        return false;
    }

    private boolean isEmpty(ResourceHandler<ItemResource> itemHandler) {
        for (int slot = 0; slot < itemHandler.size(); ++slot) {
            if (itemHandler.getAmountAsInt(slot) <= 0) continue;
            return false;
        }
        return true;
    }

    @Override
    protected boolean pullItemsFromItemHandler(Object itemHandler) {
        ResourceHandler handler = (ResourceHandler)itemHandler;
        for (int i = 0; i < handler.size(); ++i) {
            try (Transaction transaction = Transaction.open(null);){
                int extractedAmount;
                ItemResource resource = (ItemResource)handler.getResource(i);
                if (resource.isEmpty() || (extractedAmount = handler.extract(i, (Resource)resource, 1, (TransactionContext)transaction)) <= 0) continue;
                ItemStack extractItem = resource.toStack(extractedAmount);
                for (int j = 0; j < this.getContainerSize(); ++j) {
                    ItemStack destStack = this.getItem(j);
                    if (!this.canPlaceItem(j, extractItem) || !destStack.isEmpty() && (destStack.getCount() >= destStack.getMaxStackSize() || destStack.getCount() >= this.getMaxStackSize() || !ItemStack.isSameItemSameComponents((ItemStack)extractItem, (ItemStack)destStack))) continue;
                    transaction.commit();
                    if (destStack.isEmpty()) {
                        this.setItem(j, extractItem);
                    } else {
                        destStack.grow(1);
                        this.setItem(j, destStack);
                    }
                    this.setChanged();
                    boolean bl = true;
                    return bl;
                }
                continue;
            }
        }
        return false;
    }

    @Override
    protected Object getOwnItemHandler() {
        return this.inventory;
    }

    public void onTransfer(int slot, int amountChange, @NotNull TransactionContext transaction) {
        if (amountChange > 0 && this.wasEmpty(slot, amountChange)) {
            this.cooldownTimeJournal.updateSnapshots(transaction);
            this.transferCooldown = Services.CONFIG.getCooldown();
        }
    }

    private boolean wasEmpty(int slot, int amountChange) {
        if (this.inventory.getAmountAsInt(slot) != amountChange) {
            return false;
        }
        for (int i = 0; i < this.inventory.size(); ++i) {
            if (i == slot || this.inventory.getAmountAsInt(i) <= 0) continue;
            return false;
        }
        return true;
    }
}

