/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.brickhopper.platform;

import de.cech12.brickhopper.platform.services.IConfigHelper;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.ModConfigSpec;

public class NeoForgeConfigHelper
implements IConfigHelper {
    private static final ModConfigSpec SERVER_CONFIG;
    private static final ModConfigSpec.IntValue COOLDOWN;
    public static final ModConfigSpec.BooleanValue PULL_ITEMS_FROM_WORLD_ENABLED;
    public static final ModConfigSpec.BooleanValue PULL_ITEMS_FROM_INVENTORIES_ENABLED;

    @Override
    public void init() {
        ModLoadingContext.get().getActiveContainer().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)SERVER_CONFIG);
    }

    @Override
    public int getCooldown() {
        try {
            return (Integer)COOLDOWN.get();
        }
        catch (IllegalStateException ex) {
            return 12;
        }
    }

    @Override
    public boolean isPullItemsFromWorldEnabled() {
        try {
            return (Boolean)PULL_ITEMS_FROM_WORLD_ENABLED.get();
        }
        catch (IllegalStateException ex) {
            return true;
        }
    }

    @Override
    public boolean isPullItemsFromInventoriesEnabled() {
        try {
            return (Boolean)PULL_ITEMS_FROM_INVENTORIES_ENABLED.get();
        }
        catch (IllegalStateException ex) {
            return true;
        }
    }

    static {
        ModConfigSpec.Builder builder = new ModConfigSpec.Builder();
        builder.comment("Options that affect the added Brick Hopper.").push("Brick Hopper Settings");
        COOLDOWN = builder.comment("Time (ticks) that passes between two brick hopper operations. (default: 12 ticks) (vanilla hopper: 8 ticks)").defineInRange("brickHopperCooldown", 12, 1, 1000);
        PULL_ITEMS_FROM_WORLD_ENABLED = builder.comment("Whether the brick hopper can pull item entities lying above it. (default: true)").define("brickHopperPullItemsFromWorldEnabled", true);
        PULL_ITEMS_FROM_INVENTORIES_ENABLED = builder.comment("Whether the brick hopper can pull items from inventories above it. (default: true)").define("brickHopperPullItemsFromInventoriesEnabled", true);
        builder.pop();
        SERVER_CONFIG = builder.build();
    }
}

