/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.brickhopper.blockentity;

import de.cech12.brickhopper.block.ForgeBrickHopperItemHandler;
import de.cech12.brickhopper.blockentity.BrickHopperBlockEntity;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.WorldlyContainerHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class ForgeBrickHopperBlockEntity
extends BrickHopperBlockEntity {
    private ItemStackHandler inventory = new ItemStackHandler(3);

    public ForgeBrickHopperBlockEntity(BlockPos pos, BlockState state) {
        super(pos, state);
    }

    @Override
    protected void loadAdditional(@NotNull ValueInput valueInput) {
        super.loadAdditional(valueInput);
        NonNullList stacks = NonNullList.withSize((int)3, (Object)ItemStack.EMPTY);
        if (!this.tryLoadLootTable(valueInput)) {
            ContainerHelper.loadAllItems((ValueInput)valueInput, (NonNullList)stacks);
        }
        this.inventory = new ItemStackHandler(stacks);
    }

    @Override
    public void saveAdditional(@NotNull ValueOutput valueOutput) {
        super.saveAdditional(valueOutput);
        if (!this.trySaveLootTable(valueOutput)) {
            ContainerHelper.saveAllItems((ValueOutput)valueOutput, this.getItems());
        }
    }

    public int getContainerSize() {
        return this.inventory.getSlots();
    }

    @NotNull
    protected NonNullList<ItemStack> getItems() {
        NonNullList list = NonNullList.withSize((int)3, (Object)ItemStack.EMPTY);
        for (int i = 0; i < 3; ++i) {
            list.set(i, (Object)this.inventory.getStackInSlot(i));
        }
        return list;
    }

    protected void setItems(@NotNull NonNullList<ItemStack> itemsIn) {
        if (itemsIn.size() == 3) {
            for (int i = 0; i < 3; ++i) {
                this.inventory.setStackInSlot(i, (ItemStack)itemsIn.get(i));
            }
        }
    }

    @NotNull
    public ItemStack removeItem(int index, int count) {
        this.unpackLootTable(null);
        ItemStack stack = this.inventory.extractItem(index, count, false);
        this.setChanged();
        return stack;
    }

    @NotNull
    public ItemStack removeItemNoUpdate(int index) {
        this.unpackLootTable(null);
        ItemStack stack = this.inventory.getStackInSlot(index);
        this.inventory.setStackInSlot(index, ItemStack.EMPTY);
        this.setChanged();
        return stack;
    }

    public void setItem(int index, @NotNull ItemStack stack) {
        this.unpackLootTable(null);
        this.inventory.setStackInSlot(index, stack);
        this.setChanged();
    }

    @NotNull
    protected IItemHandler createUnSidedHandler() {
        return new ForgeBrickHopperItemHandler(this);
    }

    @Override
    protected ItemStack putStackInInventoryAllSlots(BlockEntity source, Object destination, Object destInventoryObj, ItemStack stack) {
        IItemHandler destInventory = (IItemHandler)destInventoryObj;
        for (int slot = 0; slot < destInventory.getSlots() && !stack.isEmpty(); ++slot) {
            stack = this.insertStack(source, destination, destInventory, stack, slot);
        }
        return stack;
    }

    private ItemStack insertStack(BlockEntity source, Object destination, IItemHandler destInventory, ItemStack stack, int slot) {
        ItemStack result = stack;
        if (!destInventory.insertItem(slot, stack, true).equals(stack)) {
            boolean inventoryWasEmpty = this.isEmpty(destInventory);
            result = destInventory.insertItem(slot, stack, false);
            if (result.getCount() < stack.getCount()) {
                this.updateCooldown(inventoryWasEmpty, source, destination);
            }
        }
        return result;
    }

    @Override
    protected Optional<Pair<Object, Object>> getItemHandler(Level level, double x, double y, double z, Direction side) {
        Block block;
        BlockEntity blockEntity;
        BlockPos blockpos = BlockPos.containing((double)x, (double)y, (double)z);
        BlockState state = level.getBlockState(blockpos);
        if (state.hasBlockEntity() && (blockEntity = level.getBlockEntity(blockpos)) != null) {
            LazyOptional handlerOptional = blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, side);
            if (handlerOptional.isPresent()) {
                return handlerOptional.map(capability -> ImmutablePair.of((Object)capability, (Object)blockEntity));
            }
            if (blockEntity instanceof WorldlyContainer) {
                WorldlyContainer container = (WorldlyContainer)blockEntity;
                return Optional.of(ImmutablePair.of((Object)new SidedInvWrapper(container, side), (Object)state));
            }
            if (blockEntity instanceof Container) {
                Container container = (Container)blockEntity;
                return Optional.of(ImmutablePair.of((Object)new InvWrapper(container), (Object)state));
            }
        }
        if ((block = state.getBlock()) instanceof WorldlyContainerHolder) {
            return Optional.of(ImmutablePair.of((Object)new SidedInvWrapper(((WorldlyContainerHolder)block).getContainer(state, (LevelAccessor)level, blockpos), side), (Object)state));
        }
        List<Entity> list = ForgeBrickHopperBlockEntity.getAllAliveEntitiesAt(level, x, y, z, entity -> entity instanceof Container || !(entity instanceof LivingEntity) && entity.getCapability(ForgeCapabilities.ITEM_HANDLER, side).isPresent());
        if (!list.isEmpty()) {
            Entity entity2 = list.get(level.random.nextInt(list.size()));
            LazyOptional cap = entity2.getCapability(ForgeCapabilities.ITEM_HANDLER, side);
            if (cap.isPresent()) {
                return cap.map(capability -> ImmutablePair.of((Object)capability, (Object)entity2));
            }
            if (entity2 instanceof WorldlyContainer) {
                WorldlyContainer container = (WorldlyContainer)entity2;
                return Optional.of(ImmutablePair.of((Object)new SidedInvWrapper(container, side), (Object)entity2));
            }
            if (entity2 instanceof Container) {
                Container containerEntity = (Container)entity2;
                return Optional.of(ImmutablePair.of((Object)new InvWrapper(containerEntity), (Object)entity2));
            }
        }
        return Optional.empty();
    }

    @Override
    protected boolean isNotFull(Object itemHandlerObj) {
        IItemHandler itemHandler = (IItemHandler)itemHandlerObj;
        for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
            ItemStack stackInSlot = itemHandler.getStackInSlot(slot);
            if (!stackInSlot.isEmpty() && stackInSlot.getCount() >= itemHandler.getSlotLimit(slot)) continue;
            return true;
        }
        return false;
    }

    private boolean isEmpty(IItemHandler itemHandler) {
        for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
            ItemStack stackInSlot = itemHandler.getStackInSlot(slot);
            if (stackInSlot.getCount() <= 0) continue;
            return false;
        }
        return true;
    }

    @Override
    protected boolean pullItemsFromItemHandler(Object itemHandlerObj) {
        IItemHandler handler = (IItemHandler)itemHandlerObj;
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack extractItem = handler.extractItem(i, 1, true);
            if (extractItem.isEmpty()) continue;
            for (int j = 0; j < this.getContainerSize(); ++j) {
                ItemStack destStack = this.getItem(j);
                if (!this.canPlaceItem(j, extractItem) || !destStack.isEmpty() && (destStack.getCount() >= destStack.getMaxStackSize() || destStack.getCount() >= this.getMaxStackSize() || !ItemHandlerHelper.canItemStacksStack((ItemStack)extractItem, (ItemStack)destStack))) continue;
                extractItem = handler.extractItem(i, 1, false);
                if (destStack.isEmpty()) {
                    this.setItem(j, extractItem);
                } else {
                    destStack.grow(1);
                    this.setItem(j, destStack);
                }
                this.setChanged();
                return true;
            }
        }
        return false;
    }

    @Override
    protected Object getOwnItemHandler() {
        return this.inventory;
    }
}

