/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.brickhopper.platform;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import de.cech12.brickhopper.platform.services.IConfigHelper;
import java.nio.file.Path;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FMLConfig;
import net.minecraftforge.fml.loading.FMLPaths;

public class ForgeConfigHelper
implements IConfigHelper {
    private static final ForgeConfigSpec SERVER_CONFIG;
    private static final ForgeConfigSpec.IntValue COOLDOWN;
    public static final ForgeConfigSpec.BooleanValue PULL_ITEMS_FROM_WORLD_ENABLED;
    public static final ForgeConfigSpec.BooleanValue PULL_ITEMS_FROM_INVENTORIES_ENABLED;

    @Override
    public void init() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)SERVER_CONFIG);
        Path path = FMLPaths.GAMEDIR.get().resolve(FMLConfig.defaultConfigPath()).resolve("brickhopper-server.toml");
        CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)path).sync().autosave().writingMode(WritingMode.REPLACE).build();
        configData.load();
        SERVER_CONFIG.setConfig((CommentedConfig)configData);
    }

    @Override
    public int getCooldown() {
        try {
            return (Integer)COOLDOWN.get();
        }
        catch (IllegalStateException ex) {
            return 12;
        }
    }

    @Override
    public boolean isPullItemsFromWorldEnabled() {
        try {
            return (Boolean)PULL_ITEMS_FROM_WORLD_ENABLED.get();
        }
        catch (IllegalStateException ex) {
            return true;
        }
    }

    @Override
    public boolean isPullItemsFromInventoriesEnabled() {
        try {
            return (Boolean)PULL_ITEMS_FROM_INVENTORIES_ENABLED.get();
        }
        catch (IllegalStateException ex) {
            return true;
        }
    }

    static {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        builder.comment("Options that affect the added Brick Hopper.").push("Brick Hopper Settings");
        COOLDOWN = builder.comment("Time (ticks) that passes between two brick hopper operations. (default: 12 ticks) (vanilla hopper: 8 ticks)").defineInRange("brickHopperCooldown", 12, 1, 1000);
        PULL_ITEMS_FROM_WORLD_ENABLED = builder.comment("Whether the brick hopper can pull item entities lying above it. (default: true)").define("brickHopperPullItemsFromWorldEnabled", true);
        PULL_ITEMS_FROM_INVENTORIES_ENABLED = builder.comment("Whether the brick hopper can pull items from inventories above it. (default: true)").define("brickHopperPullItemsFromInventoriesEnabled", true);
        builder.pop();
        SERVER_CONFIG = builder.build();
    }
}

