/*
 * Decompiled with CFR 0.152.
 */
package com.mememan.nexus.asm;

import com.mememan.nexus.NexusConstants;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class ClassFinder {
    public static Class<?> forName(String targetClassName) {
        try {
            NexusConstants.LOGGER.debug("Loading & Initializing Class: {}", (Object)targetClassName);
            return Class.forName(targetClassName);
        }
        catch (ClassNotFoundException | ExceptionInInitializerError e) {
            NexusConstants.LOGGER.error(e instanceof ClassNotFoundException ? "Failed to load/initialize: {}, no such class was found." : "Failed to initialize: {}", (Object)targetClassName, (Object)e);
            return null;
        }
    }

    public static Class<?> forNameNoInit(String targetClassName) {
        try {
            NexusConstants.LOGGER.debug("Loading Class (No Initialization): {}", (Object)targetClassName);
            return Class.forName(targetClassName, false, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException | ExceptionInInitializerError e) {
            NexusConstants.LOGGER.error(e instanceof ClassNotFoundException ? "Failed to load: {}, no such class was found." : "Failed to load: {}", (Object)targetClassName, (Object)e);
            return null;
        }
    }
}

