/*
 * Decompiled with CFR 0.152.
 */
package com.mememan.nexus.client.model.general;

import com.mememan.nexus.client.model.general.ModelElement;
import com.mememan.nexus.client.model.general.ModelGuiLight;
import com.mememan.nexus.client.model.general.ModelTransform;
import com.mememan.nexus.property_wrapper.base.specialised.model.ModelBasedPropertyWrapper;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.data.models.model.ModelTemplate;
import net.minecraft.data.models.model.TextureMapping;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BaseModelDefinition<SELF extends BaseModelDefinition<SELF>>
implements ModelBasedPropertyWrapper.ModelDefinition {
    @NotNull
    protected final ModelTemplate parentModel;
    @NotNull
    protected String modelCustomBackingDirectory;
    @Nullable
    protected TextureMapping modelTextureMapping;
    @Nullable
    protected ResourceLocation modelRenderType;
    @Nullable
    protected ModelGuiLight modelGuiLight;
    @Nullable
    protected String modelCustomName;
    protected boolean hasAO = true;
    protected final Map<ItemDisplayContext, ModelTransform> modelTransforms = new Object2ObjectOpenHashMap();
    protected final List<ModelElement> modelElements = new ObjectArrayList();
    protected final List<ModelBasedPropertyWrapper.ModelDefinition> ordinalModelDefinitions = new ObjectArrayList();

    public BaseModelDefinition(@NotNull ModelTemplate parentModel, @NotNull String customBackingDirectory) {
        this.parentModel = parentModel;
        this.modelCustomBackingDirectory = customBackingDirectory;
    }

    public SELF withOrdinalModelDefinition(ModelBasedPropertyWrapper.ModelDefinition modelDefinition) {
        this.ordinalModelDefinitions.add(modelDefinition);
        return this.self();
    }

    public SELF withOrdinalModelDefinitions(Collection<ModelBasedPropertyWrapper.ModelDefinition> modelDefinitions) {
        this.ordinalModelDefinitions.addAll(modelDefinitions);
        return this.self();
    }

    public SELF setOrdinalModelDefinitions(Collection<ModelBasedPropertyWrapper.ModelDefinition> modelDefinitions) {
        this.ordinalModelDefinitions.clear();
        this.ordinalModelDefinitions.addAll(modelDefinitions);
        return this.self();
    }

    public SELF withOrdinalModelDefinitions(ModelBasedPropertyWrapper.ModelDefinition ... modelDefinition) {
        return (SELF)this.withOrdinalModelDefinitions((Collection)ObjectArrayList.of((Object[])modelDefinition));
    }

    public SELF withCustomName(String customName) {
        this.modelCustomName = customName;
        return this.self();
    }

    public SELF appendToBackingDirectory(String appendedDir) {
        this.modelCustomBackingDirectory = this.modelCustomBackingDirectory + appendedDir;
        return this.self();
    }

    public SELF withTextureMapping(TextureMapping texMapping) {
        this.modelTextureMapping = texMapping;
        return this.self();
    }

    public SELF withRenderType(ResourceLocation renderType) {
        this.modelRenderType = renderType;
        return this.self();
    }

    public SELF withGuiLight(ModelGuiLight guiLight) {
        this.modelGuiLight = guiLight;
        return this.self();
    }

    public SELF withAmbientOcclusion(boolean ambientOcclusion) {
        this.hasAO = ambientOcclusion;
        return this.self();
    }

    public SELF withTransform(ItemDisplayContext perspectiveContext, ModelTransform applicableTransform) {
        this.modelTransforms.put(perspectiveContext, applicableTransform);
        return this.self();
    }

    public SELF withTransforms(Map<ItemDisplayContext, ModelTransform> transforms) {
        this.modelTransforms.putAll(transforms);
        return this.self();
    }

    public SELF setTransforms(Map<ItemDisplayContext, ModelTransform> transforms) {
        this.modelTransforms.clear();
        this.modelTransforms.putAll(transforms);
        return this.self();
    }

    public SELF withElement(ModelElement element) {
        this.modelElements.add(element);
        return this.self();
    }

    public SELF withElements(Collection<ModelElement> elements) {
        this.modelElements.addAll(elements);
        return this.self();
    }

    public SELF withElements(ModelElement ... elements) {
        this.modelElements.addAll((Collection<ModelElement>)new ObjectArrayList((Object[])elements));
        return this.self();
    }

    public SELF setElements(Collection<ModelElement> elements) {
        this.modelElements.clear();
        this.modelElements.addAll(elements);
        return this.self();
    }

    @Override
    @NotNull
    public ModelTemplate getParentModel() {
        return this.parentModel;
    }

    @Override
    public Optional<TextureMapping> getTextureMapping() {
        return Optional.ofNullable(this.modelTextureMapping);
    }

    @Override
    public Optional<String> getCustomModelName() {
        return Optional.ofNullable(this.modelCustomName);
    }

    @Override
    public Optional<String> getBackingDirectory() {
        return Optional.of(this.modelCustomBackingDirectory);
    }

    @Override
    public Optional<ResourceLocation> getRenderType() {
        return Optional.ofNullable(this.modelRenderType);
    }

    @Override
    public Optional<ModelGuiLight> getGuiLight() {
        return Optional.ofNullable(this.modelGuiLight);
    }

    @Override
    public boolean hasAmbientOcclusion() {
        return this.hasAO;
    }

    @Override
    public Map<ItemDisplayContext, ModelTransform> getModelTransforms() {
        return this.modelTransforms;
    }

    @Override
    public List<ModelElement> getModelElements() {
        return this.modelElements;
    }

    @Override
    public List<ModelBasedPropertyWrapper.ModelDefinition> getOrdinalModelDefinitions() {
        return this.ordinalModelDefinitions;
    }

    public SELF self() {
        return (SELF)this;
    }
}

