/*
 * Decompiled with CFR 0.152.
 */
package com.mememan.nexus.client.model.item;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mememan.nexus.client.model.general.BaseModelDefinition;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.data.models.model.ModelTemplate;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class ItemModelDefinition
extends BaseModelDefinition<ItemModelDefinition> {
    protected final Map<Map<ResourceLocation, Float>, ResourceLocation> modelTextureOverrides = new Object2ObjectLinkedOpenHashMap();

    public ItemModelDefinition(@NotNull ModelTemplate parentModel) {
        super(parentModel, "item");
    }

    public ItemModelDefinition withItemModelTextureOverride(Map<ResourceLocation, Float> textureOverridePredicates, ResourceLocation textureOverride) {
        this.modelTextureOverrides.put(textureOverridePredicates, textureOverride);
        return this;
    }

    public ItemModelDefinition withItemModelTextureOverrides(Map<Map<ResourceLocation, Float>, ResourceLocation> textureOverrides) {
        this.modelTextureOverrides.putAll(textureOverrides);
        return this;
    }

    public ItemModelDefinition setItemModelTextureOverrides(Map<Map<ResourceLocation, Float>, ResourceLocation> textureOverrides) {
        this.modelTextureOverrides.clear();
        this.modelTextureOverrides.putAll(textureOverrides);
        return this;
    }

    public Map<Map<ResourceLocation, Float>, ResourceLocation> getItemModelTextureOverrides() {
        return this.modelTextureOverrides;
    }

    @Override
    public JsonObject constructJson(ResourceLocation finalizedModelLoc, Supplier<JsonElement> baseModelJson) {
        JsonObject modifiedSuperModelJson = super.constructJson(finalizedModelLoc, baseModelJson);
        if (!this.modelTextureOverrides.isEmpty()) {
            JsonArray modelTextureOverridesArray = new JsonArray();
            this.modelTextureOverrides.forEach((overrideConditions, overrideTextureLoc) -> {
                JsonObject rootOverridesObj = new JsonObject();
                if (!overrideConditions.isEmpty()) {
                    overrideConditions.forEach((predicateLoc, predicateValue) -> {
                        JsonObject predicateObj = new JsonObject();
                        if (predicateLoc != null && predicateValue != null) {
                            predicateObj.addProperty(predicateLoc.toString(), (Number)predicateValue);
                        }
                        rootOverridesObj.add("predicate", (JsonElement)predicateObj);
                    });
                }
                if (overrideTextureLoc != null) {
                    rootOverridesObj.addProperty("model", overrideTextureLoc.toString());
                }
                modelTextureOverridesArray.add((JsonElement)rootOverridesObj);
            });
            modifiedSuperModelJson.add("overrides", (JsonElement)modelTextureOverridesArray);
        }
        return modifiedSuperModelJson;
    }
}

