/*
 * Decompiled with CFR 0.152.
 */
package com.mememan.nexus.datagen.standard.data_pack;

import com.google.gson.JsonElement;
import com.mememan.nexus.NexusConstants;
import com.mememan.nexus.datagen.DuplicateDataPolicy;
import com.mememan.nexus.datagen.NexusProviderTypes;
import com.mememan.nexus.datagen.ProviderType;
import com.mememan.nexus.datagen.standard.ModDataProvider;
import com.mememan.nexus.platform.NexusServices;
import com.mememan.nexus.util.ResourceLocationUtil;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.JsonOps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.PackOutput;
import net.minecraft.data.registries.RegistriesDatapackGenerator;
import net.minecraft.resources.RegistryDataLoader;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import org.jetbrains.annotations.NotNull;

public class StandardDatapackRegistryProvider
extends RegistriesDatapackGenerator
implements ModDataProvider {
    protected final String modId;
    protected final boolean validateAllEntries;
    protected final DuplicateDataPolicy dupeStrat;

    public StandardDatapackRegistryProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registryLookup, RegistrySetBuilder datapackEntriesBuilder, String modId, boolean validateAllEntries, DuplicateDataPolicy dupeStrat) {
        super(output, NexusServices.DATA_GENERATOR.getConfigForMod(modId) == null || !NexusServices.DATA_GENERATOR.getConfigForMod(modId).enableDatagen() ? registryLookup : registryLookup.thenApply(lookupProvider -> StandardDatapackRegistryProvider.constructDummyRegistries(lookupProvider, datapackEntriesBuilder)));
        this.modId = modId;
        this.validateAllEntries = validateAllEntries;
        this.dupeStrat = dupeStrat;
    }

    @Override
    @NotNull
    public CompletableFuture<?> m_213708_(@NotNull CachedOutput cachedOutput) {
        return this.f_254747_.thenCompose(regProvider -> {
            RegistryOps regEncoderOps = RegistryOps.m_255058_((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)regProvider);
            return CompletableFuture.allOf((CompletableFuture[])NexusServices.REGISTRAR.getDynamicRegistries().stream().flatMap(arg_0 -> this.lambda$run$1(cachedOutput, regProvider, (DynamicOps)regEncoderOps, arg_0)).toArray(CompletableFuture[]::new));
        });
    }

    @NotNull
    public <T> Optional<CompletableFuture<?>> m_254918_(CachedOutput cachedOutput, HolderLookup.Provider regProvider, DynamicOps<JsonElement> encoderOps, RegistryDataLoader.RegistryData<T> regData) {
        ResourceKey curElement = regData.f_243794_();
        Object2ObjectOpenHashMap serializedElements = new Object2ObjectOpenHashMap();
        return regProvider.m_254861_(curElement).map(regLookup -> {
            PackOutput.PathProvider datapackOutputPathProvider = this.f_254743_.m_245269_(PackOutput.Target.DATA_PACK, ResourceLocationUtil.formatPath(curElement.m_135782_()));
            return CompletableFuture.allOf((CompletableFuture[])regLookup.m_214062_().filter(holderRef -> holderRef.m_205785_().m_135782_().m_135827_().equals(this.modId)).filter(holderRef -> {
                if (this.validateAllEntries() && holderRef.m_203334_() == null) {
                    throw new NullPointerException(String.format("Missing/null registry entry for: %s (required by mod of ID: %s)", holderRef.m_205785_().m_135782_(), this.getModId()));
                }
                if (serializedElements.get((Object)holderRef.m_205785_()) != null) {
                    switch (this.getDuplicateDataPolicy()) {
                        case CRASH: {
                            throw new IllegalStateException(String.format("Duplicate registry entry for: %s (from mod of ID: %s), specified DuplicateDataPolicy is CRASH.", holderRef.m_205785_(), this.getModId()));
                        }
                        case EXCLUDE_WARN: {
                            NexusConstants.LOGGER.warn("Duplicate registry entry for: {} (from mod of ID: {}), specified DuplicateDataPolicy is EXCLUDE_WARN. Skipping...", (Object)holderRef.m_205785_(), (Object)this.getModId());
                            return false;
                        }
                        case EXCLUDE_SILENT: {
                            return false;
                        }
                        case OVERRIDE_WARN: {
                            NexusConstants.LOGGER.warn("Overriding duplicate registry entry for: {} (from mod of ID: {}), specified DuplicateDataPolicy is OVERRIDE_WARN.", (Object)holderRef.m_205785_(), (Object)this.getModId());
                            return true;
                        }
                        case OVERRIDE_SILENT: {
                            return true;
                        }
                    }
                } else {
                    serializedElements.put((Object)holderRef.m_205785_(), holderRef.m_203334_());
                }
                return true;
            }).map(holderRef -> {
                NexusConstants.LOGGER.debug("Serializing registry entry: {} (from mod of ID: {})", (Object)holderRef.m_205785_(), (Object)this.getModId());
                return StandardDatapackRegistryProvider.m_255283_((Path)datapackOutputPathProvider.m_245731_(holderRef.m_205785_().m_135782_()), (CachedOutput)cachedOutput, (DynamicOps)encoderOps, (Encoder)regData.f_244580_(), (Object)holderRef.m_203334_());
            }).toArray(CompletableFuture[]::new));
        });
    }

    @Override
    @NotNull
    public String m_6055_() {
        return String.format("Dynamic Registries [%s]", this.getModId());
    }

    @Override
    @NotNull
    public String getModId() {
        return this.modId;
    }

    @Override
    public boolean validateAllEntries() {
        return this.validateAllEntries;
    }

    @Override
    @NotNull
    public ProviderType getProviderType() {
        return NexusProviderTypes.DYNAMIC_REGISTRY_PROVIDER;
    }

    @Override
    @NotNull
    public DuplicateDataPolicy getDuplicateDataPolicy() {
        return this.dupeStrat;
    }

    protected static HolderLookup.Provider constructDummyRegistries(HolderLookup.Provider original, RegistrySetBuilder datapackEntriesBuilder) {
        HashSet<ResourceKey> builderKeys = new HashSet<ResourceKey>(datapackEntriesBuilder.f_254732_.stream().map(RegistrySetBuilder.RegistryStub::f_254738_).toList());
        NexusServices.REGISTRAR.getDynamicRegistries().stream().filter(data -> !builderKeys.contains(data.f_243794_())).forEach(data -> {
            NexusConstants.LOGGER.debug("[StandardDatapackRegistryProvider Constructor] Adding dummy registry entry for empty or unmapped dynamic registry: {}", (Object)data.f_243794_().m_135782_());
            datapackEntriesBuilder.m_254916_(data.f_243794_(), context -> {});
        });
        return datapackEntriesBuilder.m_254929_((RegistryAccess)RegistryAccess.m_206165_((Registry)BuiltInRegistries.f_257047_), original);
    }

    private /* synthetic */ Stream lambda$run$1(CachedOutput cachedOutput, HolderLookup.Provider regProvider, DynamicOps regEncoderOps, RegistryDataLoader.RegistryData regData) {
        return this.m_254918_(cachedOutput, regProvider, (DynamicOps<JsonElement>)regEncoderOps, regData).stream();
    }
}

