/*
 * Decompiled with CFR 0.152.
 */
package com.mememan.nexus.datagen.standard.data_pack;

import com.google.common.collect.Multimap;
import com.google.gson.JsonElement;
import com.mememan.nexus.NexusConstants;
import com.mememan.nexus.datagen.DuplicateDataPolicy;
import com.mememan.nexus.datagen.NexusProviderTypes;
import com.mememan.nexus.datagen.ProviderType;
import com.mememan.nexus.datagen.standard.ModDataProvider;
import com.mememan.nexus.property_wrapper.base.generic.DataGenPropertyWrapper;
import com.mememan.nexus.property_wrapper.base.generic.PropertyWrapper;
import com.mememan.nexus.property_wrapper.base.specialised.loot.LootBasedPropertyWrapper;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.RandomSequence;
import net.minecraft.world.level.levelgen.RandomSupport;
import net.minecraft.world.level.storage.loot.LootDataId;
import net.minecraft.world.level.storage.loot.LootDataResolver;
import net.minecraft.world.level.storage.loot.LootDataType;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StandardLootProvider
extends LootTableProvider
implements ModDataProvider {
    protected final String modId;
    protected final boolean validateAllEntries;
    protected final DuplicateDataPolicy dupeStrat;
    protected final List<LootBasedPropertyWrapper<?, ?, ?>> mappedLootPWs;

    public StandardLootProvider(PackOutput targetOutput, String modId, boolean validateAllEntries, DuplicateDataPolicy dupeStrat) {
        super(targetOutput, Set.of(), List.of());
        this.modId = modId;
        this.validateAllEntries = validateAllEntries;
        this.dupeStrat = dupeStrat;
        this.mappedLootPWs = PropertyWrapper.PropertyWrappersContainer.getInferrableDataGennableWrappersOfType(LootBasedPropertyWrapper.class, modId);
    }

    @Override
    @NotNull
    public CompletableFuture<?> m_213708_(CachedOutput output) {
        final Object2ObjectOpenHashMap mappedLootTables = new Object2ObjectOpenHashMap();
        Object2ObjectOpenHashMap hashedLootTableLocs = new Object2ObjectOpenHashMap();
        ObjectOpenHashSet trackedTables = new ObjectOpenHashSet();
        ObjectOpenHashSet requiredTables = new ObjectOpenHashSet();
        ValidationContext lootMiscValidationCtx = new ValidationContext(LootContextParamSets.f_81420_, new LootDataResolver(){

            @Nullable
            public <T> T m_278667_(LootDataId<T> lootDataId) {
                return (T)(lootDataId.f_278383_() == LootDataType.f_278413_ ? (LootTable)mappedLootTables.get((Object)lootDataId.f_278500_()) : null);
            }
        });
        this.populateLootTables((Map<ResourceLocation, LootTable>)mappedLootTables, (Set<ResourceLocation>)trackedTables, (Set<ResourceLocation>)requiredTables, (Map<RandomSupport.Seed128bit, ResourceLocation>)hashedLootTableLocs);
        for (ResourceLocation curLootTableLoc : requiredTables) {
            lootMiscValidationCtx.m_79357_(String.format("Missing loot table: %s (required by mod of ID: %s), either because validateAllEntries is set to true for this provider or the object itself requires validation through DataGenBasedPropertyWrapper#getProviderTypeRequisites().", curLootTableLoc, this.modId));
        }
        mappedLootTables.forEach((mappedLootTableLoc, mappedLootTable) -> mappedLootTable.m_79136_(lootMiscValidationCtx.m_79355_(mappedLootTable.m_79122_()).m_278632_("{" + String.valueOf(mappedLootTableLoc) + "}", new LootDataId(LootDataType.f_278413_, mappedLootTableLoc))));
        Multimap lootTableValidationProblems = lootMiscValidationCtx.m_79352_();
        if (!lootTableValidationProblems.isEmpty()) {
            lootTableValidationProblems.forEach((problematicLootTable, validationProblem) -> LootTableProvider.f_124431_.warn("Found validation problem: {}", validationProblem));
            throw new IllegalStateException("Failed to validate loot tables, see logs");
        }
        return CompletableFuture.allOf((CompletableFuture[])mappedLootTables.entrySet().stream().map(lootEntry -> {
            ResourceLocation lootTableLoc = (ResourceLocation)lootEntry.getKey();
            LootTable lootTable = (LootTable)lootEntry.getValue();
            Path targetPath = this.f_236267_.m_245731_(lootTableLoc);
            return DataProvider.m_253162_((CachedOutput)output, (JsonElement)LootDataType.f_278413_.m_278857_().toJsonTree((Object)lootTable), (Path)targetPath);
        }).toArray(CompletableFuture[]::new));
    }

    protected <T> void populateLootTables(Map<ResourceLocation, LootTable> mappedLootTables, Set<ResourceLocation> trackedTables, Set<ResourceLocation> requiredLootTables, Map<RandomSupport.Seed128bit, ResourceLocation> hashedLootTableLocs) {
        this.mappedLootPWs.stream().map(curPW -> curPW).forEach(curPW -> {
            Supplier parentObjSup = curPW.getParentObject();
            Object parentObj = parentObjSup.get();
            String objectDescId = curPW.getObjectDescriptionId();
            String objectClassName = parentObj.getClass().getSimpleName();
            ResourceLocation finalizedLootTableLoc = DataGenPropertyWrapper.RegistryLookupContainer.getObjectRegistryIdOrThrow(parentObj).m_246208_(curPW.getLootTableDir());
            curPW.getLootTableBuilder().ifPresentOrElse(lootTableBuilder -> {
                Runnable lootTableMapper = () -> this.lambda$populateLootTables$5(hashedLootTableLocs, finalizedLootTableLoc, objectClassName, objectDescId, mappedLootTables, lootTableBuilder, (Supplier)parentObjSup);
                this.handeDuplicateLootTables(finalizedLootTableLoc, trackedTables, objectClassName, objectDescId, lootTableMapper);
            }, () -> {
                if (this.validateAllEntries() || curPW.getProviderTypeRequisites().getOrDefault(this.getProviderType(), false).booleanValue()) {
                    requiredLootTables.add(finalizedLootTableLoc);
                }
            });
        });
    }

    protected void handeDuplicateLootTables(ResourceLocation targetLootTable, Set<ResourceLocation> trackedTables, String objectClassName, String objectName, Runnable lootTableMapper) {
        if (!trackedTables.add(targetLootTable)) {
            switch (this.getDuplicateDataPolicy()) {
                case CRASH: {
                    throw new IllegalStateException(String.format("Attempted to generate duplicate loot table %s for %s '%s' (from mod of ID %s), specified DuplicateDataPolicy is CRASH.", targetLootTable, objectClassName, objectName, this.getModId()));
                }
                case EXCLUDE_WARN: {
                    NexusConstants.LOGGER.warn("Attempted to generate duplicate loot table {} for {} '{}' (from mod of ID {}), specified DuplicateDataPolicy is EXCLUDE_WARN. Skipping...", new Object[]{targetLootTable, objectClassName, objectName, this.getModId()});
                    break;
                }
                case EXCLUDE_SILENT: {
                    break;
                }
                case OVERRIDE_WARN: {
                    NexusConstants.LOGGER.warn("Overriding duplicate loot table {} for {} '{}' (from mod of ID {}), specified DuplicateDataPolicy is OVERRIDE_WARN.", new Object[]{targetLootTable, objectClassName, objectName, this.getModId()});
                    lootTableMapper.run();
                    break;
                }
                case OVERRIDE_SILENT: {
                    lootTableMapper.run();
                }
            }
        } else {
            lootTableMapper.run();
        }
    }

    @Override
    @NotNull
    public String getModId() {
        return this.modId;
    }

    @Override
    public boolean validateAllEntries() {
        return this.validateAllEntries;
    }

    @Override
    @NotNull
    public ProviderType getProviderType() {
        return NexusProviderTypes.LOOT_TABLE_PROVIDER;
    }

    @Override
    @NotNull
    public DuplicateDataPolicy getDuplicateDataPolicy() {
        return this.dupeStrat;
    }

    @Override
    @NotNull
    public String m_6055_() {
        return String.format("Loot Tables [%s]", this.getModId());
    }

    private /* synthetic */ void lambda$populateLootTables$5(Map hashedLootTableLocs, ResourceLocation finalizedLootTableLoc, String objectClassName, String objectDescId, Map mappedLootTables, Function lootTableBuilder, Supplier parentObjSup) {
        ResourceLocation hashedLootTableLoc = hashedLootTableLocs.put(RandomSequence.m_288221_((ResourceLocation)finalizedLootTableLoc), finalizedLootTableLoc);
        if (hashedLootTableLoc != null) {
            Util.m_143785_((String)("Loot table random sequence seed collision on " + String.valueOf(hashedLootTableLoc) + " and " + String.valueOf(finalizedLootTableLoc)));
        }
        NexusConstants.LOGGER.debug("[{}] [Generating Loot Table]: {} (for {} '{}')", new Object[]{this.getModId(), finalizedLootTableLoc, objectClassName, objectDescId});
        mappedLootTables.put(finalizedLootTableLoc, ((LootTable.Builder)lootTableBuilder.apply(parentObjSup)).m_79167_());
    }
}

