/*
 * Decompiled with CFR 0.152.
 */
package com.mememan.nexus.datagen.standard.data_pack;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mememan.nexus.NexusConstants;
import com.mememan.nexus.datagen.DuplicateDataPolicy;
import com.mememan.nexus.datagen.NexusProviderTypes;
import com.mememan.nexus.datagen.ProviderType;
import com.mememan.nexus.datagen.standard.ModDataProvider;
import com.mememan.nexus.property_wrapper.base.generic.PropertyWrapper;
import com.mememan.nexus.property_wrapper.base.specialised.recipe.RecipeBasedPropertyWrapper;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class StandardRecipeProvider
extends RecipeProvider
implements ModDataProvider {
    protected final String modId;
    protected final boolean validateAllEntries;
    protected final DuplicateDataPolicy dupeStrat;
    protected final List<RecipeBasedPropertyWrapper<?, ?, ?>> mappedRecipePWs;

    public StandardRecipeProvider(PackOutput targetPackOutput, String modId, boolean validateAllEntries, DuplicateDataPolicy dupeStrat) {
        super(targetPackOutput);
        this.modId = modId;
        this.validateAllEntries = validateAllEntries;
        this.dupeStrat = dupeStrat;
        this.mappedRecipePWs = PropertyWrapper.PropertyWrappersContainer.getInferrableDataGennableWrappersOfType(RecipeBasedPropertyWrapper.class, modId);
    }

    @Override
    @NotNull
    public CompletableFuture<?> m_213708_(CachedOutput cachedOutput) {
        ObjectOpenHashSet recipeLocations = new ObjectOpenHashSet();
        ObjectArrayList recipesAndAdvancements = new ObjectArrayList();
        this.m_245200_(finishedRecipe -> {
            ResourceLocation finishedRecipeId = finishedRecipe.m_6445_();
            boolean wasAlreadyAdded = !recipeLocations.add((Object)finishedRecipeId);
            Runnable recipeAndAdvancementSerializer = () -> {
                recipesAndAdvancements.add((Object)DataProvider.m_253162_((CachedOutput)cachedOutput, (JsonElement)finishedRecipe.m_125966_(), (Path)this.f_236355_.m_245731_(finishedRecipeId)));
                JsonObject serializedRecipeAdvancement = finishedRecipe.m_5860_();
                if (serializedRecipeAdvancement != null) {
                    recipesAndAdvancements.add((Object)DataProvider.m_253162_((CachedOutput)cachedOutput, (JsonElement)serializedRecipeAdvancement, (Path)this.f_236356_.m_245731_(finishedRecipe.m_6448_())));
                }
            };
            if (wasAlreadyAdded) {
                switch (this.getDuplicateDataPolicy()) {
                    case CRASH: {
                        throw new IllegalStateException(String.format("Attempted to generate duplicate recipe %s (from mod of ID %s), specified DuplicateDataPolicy is CRASH.", finishedRecipeId, this.getModId()));
                    }
                    case EXCLUDE_WARN: {
                        NexusConstants.LOGGER.warn("Attempted to generate duplicate recipe {} (from mod of ID {}), specified DuplicateDataPolicy is EXCLUDE_WARN. Skipping...", (Object)finishedRecipeId, (Object)this.getModId());
                        break;
                    }
                    case EXCLUDE_SILENT: {
                        break;
                    }
                    case OVERRIDE_WARN: {
                        NexusConstants.LOGGER.warn("Overriding duplicate recipe {} (from mod of ID {}), specified DuplicateDataPolicy is OVERRIDE_WARN.", (Object)finishedRecipeId, (Object)this.getModId());
                        recipeAndAdvancementSerializer.run();
                        break;
                    }
                    case OVERRIDE_SILENT: {
                        recipeAndAdvancementSerializer.run();
                    }
                }
            } else {
                recipeAndAdvancementSerializer.run();
            }
        });
        return CompletableFuture.allOf((CompletableFuture[])recipesAndAdvancements.toArray(CompletableFuture[]::new));
    }

    public void m_245200_(Consumer<FinishedRecipe> recipeActionConsumer) {
        this.processRecipesGenerically(recipeActionConsumer);
    }

    protected <T> void processRecipesGenerically(Consumer<FinishedRecipe> recipeActionConsumer) {
        if (!this.mappedRecipePWs.isEmpty()) {
            this.mappedRecipePWs.stream().map(curPW -> curPW).forEach(curPW -> {
                Optional<Function<Consumer<FinishedRecipe>, Consumer<Supplier<Function>>>> mappedRecipe = curPW.getRecipeConsumer();
                String objectDescId = curPW.getObjectDescriptionId();
                String objectClassName = curPW.getParentObject().get().getClass().getSimpleName();
                mappedRecipe.ifPresentOrElse(recipeMapperFunc -> {
                    NexusConstants.LOGGER.debug("[{}] [Generating Recipe for {}]: {}", new Object[]{this.modId, objectClassName, objectDescId});
                    ((Consumer)recipeMapperFunc.apply(recipeActionConsumer)).accept(curPW.getParentObject());
                }, () -> {
                    if (this.validateAllEntries() || curPW.getProviderTypeRequisites().getOrDefault(this.getProviderType(), false).booleanValue()) {
                        throw new NullPointerException(String.format("Missing recipe mapper for %s: %s, required by mod: %s, either because validateAllEntries is set to true for this provider or the object itself requires validation through DataGenBasedPropertyWrapper#getProviderTypeRequisites().", objectClassName, objectDescId, this.modId));
                    }
                });
            });
        }
    }

    @Override
    @NotNull
    public String m_6055_() {
        return String.format("%s [%s]", super.m_6055_(), this.getModId());
    }

    @Override
    @NotNull
    public String getModId() {
        return this.modId;
    }

    @Override
    public boolean validateAllEntries() {
        return this.validateAllEntries;
    }

    @Override
    @NotNull
    public ProviderType getProviderType() {
        return NexusProviderTypes.RECIPE_PROVIDER;
    }

    @Override
    @NotNull
    public DuplicateDataPolicy getDuplicateDataPolicy() {
        return this.dupeStrat;
    }
}

